/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.util.LinkedList;
import org.apache.felix.scr.impl.logger.InternalLogger;
import org.apache.felix.scr.impl.logger.ScrLogger;

class ComponentActorThread
implements Runnable {
    private static final Runnable TERMINATION_TASK = new Runnable(){

        @Override
        public void run() {
        }

        public String toString() {
            return "Component Actor Terminator";
        }
    };
    private final LinkedList<Runnable> tasks = new LinkedList();
    private final ScrLogger logger;

    ComponentActorThread(ScrLogger log) {
        this.logger = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.logger.log(InternalLogger.Level.DEBUG, "Starting ComponentActorThread", null);
        while (true) {
            LinkedList<Runnable> linkedList;
            Runnable task;
            block29: {
                LinkedList<Runnable> linkedList2 = this.tasks;
                synchronized (linkedList2) {
                    while (true) {
                        if (!this.tasks.isEmpty()) {
                            task = this.tasks.removeFirst();
                            break;
                        }
                        boolean interrupted = Thread.interrupted();
                        try {
                            try {
                                this.tasks.wait();
                            }
                            catch (InterruptedException ie) {
                                interrupted = true;
                                if (!interrupted) continue;
                                Thread.currentThread().interrupt();
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            if (!interrupted) throw throwable;
                            Thread.currentThread().interrupt();
                            throw throwable;
                        }
                        if (!interrupted) continue;
                        Thread.currentThread().interrupt();
                    }
                }
                if (task != TERMINATION_TASK) break block29;
                this.logger.log(InternalLogger.Level.DEBUG, "Shutting down ComponentActorThread", null);
                linkedList = this.tasks;
                synchronized (linkedList) {
                    this.tasks.notifyAll();
                    return;
                }
            }
            try {
                try {
                    this.logger.log(InternalLogger.Level.DEBUG, "Running task: " + task, null);
                    task.run();
                }
                catch (Throwable t) {
                    this.logger.log(InternalLogger.Level.ERROR, "Unexpected problem executing task " + task, t);
                    linkedList = this.tasks;
                    synchronized (linkedList) {
                        this.tasks.notifyAll();
                        continue;
                    }
                }
            }
            catch (Throwable throwable) {
                linkedList = this.tasks;
                synchronized (linkedList) {
                    this.tasks.notifyAll();
                    throw throwable;
                }
            }
            linkedList = this.tasks;
            synchronized (linkedList) {
                this.tasks.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void terminate() {
        this.schedule(TERMINATION_TASK);
        LinkedList<Runnable> linkedList = this.tasks;
        synchronized (linkedList) {
            while (true) {
                if (this.tasks.isEmpty()) {
                    return;
                }
                boolean interrupted = Thread.interrupted();
                try {
                    try {
                        this.tasks.wait();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                        this.logger.log(InternalLogger.Level.ERROR, "Interrupted exception waiting for queue to empty", e);
                        if (!interrupted) continue;
                        Thread.currentThread().interrupt();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    if (!interrupted) throw throwable;
                    Thread.currentThread().interrupt();
                    throw throwable;
                }
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void schedule(Runnable task) {
        LinkedList<Runnable> linkedList = this.tasks;
        synchronized (linkedList) {
            this.tasks.add(task);
            this.logger.log(InternalLogger.Level.DEBUG, "Adding task [{0}] as #{1} in the queue", null, task, this.tasks.size());
            this.tasks.notifyAll();
        }
    }
}

