/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import org.apache.felix.scr.impl.Activator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public abstract class AbstractExtender
implements BundleActivator,
BundleTrackerCustomizer<Bundle>,
SynchronousBundleListener {
    private final ConcurrentMap<Bundle, Activator.ScrExtension> extensions = new ConcurrentHashMap<Bundle, Activator.ScrExtension>();
    private final ConcurrentMap<Bundle, FutureTask<Void>> destroying = new ConcurrentHashMap<Bundle, FutureTask<Void>>();
    private volatile boolean stopping;
    private volatile boolean stopped;
    private BundleContext context;
    private BundleTracker<Bundle> tracker;

    public BundleContext getBundleContext() {
        return this.context;
    }

    public boolean isStopping() {
        return this.stopping;
    }

    public void start(BundleContext context) throws Exception {
        this.context = context;
        this.context.addBundleListener((BundleListener)this);
        this.tracker = new BundleTracker(this.context, 40, (BundleTrackerCustomizer)this);
        this.doStart();
    }

    public void stop(BundleContext context) throws Exception {
        this.stopping = true;
        while (!this.extensions.isEmpty()) {
            Collection<Bundle> toDestroy = this.chooseBundlesToDestroy(this.extensions.keySet());
            if (toDestroy == null || toDestroy.isEmpty()) {
                toDestroy = new ArrayList(this.extensions.keySet());
            }
            for (Bundle bundle : toDestroy) {
                this.destroyExtension(bundle);
            }
        }
        this.doStop();
        this.stopped = true;
    }

    protected void doStart() throws Exception {
        this.startTracking();
    }

    protected void doStop() throws Exception {
        this.stopTracking();
    }

    protected void startTracking() {
        this.tracker.open();
    }

    protected void stopTracking() {
        this.tracker.close();
    }

    protected ExecutorService createExecutor() {
        return Executors.newScheduledThreadPool(3);
    }

    protected Collection<Bundle> chooseBundlesToDestroy(Set<Bundle> bundles) {
        return null;
    }

    public void bundleChanged(BundleEvent event) {
        if (this.stopped) {
            return;
        }
        Bundle bundle = event.getBundle();
        if (bundle.getState() != 32 && bundle.getState() != 8 && bundle != this.context.getBundle()) {
            this.destroyExtension(bundle);
        }
    }

    public Bundle addingBundle(Bundle bundle, BundleEvent event) {
        this.modifiedBundle(bundle, event, bundle);
        return bundle;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Bundle object) {
        String activationPolicyHeader;
        if (bundle.getState() != 32 && bundle.getState() != 8) {
            if (bundle != this.context.getBundle()) {
                this.destroyExtension(bundle);
            }
            return;
        }
        if (this.stopping) {
            return;
        }
        if (!(bundle.getState() != 8 || (activationPolicyHeader = (String)bundle.getHeaders("").get("Bundle-ActivationPolicy")) != null && activationPolicyHeader.startsWith("lazy") && ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).isActivationPolicyUsed())) {
            return;
        }
        this.createExtension(bundle);
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Bundle object) {
        this.destroyExtension(bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createExtension(Bundle bundle) {
        try {
            BundleContext bundleContext = bundle.getBundleContext();
            if (bundleContext == null) {
                return;
            }
            Activator.ScrExtension extension = this.doCreateExtension(bundle);
            if (extension == null) {
                return;
            }
            ConcurrentMap<Bundle, Activator.ScrExtension> concurrentMap = this.extensions;
            synchronized (concurrentMap) {
                if (this.extensions.putIfAbsent(bundle, extension) != null) {
                    return;
                }
            }
            this.debug(bundle, "Starting extension synchronously");
            extension.start();
        }
        catch (Throwable t) {
            this.warn(bundle, "Error while creating extension", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyExtension(final Bundle bundle) {
        FutureTask<Object> future;
        ConcurrentMap<Bundle, Activator.ScrExtension> concurrentMap = this.extensions;
        synchronized (concurrentMap) {
            this.debug(bundle, "Starting destruction process");
            future = (FutureTask<Object>)this.destroying.get(bundle);
            if (future == null) {
                final Activator.ScrExtension extension = (Activator.ScrExtension)this.extensions.remove(bundle);
                if (extension != null) {
                    this.debug(bundle, "Scheduling extension destruction");
                    future = new FutureTask<Object>(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            block14: {
                                AbstractExtender.this.debug(bundle, "Destroying extension");
                                try {
                                    try {
                                        extension.destroy();
                                    }
                                    catch (Exception e) {
                                        AbstractExtender.this.warn(bundle, "Error while destroying extension", e);
                                        AbstractExtender.this.debug(bundle, "Finished destroying extension");
                                        ConcurrentMap concurrentMap = AbstractExtender.this.extensions;
                                        synchronized (concurrentMap) {
                                            AbstractExtender.this.destroying.remove(bundle);
                                            break block14;
                                        }
                                    }
                                }
                                catch (Throwable throwable) {
                                    AbstractExtender.this.debug(bundle, "Finished destroying extension");
                                    ConcurrentMap concurrentMap = AbstractExtender.this.extensions;
                                    synchronized (concurrentMap) {
                                        AbstractExtender.this.destroying.remove(bundle);
                                    }
                                    throw throwable;
                                }
                                AbstractExtender.this.debug(bundle, "Finished destroying extension");
                                ConcurrentMap concurrentMap = AbstractExtender.this.extensions;
                                synchronized (concurrentMap) {
                                    AbstractExtender.this.destroying.remove(bundle);
                                }
                            }
                        }
                    }, null);
                    this.destroying.put(bundle, future);
                } else {
                    this.debug(bundle, "Not an extended bundle or destruction of extension already finished");
                }
            } else {
                this.debug(bundle, "Destruction already scheduled");
            }
        }
        if (future != null) {
            try {
                this.debug(bundle, "Waiting for extension destruction");
                future.run();
                future.get();
            }
            catch (Throwable t) {
                this.warn(bundle, "Error while destroying extension", t);
            }
        }
    }

    protected abstract Activator.ScrExtension doCreateExtension(Bundle var1) throws Exception;

    protected abstract void debug(Bundle var1, String var2);

    protected abstract void warn(Bundle var1, String var2, Throwable var3);
}

