/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.felix.scr.impl.AbstractExtender;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.ComponentActorThread;
import org.apache.felix.scr.impl.ComponentCommands;
import org.apache.felix.scr.impl.ComponentRegistry;
import org.apache.felix.scr.impl.config.ScrConfigurationImpl;
import org.apache.felix.scr.impl.inject.internal.ClassUtils;
import org.apache.felix.scr.impl.logger.InternalLogger;
import org.apache.felix.scr.impl.logger.ScrLogger;
import org.apache.felix.scr.impl.logger.ScrLoggerFactory;
import org.apache.felix.scr.impl.manager.ComponentHolder;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.apache.felix.scr.impl.metadata.MetadataStoreHelper;
import org.apache.felix.scr.impl.runtime.ServiceComponentRuntimeImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.runtime.ServiceComponentRuntime;

public class Activator
extends AbstractExtender {
    private final ScrConfigurationImpl m_configuration = new ScrConfigurationImpl(this);
    private BundleContext m_context;
    private BundleContext m_globalContext;
    private ServiceReference<?> m_trueCondition;
    private Bundle m_bundle;
    private volatile ScrLogger logger;
    private Map<Long, BundleComponentActivator> m_componentBundles;
    private ComponentRegistry m_componentRegistry;
    private ComponentActorThread m_componentActor;
    private ServiceRegistration<ServiceComponentRuntime> m_runtime_reg;
    private ComponentCommands m_componentCommands;
    private ConcurrentMap<Long, List<ComponentMetadata>> m_componentMetadataStore;

    @Override
    public void start(BundleContext context) throws Exception {
        this.m_context = context;
        this.m_bundle = context.getBundle();
        this.m_trueCondition = this.findTrueCondition(context);
        ClassUtils.setBundleContext(context);
        this.m_configuration.start(this.m_context);
    }

    private ServiceReference<?> findTrueCondition(BundleContext context) {
        try {
            ServiceReference[] foundTrue = context.getServiceReferences("org.osgi.service.condition.Condition", "(osgi.condition.id=true)");
            if (foundTrue == null || foundTrue.length == 0) {
                return null;
            }
            for (ServiceReference ref : foundTrue) {
                Bundle b = ref.getBundle();
                if (b == null || b.getBundleId() != 0L) continue;
                return ref;
            }
            return null;
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public void restart(boolean globalExtender) {
        block5: {
            this.m_componentMetadataStore = Activator.load(this.m_context, this.logger, this.m_configuration.cacheMetadata());
            BundleContext context = this.m_globalContext;
            this.m_globalContext = globalExtender ? this.m_context.getBundle("System Bundle").getBundleContext() : this.m_context;
            if (ClassUtils.m_packageAdmin != null) {
                this.logger.log(InternalLogger.Level.INFO, "Stopping to restart with new globalExtender setting: {0}", null, globalExtender);
                try {
                    super.stop(context);
                }
                catch (Exception e) {
                    if (this.logger == null) break block5;
                    this.logger.log(InternalLogger.Level.ERROR, "Exception stopping during restart", e);
                }
            }
        }
        try {
            this.logger.log(InternalLogger.Level.INFO, "Starting with globalExtender setting: {0}", null, globalExtender);
            super.start(this.m_globalContext);
        }
        catch (Exception e) {
            this.logger.log(InternalLogger.Level.ERROR, "Exception starting during restart", e);
        }
    }

    @Override
    protected void doStart() throws Exception {
        this.m_componentBundles = new HashMap<Long, BundleComponentActivator>();
        this.m_componentRegistry = new ComponentRegistry(this.m_configuration, this.logger);
        ServiceComponentRuntimeImpl runtime = new ServiceComponentRuntimeImpl(this.m_globalContext, this.m_componentRegistry);
        this.m_runtime_reg = this.m_context.registerService(ServiceComponentRuntime.class, (Object)runtime, this.m_componentRegistry.getServiceRegistrationProperties());
        this.m_componentRegistry.setRegistration(this.m_runtime_reg);
        this.logger.log(InternalLogger.Level.INFO, " Version = {0}", null, this.m_bundle.getVersion().toString());
        this.m_componentActor = new ComponentActorThread(this.logger);
        Thread t = new Thread((Runnable)this.m_componentActor, "SCR Component Actor");
        t.setDaemon(true);
        t.start();
        super.doStart();
        this.m_componentCommands = new ComponentCommands(this.m_context, runtime, this.m_configuration);
        this.m_componentCommands.register();
        this.m_componentCommands.updateProvideScrInfoService(this.m_configuration.infoAsService());
        this.m_configuration.setScrCommand(this.m_componentCommands);
    }

    @Override
    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.m_configuration.stop();
        Activator.store(this.m_componentMetadataStore, context, this.logger, this.m_configuration.cacheMetadata());
        this.logger.close();
    }

    public ServiceReference<?> getTrueCondition() {
        return this.m_trueCondition;
    }

    @Override
    public void bundleChanged(BundleEvent event) {
        super.bundleChanged(event);
        if (event.getType() == 8 || event.getType() == 16) {
            this.m_componentMetadataStore.remove(event.getBundle().getBundleId());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ConcurrentMap<Long, List<ComponentMetadata>> load(BundleContext context, ScrLogger logger, boolean loadFromCache) {
        try {
            ConcurrentHashMap<Long, List<ComponentMetadata>> result = new ConcurrentHashMap<Long, List<ComponentMetadata>>();
            if (!loadFromCache) {
                return result;
            }
            BundleContext systemContext = context.getBundle("System Bundle").getBundleContext();
            File store = context.getDataFile("componentMetadataStore");
            if (!store.isFile()) return result;
            try (DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(store)));){
                MetadataStoreHelper.MetaDataReader metaDataReader = new MetadataStoreHelper.MetaDataReader();
                if (!metaDataReader.isVersionSupported(in)) {
                    ConcurrentHashMap<Long, List<ComponentMetadata>> concurrentHashMap = result;
                    return concurrentHashMap;
                }
                int numStrings = in.readInt();
                for (int i = 0; i < numStrings; ++i) {
                    metaDataReader.readIndexedString(in);
                }
                int numBundles = in.readInt();
                int i = 0;
                while (i < numBundles) {
                    long bundleId = in.readLong();
                    int numComponents = in.readInt();
                    long lastModified = in.readLong();
                    ArrayList<ComponentMetadata> components = new ArrayList<ComponentMetadata>(numComponents);
                    for (int j = 0; j < numComponents; ++j) {
                        components.add(ComponentMetadata.load(in, metaDataReader));
                    }
                    Bundle b = systemContext.getBundle(bundleId);
                    if (b != null && lastModified == b.getLastModified()) {
                        result.put(bundleId, components);
                    }
                    ++i;
                }
                return result;
            }
            catch (IOException e) {
                logger.log(InternalLogger.Level.WARN, "Error loading component metadata cache.", e);
            }
            return result;
        }
        catch (RuntimeException re) {
            logger.log(InternalLogger.Level.ERROR, "Error loading component metadata cache.", re);
            return new ConcurrentHashMap<Long, List<ComponentMetadata>>();
        }
    }

    private static void store(Map<Long, List<ComponentMetadata>> componentsMap, BundleContext context, ScrLogger logger, boolean storeCache) {
        if (!storeCache) {
            return;
        }
        BundleContext systemContext = context.getBundle("System Bundle").getBundleContext();
        File store = context.getDataFile("componentMetadataStore");
        try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(store)));){
            MetadataStoreHelper.MetaDataWriter metaDataWriter = new MetadataStoreHelper.MetaDataWriter();
            metaDataWriter.writeVersion(out);
            HashSet<String> allStrings = new HashSet<String>();
            for (List<ComponentMetadata> list : componentsMap.values()) {
                for (ComponentMetadata component : list) {
                    component.collectStrings(allStrings);
                }
            }
            allStrings.remove(null);
            out.writeInt(allStrings.size());
            for (String string : allStrings) {
                metaDataWriter.writeIndexedString(string, out);
            }
            out.writeInt(componentsMap.size());
            for (Map.Entry entry : componentsMap.entrySet()) {
                out.writeLong((Long)entry.getKey());
                out.writeInt(((List)entry.getValue()).size());
                Bundle b = systemContext.getBundle(((Long)entry.getKey()).longValue());
                out.writeLong(b == null ? -1L : b.getLastModified());
                for (ComponentMetadata component : (List)entry.getValue()) {
                    component.store(out, metaDataWriter);
                }
            }
        }
        catch (IOException e) {
            logger.log(InternalLogger.Level.WARN, "Error storing component metadata cache.", e);
        }
    }

    @Override
    public void doStop() throws Exception {
        super.doStop();
        if (this.m_componentCommands != null) {
            this.m_componentCommands.unregister();
        }
        if (this.m_runtime_reg != null) {
            this.m_runtime_reg.unregister();
            this.m_runtime_reg = null;
        }
        if (this.m_componentRegistry != null) {
            this.m_componentRegistry = null;
        }
        if (this.m_componentActor != null) {
            this.m_componentActor.terminate();
            this.m_componentActor = null;
        }
        ClassUtils.close();
    }

    @Override
    protected ScrExtension doCreateExtension(Bundle bundle) throws Exception {
        return new ScrExtension(bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadComponents(Bundle bundle) {
        boolean loaded;
        Object wire2;
        Long bundleId = bundle.getBundleId();
        List cached = (List)this.m_componentMetadataStore.get(bundleId);
        if (cached != null && cached.isEmpty()) {
            return;
        }
        if (cached == null && bundle.getHeaders("").get("Service-Component") == null) {
            this.m_componentMetadataStore.put(bundleId, Collections.emptyList());
            return;
        }
        BundleContext context = bundle.getBundleContext();
        if (context == null) {
            this.logger.log(InternalLogger.Level.DEBUG, "Cannot get BundleContext of {0}.", null, bundle);
            return;
        }
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        List extenderWires = wiring.getRequiredWires("osgi.extender");
        for (Object wire2 : extenderWires) {
            if (!"osgi.component".equals(wire2.getCapability().getAttributes().get("osgi.extender"))) continue;
            if (((BundleRevision)this.m_bundle.adapt(BundleRevision.class)).equals(wire2.getProvider())) break;
            this.logger.log(InternalLogger.Level.DEBUG, "{0} wired to a different extender: {1}.", null, bundle, wire2.getProvider().getBundle());
            return;
        }
        wire2 = this.m_componentBundles;
        synchronized (wire2) {
            if (this.m_componentBundles.containsKey(bundleId)) {
                loaded = true;
            } else {
                this.m_componentBundles.put(bundleId, null);
                loaded = false;
            }
        }
        if (loaded) {
            this.logger.log(InternalLogger.Level.DEBUG, "Components for {0} already loaded. Nothing to do.", null, bundle);
            return;
        }
        try {
            BundleComponentActivator ga = new BundleComponentActivator(this.logger, this.m_componentRegistry, this.m_componentActor, context, this.m_configuration, cached, this.getTrueCondition());
            ga.initialEnable();
            if (cached == null) {
                List<ComponentHolder<?>> components = ga.getSelectedComponents(null);
                ArrayList<ComponentMetadata> metadatas = new ArrayList<ComponentMetadata>(components.size());
                for (ComponentHolder<?> holder : ga.getSelectedComponents(null)) {
                    metadatas.add(holder.getComponentMetadata());
                }
                this.m_componentMetadataStore.put(bundleId, metadatas);
            }
            Map<Long, BundleComponentActivator> map = this.m_componentBundles;
            synchronized (map) {
                this.m_componentBundles.put(bundleId, ga);
            }
        }
        catch (Exception e) {
            Map<Long, BundleComponentActivator> map = this.m_componentBundles;
            synchronized (map) {
                this.m_componentBundles.remove(bundleId);
            }
            if (e instanceof IllegalStateException && bundle.getState() != 32) {
                this.logger.log(InternalLogger.Level.DEBUG, "{0} has been stopped while trying to activate its components. Trying again when the bundles gets started again.", e, bundle);
            }
            this.logger.log(InternalLogger.Level.ERROR, "Error while loading components of {0}", e, bundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeComponents(Bundle bundle) {
        BundleComponentActivator ga;
        Map<Long, BundleComponentActivator> map = this.m_componentBundles;
        synchronized (map) {
            ga = this.m_componentBundles.remove(bundle.getBundleId());
        }
        if (ga != null) {
            try {
                int reason = this.isStopping() ? 5 : 6;
                ga.dispose(reason);
            }
            catch (Exception e) {
                this.logger.log(InternalLogger.Level.ERROR, "Error while disposing components of {0}", e, bundle);
            }
        }
    }

    @Override
    protected void debug(Bundle bundle, String msg) {
        if (this.logger.isLogEnabled(InternalLogger.Level.DEBUG)) {
            if (bundle != null) {
                this.logger.log(InternalLogger.Level.DEBUG, "{0} : " + msg, null, bundle);
            } else {
                this.logger.log(InternalLogger.Level.DEBUG, msg, null);
            }
        }
    }

    @Override
    protected void warn(Bundle bundle, String msg, Throwable t) {
        if (this.logger.isLogEnabled(InternalLogger.Level.WARN)) {
            if (bundle != null) {
                this.logger.log(InternalLogger.Level.WARN, "{0} : " + msg, t, bundle);
            } else {
                this.logger.log(InternalLogger.Level.WARN, msg, t);
            }
        }
    }

    public void setLogger() {
        if (this.logger == null) {
            this.logger = ScrLoggerFactory.create(this.m_context, this.m_configuration);
        }
    }

    protected class ScrExtension {
        private final Bundle bundle;
        private final Lock stateLock = new ReentrantLock();

        public ScrExtension(Bundle bundle) {
            this.bundle = bundle;
        }

        public void start() {
            boolean acquired = false;
            try {
                try {
                    acquired = this.stateLock.tryLock(Activator.this.m_configuration.stopTimeout(), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    Activator.this.logger.log(InternalLogger.Level.WARN, "The wait for {0} being destroyed before destruction has been interrupted.", e, this.bundle);
                }
                Activator.this.loadComponents(this.bundle);
            }
            finally {
                if (acquired) {
                    this.stateLock.unlock();
                }
            }
        }

        public void destroy() {
            boolean acquired = false;
            try {
                try {
                    acquired = this.stateLock.tryLock(Activator.this.m_configuration.stopTimeout(), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    Activator.this.logger.log(InternalLogger.Level.WARN, "The wait for {0} being started before destruction has been interrupted.", e, this.bundle);
                }
                Activator.this.disposeComponents(this.bundle);
            }
            finally {
                if (acquired) {
                    this.stateLock.unlock();
                }
            }
        }
    }
}

