/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.logger;

import org.apache.felix.scr.impl.logger.InternalLogger;
import org.apache.felix.scr.impl.logger.R6LogServiceLogger;
import org.apache.felix.scr.impl.logger.R7LogServiceLogger;
import org.osgi.framework.Bundle;
import org.osgi.service.log.LogService;

class LogServiceSupport {
    private final boolean r7Enabled;
    private final LogService logService;
    private final Bundle bundle;

    public LogServiceSupport(Bundle bundle, Object logService) {
        this.logService = (LogService)logService;
        this.bundle = bundle;
        this.r7Enabled = "org.osgi.service.log.LoggerFactory".equals(this.logService.getClass().getSuperclass().getName());
    }

    InternalLogger getLogger() {
        if (this.r7Enabled) {
            return new R7LogServiceLogger(this.bundle, this.logService, null);
        }
        return new R6LogServiceLogger(this.logService);
    }

    InternalLogger getLogger(String className) {
        if (this.r7Enabled) {
            return new R7LogServiceLogger(this.bundle, this.logService, className);
        }
        return new R6LogServiceLogger(this.logService);
    }
}

