/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.inject;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.felix.scr.impl.helper.MethodResult;
import org.apache.felix.scr.impl.helper.ReadOnlyDictionary;
import org.apache.felix.scr.impl.helper.ReferenceMethod;
import org.apache.felix.scr.impl.helper.SimpleLogger;
import org.apache.felix.scr.impl.inject.BaseMethod;
import org.apache.felix.scr.impl.inject.BindParameters;
import org.apache.felix.scr.impl.inject.ClassUtils;
import org.apache.felix.scr.impl.inject.SuitableMethodNotAccessibleException;
import org.apache.felix.scr.impl.manager.ComponentContextImpl;
import org.apache.felix.scr.impl.manager.RefPair;
import org.apache.felix.scr.impl.metadata.DSVersion;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindMethod
extends BaseMethod<BindParameters>
implements ReferenceMethod {
    private final String m_referenceClassName;
    private volatile List<ParamType> m_paramTypes = Collections.emptyList();

    public BindMethod(String methodName, Class<?> componentClass, String referenceClassName, DSVersion dsVersion, boolean configurableServiceProperties) {
        super(methodName, componentClass, dsVersion, configurableServiceProperties);
        this.m_referenceClassName = referenceClassName;
    }

    @Override
    protected Method doFindMethod(Class<?> targetClass, boolean acceptPrivate, boolean acceptPackage, SimpleLogger logger) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        Class<?> parameterClass;
        Method method;
        boolean suitableMethodNotAccessible = false;
        if (logger.isLogEnabled(4)) {
            logger.log(4, "doFindMethod: Looking for method " + targetClass.getName() + "." + this.getMethodName(), null);
        }
        try {
            method = this.getServiceReferenceMethod(targetClass, acceptPrivate, acceptPackage, logger);
            if (method != null) {
                if (logger.isLogEnabled(4)) {
                    logger.log(4, "doFindMethod: Found Method " + method, null);
                }
                this.m_paramTypes = Collections.singletonList(ParamType.serviceReference);
                return method;
            }
        }
        catch (SuitableMethodNotAccessibleException ex) {
            suitableMethodNotAccessible = true;
        }
        if (this.getDSVersion().isDS13()) {
            try {
                method = this.getComponentObjectsMethod(targetClass, acceptPrivate, acceptPackage, logger);
                if (method != null) {
                    if (logger.isLogEnabled(4)) {
                        logger.log(4, "doFindMethod: Found Method " + method, null);
                    }
                    this.m_paramTypes = Collections.singletonList(ParamType.serviceObjects);
                    return method;
                }
            }
            catch (SuitableMethodNotAccessibleException ex) {
                suitableMethodNotAccessible = true;
            }
        }
        if ((parameterClass = ClassUtils.getClassFromComponentClassLoader(targetClass, this.m_referenceClassName, logger)) != null) {
            if (logger.isLogEnabled(4)) {
                logger.log(4, "doFindMethod: No method taking ServiceReference found, checking method taking " + parameterClass.getName(), null);
            }
            try {
                method = this.getServiceObjectMethod(targetClass, parameterClass, acceptPrivate, acceptPackage, logger);
                if (method != null) {
                    if (logger.isLogEnabled(4)) {
                        logger.log(4, "doFindMethod: Found Method " + method, null);
                    }
                    this.m_paramTypes = Collections.singletonList(ParamType.serviceType);
                    return method;
                }
            }
            catch (SuitableMethodNotAccessibleException ex) {
                suitableMethodNotAccessible = true;
            }
            try {
                method = this.getServiceObjectAssignableMethod(targetClass, parameterClass, acceptPrivate, acceptPackage, logger);
                if (method != null) {
                    if (logger.isLogEnabled(4)) {
                        logger.log(4, "doFindMethod: Found Method " + method, null);
                    }
                    this.m_paramTypes = Collections.singletonList(ParamType.serviceType);
                    return method;
                }
            }
            catch (SuitableMethodNotAccessibleException ex) {
                suitableMethodNotAccessible = true;
            }
            if (this.getDSVersion().isDS13()) {
                try {
                    method = this.getMapMethod(targetClass, parameterClass, acceptPrivate, acceptPackage, logger);
                    if (method != null) {
                        if (logger.isLogEnabled(4)) {
                            logger.log(4, "doFindMethod: Found Method " + method, null);
                        }
                        this.m_paramTypes = Collections.singletonList(ParamType.map);
                        return method;
                    }
                }
                catch (SuitableMethodNotAccessibleException ex) {
                    suitableMethodNotAccessible = true;
                }
            }
            if (this.getDSVersion().isDS11() && !this.getDSVersion().isDS13()) {
                ArrayList<ParamType> paramTypes;
                try {
                    method = this.getServiceObjectWithMapMethod(targetClass, parameterClass, acceptPrivate, acceptPackage, logger);
                    if (method != null) {
                        if (logger.isLogEnabled(4)) {
                            logger.log(4, "doFindMethod: Found Method " + method, null);
                        }
                        paramTypes = new ArrayList<ParamType>(2);
                        paramTypes.add(ParamType.serviceType);
                        paramTypes.add(ParamType.map);
                        this.m_paramTypes = paramTypes;
                        return method;
                    }
                }
                catch (SuitableMethodNotAccessibleException ex) {
                    suitableMethodNotAccessible = true;
                }
                try {
                    method = this.getServiceObjectAssignableWithMapMethod(targetClass, parameterClass, acceptPrivate, acceptPackage);
                    if (method != null) {
                        if (logger.isLogEnabled(4)) {
                            logger.log(4, "doFindMethod: Found Method " + method, null);
                        }
                        paramTypes = new ArrayList(2);
                        paramTypes.add(ParamType.serviceType);
                        paramTypes.add(ParamType.map);
                        this.m_paramTypes = paramTypes;
                        return method;
                    }
                }
                catch (SuitableMethodNotAccessibleException ex) {
                    suitableMethodNotAccessible = true;
                }
            }
            if (this.getDSVersion().isDS13()) {
                for (Method m : targetClass.getDeclaredMethods()) {
                    if (!this.getMethodName().equals(m.getName())) continue;
                    Class<?>[] parameterTypes = m.getParameterTypes();
                    boolean matches = true;
                    boolean specialMatch = true;
                    ArrayList<ParamType> paramTypes = new ArrayList<ParamType>(parameterTypes.length);
                    for (Class<?> paramType : parameterTypes) {
                        if (paramType == ClassUtils.SERVICE_REFERENCE_CLASS) {
                            if (specialMatch && parameterClass == ClassUtils.SERVICE_REFERENCE_CLASS) {
                                specialMatch = false;
                                paramTypes.add(ParamType.serviceType);
                                continue;
                            }
                            paramTypes.add(ParamType.serviceReference);
                            continue;
                        }
                        if (paramType == ClassUtils.COMPONENTS_SERVICE_OBJECTS_CLASS) {
                            if (specialMatch && parameterClass == ClassUtils.COMPONENTS_SERVICE_OBJECTS_CLASS) {
                                specialMatch = false;
                                paramTypes.add(ParamType.serviceType);
                                continue;
                            }
                            paramTypes.add(ParamType.serviceObjects);
                            continue;
                        }
                        if (paramType == Map.class) {
                            if (specialMatch && parameterClass == Map.class) {
                                specialMatch = false;
                                paramTypes.add(ParamType.serviceType);
                                continue;
                            }
                            paramTypes.add(ParamType.map);
                            continue;
                        }
                        if (paramType.isAssignableFrom(parameterClass)) {
                            paramTypes.add(ParamType.serviceType);
                            continue;
                        }
                        matches = false;
                        break;
                    }
                    if (!matches) continue;
                    if (BindMethod.accept(m, acceptPrivate, acceptPackage, this.returnValue())) {
                        if (logger.isLogEnabled(4)) {
                            logger.log(4, "doFindMethod: Found Method " + m, null);
                        }
                        this.m_paramTypes = paramTypes;
                        return m;
                    }
                    suitableMethodNotAccessible = true;
                }
            }
        } else if (logger.isLogEnabled(2)) {
            logger.log(2, "doFindMethod: Cannot check for methods taking parameter class " + this.m_referenceClassName + ": " + targetClass.getName() + " does not see it", null);
        }
        if (suitableMethodNotAccessible) {
            logger.log(1, "doFindMethod: Suitable but non-accessible method found in class {0}", new Object[]{targetClass.getName()}, null);
            throw new SuitableMethodNotAccessibleException();
        }
        return null;
    }

    private Method getServiceReferenceMethod(Class<?> targetClass, boolean acceptPrivate, boolean acceptPackage, SimpleLogger logger) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        return this.getMethod(targetClass, this.getMethodName(), new Class[]{ClassUtils.SERVICE_REFERENCE_CLASS}, acceptPrivate, acceptPackage, logger);
    }

    private Method getComponentObjectsMethod(Class<?> targetClass, boolean acceptPrivate, boolean acceptPackage, SimpleLogger logger) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        return this.getMethod(targetClass, this.getMethodName(), new Class[]{ClassUtils.COMPONENTS_SERVICE_OBJECTS_CLASS}, acceptPrivate, acceptPackage, logger);
    }

    private Method getServiceObjectMethod(Class<?> targetClass, Class<?> parameterClass, boolean acceptPrivate, boolean acceptPackage, SimpleLogger logger) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        return this.getMethod(targetClass, this.getMethodName(), new Class[]{parameterClass}, acceptPrivate, acceptPackage, logger);
    }

    private Method getServiceObjectAssignableMethod(Class<?> targetClass, Class<?> parameterClass, boolean acceptPrivate, boolean acceptPackage, SimpleLogger logger) throws SuitableMethodNotAccessibleException {
        Method[] candidateBindMethods = targetClass.getDeclaredMethods();
        boolean suitableNotAccessible = false;
        if (logger.isLogEnabled(4)) {
            logger.log(4, "getServiceObjectAssignableMethod: Checking " + candidateBindMethods.length + " declared method in class " + targetClass.getName(), null);
        }
        for (int i = 0; i < candidateBindMethods.length; ++i) {
            Class<?> theParameter;
            Class<?>[] parameters;
            Method method = candidateBindMethods[i];
            if (logger.isLogEnabled(4)) {
                logger.log(4, "getServiceObjectAssignableMethod: Checking " + method, null);
            }
            if ((parameters = method.getParameterTypes()).length != 1 || !method.getName().equals(this.getMethodName())) continue;
            if (logger.isLogEnabled(4)) {
                logger.log(4, "getServiceObjectAssignableMethod: Considering " + method, null);
            }
            if ((theParameter = parameters[0]).isAssignableFrom(parameterClass)) {
                if (BindMethod.accept(method, acceptPrivate, acceptPackage, false)) {
                    return method;
                }
                suitableNotAccessible = true;
                continue;
            }
            if (!logger.isLogEnabled(4)) continue;
            logger.log(4, "getServiceObjectAssignableMethod: Parameter failure: Required " + theParameter + "; actual " + parameterClass.getName(), null);
        }
        if (suitableNotAccessible) {
            throw new SuitableMethodNotAccessibleException();
        }
        return null;
    }

    private Method getServiceObjectWithMapMethod(Class<?> targetClass, Class<?> parameterClass, boolean acceptPrivate, boolean acceptPackage, SimpleLogger logger) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        return this.getMethod(targetClass, this.getMethodName(), new Class[]{parameterClass, ClassUtils.MAP_CLASS}, acceptPrivate, acceptPackage, logger);
    }

    private Method getServiceObjectAssignableWithMapMethod(Class<?> targetClass, Class<?> parameterClass, boolean acceptPrivate, boolean acceptPackage) throws SuitableMethodNotAccessibleException {
        Method[] candidateBindMethods = targetClass.getDeclaredMethods();
        boolean suitableNotAccessible = false;
        for (int i = 0; i < candidateBindMethods.length; ++i) {
            Method method = candidateBindMethods[i];
            Class<?>[] parameters = method.getParameterTypes();
            if (parameters.length != 2 || !method.getName().equals(this.getMethodName()) || !parameters[0].isAssignableFrom(parameterClass) || parameters[1] != ClassUtils.MAP_CLASS) continue;
            if (BindMethod.accept(method, acceptPrivate, acceptPackage, false)) {
                return method;
            }
            suitableNotAccessible = true;
        }
        if (suitableNotAccessible) {
            throw new SuitableMethodNotAccessibleException();
        }
        return null;
    }

    private Method getMapMethod(Class<?> targetClass, Class<?> parameterClass, boolean acceptPrivate, boolean acceptPackage, SimpleLogger logger) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        return this.getMethod(targetClass, this.getMethodName(), new Class[]{ClassUtils.MAP_CLASS}, acceptPrivate, acceptPackage, logger);
    }

    @Override
    public <S, T> boolean getServiceObject(ComponentContextImpl<S> key, RefPair<S, T> refPair, BundleContext context, SimpleLogger logger) {
        if (refPair.getServiceObject(key) == null && this.methodExists(logger) && this.m_paramTypes.contains((Object)ParamType.serviceType)) {
            return refPair.getServiceObject(key, context, logger);
        }
        return true;
    }

    @Override
    public MethodResult invoke(Object componentInstance, ComponentContextImpl<?> componentContext, RefPair<?, ?> refPair, MethodResult methodCallFailureResult, SimpleLogger logger) {
        return this.invoke(componentInstance, new BindParameters(componentContext, refPair), methodCallFailureResult, logger);
    }

    @Override
    protected Object[] getParameters(Method method, BindParameters bp) {
        ComponentContextImpl<?> key = bp.getComponentContext();
        Object[] result = new Object[this.m_paramTypes.size()];
        RefPair<?, ?> refPair = bp.getRefPair();
        int i = 0;
        block6: for (ParamType pt : this.m_paramTypes) {
            switch (pt) {
                case serviceReference: {
                    result[i++] = refPair.getRef();
                    continue block6;
                }
                case serviceObjects: {
                    result[i++] = bp.getComponentContext().getComponentServiceObjectsHelper().getServiceObjects(refPair.getRef());
                    continue block6;
                }
                case map: {
                    result[i++] = new ReadOnlyDictionary(refPair.getRef());
                    continue block6;
                }
                case serviceType: {
                    result[i++] = refPair.getServiceObject(key);
                    continue block6;
                }
            }
            throw new IllegalStateException("unexpected ParamType: " + (Object)((Object)pt));
        }
        return result;
    }

    @Override
    protected String getMethodNamePrefix() {
        return "bind";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ParamType {
        serviceReference,
        serviceObjects,
        serviceType,
        map;

    }
}

