/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.helper;

import java.lang.reflect.Array;
import java.util.Collection;
import org.osgi.framework.Bundle;
import org.osgi.service.component.ComponentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Coercions {
    private static final byte byte0 = 0;
    private static final char char0 = '\u0000';
    private static final double double0 = 0.0;
    private static final float float0 = 0.0f;
    private static final int int0 = 0;
    private static final long long0 = 0L;
    private static final short short0 = 0;

    public static Object coerce(Class<?> type, Object raw, Bundle bundle) {
        if (type == Byte.class || type == Byte.TYPE) {
            return Coercions.coerceToByte(raw);
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return Coercions.coerceToBoolean(raw);
        }
        if (type == Character.class || type == Character.TYPE) {
            return Character.valueOf(Coercions.coerceToChar(raw));
        }
        if (type == Class.class) {
            return Coercions.coerceToClass(raw, bundle);
        }
        if (type == Double.class || type == Double.TYPE) {
            return Coercions.coerceToDouble(raw);
        }
        if (type.isEnum()) {
            Class<?> clazz = type;
            return Coercions.coerceToEnum(raw, clazz);
        }
        if (type == Float.class || type == Float.TYPE) {
            return Float.valueOf(Coercions.coerceToFloat(raw));
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return Coercions.coerceToInteger(raw);
        }
        if (type == Long.class || type == Long.TYPE) {
            return Coercions.coerceToLong(raw);
        }
        if (type == Short.class || type == Short.TYPE) {
            return Coercions.coerceToShort(raw);
        }
        if (type == String.class) {
            return Coercions.coerceToString(raw);
        }
        throw new ComponentException("unexpected output type " + type);
    }

    public static byte coerceToByte(Object o) {
        if ((o = Coercions.multipleToSingle(o, (byte)0)) instanceof Byte) {
            return (Byte)o;
        }
        if (o instanceof String) {
            try {
                return Byte.parseByte((String)o);
            }
            catch (NumberFormatException e) {
                throw new ComponentException(e);
            }
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? (byte)1 : 0;
        }
        if (o instanceof Character) {
            return (byte)((Character)o).charValue();
        }
        if (o instanceof Number) {
            return ((Number)o).byteValue();
        }
        if (o == null) {
            return 0;
        }
        throw new ComponentException("Unrecognized input value: " + o + " of type: " + o.getClass());
    }

    public static char coerceToChar(Object o) {
        if ((o = Coercions.multipleToSingle(o, (byte)0)) instanceof Character) {
            return ((Character)o).charValue();
        }
        if (o instanceof String) {
            if (((String)o).length() > 0) {
                return ((String)o).charAt(0);
            }
            return '\u0000';
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? (char)'\u0001' : '\u0000';
        }
        if (o instanceof Number) {
            return (char)((Number)o).intValue();
        }
        if (o == null) {
            return '\u0000';
        }
        throw new ComponentException("Unrecognized input value: " + o + " of type: " + o.getClass());
    }

    public static double coerceToDouble(Object o) {
        if ((o = Coercions.multipleToSingle(o, 0.0)) instanceof Double) {
            return (Double)o;
        }
        if (o instanceof String) {
            try {
                return Double.parseDouble((String)o);
            }
            catch (NumberFormatException e) {
                throw new ComponentException(e);
            }
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1.0 : 0.0;
        }
        if (o instanceof Character) {
            return ((Character)o).charValue();
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o == null) {
            return 0.0;
        }
        throw new ComponentException("Unrecognized input value: " + o + " of type: " + o.getClass());
    }

    public static float coerceToFloat(Object o) {
        if ((o = Coercions.multipleToSingle(o, Float.valueOf(0.0f))) instanceof Float) {
            return ((Float)o).floatValue();
        }
        if (o instanceof String) {
            try {
                return Float.parseFloat((String)o);
            }
            catch (NumberFormatException e) {
                throw new ComponentException(e);
            }
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1.0f : 0.0f;
        }
        if (o instanceof Character) {
            return ((Character)o).charValue();
        }
        if (o instanceof Number) {
            return ((Number)o).floatValue();
        }
        if (o == null) {
            return 0.0f;
        }
        throw new ComponentException("Unrecognized input value: " + o + " of type: " + o.getClass());
    }

    public static int coerceToInteger(Object o) {
        if ((o = Coercions.multipleToSingle(o, 0)) instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof String) {
            try {
                return Integer.parseInt((String)o);
            }
            catch (NumberFormatException e) {
                throw new ComponentException(e);
            }
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1 : 0;
        }
        if (o instanceof Character) {
            return ((Character)o).charValue();
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o == null) {
            return 0;
        }
        throw new ComponentException("Unrecognized input value: " + o + " of type: " + o.getClass());
    }

    public static long coerceToLong(Object o) {
        if ((o = Coercions.multipleToSingle(o, 0L)) instanceof Long) {
            return (Long)o;
        }
        if (o instanceof String) {
            try {
                return Long.parseLong((String)o);
            }
            catch (NumberFormatException e) {
                throw new ComponentException(e);
            }
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1L : 0L;
        }
        if (o instanceof Character) {
            return ((Character)o).charValue();
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o == null) {
            return 0L;
        }
        throw new ComponentException("Unrecognized input value: " + o + " of type: " + o.getClass());
    }

    public static short coerceToShort(Object o) {
        if ((o = Coercions.multipleToSingle(o, (short)0)) instanceof Short) {
            return (Short)o;
        }
        if (o instanceof String) {
            try {
                return Short.parseShort((String)o);
            }
            catch (NumberFormatException e) {
                throw new ComponentException(e);
            }
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? (short)1 : 0;
        }
        if (o instanceof Character) {
            return (short)((Character)o).charValue();
        }
        if (o instanceof Number) {
            return ((Number)o).shortValue();
        }
        if (o == null) {
            return 0;
        }
        throw new ComponentException("Unrecognized input value: " + o + " of type: " + o.getClass());
    }

    public static String coerceToString(Object o) {
        if ((o = Coercions.multipleToSingle(o, null)) instanceof String) {
            return (String)o;
        }
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public static boolean coerceToBoolean(Object o) {
        if ((o = Coercions.multipleToSingle(o, false)) instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            try {
                return Boolean.parseBoolean((String)o);
            }
            catch (NumberFormatException e) {
                throw new ComponentException(e);
            }
        }
        if (o instanceof Character) {
            return ((Character)o).charValue() != '\u0000';
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue() != 0.0;
        }
        if (o == null) {
            return false;
        }
        throw new ComponentException("Unrecognized input value: " + o + " of type: " + o.getClass());
    }

    public static Class<?> coerceToClass(Object o, Bundle b) {
        if ((o = Coercions.multipleToSingle(o, null)) == null) {
            return null;
        }
        if (o instanceof String) {
            try {
                return b.loadClass((String)o);
            }
            catch (ClassNotFoundException e) {
                throw new ComponentException(e);
            }
        }
        throw new ComponentException("Unrecognized input value: " + o + " of type: " + o.getClass());
    }

    public static <T extends Enum<T>> T coerceToEnum(Object o, Class<T> clazz) {
        if ((o = Coercions.multipleToSingle(o, null)) instanceof String) {
            try {
                return Enum.valueOf(clazz, (String)o);
            }
            catch (IllegalArgumentException e) {
                throw new ComponentException(e);
            }
        }
        if (o == null) {
            return null;
        }
        throw new ComponentException("Unrecognized input value: " + o + " of type: " + o.getClass());
    }

    private static Object multipleToSingle(Object o, Object defaultValue) {
        if (o instanceof Collection) {
            return Coercions.firstCollectionElement(o, defaultValue);
        }
        if (o != null && o.getClass().isArray()) {
            return Coercions.firstArrayElement(o, defaultValue);
        }
        return o;
    }

    private static Object firstCollectionElement(Object raw, Object defaultValue) {
        if (!(raw instanceof Collection)) {
            throw new ComponentException("Not a collection: " + raw);
        }
        Collection c = (Collection)raw;
        if (c.isEmpty()) {
            return defaultValue;
        }
        return c.iterator().next();
    }

    private static Object firstArrayElement(Object o, Object defaultValue) {
        if (o == null || !o.getClass().isArray()) {
            throw new ComponentException("Not an array: " + o);
        }
        if (Array.getLength(o) == 0) {
            return defaultValue;
        }
        return Array.get(o, 0);
    }
}

