/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.metadata;

import java.util.ArrayList;
import java.util.List;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;

public class ServiceMetadata {
    private Boolean m_serviceFactory;
    private String m_scopeName;
    private Scope m_scope = Scope.singleton;
    private List<String> m_provides = new ArrayList<String>();
    private boolean m_validated = false;

    public void setServiceFactory(boolean serviceFactory) {
        if (this.m_validated) {
            return;
        }
        this.m_serviceFactory = serviceFactory;
    }

    public void setScope(String scopeName) {
        if (this.m_validated) {
            return;
        }
        this.m_scopeName = scopeName;
    }

    public Scope getScope() {
        return this.m_scope;
    }

    public void addProvide(String provide) {
        if (this.m_validated) {
            return;
        }
        this.m_provides.add(provide);
    }

    public String[] getProvides() {
        return this.m_provides.toArray(new String[this.m_provides.size()]);
    }

    void validate(ComponentMetadata componentMetadata) {
        if (this.m_provides.size() == 0) {
            throw componentMetadata.validationFailure("At least one provided interface must be declared in the service element");
        }
        for (String provide : this.m_provides) {
            if (provide != null) continue;
            throw componentMetadata.validationFailure("Null provides.  Possibly service is not specified as value of attribute 'interface'");
        }
        if (this.m_serviceFactory != null) {
            if (componentMetadata.getDSVersion().isDS13()) {
                throw componentMetadata.validationFailure("service-factory can only be specified in version 1.2 and earlier");
            }
            Scope scope = this.m_scope = this.m_serviceFactory != false ? Scope.bundle : Scope.singleton;
        }
        if (this.m_scopeName != null) {
            if (!componentMetadata.getDSVersion().isDS13()) {
                throw componentMetadata.validationFailure("service scope can only be specified in version 1.3 and later");
            }
            try {
                this.m_scope = Scope.valueOf(this.m_scopeName);
            }
            catch (IllegalArgumentException e) {
                throw componentMetadata.validationFailure("Service scope may be only 'singleton' 'bundle' or 'prototype' not " + this.m_scopeName);
            }
        }
        this.m_validated = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Scope {
        singleton,
        bundle,
        prototype;

    }
}

