/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.helper;

import org.apache.felix.scr.impl.helper.BindParameters;
import org.apache.felix.scr.impl.helper.InitReferenceMethod;
import org.apache.felix.scr.impl.helper.MethodResult;
import org.apache.felix.scr.impl.helper.ReferenceMethod;
import org.apache.felix.scr.impl.helper.ReferenceMethods;
import org.apache.felix.scr.impl.helper.SimpleLogger;
import org.apache.felix.scr.impl.manager.ComponentContextImpl;
import org.apache.felix.scr.impl.manager.RefPair;
import org.osgi.framework.BundleContext;

public class DuplexReferenceMethods
implements ReferenceMethods {
    private final ReferenceMethods first;
    private final ReferenceMethods second;

    public DuplexReferenceMethods(ReferenceMethods first, ReferenceMethods second) {
        this.first = first;
        this.second = second;
    }

    public ReferenceMethod getBind() {
        return new DuplexReferenceMethod(this.first.getBind(), this.second.getBind());
    }

    public ReferenceMethod getUnbind() {
        return new DuplexReferenceMethod(this.first.getUnbind(), this.second.getUnbind());
    }

    public ReferenceMethod getUpdated() {
        return new DuplexReferenceMethod(this.first.getUpdated(), this.second.getUpdated());
    }

    public InitReferenceMethod getInit() {
        return new InitReferenceMethod(){

            public boolean init(Object componentInstance, SimpleLogger logger) {
                InitReferenceMethod i1 = DuplexReferenceMethods.this.first.getInit();
                if (i1 != null && !i1.init(componentInstance, logger)) {
                    return false;
                }
                InitReferenceMethod i2 = DuplexReferenceMethods.this.second.getInit();
                return i2 == null || i2.init(componentInstance, logger);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DuplexReferenceMethod
    implements ReferenceMethod {
        private final ReferenceMethod first;
        private final ReferenceMethod second;

        public DuplexReferenceMethod(ReferenceMethod first, ReferenceMethod second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public MethodResult invoke(Object componentInstance, BindParameters rawParameter, MethodResult methodCallFailureResult, SimpleLogger logger) {
            if (this.first.invoke(componentInstance, rawParameter, methodCallFailureResult, logger) != null) {
                return this.second.invoke(componentInstance, rawParameter, methodCallFailureResult, logger);
            }
            return null;
        }

        @Override
        public <S, T> boolean getServiceObject(ComponentContextImpl<S> key, RefPair<S, T> refPair, BundleContext context, SimpleLogger logger) {
            boolean result = this.first.getServiceObject(key, refPair, context, logger);
            if (result) {
                result = this.second.getServiceObject(key, refPair, context, logger);
            }
            return result;
        }
    }
}

