/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.helper;

import java.util.HashMap;
import java.util.Map;
import org.apache.felix.scr.impl.helper.ActivateMethod;
import org.apache.felix.scr.impl.helper.BindMethods;
import org.apache.felix.scr.impl.helper.DeactivateMethod;
import org.apache.felix.scr.impl.helper.DuplexReferenceMethods;
import org.apache.felix.scr.impl.helper.FieldMethods;
import org.apache.felix.scr.impl.helper.ModifiedMethod;
import org.apache.felix.scr.impl.helper.ReferenceMethods;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.apache.felix.scr.impl.metadata.DSVersion;
import org.apache.felix.scr.impl.metadata.ReferenceMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentMethods {
    private ActivateMethod m_activateMethod;
    private ModifiedMethod m_modifiedMethod;
    private DeactivateMethod m_deactivateMethod;
    private final Map<String, ReferenceMethods> bindMethodMap = new HashMap<String, ReferenceMethods>();

    public synchronized void initComponentMethods(ComponentMetadata componentMetadata, Class<?> implementationObjectClass) {
        if (this.m_activateMethod != null) {
            return;
        }
        DSVersion dsVersion = componentMetadata.getDSVersion();
        boolean configurableServiceProperties = componentMetadata.isConfigurableServiceProperties();
        boolean supportsInterfaces = componentMetadata.isConfigureWithInterfaces();
        this.m_activateMethod = new ActivateMethod(componentMetadata.getActivate(), componentMetadata.isActivateDeclared(), implementationObjectClass, dsVersion, configurableServiceProperties, supportsInterfaces);
        this.m_deactivateMethod = new DeactivateMethod(componentMetadata.getDeactivate(), componentMetadata.isDeactivateDeclared(), implementationObjectClass, dsVersion, configurableServiceProperties, supportsInterfaces);
        this.m_modifiedMethod = new ModifiedMethod(componentMetadata.getModified(), implementationObjectClass, dsVersion, configurableServiceProperties, supportsInterfaces);
        for (ReferenceMetadata referenceMetadata : componentMetadata.getDependencies()) {
            String refName = referenceMetadata.getName();
            ReferenceMethods methods = referenceMetadata.getField() != null && referenceMetadata.getBind() != null ? new DuplexReferenceMethods(new FieldMethods(referenceMetadata, implementationObjectClass, dsVersion, configurableServiceProperties), new BindMethods(referenceMetadata, implementationObjectClass, dsVersion, configurableServiceProperties)) : (referenceMetadata.getField() != null ? new FieldMethods(referenceMetadata, implementationObjectClass, dsVersion, configurableServiceProperties) : new BindMethods(referenceMetadata, implementationObjectClass, dsVersion, configurableServiceProperties));
            this.bindMethodMap.put(refName, methods);
        }
    }

    public ActivateMethod getActivateMethod() {
        return this.m_activateMethod;
    }

    public DeactivateMethod getDeactivateMethod() {
        return this.m_deactivateMethod;
    }

    public ModifiedMethod getModifiedMethod() {
        return this.m_modifiedMethod;
    }

    public ReferenceMethods getBindMethods(String refName) {
        return this.bindMethodMap.get(refName);
    }
}

