/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.config;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.felix.scr.Component;
import org.apache.felix.scr.impl.Activator;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.TargetedPID;
import org.apache.felix.scr.impl.config.ComponentHolder;
import org.apache.felix.scr.impl.helper.ComponentMethods;
import org.apache.felix.scr.impl.helper.SimpleLogger;
import org.apache.felix.scr.impl.manager.ServiceFactoryComponentManager;
import org.apache.felix.scr.impl.manager.SingleComponentManager;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurableComponentHolder<S>
implements ComponentHolder,
SimpleLogger {
    private final BundleComponentActivator m_activator;
    private final ComponentMetadata m_componentMetadata;
    private final Map<String, SingleComponentManager<S>> m_components;
    private SingleComponentManager<S> m_singleComponent;
    private volatile boolean m_enabled;
    private final ComponentMethods m_componentMethods;

    public ConfigurableComponentHolder(BundleComponentActivator activator, ComponentMetadata metadata) {
        this.m_activator = activator;
        this.m_componentMetadata = metadata;
        this.m_components = new HashMap<String, SingleComponentManager<S>>();
        this.m_componentMethods = new ComponentMethods();
        this.m_singleComponent = this.createComponentManager();
        this.m_enabled = false;
    }

    protected SingleComponentManager<S> createComponentManager() {
        if (this.m_componentMetadata.isFactory()) {
            throw new IllegalArgumentException("Cannot create component factory for " + this.m_componentMetadata.getName());
        }
        SingleComponentManager manager = this.m_componentMetadata.getServiceMetadata() != null && this.m_componentMetadata.getServiceMetadata().isServiceFactory() ? new ServiceFactoryComponentManager(this.m_activator, this, this.m_componentMetadata, this.m_componentMethods) : new SingleComponentManager(this.m_activator, this, this.m_componentMetadata, this.m_componentMethods);
        return manager;
    }

    @Override
    public final BundleComponentActivator getActivator() {
        return this.m_activator;
    }

    @Override
    public final ComponentMetadata getComponentMetadata() {
        return this.m_componentMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configurationDeleted(String pid) {
        SingleComponentManager<S> icm;
        this.log(4, "ImmediateComponentHolder configuration deleted for pid {0}", new Object[]{pid}, null);
        boolean deconfigure = false;
        Map<String, SingleComponentManager<S>> map = this.m_components;
        synchronized (map) {
            if (this.m_singleComponent == null) {
                return;
            }
            if (pid.equals(this.getComponentMetadata().getConfigurationPid())) {
                icm = this.m_singleComponent;
                deconfigure = true;
            } else {
                icm = this.m_components.remove(pid);
                if (icm == null) {
                    return;
                }
                if (this.m_singleComponent == icm) {
                    if (this.m_components.isEmpty()) {
                        deconfigure = true;
                    } else {
                        this.m_singleComponent = this.m_components.values().iterator().next();
                    }
                }
            }
        }
        if (deconfigure) {
            icm.reconfigure(null, -1L, null);
        } else {
            icm.dispose(4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean configurationUpdated(String pid, Dictionary<String, Object> props, long changeCount, TargetedPID targetedPid) {
        boolean enable;
        String message;
        SingleComponentManager<S> icm;
        this.log(4, "ImmediateComponentHolder configuration updated for pid {0} with properties {1}", new Object[]{pid, props}, null);
        Object[] notEnabledArguments = null;
        boolean created = false;
        Map<String, SingleComponentManager<S>> map = this.m_components;
        synchronized (map) {
            if (this.m_singleComponent == null) {
                return false;
            }
            if (pid.equals(this.getComponentMetadata().getConfigurationPid())) {
                icm = this.m_singleComponent;
                message = "ImmediateComponentHolder reconfiguring single component for pid {0} ";
                enable = false;
            } else {
                SingleComponentManager<S> existingIcm = this.m_components.get(pid);
                if (existingIcm != null) {
                    icm = existingIcm;
                    message = "ImmediateComponentHolder reconfiguring existing component for pid {0} ";
                    enable = false;
                } else {
                    created = true;
                    if (!this.m_singleComponent.hasConfiguration()) {
                        icm = this.m_singleComponent;
                        message = "ImmediateComponentHolder configuring the unconfigured single component for pid {0} ";
                    } else {
                        icm = this.createComponentManager();
                        message = "ImmediateComponentHolder configuring a new component for pid {0} ";
                    }
                    if (this.m_enabled && this.getComponentMetadata().isEnabled()) {
                        enable = true;
                    } else {
                        enable = false;
                        notEnabledArguments = new Object[]{pid, this.m_enabled, this.getComponentMetadata().isEnabled()};
                    }
                    this.m_components.put(pid, icm);
                }
            }
        }
        this.log(4, message, new Object[]{pid}, null);
        icm.reconfigure(props, changeCount, targetedPid);
        this.log(4, "ImmediateComponentHolder Finished configuring the dependency managers for component for pid {0} ", new Object[]{pid}, null);
        if (enable) {
            icm.enable(false);
            this.log(4, "ImmediateComponentHolder Finished enabling component for pid {0} ", new Object[]{pid}, null);
        } else if (notEnabledArguments != null) {
            this.log(4, "ImmediateComponentHolder Will not enable component for pid {0}: holder enabled state: {1}, metadata enabled: {2} ", notEnabledArguments, null);
        }
        return created;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getChangeCount(String pid) {
        Map<String, SingleComponentManager<S>> map = this.m_components;
        synchronized (map) {
            SingleComponentManager<S> icm = pid.equals(this.getComponentMetadata().getConfigurationPid()) ? this.m_singleComponent : this.m_components.get(pid);
            return icm == null ? -1L : icm.getChangeCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component[] getComponents() {
        Map<String, SingleComponentManager<S>> map = this.m_components;
        synchronized (map) {
            return this.getComponentManagers(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableComponents(boolean async) {
        SingleComponentManager<S>[] cms;
        Map<String, SingleComponentManager<S>> map = this.m_components;
        synchronized (map) {
            this.m_enabled = true;
            cms = this.getComponentManagers(false);
        }
        for (SingleComponentManager<S> cm : cms) {
            cm.enable(async);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableComponents(boolean async) {
        SingleComponentManager<S>[] cms;
        Map<String, SingleComponentManager<S>> map = this.m_components;
        synchronized (map) {
            this.m_enabled = false;
            cms = this.getComponentManagers(false);
        }
        for (SingleComponentManager<S> cm : cms) {
            cm.disable(async);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disposeComponents(int reason) {
        SingleComponentManager<S>[] cms;
        Map<String, SingleComponentManager<S>> map = this.m_components;
        synchronized (map) {
            cms = this.getComponentManagers(true);
        }
        for (SingleComponentManager<S> cm : cms) {
            cm.dispose(reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disposed(SingleComponentManager component) {
        Map<String, SingleComponentManager<S>> map = this.m_components;
        synchronized (map) {
            if (!this.m_components.isEmpty()) {
                Iterator<SingleComponentManager<S>> vi = this.m_components.values().iterator();
                while (vi.hasNext()) {
                    if (component != vi.next()) continue;
                    vi.remove();
                    break;
                }
            }
            if (component == this.m_singleComponent) {
                this.m_singleComponent = this.m_components.isEmpty() ? this.createComponentManager() : this.m_components.values().iterator().next();
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof ConfigurableComponentHolder)) {
            return false;
        }
        ConfigurableComponentHolder other = (ConfigurableComponentHolder)object;
        return this.m_activator == other.m_activator && this.getName().equals(other.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return "[ImmediateComponentHolder:" + this.getName() + "]";
    }

    String getName() {
        return this.m_componentMetadata.getName();
    }

    private SingleComponentManager<S>[] getComponentManagers(boolean clear) {
        SingleComponentManager[] cm;
        if (this.m_components.isEmpty()) {
            cm = this.m_singleComponent != null ? new SingleComponentManager[]{this.m_singleComponent} : null;
        } else {
            cm = new SingleComponentManager[this.m_components.size()];
            this.m_components.values().toArray(cm);
        }
        if (clear) {
            this.m_components.clear();
            this.m_singleComponent = null;
        }
        return cm;
    }

    @Override
    public boolean isLogEnabled(int level) {
        return Activator.isLogEnabled(level);
    }

    @Override
    public void log(int level, String message, Throwable ex) {
        BundleComponentActivator activator = this.getActivator();
        if (activator != null) {
            activator.log(level, message, this.getComponentMetadata(), null, ex);
        }
    }

    @Override
    public void log(int level, String message, Object[] arguments, Throwable ex) {
        BundleComponentActivator activator = this.getActivator();
        if (activator != null) {
            activator.log(level, message, arguments, this.getComponentMetadata(), null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TargetedPID getConfigurationTargetedPID(TargetedPID pid) {
        SingleComponentManager<S> icm = null;
        Map<String, SingleComponentManager<S>> map = this.m_components;
        synchronized (map) {
            icm = pid.getServicePid().equals(this.m_componentMetadata.getConfigurationPid()) ? this.m_singleComponent : this.m_components.get(pid.getServicePid());
        }
        if (icm != null) {
            return icm.getConfigurationTargetedPID();
        }
        return null;
    }
}

