/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.felix.scr.Reference;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.helper.BindMethod;
import org.apache.felix.scr.impl.helper.BindMethods;
import org.apache.felix.scr.impl.helper.MethodResult;
import org.apache.felix.scr.impl.manager.AbstractComponentManager;
import org.apache.felix.scr.impl.manager.EdgeInfo;
import org.apache.felix.scr.impl.manager.RefPair;
import org.apache.felix.scr.impl.manager.ServiceTracker;
import org.apache.felix.scr.impl.manager.ServiceTrackerCustomizer;
import org.apache.felix.scr.impl.metadata.ReferenceMetadata;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyManager<S, T>
implements Reference {
    private static final int STATE_MASK = 112;
    private final AbstractComponentManager<S> m_componentManager;
    private final ReferenceMetadata m_dependencyMetadata;
    private final int m_index;
    private final Customizer<T> m_customizer;
    private volatile BindMethods m_bindMethods;
    private volatile ServiceTracker<T, RefPair<T>> m_tracker;
    private volatile String m_target;
    private volatile Filter m_targetFilter;

    DependencyManager(AbstractComponentManager<S> componentManager, ReferenceMetadata dependency, int index) {
        this.m_componentManager = componentManager;
        this.m_dependencyMetadata = dependency;
        this.m_index = index;
        this.m_customizer = this.newCustomizer();
        if (this.m_componentManager.isLogEnabled(4)) {
            this.m_componentManager.log(4, "Dependency Manager {0} created: interface={1}, filter={2}, policy={3}, cardinality={4}, bind={5}, unbind={6}", new Object[]{this.getName(), dependency.getInterface(), dependency.getTarget(), dependency.getPolicy(), dependency.getCardinality(), dependency.getBind(), dependency.getUnbind()}, null);
        }
    }

    int getIndex() {
        return this.m_index;
    }

    void initBindingMethods(BindMethods bindMethods) {
        this.m_bindMethods = bindMethods;
    }

    @Override
    public String getServiceName() {
        return this.m_dependencyMetadata.getInterface();
    }

    @Override
    public boolean isOptional() {
        return this.m_dependencyMetadata.isOptional();
    }

    @Override
    public boolean isMultiple() {
        return this.m_dependencyMetadata.isMultiple();
    }

    @Override
    public boolean isStatic() {
        return this.m_dependencyMetadata.isStatic();
    }

    @Override
    public boolean isReluctant() {
        return this.m_dependencyMetadata.isReluctant();
    }

    @Override
    public String getBindMethodName() {
        return this.m_dependencyMetadata.getBind();
    }

    @Override
    public String getUnbindMethodName() {
        return this.m_dependencyMetadata.getUnbind();
    }

    @Override
    public String getUpdatedMethodName() {
        return this.m_dependencyMetadata.getUpdated();
    }

    void deactivate() {
        this.m_customizer.close();
    }

    int size() {
        AtomicInteger trackingCount = new AtomicInteger();
        return this.m_tracker.getTracked(null, trackingCount).size();
    }

    private ServiceReference<T>[] getFrameworkServiceReferences(String targetFilter) {
        if (this.hasGetPermission()) {
            BundleComponentActivator bca = this.m_componentManager.getActivator();
            if (bca == null) {
                return null;
            }
            BundleContext bc = bca.getBundleContext();
            if (bc == null) {
                return null;
            }
            try {
                return bc.getServiceReferences(this.m_dependencyMetadata.getInterface(), targetFilter);
            }
            catch (IllegalStateException ise) {
            }
            catch (InvalidSyntaxException ise) {
                this.m_componentManager.log(1, "Unexpected problem with filter ''{0}''", new Object[]{targetFilter}, ise);
                return null;
            }
        }
        this.m_componentManager.log(4, "No permission to access the services", null);
        return null;
    }

    private RefPair<T> getBestRefPair() {
        Collection<RefPair<T>> refs = this.m_customizer.getRefs(new AtomicInteger());
        if (refs.isEmpty()) {
            return null;
        }
        return refs.iterator().next();
    }

    T getService() {
        RefPair<T> sr = this.getBestRefPair();
        return this.getService(sr);
    }

    T[] getServices() {
        Collection<RefPair<T>> refs = this.m_customizer.getRefs(new AtomicInteger());
        ArrayList<T> services = new ArrayList<T>(refs.size());
        for (RefPair<T> ref : refs) {
            T service = this.getService(ref);
            if (service == null) continue;
            services.add(service);
        }
        return services.isEmpty() ? null : services.toArray(new Object[services.size()]);
    }

    public ServiceReference<T>[] getServiceReferences() {
        Collection<RefPair<T>> bound = this.m_customizer.getRefs(new AtomicInteger());
        if (bound.isEmpty()) {
            return null;
        }
        ServiceReference[] result = new ServiceReference[bound.size()];
        int i = 0;
        for (RefPair<T> ref : bound) {
            result[i++] = ref.getRef();
        }
        return result;
    }

    @Override
    @Deprecated
    public ServiceReference[] getBoundServiceReferences() {
        return this.getServiceReferences();
    }

    private RefPair<T> getRefPair(ServiceReference<T> serviceReference) {
        AtomicInteger trackingCount = new AtomicInteger();
        return (RefPair)this.m_tracker.getTracked(null, trackingCount).get(serviceReference);
    }

    T getService(ServiceReference<T> serviceReference) {
        RefPair<T> refPair = this.getRefPair(serviceReference);
        return this.getService(refPair);
    }

    private T getService(RefPair<T> refPair) {
        if (refPair == null) {
            return null;
        }
        Object serviceObject = refPair.getServiceObject();
        if (serviceObject != null) {
            return serviceObject;
        }
        BundleContext bundleContext = this.m_componentManager.getBundleContext();
        if (bundleContext == null) {
            this.m_componentManager.log(1, "Bundle shut down while getting service {0} ({1}/{2,number,#})", new Object[]{this.getName(), this.m_dependencyMetadata.getInterface(), refPair.getRef().getProperty("service.id")}, null);
            return null;
        }
        try {
            serviceObject = bundleContext.getService(refPair.getRef());
        }
        catch (Exception e) {
            this.m_componentManager.log(1, "Failed getting service {0} ({1}/{2,number,#})", new Object[]{this.getName(), this.m_dependencyMetadata.getInterface(), refPair.getRef().getProperty("service.id")}, e);
            return null;
        }
        if (!refPair.setServiceObject(serviceObject)) {
            bundleContext.ungetService(refPair.getRef());
        }
        return serviceObject;
    }

    @Override
    public String getName() {
        return this.m_dependencyMetadata.getName();
    }

    @Override
    public boolean isSatisfied() {
        return this.m_customizer.isSatisfied();
    }

    public boolean hasGetPermission() {
        if (System.getSecurityManager() != null) {
            ServicePermission perm = new ServicePermission(this.getServiceName(), "get");
            return this.m_componentManager.getBundle().hasPermission((Object)perm);
        }
        return true;
    }

    boolean prebind() {
        return this.m_customizer.prebind();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean open(S componentInstance, EdgeInfo edgeInfo) {
        CountDownLatch openLatch;
        Collection<RefPair<T>> refs;
        boolean success = this.m_dependencyMetadata.isOptional();
        AtomicInteger trackingCount = new AtomicInteger();
        ServiceTracker.Tracked tracked = this.m_tracker.tracked();
        synchronized (tracked) {
            refs = this.m_customizer.getRefs(trackingCount);
            edgeInfo.setOpen(trackingCount.get());
            openLatch = edgeInfo.getOpenLatch();
        }
        this.m_componentManager.log(4, "For dependency {0}, optional: {1}; to bind: {2}", new Object[]{this.getName(), success, refs}, null);
        for (RefPair<T> refPair : refs) {
            if (refPair.isFailed()) continue;
            if (!this.doInvokeBindMethod(componentInstance, refPair)) {
                this.m_componentManager.log(4, "For dependency {0}, failed to invoke bind method on object {1}", new Object[]{this.getName(), refPair}, null);
            }
            success = true;
        }
        openLatch.countDown();
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(S componentInstance, EdgeInfo edgeInfo) {
        CountDownLatch latch;
        Collection<RefPair<T>> refPairs;
        boolean doUnbind = componentInstance != null && this.m_dependencyMetadata.getUnbind() != null;
        AtomicInteger trackingCount = new AtomicInteger();
        ServiceTracker.Tracked tracked = this.m_tracker.tracked();
        synchronized (tracked) {
            refPairs = this.m_customizer.getRefs(trackingCount);
            edgeInfo.setClose(trackingCount.get());
            latch = edgeInfo.getCloseLatch();
        }
        this.m_componentManager.log(4, "DependencyManager: {0} close component unbinding from {1} at tracking count {2} refpairs: {3}", new Object[]{this.getName(), componentInstance, trackingCount.get(), refPairs}, null);
        this.m_componentManager.waitForTracked(trackingCount.get());
        for (RefPair<T> boundRef : refPairs) {
            if (!doUnbind || boundRef.isFailed()) continue;
            this.invokeUnbindMethod(componentInstance, boundRef, trackingCount.get(), edgeInfo);
        }
        latch.countDown();
    }

    public void invokeBindMethodLate(ServiceReference<T> ref, int trackingCount) {
        RefPair<T> refPair;
        if (!this.isSatisfied()) {
            return;
        }
        if (!this.isMultiple()) {
            Collection<RefPair<T>> refs = this.m_customizer.getRefs(new AtomicInteger());
            if (refs.isEmpty()) {
                return;
            }
            RefPair<T> test = refs.iterator().next();
            if (ref != test.getRef()) {
                return;
            }
        }
        if ((refPair = this.m_tracker.getService(ref)).getServiceObject() != null) {
            this.m_componentManager.log(4, "DependencyManager : late binding of service reference {1} skipped as service has already been located", new Object[]{ref}, null);
            return;
        }
        this.getServiceObject(this.m_bindMethods.getBind(), refPair);
        this.m_componentManager.invokeBindMethod(this, refPair, trackingCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean invokeBindMethod(S componentInstance, RefPair refPair, int trackingCount, EdgeInfo info) {
        if (componentInstance != null) {
            ServiceTracker.Tracked tracked = this.m_tracker.tracked();
            synchronized (tracked) {
                if (info.outOfRange(trackingCount)) {
                    return true;
                }
            }
            return this.doInvokeBindMethod(componentInstance, refPair);
        }
        this.m_componentManager.log(4, "DependencyManager : component not yet created, assuming bind method call succeeded", null);
        return true;
    }

    private boolean doInvokeBindMethod(S componentInstance, RefPair refPair) {
        MethodResult result = this.m_bindMethods.getBind().invoke(componentInstance, refPair, MethodResult.VOID, this.m_componentManager);
        if (result == null) {
            return false;
        }
        this.m_componentManager.setServiceProperties(result);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeUpdatedMethod(S componentInstance, RefPair<T> refPair, int trackingCount, EdgeInfo info) {
        if (this.m_dependencyMetadata.getUpdated() == null) {
            return;
        }
        if (componentInstance != null) {
            ServiceTracker.Tracked tracked = this.m_tracker.tracked();
            synchronized (tracked) {
                if (info.outOfRange(trackingCount)) {
                    return;
                }
            }
            info.waitForOpen(this.m_componentManager, this.getName(), "invokeUpdatedMethod");
            if (!this.getServiceObject(this.m_bindMethods.getUpdated(), refPair)) {
                this.m_componentManager.log(2, "DependencyManager : invokeUpdatedMethod : Service not available from service registry for ServiceReference {0} for reference {1}", new Object[]{refPair.getRef(), this.getName()}, null);
                return;
            }
            MethodResult methodResult = this.m_bindMethods.getUpdated().invoke(componentInstance, refPair, MethodResult.VOID, this.m_componentManager);
            if (methodResult != null) {
                this.m_componentManager.setServiceProperties(methodResult);
            }
        } else {
            this.m_componentManager.log(4, "DependencyManager : Component not set, no need to call updated method", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeUnbindMethod(S componentInstance, RefPair<T> refPair, int trackingCount, EdgeInfo info) {
        if (componentInstance != null) {
            boolean outOfRange;
            ServiceTracker.Tracked tracked = this.m_tracker.tracked();
            synchronized (tracked) {
                if (info.beforeRange(trackingCount)) {
                    return;
                }
            }
            info.waitForOpen(this.m_componentManager, this.getName(), "invokeUnbindMethod");
            ServiceTracker.Tracked tracked2 = this.m_tracker.tracked();
            synchronized (tracked2) {
                outOfRange = info.afterRange(trackingCount);
            }
            if (outOfRange) {
                info.waitForClose(this.m_componentManager, this.getName(), "invokeUnbindMethod");
                return;
            }
            if (!this.getServiceObject(this.m_bindMethods.getUnbind(), refPair)) {
                this.m_componentManager.log(2, "DependencyManager : invokeUnbindMethod : Service not available from service registry for ServiceReference {0} for reference {1}", new Object[]{refPair.getRef(), this.getName()}, null);
                return;
            }
            MethodResult methodResult = this.m_bindMethods.getUnbind().invoke(componentInstance, refPair, MethodResult.VOID, this.m_componentManager);
            if (methodResult != null) {
                this.m_componentManager.setServiceProperties(methodResult);
            }
        } else {
            this.m_componentManager.log(4, "DependencyManager : Component not set, no need to call unbind method", null);
        }
    }

    private long getLockTimeout() {
        return this.m_componentManager.getLockTimeout();
    }

    boolean canUpdateDynamically(Dictionary<String, Object> properties) {
        String newTarget = (String)properties.get(this.m_dependencyMetadata.getTargetPropertyName());
        String currentTarget = this.getTarget();
        if (currentTarget == null && newTarget == null || currentTarget != null && currentTarget.equals(newTarget)) {
            return true;
        }
        if (this.m_dependencyMetadata.isStatic()) {
            return false;
        }
        if (this.m_dependencyMetadata.isOptional()) {
            return true;
        }
        ServiceReference<T>[] refs = this.getFrameworkServiceReferences(newTarget);
        return refs != null && refs.length > 0;
    }

    void setTargetFilter(Dictionary<String, Object> properties) {
        this.setTargetFilter((String)properties.get(this.m_dependencyMetadata.getTargetPropertyName()));
    }

    private void setTargetFilter(String target) {
        if (target == null) {
            target = this.m_dependencyMetadata.getTarget();
        }
        if (this.m_target == null && target == null || this.m_target != null && this.m_target.equals(target)) {
            this.m_componentManager.log(4, "No change in target property for dependency {0}: currently registered: {1}", new Object[]{this.getName(), this.m_tracker != null}, null);
            if (this.m_tracker != null) {
                return;
            }
        }
        this.m_target = target;
        String filterString = "(objectClass=" + this.m_dependencyMetadata.getInterface() + ")";
        if (this.m_target != null) {
            filterString = "(&" + filterString + this.m_target + ")";
        }
        ServiceTracker<RefPair<T>, RefPair<RefPair<T>>> oldTracker = this.m_tracker;
        AtomicInteger trackingCount = new AtomicInteger();
        SortedMap<ServiceReference<T>, RefPair<T>> refMap = this.unregisterServiceListener(trackingCount);
        if (trackingCount.get() != -1) {
            this.m_componentManager.waitForTracked(trackingCount.get());
        }
        this.m_componentManager.log(4, "Setting target property for dependency {0} to {1}", new Object[]{this.getName(), target}, null);
        BundleContext bundleContext = this.m_componentManager.getBundleContext();
        if (bundleContext != null) {
            try {
                this.m_targetFilter = bundleContext.createFilter(filterString);
            }
            catch (InvalidSyntaxException ise) {
                this.m_componentManager.log(1, "Invalid syntax in target property for dependency {0} to {1}", new Object[]{this.getName(), target}, null);
                filterString = "(component.id=-1)";
                try {
                    this.m_targetFilter = bundleContext.createFilter(filterString);
                }
                catch (InvalidSyntaxException e) {
                    return;
                }
            }
        } else {
            this.m_componentManager.log(1, "Bundle is shut down for dependency {0} to {1}", new Object[]{this.getName(), target}, null);
            return;
        }
        this.m_customizer.setPreviousRefMap(refMap);
        boolean initialActive = oldTracker != null && oldTracker.isActive();
        this.m_componentManager.log(3, "New service tracker for {0}, initial active: {1}, previous references: {2}", new Object[]{this.getName(), initialActive, refMap}, null);
        ServiceTracker tracker = new ServiceTracker(bundleContext, this.m_targetFilter, this.m_customizer, initialActive);
        this.m_customizer.setTracker(tracker);
        tracker.open(this.m_componentManager.getTrackingCount());
        this.m_customizer.setTrackerOpened();
        if (oldTracker != null) {
            oldTracker.completeClose(refMap);
        }
        this.m_componentManager.log(4, "registering service listener for dependency {0}", new Object[]{this.getName()}, null);
    }

    private Customizer<T> newCustomizer() {
        Customizer customizer;
        if (!this.hasGetPermission()) {
            customizer = new NoPermissionsCustomizer();
            this.m_componentManager.log(3, "No permission to get services for {0}", new Object[]{this.getName()}, null);
        } else {
            customizer = this.m_componentManager.isFactory() ? new FactoryCustomizer() : (this.isMultiple() ? (this.isStatic() ? (this.isReluctant() ? new MultipleStaticReluctantCustomizer() : new MultipleStaticGreedyCustomizer()) : new MultipleDynamicCustomizer()) : (this.isStatic() ? new SingleStaticCustomizer() : new SingleDynamicCustomizer()));
        }
        return customizer;
    }

    SortedMap<ServiceReference<T>, RefPair<T>> unregisterServiceListener(AtomicInteger trackingCount) {
        SortedMap<ServiceReference<T>, RefPair<T>> refMap;
        ServiceTracker<T, RefPair<T>> tracker = this.m_tracker;
        if (tracker != null) {
            refMap = tracker.close(trackingCount);
            this.m_tracker = null;
            this.m_componentManager.log(4, "unregistering service listener for dependency {0}", new Object[]{this.getName()}, null);
        } else {
            refMap = new TreeMap(Collections.reverseOrder());
            this.m_componentManager.log(4, " No existing service listener to unregister for dependency {0}", new Object[]{this.getName()}, null);
            trackingCount.set(-1);
        }
        return refMap;
    }

    @Override
    public String getTarget() {
        return this.m_target;
    }

    public String toString() {
        return "DependencyManager: Component [" + this.m_componentManager + "] reference [" + this.getName() + "]";
    }

    boolean getServiceObject(BindMethod bindMethod, RefPair<T> refPair) {
        BundleContext bundleContext = this.m_componentManager.getBundleContext();
        if (bundleContext != null) {
            return bindMethod.getServiceObject(refPair, bundleContext, this.m_componentManager);
        }
        refPair.setFailed();
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NoPermissionsCustomizer
    implements Customizer<T> {
        private NoPermissionsCustomizer() {
        }

        @Override
        public boolean prebind() {
            return false;
        }

        @Override
        public void close() {
        }

        @Override
        public Collection<RefPair<T>> getRefs(AtomicInteger trackingCount) {
            return Collections.emptyList();
        }

        @Override
        public boolean isSatisfied() {
            return DependencyManager.this.isOptional();
        }

        @Override
        public void setTracker(ServiceTracker<T, RefPair<T>> tRefPairServiceTracker) {
        }

        @Override
        public void setTrackerOpened() {
        }

        @Override
        public void setPreviousRefMap(Map<ServiceReference<T>, RefPair<T>> previousRefMap) {
        }

        @Override
        public RefPair<T> addingService(ServiceReference<T> tServiceReference) {
            return null;
        }

        @Override
        public void addedService(ServiceReference<T> tServiceReference, RefPair<T> service, int trackingCount) {
        }

        @Override
        public void modifiedService(ServiceReference<T> tServiceReference, RefPair<T> service, int trackingCount) {
        }

        @Override
        public void removedService(ServiceReference<T> tServiceReference, RefPair<T> service, int trackingCount) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SingleStaticCustomizer
    extends AbstractCustomizer {
        private RefPair<T> refPair;
        private int trackingCount;

        private SingleStaticCustomizer() {
        }

        @Override
        public RefPair<T> addingService(ServiceReference<T> serviceReference) {
            RefPair refPair = new RefPair(serviceReference);
            return refPair;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addedService(ServiceReference<T> serviceReference, RefPair<T> refPair, int trackingCount) {
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} SingleStatic added {2} (enter)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            this.trackingCount = trackingCount;
            this.tracked(trackingCount);
            if (this.isActive()) {
                boolean reactivate;
                ServiceTracker.Tracked tracked = this.getTracker().tracked();
                synchronized (tracked) {
                    reactivate = !DependencyManager.this.isReluctant() && (this.refPair == null || refPair.getRef().compareTo(this.refPair.getRef()) > 0);
                }
                if (reactivate) {
                    DependencyManager.this.m_componentManager.deactivateInternal(2, false, false);
                    DependencyManager.this.m_componentManager.activateInternal(trackingCount);
                } else {
                    DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} SingleStatic active but new {2} is worse match than old {3}", new Object[]{DependencyManager.this.getName(), trackingCount, refPair, this.refPair}, null);
                }
            } else if (this.isTrackerOpened() && !DependencyManager.this.isOptional()) {
                DependencyManager.this.m_componentManager.activateInternal(trackingCount);
            } else {
                DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} SingleStatic active: {2} trackerOpened: {3} optional: {4}", new Object[]{DependencyManager.this.getName(), trackingCount, this.isActive(), this.isTrackerOpened(), DependencyManager.this.isOptional()}, null);
            }
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} SingleStatic added {2} (exit)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void modifiedService(ServiceReference<T> serviceReference, RefPair<T> refPair, int trackingCount) {
            boolean invokeUpdated;
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} SingleStatic modified {2} (enter)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            ServiceTracker.Tracked tracked = this.getTracker().tracked();
            synchronized (tracked) {
                invokeUpdated = this.isActive() && refPair == this.refPair;
            }
            if (invokeUpdated) {
                DependencyManager.this.m_componentManager.invokeUpdatedMethod(DependencyManager.this, refPair, trackingCount);
            }
            this.trackingCount = trackingCount;
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} SingleStatic modified {2} (exit)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            this.tracked(trackingCount);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removedService(ServiceReference<T> serviceReference, RefPair<T> refPair, int trackingCount) {
            boolean reactivate;
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} SingleStatic removed {2} (enter)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            this.trackingCount = trackingCount;
            this.tracked(trackingCount);
            ServiceTracker.Tracked tracked = this.getTracker().tracked();
            synchronized (tracked) {
                reactivate = this.isActive() && refPair == this.refPair || !DependencyManager.this.isOptional() && this.getTracker().isEmpty();
            }
            if (reactivate) {
                DependencyManager.this.m_componentManager.deactivateInternal(2, false, false);
                DependencyManager.this.m_componentManager.activateInternal(trackingCount);
            }
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} SingleStatic removed {2} (exit)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean prebind() {
            boolean success = DependencyManager.this.m_dependencyMetadata.isOptional();
            if (success || !this.getTracker().isEmpty()) {
                RefPair refPair = null;
                AtomicInteger trackingCount = new AtomicInteger();
                ServiceTracker.Tracked tracked = this.getTracker().tracked();
                synchronized (tracked) {
                    SortedMap tracked2 = this.getTracker().getTracked(true, trackingCount);
                    if (!tracked2.isEmpty()) {
                        refPair = tracked2.values().iterator().next();
                        this.refPair = refPair;
                    }
                }
                if (refPair != null) {
                    success |= DependencyManager.this.getServiceObject(DependencyManager.this.m_bindMethods.getBind(), refPair);
                    if (refPair.isFailed()) {
                        DependencyManager.this.m_componentManager.registerMissingDependency(DependencyManager.this, refPair.getRef(), trackingCount.get());
                    }
                }
            }
            return success;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            ServiceTracker.Tracked tracked = this.getTracker().tracked();
            synchronized (tracked) {
                if (this.refPair != null) {
                    this.ungetService(this.refPair);
                }
                this.refPair = null;
                this.getTracker().deactivate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<RefPair<T>> getRefs(AtomicInteger trackingCount) {
            ServiceTracker.Tracked monitor;
            ServiceTracker.Tracked tracked = monitor = this.getTracker() == null ? null : this.getTracker().tracked();
            if (monitor != null) {
                ServiceTracker.Tracked tracked2 = monitor;
                synchronized (tracked2) {
                    trackingCount.set(this.trackingCount);
                    return this.refPair == null ? Collections.emptyList() : Collections.singleton(this.refPair);
                }
            }
            return Collections.emptyList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SingleDynamicCustomizer
    extends AbstractCustomizer {
        private RefPair<T> refPair;
        private int trackingCount;

        private SingleDynamicCustomizer() {
        }

        @Override
        public RefPair<T> addingService(ServiceReference<T> serviceReference) {
            RefPair refPair = this.getPreviousRefMap().get(serviceReference);
            if (refPair == null) {
                refPair = new RefPair(serviceReference);
            }
            return refPair;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addedService(ServiceReference<T> serviceReference, RefPair<T> refPair, int trackingCount) {
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} SingleDynamic added {2} (enter)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            boolean tracked = false;
            if (this.getPreviousRefMap().remove(serviceReference) == null) {
                if (this.isActive()) {
                    boolean invokeBind;
                    ServiceTracker.Tracked tracked2 = this.getTracker().tracked();
                    synchronized (tracked2) {
                        invokeBind = this.refPair == null || !DependencyManager.this.isReluctant() && refPair.getRef().compareTo(this.refPair.getRef()) > 0;
                    }
                    if (invokeBind) {
                        DependencyManager.this.getServiceObject(DependencyManager.this.m_bindMethods.getBind(), refPair);
                        if (!refPair.isFailed()) {
                            DependencyManager.this.m_componentManager.invokeBindMethod(DependencyManager.this, refPair, trackingCount);
                            if (this.refPair != null) {
                                DependencyManager.this.m_componentManager.invokeUnbindMethod(DependencyManager.this, this.refPair, trackingCount);
                                this.closeRefPair();
                            }
                        } else {
                            DependencyManager.this.m_componentManager.registerMissingDependency(DependencyManager.this, serviceReference, trackingCount);
                        }
                        this.refPair = refPair;
                    }
                } else if (this.isTrackerOpened() && !DependencyManager.this.isOptional()) {
                    this.tracked(trackingCount);
                    tracked = true;
                    DependencyManager.this.m_componentManager.activateInternal(trackingCount);
                }
            }
            this.trackingCount = trackingCount;
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} SingleDynamic added {2} (exit)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            if (!tracked) {
                this.tracked(trackingCount);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void modifiedService(ServiceReference<T> serviceReference, RefPair<T> refPair, int trackingCount) {
            boolean invokeUpdated;
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} SingleDynamic modified {2} (enter)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            ServiceTracker.Tracked tracked = this.getTracker().tracked();
            synchronized (tracked) {
                invokeUpdated = this.isActive() && refPair == this.refPair;
            }
            if (invokeUpdated) {
                DependencyManager.this.m_componentManager.invokeUpdatedMethod(DependencyManager.this, refPair, trackingCount);
            }
            this.trackingCount = trackingCount;
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} SingleDynamic modified {2} (exit)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            this.tracked(trackingCount);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removedService(ServiceReference<T> serviceReference, RefPair<T> refPair, int trackingCount) {
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} SingleDynamic removed {2} (enter)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            boolean deactivate = false;
            boolean untracked = true;
            RefPair oldRefPair = null;
            RefPair nextRefPair = null;
            ServiceTracker.Tracked tracked = this.getTracker().tracked();
            synchronized (tracked) {
                if (refPair == this.refPair && this.isActive()) {
                    if (!this.getTracker().isEmpty()) {
                        AtomicInteger trackingCount2 = new AtomicInteger();
                        SortedMap tracked2 = this.getTracker().getTracked(true, trackingCount2);
                        nextRefPair = tracked2.values().iterator().next();
                    }
                    if (DependencyManager.this.isOptional() || nextRefPair != null) {
                        oldRefPair = this.refPair;
                        this.refPair = null;
                    } else {
                        deactivate = true;
                    }
                } else if (!DependencyManager.this.isOptional() && this.refPair == null && this.getTracker().isEmpty()) {
                    deactivate = true;
                }
            }
            if (nextRefPair != null) {
                if (!DependencyManager.this.getServiceObject(DependencyManager.this.m_bindMethods.getBind(), nextRefPair)) {
                    // empty if block
                }
                if (!nextRefPair.isFailed()) {
                    DependencyManager.this.m_componentManager.invokeBindMethod(DependencyManager.this, nextRefPair, trackingCount);
                }
            }
            if (oldRefPair != null) {
                this.trackingCount = trackingCount;
                DependencyManager.this.m_componentManager.invokeUnbindMethod(DependencyManager.this, oldRefPair, trackingCount);
                tracked = this.getTracker().tracked();
                synchronized (tracked) {
                    this.refPair = nextRefPair;
                }
                this.tracked(trackingCount);
                untracked = false;
            } else if (deactivate) {
                this.trackingCount = trackingCount;
                this.tracked(trackingCount);
                untracked = false;
                DependencyManager.this.m_componentManager.deactivateInternal(2, false, false);
            }
            if (oldRefPair != null) {
                this.ungetService(oldRefPair);
            }
            if (untracked) {
                this.trackingCount = trackingCount;
                this.tracked(trackingCount);
            }
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} SingleDynamic removed {2} (exit)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean prebind() {
            RefPair refPair = null;
            boolean success = DependencyManager.this.m_dependencyMetadata.isOptional();
            AtomicInteger trackingCount = new AtomicInteger();
            ServiceTracker.Tracked tracked = this.getTracker().tracked();
            synchronized (tracked) {
                SortedMap tracked2;
                if (!(!success && this.getTracker().isEmpty() || (tracked2 = this.getTracker().getTracked(true, trackingCount)).isEmpty())) {
                    refPair = tracked2.values().iterator().next();
                    this.refPair = refPair;
                }
            }
            if (refPair != null) {
                success |= DependencyManager.this.getServiceObject(DependencyManager.this.m_bindMethods.getBind(), refPair);
                if (refPair.isFailed()) {
                    DependencyManager.this.m_componentManager.registerMissingDependency(DependencyManager.this, refPair.getRef(), trackingCount.get());
                }
            }
            return success;
        }

        @Override
        public void close() {
            this.closeRefPair();
            this.getTracker().deactivate();
        }

        private void closeRefPair() {
            if (this.refPair != null) {
                this.ungetService(this.refPair);
            }
            this.refPair = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<RefPair<T>> getRefs(AtomicInteger trackingCount) {
            ServiceTracker.Tracked monitor;
            ServiceTracker.Tracked tracked = monitor = this.getTracker() == null ? null : this.getTracker().tracked();
            if (monitor != null) {
                ServiceTracker.Tracked tracked2 = monitor;
                synchronized (tracked2) {
                    trackingCount.set(this.trackingCount);
                    return this.refPair == null ? Collections.emptyList() : Collections.singleton(this.refPair);
                }
            }
            return Collections.emptyList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MultipleStaticReluctantCustomizer
    extends AbstractCustomizer {
        private final AtomicReference<Collection<RefPair<T>>> refs;
        private int trackingCount;

        private MultipleStaticReluctantCustomizer() {
            this.refs = new AtomicReference();
        }

        @Override
        public RefPair<T> addingService(ServiceReference<T> serviceReference) {
            RefPair refPair = new RefPair(serviceReference);
            return refPair;
        }

        @Override
        public void addedService(ServiceReference<T> serviceReference, RefPair<T> refPair, int trackingCount) {
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleStaticReluctant added {2} (enter)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            this.tracked(trackingCount);
            if (this.isTrackerOpened() && !DependencyManager.this.isOptional() && !this.isActive()) {
                DependencyManager.this.m_componentManager.activateInternal(trackingCount);
            }
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleStaticReluctant added {2} (exit)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
        }

        @Override
        public void modifiedService(ServiceReference<T> serviceReference, RefPair<T> refPair, int trackingCount) {
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleStaticReluctant modified {2} (enter)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            Collection refs = this.refs.get();
            if (this.isActive() && refs.contains(refPair)) {
                DependencyManager.this.m_componentManager.invokeUpdatedMethod(DependencyManager.this, refPair, trackingCount);
            }
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleStaticReluctant modified {2} (exit)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            this.tracked(trackingCount);
        }

        @Override
        public void removedService(ServiceReference<T> serviceReference, RefPair<T> refPair, int trackingCount) {
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleStaticReluctant removed {2} (enter)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            this.tracked(trackingCount);
            Collection refs = this.refs.get();
            if (this.isActive() && refs != null) {
                if (refs.contains(refPair)) {
                    DependencyManager.this.m_componentManager.log(4, "Dependency Manager: Static dependency on {0}/{1} is broken", new Object[]{DependencyManager.this.getName(), DependencyManager.this.m_dependencyMetadata.getInterface()}, null);
                    DependencyManager.this.m_componentManager.deactivateInternal(2, false, false);
                    DependencyManager.this.m_componentManager.activateInternal(trackingCount);
                }
            } else if (!DependencyManager.this.isOptional() && this.getTracker().isEmpty()) {
                DependencyManager.this.m_componentManager.log(4, "Dependency Manager: Static dependency on {0}/{1} is broken", new Object[]{DependencyManager.this.getName(), DependencyManager.this.m_dependencyMetadata.getInterface()}, null);
                DependencyManager.this.m_componentManager.deactivateInternal(2, false, false);
            }
            this.ungetService(refPair);
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleStaticReluctant removed {2} (exit)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
        }

        @Override
        public boolean prebind() {
            boolean success = DependencyManager.this.m_dependencyMetadata.isOptional();
            Collection refs = this.refs.get();
            if (refs != null) {
                for (RefPair refPair : refs) {
                    success |= DependencyManager.this.getServiceObject(DependencyManager.this.m_bindMethods.getBind(), refPair);
                }
                return success;
            }
            refs = new ArrayList();
            AtomicInteger trackingCount = new AtomicInteger();
            SortedMap tracked = this.getTracker().getTracked(true, trackingCount);
            for (RefPair refPair : tracked.values()) {
                success |= DependencyManager.this.getServiceObject(DependencyManager.this.m_bindMethods.getBind(), refPair);
                refs.add(refPair);
            }
            if (this.refs.compareAndSet(null, refs)) {
                this.trackingCount = trackingCount.get();
            } else {
                Collection actualRefs = this.refs.get();
                refs.removeAll(actualRefs);
                for (RefPair ref : refs) {
                    this.ungetService(ref);
                }
            }
            return success;
        }

        @Override
        public void close() {
            Collection refs = this.refs.getAndSet(null);
            if (refs != null) {
                for (RefPair ref : refs) {
                    this.ungetService(ref);
                }
            }
            this.getTracker().deactivate();
        }

        @Override
        public Collection<RefPair<T>> getRefs(AtomicInteger trackingCount) {
            trackingCount.set(this.trackingCount);
            Collection refs = this.refs.get();
            return refs == null ? Collections.emptyList() : refs;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MultipleStaticGreedyCustomizer
    extends AbstractCustomizer {
        private MultipleStaticGreedyCustomizer() {
        }

        @Override
        public RefPair<T> addingService(ServiceReference<T> serviceReference) {
            RefPair refPair = new RefPair(serviceReference);
            if (this.isActive()) {
                DependencyManager.this.getServiceObject(DependencyManager.this.m_bindMethods.getBind(), refPair);
            }
            return refPair;
        }

        @Override
        public void addedService(ServiceReference<T> serviceReference, RefPair<T> refPair, int trackingCount) {
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleStaticGreedy added {2} (enter)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            this.tracked(trackingCount);
            if (this.isActive()) {
                DependencyManager.this.m_componentManager.log(4, "Dependency Manager: Static dependency on {0}/{1} is broken", new Object[]{DependencyManager.this.getName(), DependencyManager.this.m_dependencyMetadata.getInterface()}, null);
                DependencyManager.this.m_componentManager.deactivateInternal(2, false, false);
                DependencyManager.this.m_componentManager.activateInternal(trackingCount);
            } else if (this.isTrackerOpened() && !DependencyManager.this.isOptional()) {
                DependencyManager.this.m_componentManager.activateInternal(trackingCount);
            }
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleStaticGreedy added {2} (exit)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
        }

        @Override
        public void modifiedService(ServiceReference<T> serviceReference, RefPair<T> refPair, int trackingCount) {
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleStaticGreedy modified {2} (enter)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            if (this.isActive()) {
                DependencyManager.this.m_componentManager.invokeUpdatedMethod(DependencyManager.this, refPair, trackingCount);
            }
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleStaticGreedy modified {2} (exit)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            this.tracked(trackingCount);
        }

        @Override
        public void removedService(ServiceReference<T> serviceReference, RefPair<T> refPair, int trackingCount) {
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleStaticGreedy removed {2} (enter)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            this.tracked(trackingCount);
            if (this.isActive()) {
                DependencyManager.this.m_componentManager.log(4, "Dependency Manager: Static dependency on {0}/{1} is broken", new Object[]{DependencyManager.this.getName(), DependencyManager.this.m_dependencyMetadata.getInterface()}, null);
                DependencyManager.this.m_componentManager.deactivateInternal(2, false, false);
                DependencyManager.this.m_componentManager.activateInternal(trackingCount);
            } else if (!DependencyManager.this.isOptional() && this.getTracker().isEmpty()) {
                DependencyManager.this.m_componentManager.log(4, "Dependency Manager: Static dependency on {0}/{1} is broken", new Object[]{DependencyManager.this.getName(), DependencyManager.this.m_dependencyMetadata.getInterface()}, null);
                DependencyManager.this.m_componentManager.deactivateInternal(2, false, false);
            }
            this.ungetService(refPair);
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleStaticGreedy removed {2} (exit)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
        }

        @Override
        public boolean prebind() {
            boolean success = DependencyManager.this.m_dependencyMetadata.isOptional();
            AtomicInteger trackingCount = new AtomicInteger();
            SortedMap tracked = this.getTracker().getTracked(success || !this.getTracker().isEmpty(), trackingCount);
            for (RefPair refPair : tracked.values()) {
                success |= DependencyManager.this.getServiceObject(DependencyManager.this.m_bindMethods.getBind(), refPair);
                if (!refPair.isFailed()) continue;
                DependencyManager.this.m_componentManager.registerMissingDependency(DependencyManager.this, refPair.getRef(), trackingCount.get());
            }
            return success;
        }

        @Override
        public void close() {
            AtomicInteger trackingCount = new AtomicInteger();
            for (RefPair ref : this.getRefs(trackingCount)) {
                this.ungetService(ref);
            }
            this.getTracker().deactivate();
        }

        @Override
        public Collection<RefPair<T>> getRefs(AtomicInteger trackingCount) {
            ServiceTracker tracker = this.getTracker();
            if (tracker == null) {
                return Collections.emptyList();
            }
            return tracker.getTracked(null, trackingCount).values();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MultipleDynamicCustomizer
    extends AbstractCustomizer {
        private RefPair<T> lastRefPair;
        private int lastRefPairTrackingCount;

        private MultipleDynamicCustomizer() {
        }

        @Override
        public RefPair<T> addingService(ServiceReference<T> serviceReference) {
            RefPair refPair = this.getPreviousRefMap().get(serviceReference);
            if (refPair == null) {
                refPair = new RefPair(serviceReference);
            }
            return refPair;
        }

        @Override
        public void addedService(ServiceReference<T> serviceReference, RefPair<T> refPair, int trackingCount) {
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleDynamic added {2} (enter)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            boolean tracked = false;
            if (this.getPreviousRefMap().remove(serviceReference) == null) {
                if (this.isActive()) {
                    DependencyManager.this.getServiceObject(DependencyManager.this.m_bindMethods.getBind(), refPair);
                    if (!refPair.isFailed()) {
                        DependencyManager.this.m_componentManager.invokeBindMethod(DependencyManager.this, refPair, trackingCount);
                    } else {
                        DependencyManager.this.m_componentManager.registerMissingDependency(DependencyManager.this, serviceReference, trackingCount);
                    }
                } else if (this.isTrackerOpened() && !DependencyManager.this.isOptional()) {
                    this.tracked(trackingCount);
                    tracked = true;
                    DependencyManager.this.m_componentManager.activateInternal(trackingCount);
                }
            }
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleDynamic added {2} (exit)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            if (!tracked) {
                this.tracked(trackingCount);
            }
        }

        @Override
        public void modifiedService(ServiceReference<T> serviceReference, RefPair<T> refPair, int trackingCount) {
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleDynamic modified {2} (enter)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            if (this.isActive()) {
                DependencyManager.this.m_componentManager.invokeUpdatedMethod(DependencyManager.this, refPair, trackingCount);
            }
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleDynamic modified {2} (exit)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            this.tracked(trackingCount);
        }

        @Override
        public void removedService(ServiceReference<T> serviceReference, RefPair<T> refPair, int trackingCount) {
            boolean unbind;
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleDynamic removed {2} (enter)", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            boolean bl = unbind = DependencyManager.this.isOptional() || !this.getTracker().isEmpty();
            if (unbind) {
                if (this.isActive()) {
                    DependencyManager.this.m_componentManager.invokeUnbindMethod(DependencyManager.this, refPair, trackingCount);
                }
                DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleDynamic removed (unbind) {2}", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
                this.tracked(trackingCount);
            } else {
                this.lastRefPair = refPair;
                this.lastRefPairTrackingCount = trackingCount;
                this.tracked(trackingCount);
                DependencyManager.this.m_componentManager.deactivateInternal(2, false, false);
                this.lastRefPair = null;
                DependencyManager.this.m_componentManager.log(4, "dm {0} tracking {1} MultipleDynamic removed (deactivate) {2}", new Object[]{DependencyManager.this.getName(), trackingCount, serviceReference}, null);
            }
            this.ungetService(refPair);
        }

        @Override
        public boolean prebind() {
            boolean success = DependencyManager.this.m_dependencyMetadata.isOptional();
            AtomicInteger trackingCount = new AtomicInteger();
            SortedMap tracked = this.getTracker().getTracked(true, trackingCount);
            for (RefPair refPair : tracked.values()) {
                if (DependencyManager.this.getServiceObject(DependencyManager.this.m_bindMethods.getBind(), refPair)) {
                    success = true;
                    continue;
                }
                DependencyManager.this.m_componentManager.registerMissingDependency(DependencyManager.this, refPair.getRef(), trackingCount.get());
            }
            return success;
        }

        @Override
        public void close() {
            AtomicInteger trackingCount = new AtomicInteger();
            for (RefPair ref : this.getRefs(trackingCount)) {
                this.ungetService(ref);
            }
            this.getTracker().deactivate();
        }

        @Override
        public Collection<RefPair<T>> getRefs(AtomicInteger trackingCount) {
            if (this.lastRefPair == null) {
                ServiceTracker tracker = this.getTracker();
                if (tracker == null) {
                    trackingCount.set(this.lastRefPairTrackingCount);
                    return Collections.emptyList();
                }
                return this.getTracker().getTracked(true, trackingCount).values();
            }
            trackingCount.set(this.lastRefPairTrackingCount);
            return Collections.singletonList(this.lastRefPair);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FactoryCustomizer
    extends AbstractCustomizer {
        private FactoryCustomizer() {
        }

        @Override
        public RefPair<T> addingService(ServiceReference<T> serviceReference) {
            RefPair refPair = new RefPair(serviceReference);
            return refPair;
        }

        @Override
        public void addedService(ServiceReference<T> serviceReference, RefPair<T> refPair, int trackingCount) {
            if (!DependencyManager.this.isOptional()) {
                DependencyManager.this.m_componentManager.activateInternal(trackingCount);
            }
        }

        @Override
        public void modifiedService(ServiceReference<T> serviceReference, RefPair<T> refPair, int trackingCount) {
        }

        @Override
        public void removedService(ServiceReference<T> serviceReference, RefPair<T> refPair, int trackingCount) {
            if (!DependencyManager.this.isOptional() && this.getTracker().isEmpty()) {
                DependencyManager.this.m_componentManager.deactivateInternal(2, false, false);
            }
        }

        @Override
        public boolean prebind() {
            boolean success = DependencyManager.this.m_dependencyMetadata.isOptional() || !this.getTracker().isEmpty();
            AtomicInteger trackingCount = new AtomicInteger();
            this.getTracker().getTracked(true, trackingCount);
            return success;
        }

        @Override
        public void close() {
            this.getTracker().deactivate();
        }

        @Override
        public Collection<RefPair<T>> getRefs(AtomicInteger trackingCount) {
            return Collections.emptyList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractCustomizer
    implements Customizer<T> {
        private final Map<ServiceReference<T>, RefPair<T>> EMPTY_REF_MAP = Collections.emptyMap();
        private volatile boolean trackerOpened;
        private volatile Map<ServiceReference<T>, RefPair<T>> previousRefMap = this.EMPTY_REF_MAP;

        private AbstractCustomizer() {
        }

        @Override
        public void setTracker(ServiceTracker<T, RefPair<T>> tracker) {
            DependencyManager.this.m_tracker = tracker;
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracker reset (closed)", new Object[]{DependencyManager.this.getName()}, null);
            this.trackerOpened = false;
        }

        @Override
        public boolean isSatisfied() {
            if (DependencyManager.this.isOptional()) {
                return true;
            }
            ServiceTracker tracker = this.getTracker();
            return tracker != null && !tracker.isEmpty();
        }

        protected ServiceTracker<T, RefPair<T>> getTracker() {
            return DependencyManager.this.m_tracker;
        }

        protected boolean isActive() {
            return this.getTracker().isActive();
        }

        protected boolean isTrackerOpened() {
            return this.trackerOpened;
        }

        @Override
        public void setTrackerOpened() {
            this.trackerOpened = true;
            DependencyManager.this.m_componentManager.log(4, "dm {0} tracker opened", new Object[]{DependencyManager.this.getName()}, null);
        }

        protected Map<ServiceReference<T>, RefPair<T>> getPreviousRefMap() {
            return this.previousRefMap;
        }

        @Override
        public void setPreviousRefMap(Map<ServiceReference<T>, RefPair<T>> previousRefMap) {
            this.previousRefMap = previousRefMap != null ? previousRefMap : this.EMPTY_REF_MAP;
        }

        protected void ungetService(RefPair<T> ref) {
            BundleContext bundleContext;
            Object service = ref.unsetServiceObject();
            if (service != null && (bundleContext = DependencyManager.this.m_componentManager.getBundleContext()) != null) {
                bundleContext.ungetService(ref.getRef());
            }
        }

        protected void tracked(int trackingCount) {
            DependencyManager.this.m_componentManager.tracked(trackingCount);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Customizer<T>
    extends ServiceTrackerCustomizer<T, RefPair<T>> {
        public boolean prebind();

        public void close();

        public Collection<RefPair<T>> getRefs(AtomicInteger var1);

        public boolean isSatisfied();

        public void setTracker(ServiceTracker<T, RefPair<T>> var1);

        public void setTrackerOpened();

        public void setPreviousRefMap(Map<ServiceReference<T>, RefPair<T>> var1);
    }
}

