/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.felix.scr.Component;
import org.apache.felix.scr.Reference;
import org.apache.felix.scr.impl.Activator;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.helper.ComponentMethods;
import org.apache.felix.scr.impl.helper.MethodResult;
import org.apache.felix.scr.impl.helper.SimpleLogger;
import org.apache.felix.scr.impl.manager.DependencyManager;
import org.apache.felix.scr.impl.manager.RefPair;
import org.apache.felix.scr.impl.manager.RegistrationManager;
import org.apache.felix.scr.impl.manager.ThreadDump;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.apache.felix.scr.impl.metadata.ReferenceMetadata;
import org.apache.felix.scr.impl.metadata.ServiceMetadata;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractComponentManager<S>
implements Component,
SimpleLogger {
    static final String[] REASONS = new String[]{"Unspecified", "Component disabled", "Reference became unsatisfied", "Configuration modified", "Configuration deleted", "Component disabled", "Bundle stopped"};
    private final boolean m_factoryInstance;
    private long m_componentId;
    private final ComponentMetadata m_componentMetadata;
    private final ComponentMethods m_componentMethods;
    private final List<DependencyManager<S, ?>> m_dependencyManagers;
    private volatile boolean m_dependencyManagersInitialized;
    private volatile boolean m_dependenciesCollected;
    private final AtomicInteger m_trackingCount = new AtomicInteger();
    private BundleComponentActivator m_activator;
    private final ReentrantLock m_stateLock;
    protected volatile boolean m_enabled;
    protected final AtomicReference<CountDownLatch> m_enabledLatchRef = new AtomicReference<CountDownLatch>(new CountDownLatch(0));
    protected volatile boolean m_internalEnabled;
    protected volatile boolean m_disposed;
    private int m_floor;
    private volatile int m_ceiling;
    private final Lock m_missingLock = new ReentrantLock();
    private final Condition m_missingCondition = this.m_missingLock.newCondition();
    private final Set<Integer> m_missing = new TreeSet<Integer>();
    volatile boolean m_activated;
    protected final ReentrantReadWriteLock m_activationLock = new ReentrantReadWriteLock();
    private static final AtomicLong taskCounter = new AtomicLong();
    private final RegistrationManager<ServiceRegistration<S>> registrationManager = new RegistrationManager<ServiceRegistration<S>>(){

        @Override
        ServiceRegistration<S> register(String[] services) {
            BundleContext bundleContext = AbstractComponentManager.this.getBundleContext();
            if (bundleContext == null) {
                return null;
            }
            Dictionary<String, Object> serviceProperties = AbstractComponentManager.this.getServiceProperties();
            ServiceRegistration serviceRegistration = bundleContext.registerService(services, AbstractComponentManager.this.getService(), serviceProperties);
            return serviceRegistration;
        }

        @Override
        void unregister(ServiceRegistration<S> serviceRegistration) {
            serviceRegistration.unregister();
        }

        @Override
        void log(int level, String message, Object[] arguments, Throwable ex) {
            AbstractComponentManager.this.log(level, message, arguments, ex);
        }

        @Override
        long getTimeout() {
            return AbstractComponentManager.this.getLockTimeout();
        }

        @Override
        void reportTimeout() {
            AbstractComponentManager.this.dumpThreads();
        }
    };

    protected AbstractComponentManager(BundleComponentActivator activator, ComponentMetadata metadata, ComponentMethods componentMethods) {
        this(activator, metadata, componentMethods, false);
    }

    protected AbstractComponentManager(BundleComponentActivator activator, ComponentMetadata metadata, ComponentMethods componentMethods, boolean factoryInstance) {
        this.m_factoryInstance = factoryInstance;
        this.m_activator = activator;
        this.m_componentMetadata = metadata;
        this.m_componentMethods = componentMethods;
        this.m_componentId = -1L;
        this.m_dependencyManagers = this.loadDependencyManagers(metadata);
        this.m_stateLock = new ReentrantLock(true);
        if (this.isLogEnabled(4)) {
            this.log(4, "Component {0} created: DS={1}, implementation={2}, immediate={3}, default-enabled={4}, factory={5}, configuration-policy={6}, activate={7}, deactivate={8}, modified={9} configuration-pid={10}", new Object[]{metadata.getName(), metadata.getNamespaceCode(), metadata.getImplementationClassName(), metadata.isImmediate(), metadata.isEnabled(), metadata.getFactoryIdentifier(), metadata.getConfigurationPolicy(), metadata.getActivate(), metadata.getDeactivate(), metadata.getModified(), metadata.getConfigurationPid()}, null);
            if (metadata.getServiceMetadata() != null) {
                this.log(4, "Component {0} Services: servicefactory={1}, services={2}", new Object[]{metadata.getName(), metadata.getServiceMetadata().isServiceFactory(), Arrays.asList(metadata.getServiceMetadata().getProvides())}, null);
            }
            if (metadata.getProperties() != null) {
                this.log(4, "Component {0} Properties: {1}", new Object[]{metadata.getName(), metadata.getProperties()}, null);
            }
        }
    }

    final long getLockTimeout() {
        BundleComponentActivator activator = this.getActivator();
        if (activator != null) {
            return activator.getConfiguration().lockTimeout();
        }
        return 5000L;
    }

    private void obtainLock(Lock lock, String source) {
        try {
            if (!lock.tryLock(this.getLockTimeout(), TimeUnit.MILLISECONDS)) {
                this.dumpThreads();
                throw new IllegalStateException("Could not obtain lock");
            }
        }
        catch (InterruptedException e) {
            try {
                if (!lock.tryLock(this.getLockTimeout(), TimeUnit.MILLISECONDS)) {
                    this.dumpThreads();
                    throw new IllegalStateException("Could not obtain lock");
                }
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Interrupted twice: Could not obtain lock");
            }
            Thread.currentThread().interrupt();
        }
    }

    final void obtainActivationReadLock(String source) {
        this.obtainLock(this.m_activationLock.readLock(), source);
    }

    final void releaseActivationReadLock(String source) {
        this.m_activationLock.readLock().unlock();
    }

    final void obtainActivationWriteLock(String source) {
        this.obtainLock(this.m_activationLock.writeLock(), source);
    }

    final void releaseActivationWriteeLock(String source) {
        if (this.m_activationLock.getWriteHoldCount() > 0) {
            this.m_activationLock.writeLock().unlock();
        }
    }

    final void obtainStateLock(String source) {
        this.obtainLock(this.m_stateLock, source);
    }

    final void releaseStateLock(String source) {
        this.m_stateLock.unlock();
    }

    final boolean isStateLocked() {
        return this.m_stateLock.getHoldCount() > 0;
    }

    final void dumpThreads() {
        try {
            String dump = new ThreadDump().call();
            this.log(4, dump, null);
        }
        catch (Throwable t) {
            this.log(4, "Could not dump threads", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tracked(int trackingCount) {
        this.m_missingLock.lock();
        try {
            if (trackingCount == this.m_floor + 1) {
                ++this.m_floor;
                this.m_missing.remove(trackingCount);
            } else if (trackingCount < this.m_ceiling) {
                this.m_missing.remove(trackingCount);
            }
            if (trackingCount > this.m_ceiling) {
                for (int i = this.m_ceiling + 1; i < trackingCount; ++i) {
                    this.m_missing.add(i);
                }
                this.m_ceiling = trackingCount;
            }
            this.m_missingCondition.signalAll();
            Object var4_3 = null;
            this.m_missingLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.m_missingLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void waitForTracked(int trackingCount) {
        this.m_missingLock.lock();
        try {
            while (this.m_ceiling < trackingCount || !this.m_missing.isEmpty() && this.m_missing.iterator().next() < trackingCount) {
                this.log(4, "waitForTracked trackingCount: {0} ceiling: {1} missing: {2}", new Object[]{trackingCount, this.m_ceiling, this.m_missing}, null);
                try {
                    if (this.doMissingWait()) continue;
                }
                catch (InterruptedException e) {
                    block7: {
                        try {
                            if (this.doMissingWait()) break block7;
                        }
                        catch (InterruptedException e1) {
                            this.log(1, "waitForTracked interrupted twice: {0} ceiling: {1} missing: {2},  Expect further errors", new Object[]{trackingCount, this.m_ceiling, this.m_missing}, e1);
                            break block7;
                        }
                        Object var5_5 = null;
                        this.m_missingLock.unlock();
                        return;
                    }
                    Thread.currentThread().interrupt();
                    continue;
                }
                Object var5_4 = null;
                this.m_missingLock.unlock();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.m_missingLock.unlock();
            throw throwable;
        }
        Object var5_6 = null;
        this.m_missingLock.unlock();
    }

    private boolean doMissingWait() throws InterruptedException {
        if (!this.m_missingCondition.await(this.getLockTimeout(), TimeUnit.MILLISECONDS)) {
            this.log(1, "waitForTracked timed out: {0} ceiling: {1} missing: {2},  Expect further errors", new Object[]{this.m_trackingCount, this.m_ceiling, this.m_missing}, null);
            this.dumpThreads();
            this.m_missing.clear();
            return false;
        }
        return true;
    }

    void registerComponentId() {
        BundleComponentActivator activator = this.getActivator();
        if (activator != null) {
            this.m_componentId = activator.registerComponentId(this);
        }
    }

    void unregisterComponentId() {
        if (this.m_componentId >= 0L) {
            BundleComponentActivator activator = this.getActivator();
            if (activator != null) {
                activator.unregisterComponentId(this);
            }
            this.m_componentId = -1L;
        }
    }

    @Override
    public final void enable() {
        this.enable(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enable(boolean async) {
        if (this.m_enabled) {
            return;
        }
        CountDownLatch enableLatch = null;
        try {
            enableLatch = this.enableLatchWait();
            this.enableInternal();
            if (!async) {
                this.activateInternal(this.m_trackingCount.get());
            }
            Object var4_3 = null;
            if (!async) {
                enableLatch.countDown();
            }
            this.m_enabled = true;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!async) {
                enableLatch.countDown();
            }
            this.m_enabled = true;
            throw throwable;
        }
        if (async) {
            final CountDownLatch latch = enableLatch;
            this.m_activator.schedule(new Runnable(){
                long count = AbstractComponentManager.access$000().incrementAndGet();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        AbstractComponentManager.this.activateInternal(AbstractComponentManager.this.m_trackingCount.get());
                        Object var2_1 = null;
                        latch.countDown();
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        latch.countDown();
                        throw throwable;
                    }
                }

                public String toString() {
                    return "Async Activate: " + AbstractComponentManager.this.getComponentMetadata().getName() + " id: " + this.count;
                }
            });
        }
    }

    CountDownLatch enableLatchWait() {
        CountDownLatch newEnabledLatch;
        CountDownLatch enabledLatch;
        do {
            enabledLatch = this.m_enabledLatchRef.get();
            boolean waited = false;
            boolean interrupted = false;
            while (!waited) {
                try {
                    enabledLatch.await();
                    waited = true;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            if (!interrupted) continue;
            Thread.currentThread().interrupt();
        } while (!this.m_enabledLatchRef.compareAndSet(enabledLatch, newEnabledLatch = new CountDownLatch(1)));
        return newEnabledLatch;
    }

    @Override
    public final void disable() {
        this.disable(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disable(boolean async) {
        if (!this.m_enabled) {
            return;
        }
        CountDownLatch enableLatch = null;
        try {
            enableLatch = this.enableLatchWait();
            if (!async) {
                this.deactivateInternal(1, true, false);
            }
            this.disableInternal();
            Object var4_3 = null;
            if (!async) {
                enableLatch.countDown();
            }
            this.m_enabled = false;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!async) {
                enableLatch.countDown();
            }
            this.m_enabled = false;
            throw throwable;
        }
        if (async) {
            final CountDownLatch latch = enableLatch;
            this.m_activator.schedule(new Runnable(){
                long count = AbstractComponentManager.access$000().incrementAndGet();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        AbstractComponentManager.this.deactivateInternal(1, true, false);
                        Object var2_1 = null;
                        latch.countDown();
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        latch.countDown();
                        throw throwable;
                    }
                }

                public String toString() {
                    return "Async Deactivate: " + AbstractComponentManager.this.getComponentMetadata().getName() + " id: " + this.count;
                }
            });
        }
    }

    void dispose() {
        this.dispose(5);
    }

    public void dispose(int reason) {
        this.deactivateInternal(reason, true, true);
    }

    <T> void registerMissingDependency(DependencyManager<S, T> dm, ServiceReference<T> ref, int trackingCount) {
        BundleComponentActivator activator = this.getActivator();
        if (activator != null) {
            activator.registerMissingDependency(dm, ref, trackingCount);
        }
    }

    @Override
    public long getId() {
        return this.m_componentId;
    }

    @Override
    public String getName() {
        return this.m_componentMetadata.getName();
    }

    @Override
    public Bundle getBundle() {
        BundleContext context = this.getBundleContext();
        if (context != null) {
            try {
                return context.getBundle();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return null;
    }

    BundleContext getBundleContext() {
        BundleComponentActivator activator = this.getActivator();
        if (activator != null) {
            return activator.getBundleContext();
        }
        return null;
    }

    @Override
    public String getClassName() {
        return this.m_componentMetadata.getImplementationClassName();
    }

    @Override
    public String getFactory() {
        return this.m_componentMetadata.getFactoryIdentifier();
    }

    @Override
    public Reference[] getReferences() {
        if (this.m_dependencyManagers != null && this.m_dependencyManagers.size() > 0) {
            return this.m_dependencyManagers.toArray(new Reference[this.m_dependencyManagers.size()]);
        }
        return null;
    }

    @Override
    public boolean isImmediate() {
        return this.m_componentMetadata.isImmediate();
    }

    @Override
    public boolean isDefaultEnabled() {
        return this.m_componentMetadata.isEnabled();
    }

    @Override
    public String getActivate() {
        return this.m_componentMetadata.getActivate();
    }

    @Override
    public boolean isActivateDeclared() {
        return this.m_componentMetadata.isActivateDeclared();
    }

    @Override
    public String getDeactivate() {
        return this.m_componentMetadata.getDeactivate();
    }

    @Override
    public boolean isDeactivateDeclared() {
        return this.m_componentMetadata.isDeactivateDeclared();
    }

    @Override
    public String getModified() {
        return this.m_componentMetadata.getModified();
    }

    @Override
    public String getConfigurationPolicy() {
        return this.m_componentMetadata.getConfigurationPolicy();
    }

    @Override
    public String getConfigurationPid() {
        return this.m_componentMetadata.getConfigurationPid();
    }

    @Override
    public boolean isConfigurationPidDeclared() {
        return this.m_componentMetadata.isConfigurationPidDeclared();
    }

    @Override
    public boolean isServiceFactory() {
        return this.m_componentMetadata.getServiceMetadata() != null && this.m_componentMetadata.getServiceMetadata().isServiceFactory();
    }

    public boolean isFactory() {
        return false;
    }

    @Override
    public String[] getServices() {
        if (this.m_componentMetadata.getServiceMetadata() != null) {
            return this.m_componentMetadata.getServiceMetadata().getProvides();
        }
        return null;
    }

    final void enableInternal() {
        if (this.m_disposed) {
            throw new IllegalStateException("enable: " + this);
        }
        if (!this.isActivatorActive()) {
            this.log(4, "Bundle's component activator is not active; not enabling component", null);
            return;
        }
        this.registerComponentId();
        if (this.hasConfiguration() || !this.getComponentMetadata().isConfigurationRequired()) {
            this.log(4, "Updating target filters", null);
            this.updateTargets(this.getProperties());
        }
        this.m_internalEnabled = true;
        this.log(4, "Component enabled", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void activateInternal(int trackingCount) {
        block12: {
            block11: {
                this.log(4, "ActivateInternal", null);
                if (this.m_disposed) {
                    this.log(4, "ActivateInternal: disposed", null);
                    return;
                }
                if (this.m_activated) {
                    this.log(4, "ActivateInternal: already activated", null);
                    return;
                }
                if (!this.isEnabled()) {
                    this.log(4, "Component is not enabled; not activating component", null);
                    return;
                }
                if (!this.isActivatorActive()) {
                    this.log(4, "Bundle's component activator is not active; not activating component", null);
                    return;
                }
                this.log(4, "Activating component from state {0}", new Object[]{this.getState()}, null);
                if (!this.hasConfiguration() && this.getComponentMetadata().isConfigurationRequired()) {
                    this.log(4, "Missing required configuration, cannot activate", null);
                    return;
                }
                if (!this.hasServiceRegistrationPermissions()) {
                    this.log(4, "Component is not permitted to register all services, cannot activate", null);
                    return;
                }
                this.obtainActivationReadLock("activateInternal");
                try {
                    if (!this.verifyDependencyManagers()) {
                        this.log(4, "Not all dependencies satisfied, cannot activate", null);
                        Object var3_2 = null;
                        this.releaseActivationReadLock("activateInternal");
                        return;
                    }
                    if (!this.registerService()) {
                        break block11;
                    }
                    if (this.isImmediate() || this.getComponentMetadata().isFactory()) {
                        this.getServiceInternal();
                    }
                    break block12;
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    this.releaseActivationReadLock("activateInternal");
                    throw throwable;
                }
            }
            Object var3_3 = null;
            this.releaseActivationReadLock("activateInternal");
            return;
        }
        Object var3_4 = null;
        this.releaseActivationReadLock("activateInternal");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void deactivateInternal(int reason, boolean disable, boolean dispose) {
        AbstractComponentManager abstractComponentManager = this;
        synchronized (abstractComponentManager) {
            if (this.m_disposed) {
                return;
            }
            this.m_disposed = dispose;
        }
        this.log(4, "Deactivating component", null);
        this.obtainActivationReadLock("deactivateInternal");
        try {
            this.doDeactivate(reason, disable || this.m_factoryInstance);
            Object var7_6 = null;
            this.releaseActivationReadLock("deactivateInternal");
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.releaseActivationReadLock("deactivateInternal");
            throw throwable;
        }
        if (this.isFactory() || this.m_factoryInstance || dispose) {
            this.log(4, "Disposing component (reason: " + reason + ")", null);
            this.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDeactivate(int reason, boolean disable) {
        try {
            if (!this.unregisterService()) {
                this.log(4, "Component deactivation occuring on another thread", null);
            }
            this.obtainStateLock("AbstractComponentManager.State.doDeactivate.1");
            try {
                if (this.m_activated) {
                    this.m_activated = false;
                    this.deleteComponent(reason);
                    this.deactivateDependencyManagers();
                    if (disable) {
                        this.disableDependencyManagers();
                    }
                    this.unsetDependenciesCollected();
                }
                Object var4_3 = null;
                this.releaseStateLock("AbstractComponentManager.State.doDeactivate.1");
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.releaseStateLock("AbstractComponentManager.State.doDeactivate.1");
                throw throwable;
            }
        }
        catch (Throwable t) {
            this.log(2, "Component deactivation threw an exception", t);
        }
    }

    final void disableInternal() {
        this.m_internalEnabled = false;
        if (this.m_disposed) {
            throw new IllegalStateException("Cannot disable a disposed component " + this.getName());
        }
        this.unregisterComponentId();
    }

    final ServiceReference<S> getServiceReference() {
        ServiceRegistration<S> reg = this.getServiceRegistration();
        if (reg != null) {
            return reg.getReference();
        }
        return null;
    }

    protected abstract boolean createComponent();

    protected abstract void deleteComponent(int var1);

    boolean getServiceInternal() {
        return false;
    }

    private Object getService() {
        return this;
    }

    ComponentMethods getComponentMethods() {
        return this.m_componentMethods;
    }

    protected String[] getProvidedServices() {
        if (this.getComponentMetadata().getServiceMetadata() != null) {
            String[] provides = this.getComponentMetadata().getServiceMetadata().getProvides();
            return provides;
        }
        return null;
    }

    protected boolean registerService() {
        String[] services = this.getProvidedServices();
        if (services != null) {
            return this.registrationManager.changeRegistration(RegistrationManager.RegState.registered, services);
        }
        return true;
    }

    protected boolean unregisterService() {
        String[] services = this.getProvidedServices();
        if (services != null) {
            return this.registrationManager.changeRegistration(RegistrationManager.RegState.unregistered, services);
        }
        return true;
    }

    AtomicInteger getTrackingCount() {
        return this.m_trackingCount;
    }

    private void initDependencyManagers() {
        Class implementationObjectClass;
        if (this.m_dependencyManagersInitialized) {
            return;
        }
        Bundle bundle = this.getBundle();
        if (bundle == null) {
            this.log(1, "bundle shut down while trying to load implementation object class", null);
            throw new IllegalStateException("bundle shut down while trying to load implementation object class");
        }
        try {
            implementationObjectClass = bundle.loadClass(this.getComponentMetadata().getImplementationClassName());
        }
        catch (ClassNotFoundException e) {
            this.log(1, "Could not load implementation object class {0}", new Object[]{this.getComponentMetadata().getImplementationClassName()}, e);
            throw new IllegalStateException("Could not load implementation object class " + this.getComponentMetadata().getImplementationClassName());
        }
        this.m_componentMethods.initComponentMethods(this.m_componentMetadata, implementationObjectClass);
        for (DependencyManager<S, ?> dependencyManager : this.m_dependencyManagers) {
            dependencyManager.initBindingMethods(this.m_componentMethods.getBindMethods(dependencyManager.getName()));
        }
        this.m_dependencyManagersInitialized = true;
    }

    protected boolean collectDependencies() throws IllegalStateException {
        if (this.m_dependenciesCollected) {
            this.log(4, "dependencies already collected, do not collect dependencies", null);
            return false;
        }
        this.initDependencyManagers();
        for (DependencyManager<S, ?> dependencyManager : this.m_dependencyManagers) {
            if (dependencyManager.prebind()) continue;
            this.deactivateDependencyManagers();
            this.log(4, "Could not get required dependency for dependency manager: {0}", new Object[]{dependencyManager.getName()}, null);
            throw new IllegalStateException("Missing dependencies, not satisfied");
        }
        this.m_dependenciesCollected = true;
        this.log(4, "This thread collected dependencies", null);
        return true;
    }

    protected void unsetDependenciesCollected() {
        this.m_dependenciesCollected = false;
    }

    abstract <T> void invokeUpdatedMethod(DependencyManager<S, T> var1, RefPair<T> var2, int var3);

    abstract <T> void invokeBindMethod(DependencyManager<S, T> var1, RefPair<T> var2, int var3);

    abstract <T> void invokeUnbindMethod(DependencyManager<S, T> var1, RefPair<T> var2, int var3);

    public BundleComponentActivator getActivator() {
        return this.m_activator;
    }

    boolean isActivatorActive() {
        BundleComponentActivator activator = this.getActivator();
        return activator != null && activator.isActive();
    }

    final ServiceRegistration<S> getServiceRegistration() {
        return this.registrationManager.getServiceRegistration();
    }

    synchronized void clear() {
        if (this.m_activator != null) {
            this.m_activator.unregisterComponentId(this);
        }
    }

    @Override
    public boolean isLogEnabled(int level) {
        return Activator.isLogEnabled(level);
    }

    @Override
    public void log(int level, String message, Throwable ex) {
        BundleComponentActivator activator = this.getActivator();
        if (activator != null) {
            activator.log(level, message, this.getComponentMetadata(), this.m_componentId, ex);
        }
    }

    @Override
    public void log(int level, String message, Object[] arguments, Throwable ex) {
        BundleComponentActivator activator = this.getActivator();
        if (activator != null) {
            activator.log(level, message, arguments, this.getComponentMetadata(), this.m_componentId, ex);
        }
    }

    public String toString() {
        return "Component: " + this.getName() + " (" + this.getId() + ")";
    }

    private boolean hasServiceRegistrationPermissions() {
        String[] services;
        ServiceMetadata serviceMetadata;
        boolean allowed = true;
        if (System.getSecurityManager() != null && (serviceMetadata = this.getComponentMetadata().getServiceMetadata()) != null && (services = serviceMetadata.getProvides()) != null && services.length > 0) {
            Bundle bundle = this.getBundle();
            for (String service : services) {
                ServicePermission perm = new ServicePermission(service, "register");
                if (bundle.hasPermission((Object)perm)) continue;
                this.log(4, "Permission to register service {0} is denied", new Object[]{service}, null);
                allowed = false;
            }
        }
        return allowed;
    }

    private List<DependencyManager<S, ?>> loadDependencyManagers(ComponentMetadata metadata) {
        ArrayList depMgrList = new ArrayList(metadata.getDependencies().size());
        if (metadata.getDependencies().size() != 0) {
            int index = 0;
            for (ReferenceMetadata currentdependency : metadata.getDependencies()) {
                DependencyManager depmanager = new DependencyManager(this, currentdependency, index++);
                depMgrList.add(depmanager);
            }
        }
        return depMgrList;
    }

    final void updateTargets(Dictionary<String, Object> properties) {
        for (DependencyManager<S, ?> dm : this.getDependencyManagers()) {
            dm.setTargetFilter(properties);
        }
    }

    protected boolean verifyDependencyManagers() {
        boolean satisfied = true;
        for (DependencyManager<S, ?> dm : this.getDependencyManagers()) {
            if (!dm.hasGetPermission()) {
                if (dm.isOptional()) {
                    this.log(4, "No permission to get optional dependency: {0}; assuming satisfied", new Object[]{dm.getName()}, null);
                    continue;
                }
                this.log(4, "No permission to get mandatory dependency: {0}; assuming unsatisfied", new Object[]{dm.getName()}, null);
                satisfied = false;
                continue;
            }
            if (dm.isSatisfied()) continue;
            this.log(4, "Dependency not satisfied: {0}", new Object[]{dm.getName()}, null);
            satisfied = false;
        }
        return satisfied;
    }

    List<DependencyManager<S, ?>> getDependencyManagers() {
        return this.m_dependencyManagers;
    }

    List<DependencyManager<S, ?>> getReversedDependencyManagers() {
        ArrayList list = new ArrayList(this.m_dependencyManagers);
        Collections.reverse(list);
        return list;
    }

    DependencyManager<S, ?> getDependencyManager(String name) {
        for (DependencyManager<S, ?> dm : this.getDependencyManagers()) {
            if (!name.equals(dm.getName())) continue;
            return dm;
        }
        return null;
    }

    private void deactivateDependencyManagers() {
        this.log(4, "Deactivating dependency managers", null);
        for (DependencyManager<S, ?> dm : this.getDependencyManagers()) {
            dm.deactivate();
        }
    }

    private void disableDependencyManagers() {
        this.log(4, "Disabling dependency managers", null);
        AtomicInteger trackingCount = new AtomicInteger();
        for (DependencyManager<S, ?> dm : this.getDependencyManagers()) {
            dm.unregisterServiceListener(trackingCount);
        }
    }

    public abstract boolean hasConfiguration();

    @Override
    public abstract Dictionary<String, Object> getProperties();

    public abstract void setServiceProperties(Dictionary<String, Object> var1);

    public Dictionary<String, Object> getServiceProperties() {
        return AbstractComponentManager.copyTo(null, this.getProperties(), false);
    }

    protected static Dictionary<String, Object> copyTo(Dictionary<String, Object> target, Dictionary<String, Object> source) {
        return AbstractComponentManager.copyTo(target, source, true);
    }

    protected static Dictionary<String, Object> copyTo(Dictionary<String, Object> target, Dictionary<String, Object> source, boolean allProps) {
        if (target == null) {
            target = new Hashtable<String, Object>();
        }
        if (source != null && !source.isEmpty()) {
            Enumeration<String> ce = source.keys();
            while (ce.hasMoreElements()) {
                String key = ce.nextElement();
                if (!allProps && key.charAt(0) == '.') continue;
                target.put(key, source.get(key));
            }
        }
        return target;
    }

    public ComponentMetadata getComponentMetadata() {
        return this.m_componentMetadata;
    }

    @Override
    public int getState() {
        if (this.m_disposed) {
            return 256;
        }
        if (!this.m_internalEnabled) {
            return 1;
        }
        if (!(this.getServiceRegistration() != null || this.getProvidedServices() == null && this.hasInstance())) {
            return 4;
        }
        if (this.isFactory() && !this.m_factoryInstance) {
            return 64;
        }
        if (this.hasInstance()) {
            return 16;
        }
        return 32;
    }

    abstract boolean hasInstance();

    public void setServiceProperties(MethodResult methodResult) {
        if (methodResult.hasResult()) {
            Hashtable<String, Object> serviceProps = methodResult.getResult() == null ? null : new Hashtable<String, Object>(methodResult.getResult());
            this.setServiceProperties(serviceProps);
        }
    }

    boolean isEnabled() {
        return this.m_internalEnabled;
    }

    static /* synthetic */ AtomicLong access$000() {
        return taskCounter;
    }
}

