/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.metadata;

import java.util.Set;
import java.util.TreeSet;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;

public class ReferenceMetadata {
    public static final String CARDINALITY_0_1 = "0..1";
    public static final String CARDINALITY_0_N = "0..n";
    public static final String CARDINALITY_1_1 = "1..1";
    public static final String CARDINALITY_1_N = "1..n";
    private static final Set CARDINALITY_VALID = new TreeSet();
    public static final String POLICY_STATIC = "static";
    public static final String POLICY_DYNAMIC = "dynamic";
    private static final Set POLICY_VALID;
    private String m_name = null;
    private String m_interface = null;
    private String m_cardinality = null;
    private String m_target;
    private String m_bind = null;
    private String m_unbind = null;
    private String m_policy = null;
    private boolean m_validated = false;
    private boolean m_isStatic = true;
    private boolean m_isOptional = false;
    private boolean m_isMultiple = false;

    public void setName(String name) {
        if (this.m_validated) {
            return;
        }
        this.m_name = name;
    }

    public void setInterface(String interfaceName) {
        if (this.m_validated) {
            return;
        }
        this.m_interface = interfaceName;
    }

    public void setCardinality(String cardinality) {
        if (this.m_validated) {
            return;
        }
        this.m_cardinality = cardinality;
        this.m_isOptional = CARDINALITY_0_1.equals(cardinality) || CARDINALITY_0_N.equals(cardinality);
        this.m_isMultiple = CARDINALITY_0_N.equals(cardinality) || CARDINALITY_1_N.equals(cardinality);
    }

    public void setPolicy(String policy) {
        if (this.m_validated) {
            return;
        }
        this.m_policy = policy;
        this.m_isStatic = POLICY_STATIC.equals(policy);
    }

    public void setTarget(String target) {
        if (this.m_validated) {
            return;
        }
        this.m_target = target == null || target.length() == 0 ? null : target;
    }

    public void setBind(String bind) {
        if (this.m_validated) {
            return;
        }
        this.m_bind = bind;
    }

    public void setUnbind(String unbind) {
        if (this.m_validated) {
            return;
        }
        this.m_unbind = unbind;
    }

    public String getName() {
        return this.m_name;
    }

    public String getInterface() {
        return this.m_interface;
    }

    public String getCardinality() {
        return this.m_cardinality;
    }

    public String getPolicy() {
        return this.m_policy;
    }

    public String getTarget() {
        return this.m_target;
    }

    public String getBind() {
        return this.m_bind;
    }

    public String getUnbind() {
        return this.m_unbind;
    }

    public boolean isStatic() {
        return this.m_isStatic;
    }

    public boolean isOptional() {
        return this.m_isOptional;
    }

    public boolean isMultiple() {
        return this.m_isMultiple;
    }

    public String getTargetPropertyName() {
        return this.getName() + ".target";
    }

    void validate(ComponentMetadata componentMetadata) {
        if (this.m_name == null) {
            if (!componentMetadata.isDS11()) {
                throw componentMetadata.validationFailure("A name must be declared for the reference");
            }
            this.setName(this.getInterface());
        }
        if (this.m_interface == null) {
            throw componentMetadata.validationFailure("An interface must be declared for the reference");
        }
        if (this.m_cardinality == null) {
            this.setCardinality(CARDINALITY_1_1);
        } else if (!CARDINALITY_VALID.contains(this.m_cardinality)) {
            throw componentMetadata.validationFailure("Cardinality must be one of " + CARDINALITY_VALID);
        }
        if (this.m_policy == null) {
            this.setPolicy(POLICY_STATIC);
        } else if (!POLICY_VALID.contains(this.m_policy)) {
            throw componentMetadata.validationFailure("Policy must be one of " + POLICY_VALID);
        }
    }

    static {
        CARDINALITY_VALID.add(CARDINALITY_0_1);
        CARDINALITY_VALID.add(CARDINALITY_0_N);
        CARDINALITY_VALID.add(CARDINALITY_1_1);
        CARDINALITY_VALID.add(CARDINALITY_1_N);
        POLICY_VALID = new TreeSet();
        POLICY_VALID.add(POLICY_DYNAMIC);
        POLICY_VALID.add(POLICY_STATIC);
    }
}

