/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.config.ComponentHolder;
import org.apache.felix.scr.impl.manager.AbstractComponentManager;
import org.apache.felix.scr.impl.manager.ImmediateComponentManager;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentException;
import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.ComponentInstance;

public class ComponentFactoryImpl
extends AbstractComponentManager
implements ComponentFactory,
ComponentHolder {
    private final Map m_componentInstances = new IdentityHashMap();
    private Dictionary m_configuration;
    private Map m_configuredServices;
    private final boolean m_isConfigurationFactory;
    static /* synthetic */ Class class$org$osgi$service$component$ComponentFactory;

    public ComponentFactoryImpl(BundleComponentActivator activator, ComponentMetadata metadata) {
        super(activator, metadata);
        this.m_isConfigurationFactory = "true".equals(activator.getBundleContext().getProperty("ds.factory.enabled"));
    }

    public ComponentInstance newInstance(Dictionary dictionary) {
        ImmediateComponentManager cm = this.createComponentManager();
        cm.setFactoryProperties(dictionary);
        cm.reconfigure(this.m_configuration);
        cm.enableInternal();
        cm.activateInternal();
        ComponentInstance instance = cm.getComponentInstance();
        if (instance == null) {
            cm.dispose();
            throw new ComponentException("Failed activating component");
        }
        this.m_componentInstances.put(cm, cm);
        return instance;
    }

    protected boolean createComponent() {
        ImmediateComponentManager[] cms = this.getComponentManagers(this.m_configuredServices);
        for (int i = 0; i < cms.length; ++i) {
            cms[i].enable();
        }
        return true;
    }

    protected void deleteComponent(int reason) {
        ImmediateComponentManager[] cms = this.getComponentManagers(this.m_configuredServices);
        for (int i = 0; i < cms.length; ++i) {
            cms[i].disable();
        }
    }

    protected ServiceRegistration registerService() {
        this.log(4, "registering component factory", null);
        Dictionary serviceProperties = this.getProperties();
        return this.getActivator().getBundleContext().registerService(new String[]{(class$org$osgi$service$component$ComponentFactory == null ? (class$org$osgi$service$component$ComponentFactory = ComponentFactoryImpl.class$("org.osgi.service.component.ComponentFactory")) : class$org$osgi$service$component$ComponentFactory).getName()}, this.getService(), serviceProperties);
    }

    public Object getInstance() {
        return null;
    }

    public boolean hasConfiguration() {
        return true;
    }

    public Dictionary getProperties() {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("component.name", this.getComponentMetadata().getName());
        ((Dictionary)props).put("component.factory", this.getComponentMetadata().getFactoryIdentifier());
        ((Dictionary)props).put("service.pid", this.getComponentMetadata().getName());
        ((Dictionary)props).put("service.description", "ManagedServiceFactory for Factory Component" + this.getComponentMetadata().getName());
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        return props;
    }

    protected Object getService() {
        return this;
    }

    public ComponentInstance getComponentInstance() {
        return null;
    }

    public void configurationDeleted(String pid) {
        ImmediateComponentManager cm;
        if (pid.equals(this.getComponentMetadata().getName())) {
            this.m_configuration = null;
            this.reconfigureComponents(null);
        } else if (this.m_isConfigurationFactory && this.m_configuredServices != null && (cm = (ImmediateComponentManager)this.m_configuredServices.remove(pid)) != null) {
            this.log(4, "Disposing component after configuration deletion", null);
            cm.dispose();
        }
    }

    public void configurationUpdated(String pid, Dictionary configuration) {
        if (pid.equals(this.getComponentMetadata().getName())) {
            this.m_configuration = configuration;
            this.reconfigureComponents(configuration);
        } else if (this.m_isConfigurationFactory) {
            ImmediateComponentManager cm;
            if (this.m_configuredServices != null) {
                cm = (ImmediateComponentManager)this.m_configuredServices.get(pid);
            } else {
                this.m_configuredServices = new HashMap();
                cm = null;
            }
            if (cm == null) {
                cm = this.createComponentManager();
                cm.reconfigure(configuration);
                if (this.getState() == 64) {
                    cm.enable();
                }
                this.m_configuredServices.put(pid, cm);
            } else {
                cm.reconfigure(configuration);
            }
        } else {
            this.log(1, "Component Factory cannot be configured by factory configuration", null);
        }
    }

    public void enableComponents() {
        this.enable();
    }

    private void reconfigureComponents(Dictionary configuration) {
        ImmediateComponentManager[] cms = this.getComponentManagers(this.m_componentInstances);
        for (int i = 0; i < cms.length; ++i) {
            cms[i].reconfigure(configuration);
        }
    }

    public void disableComponents() {
        this.disable();
    }

    public void disposeComponents(int reason) {
        int i;
        ImmediateComponentManager[] cms = this.getComponentManagers(this.m_componentInstances);
        for (i = 0; i < cms.length; ++i) {
            cms[i].dispose(reason);
        }
        this.m_componentInstances.clear();
        cms = this.getComponentManagers(this.m_configuredServices);
        for (i = 0; i < cms.length; ++i) {
            cms[i].dispose(reason);
        }
        this.m_configuredServices = null;
        this.dispose(reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposed(ImmediateComponentManager component) {
        Map map = this.m_componentInstances;
        synchronized (map) {
            this.m_componentInstances.remove(component);
        }
    }

    private ImmediateComponentManager createComponentManager() {
        return new ImmediateComponentManager(this.getActivator(), this, this.getComponentMetadata());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImmediateComponentManager[] getComponentManagers(Map componentMap) {
        if (componentMap != null) {
            Map map = componentMap;
            synchronized (map) {
                ImmediateComponentManager[] cm = new ImmediateComponentManager[componentMap.size()];
                componentMap.values().toArray(cm);
                return cm;
            }
        }
        return new ImmediateComponentManager[0];
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

