/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.ComponentActorThread;
import org.apache.felix.scr.impl.ComponentRegistry;
import org.apache.felix.scr.impl.ScrCommand;
import org.apache.felix.scr.impl.config.ConfigurationComponentRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator,
SynchronousBundleListener {
    static final String LOGSERVICE_CLASS = "org.osgi.service.log.LogService";
    private static int m_logLevel = 1;
    private BundleContext m_context;
    private static ServiceTracker m_logService;
    private Map m_componentBundles;
    private ComponentRegistry m_componentRegistry;
    private ComponentActorThread m_componentActor;
    static /* synthetic */ Class class$org$apache$felix$shell$Command;

    public void start(BundleContext context) throws Exception {
        this.m_context = context;
        this.m_componentBundles = new HashMap();
        this.m_componentRegistry = Activator.createComponentRegistry(context);
        m_logService = new ServiceTracker(context, LOGSERVICE_CLASS, null);
        m_logService.open();
        m_logLevel = Activator.getLogLevel(context);
        if ("true".equalsIgnoreCase(context.getProperty("ds.showversion"))) {
            Activator.log(3, context.getBundle(), " Version = " + context.getBundle().getHeaders().get("Bundle-Version"), null);
        }
        this.m_componentActor = new ComponentActorThread();
        Thread t = new Thread((Runnable)this.m_componentActor, "SCR Component Actor");
        t.setDaemon(true);
        t.start();
        context.addBundleListener((BundleListener)this);
        this.loadAllComponents(context);
        try {
            context.registerService((class$org$apache$felix$shell$Command == null ? (class$org$apache$felix$shell$Command = Activator.class$("org.apache.felix.shell.Command")) : class$org$apache$felix$shell$Command).getName(), (Object)new ScrCommand(this.m_context, this.m_componentRegistry), null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void stop(BundleContext context) throws Exception {
        context.removeBundleListener((BundleListener)this);
        this.disposeAllComponents();
        this.m_componentRegistry.dispose();
        if (this.m_componentActor != null) {
            this.m_componentActor.terminate();
            this.m_componentActor = null;
        }
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 512 || event.getType() == 2) {
            this.loadComponents(event.getBundle());
        } else if (event.getType() == 256) {
            this.disposeComponents(event.getBundle());
        }
    }

    private void loadAllComponents(BundleContext context) {
        Bundle[] bundles = context.getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            Bundle bundle = bundles[i];
            if (!ComponentRegistry.isBundleActive(bundle)) continue;
            this.loadComponents(bundle);
        }
    }

    private void loadComponents(Bundle bundle) {
        if (bundle.getHeaders().get("Service-Component") == null) {
            return;
        }
        if (this.m_componentBundles.containsKey(new Long(bundle.getBundleId()))) {
            Activator.log(4, this.m_context.getBundle(), "Components for bundle  " + bundle.getSymbolicName() + "/" + bundle.getBundleId() + " already loaded. Nothing to do.", null);
            return;
        }
        BundleContext context = bundle.getBundleContext();
        if (context == null) {
            Activator.log(1, this.m_context.getBundle(), "Cannot get BundleContext of bundle " + bundle.getSymbolicName() + "/" + bundle.getBundleId(), null);
            return;
        }
        try {
            BundleComponentActivator ga = new BundleComponentActivator(this.m_componentRegistry, this.m_componentActor, context, m_logLevel);
            this.m_componentBundles.put(new Long(bundle.getBundleId()), ga);
        }
        catch (Exception e) {
            if (e instanceof IllegalStateException && bundle.getState() != 32) {
                Activator.log(3, this.m_context.getBundle(), "Bundle " + bundle.getSymbolicName() + "/" + bundle.getBundleId() + " has been stopped while trying to activate its components. Trying again when the bundles gets startet again.", e);
            }
            Activator.log(1, this.m_context.getBundle(), "Error while loading components of bundle " + bundle.getSymbolicName() + "/" + bundle.getBundleId(), e);
        }
    }

    private void disposeComponents(Bundle bundle) {
        BundleComponentActivator ga = (BundleComponentActivator)this.m_componentBundles.remove(new Long(bundle.getBundleId()));
        if (ga != null) {
            try {
                ga.dispose(6);
            }
            catch (Exception e) {
                Activator.log(1, this.m_context.getBundle(), "Error while disposing components of bundle " + bundle.getSymbolicName() + "/" + bundle.getBundleId(), e);
            }
        }
    }

    private void disposeAllComponents() {
        Iterator it = this.m_componentBundles.values().iterator();
        while (it.hasNext()) {
            BundleComponentActivator ga = (BundleComponentActivator)it.next();
            try {
                ga.dispose(5);
            }
            catch (Exception e) {
                Activator.log(1, this.m_context.getBundle(), "Error while disposing components of bundle " + ga.getBundleContext().getBundle().getSymbolicName(), e);
            }
            it.remove();
        }
    }

    public static ComponentRegistry createComponentRegistry(BundleContext bundleContext) {
        try {
            return new ConfigurationComponentRegistry(bundleContext);
        }
        catch (Throwable t) {
            Activator.log(3, bundleContext.getBundle(), "ConfigurationAdmin supporting ComponentRegistry not available, not using ConfigurationAdmin", t);
            return new ComponentRegistry(bundleContext);
        }
    }

    private static int getLogLevel(BundleContext bundleContext) {
        String levelString;
        block8: {
            levelString = bundleContext.getProperty("ds.loglevel");
            if (levelString != null) {
                try {
                    return Integer.parseInt(levelString);
                }
                catch (NumberFormatException numberFormatException) {
                    if ("debug".equalsIgnoreCase(levelString)) {
                        return 4;
                    }
                    if ("info".equalsIgnoreCase(levelString)) {
                        return 3;
                    }
                    if ("warn".equalsIgnoreCase(levelString)) {
                        return 2;
                    }
                    if (!"error".equalsIgnoreCase(levelString)) break block8;
                    return 1;
                }
            }
        }
        levelString = bundleContext.getProperty("ds.trace");
        if ("true".equalsIgnoreCase(bundleContext.getProperty("ds.showtrace"))) {
            return 4;
        }
        if ("false".equalsIgnoreCase(bundleContext.getProperty("ds.showerrors"))) {
            return -1;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(int level, Bundle bundle, String message, Throwable ex) {
        if (m_logLevel >= level) {
            Object logger;
            Object object = logger = m_logService != null ? m_logService.getService() : null;
            if (logger == null) {
                PrintStream out = level == 1 ? System.err : System.out;
                StringBuffer buf = new StringBuffer();
                switch (level) {
                    case 4: {
                        buf.append("DEBUG: ");
                        break;
                    }
                    case 3: {
                        buf.append("INFO : ");
                        break;
                    }
                    case 2: {
                        buf.append("WARN : ");
                        break;
                    }
                    case 1: {
                        buf.append("ERROR: ");
                        break;
                    }
                    default: {
                        buf.append("UNK  : ");
                    }
                }
                if (bundle != null) {
                    buf.append(bundle.getSymbolicName());
                    buf.append(" (");
                    buf.append(bundle.getBundleId());
                    buf.append("): ");
                }
                buf.append(message);
                PrintStream printStream = out;
                synchronized (printStream) {
                    out.println(buf);
                    if (ex != null) {
                        ex.printStackTrace(out);
                    }
                }
            } else {
                ((LogService)logger).log(level, message, ex);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

