/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.felix.scr.impl.ComponentMetadata;
import org.apache.felix.scr.impl.PropertyMetadata;
import org.apache.felix.scr.impl.ReferenceMetadata;
import org.apache.felix.scr.impl.ServiceMetadata;
import org.apache.felix.scr.impl.parser.KXml2SAXHandler;
import org.apache.felix.scr.impl.parser.ParseException;
import org.osgi.framework.Bundle;

public class XmlHandler
implements KXml2SAXHandler {
    public static final String NAMESPACE_URI = "http://www.osgi.org/xmlns/scr/v1.0.0";
    private Bundle m_bundle;
    private ComponentMetadata m_currentComponent;
    private ServiceMetadata m_currentService;
    private List m_components = new ArrayList();
    private PropertyMetadata m_pendingProperty;
    protected boolean firstElement = true;
    protected String overrideNamespace;
    protected boolean isComponent = false;

    XmlHandler(Bundle bundle) {
        this.m_bundle = bundle;
    }

    public void startElement(String uri, String localName, Properties attrib) throws ParseException {
        if (this.firstElement) {
            this.firstElement = false;
            if (localName.equals("component") && "".equals(uri)) {
                this.overrideNamespace = NAMESPACE_URI;
            }
        }
        if (this.overrideNamespace != null && "".equals(uri)) {
            uri = this.overrideNamespace;
        }
        if (this.isComponent && "".equals(uri)) {
            uri = NAMESPACE_URI;
        }
        if (NAMESPACE_URI.equals(uri)) {
            try {
                if (localName.equals("component")) {
                    this.isComponent = true;
                    this.m_currentComponent = new ComponentMetadata();
                    this.m_currentComponent.setName(attrib.getProperty("name"));
                    if (attrib.getProperty("enabled") != null) {
                        this.m_currentComponent.setEnabled(attrib.getProperty("enabled").equals("true"));
                    }
                    if (attrib.getProperty("immediate") != null) {
                        this.m_currentComponent.setImmediate(attrib.getProperty("immediate").equals("true"));
                    }
                    if (attrib.getProperty("factory") != null) {
                        this.m_currentComponent.setFactoryIdentifier(attrib.getProperty("factory"));
                    }
                    this.m_components.add(this.m_currentComponent);
                } else if (localName.equals("implementation")) {
                    this.m_currentComponent.setImplementationClassName(attrib.getProperty("class"));
                } else if (localName.equals("property")) {
                    PropertyMetadata prop = new PropertyMetadata();
                    prop.setName(attrib.getProperty("name"));
                    if (attrib.getProperty("type") != null) {
                        prop.setType(attrib.getProperty("type"));
                    }
                    if (attrib.getProperty("value") != null) {
                        prop.setValue(attrib.getProperty("value"));
                        this.m_currentComponent.addProperty(prop);
                    } else {
                        this.m_pendingProperty = prop;
                    }
                } else if (localName.equals("properties")) {
                    this.readPropertiesEntry(attrib.getProperty("entry"));
                } else if (localName.equals("service")) {
                    this.m_currentService = new ServiceMetadata();
                    if (attrib.getProperty("servicefactory") != null) {
                        this.m_currentService.setServiceFactory(attrib.getProperty("servicefactory").equals("true"));
                    }
                    this.m_currentComponent.setService(this.m_currentService);
                } else if (localName.equals("provide")) {
                    this.m_currentService.addProvide(attrib.getProperty("interface"));
                } else if (localName.equals("reference")) {
                    ReferenceMetadata ref = new ReferenceMetadata();
                    ref.setName(attrib.getProperty("name"));
                    ref.setInterface(attrib.getProperty("interface"));
                    if (attrib.getProperty("cardinality") != null) {
                        ref.setCardinality(attrib.getProperty("cardinality"));
                    }
                    if (attrib.getProperty("policy") != null) {
                        ref.setPolicy(attrib.getProperty("policy"));
                    }
                    ref.setTarget(attrib.getProperty("target"));
                    ref.setBind(attrib.getProperty("bind"));
                    ref.setUnbind(attrib.getProperty("unbind"));
                    this.m_currentComponent.addDependency(ref);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new ParseException("Exception during parsing", ex);
            }
        }
    }

    public void endElement(String uri, String localName) {
        if (this.overrideNamespace != null && "".equals(uri)) {
            uri = this.overrideNamespace;
        }
        if (this.isComponent && "".equals(uri)) {
            uri = NAMESPACE_URI;
        }
        if (NAMESPACE_URI.equals(uri)) {
            if (localName.equals("component")) {
                this.isComponent = false;
                this.m_currentComponent.validate();
            } else if (localName.equals("property") && this.m_pendingProperty != null) {
                this.m_pendingProperty = null;
            }
        }
    }

    List getComponentMetadataList() {
        return this.m_components;
    }

    public void characters(String text) {
        if (this.m_pendingProperty != null) {
            this.m_pendingProperty.setValues(text);
            this.m_currentComponent.addProperty(this.m_pendingProperty);
            this.m_pendingProperty = null;
        }
    }

    public void processingInstruction(String target, String data) {
    }

    public void setLineNumber(int lineNumber) {
    }

    public void setColumnNumber(int columnNumber) {
    }

    private void readPropertiesEntry(String entryName) throws ParseException {
        if (entryName == null) {
            throw new ParseException("Missing entry attribute of properties element", null);
        }
        URL entryURL = this.m_bundle.getEntry(entryName);
        if (entryURL == null) {
            throw new ParseException("Missing bundle entry " + entryName, null);
        }
        Properties props = new Properties();
        InputStream entryStream = null;
        try {
            entryStream = entryURL.openStream();
            props.load(entryStream);
        }
        catch (IOException ioe) {
            throw new ParseException("Failed to read properties entry " + entryName, ioe);
        }
        finally {
            if (entryStream != null) {
                try {
                    entryStream.close();
                }
                catch (IOException ignore) {}
            }
        }
        Iterator<Map.Entry<Object, Object>> pi = props.entrySet().iterator();
        while (pi.hasNext()) {
            Map.Entry<Object, Object> pEntry = pi.next();
            PropertyMetadata prop = new PropertyMetadata();
            prop.setName(String.valueOf(pEntry.getKey()));
            prop.setValue(String.valueOf(pEntry.getValue()));
            this.m_currentComponent.addProperty(prop);
        }
    }
}

