/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.felix.scr.impl.Activator;
import org.apache.felix.scr.impl.ComponentActorThread;
import org.apache.felix.scr.impl.ComponentFactoryImpl;
import org.apache.felix.scr.impl.ComponentManager;
import org.apache.felix.scr.impl.ComponentMetadata;
import org.apache.felix.scr.impl.ComponentRegistry;
import org.apache.felix.scr.impl.ManagerFactory;
import org.apache.felix.scr.impl.XmlHandler;
import org.apache.felix.scr.impl.parser.KXml2SAXParser;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentException;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

class BundleComponentActivator {
    private ComponentRegistry m_componentRegistry;
    private BundleContext m_context = null;
    private List m_managers = new ArrayList();
    private ServiceTracker m_configurationAdmin;
    private ServiceTracker m_logService;
    private ComponentActorThread m_componentActor;
    private boolean m_active;
    private int m_logLevel;
    static /* synthetic */ Class class$org$osgi$service$cm$ConfigurationAdmin;

    BundleComponentActivator(ComponentRegistry componentRegistry, ComponentActorThread componentActor, BundleContext context, int logLevel) throws ComponentException {
        this.m_componentRegistry = componentRegistry;
        this.m_componentActor = componentActor;
        this.m_context = context;
        this.m_active = true;
        this.m_configurationAdmin = new ServiceTracker(context, (class$org$osgi$service$cm$ConfigurationAdmin == null ? (class$org$osgi$service$cm$ConfigurationAdmin = BundleComponentActivator.class$("org.osgi.service.cm.ConfigurationAdmin")) : class$org$osgi$service$cm$ConfigurationAdmin).getName(), null);
        this.m_configurationAdmin.open();
        this.m_logService = new ServiceTracker(context, "org.osgi.service.log.LogService", null);
        this.m_logService.open();
        this.m_logLevel = logLevel;
        String descriptorLocations = (String)this.m_context.getBundle().getHeaders().get("Service-Component");
        if (descriptorLocations == null) {
            throw new ComponentException("Service-Component entry not found in the manifest");
        }
        this.initialize(descriptorLocations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(String descriptorLocations) {
        StringTokenizer st = new StringTokenizer(descriptorLocations, ", ");
        while (st.hasMoreTokens()) {
            String descriptorLocation = st.nextToken();
            URL descriptorURL = this.m_context.getBundle().getResource(descriptorLocation);
            if (descriptorURL == null) {
                this.log(1, "Component descriptor entry '" + descriptorLocation + "' not found", null, null);
                continue;
            }
            InputStream stream = null;
            try {
                stream = descriptorURL.openStream();
                BufferedReader in = new BufferedReader(new InputStreamReader(stream));
                XmlHandler handler = new XmlHandler(this.m_context.getBundle());
                KXml2SAXParser parser = new KXml2SAXParser(in);
                parser.parseXML(handler);
                Iterator i = handler.getComponentMetadataList().iterator();
                while (i.hasNext()) {
                    ComponentMetadata metadata = (ComponentMetadata)i.next();
                    try {
                        this.m_componentRegistry.checkComponentName(metadata.getName());
                        metadata.validate();
                        ComponentManager manager = metadata.isFactory() ? new ComponentFactoryImpl(this, metadata, this.m_componentRegistry) : ManagerFactory.createManager(this, metadata, this.m_componentRegistry.createComponentId());
                        this.m_componentRegistry.registerComponent(metadata.getName(), manager);
                        this.m_managers.add(manager);
                        if (!metadata.isEnabled()) continue;
                        manager.enable();
                    }
                    catch (Throwable t) {
                        this.log(1, "Cannot register Component", metadata, t);
                        this.m_componentRegistry.unregisterComponent(metadata.getName());
                    }
                }
            }
            catch (IOException ex) {
                this.log(1, "Problem reading descriptor entry '" + descriptorLocation + "'", null, ex);
            }
            catch (Exception ex) {
                this.log(1, "General problem with descriptor entry '" + descriptorLocation + "'", null, ex);
            }
            finally {
                if (stream == null) continue;
                try {
                    stream.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose() {
        if (this.m_context == null) {
            return;
        }
        this.m_active = false;
        this.log(4, "BundleComponentActivator : Bundle [" + this.m_context.getBundle().getBundleId() + "] will destroy " + this.m_managers.size() + " instances", null, null);
        while (this.m_managers.size() != 0) {
            ComponentManager manager = (ComponentManager)this.m_managers.get(0);
            try {
                this.m_managers.remove(manager);
                manager.dispose();
            }
            catch (Exception e) {
                this.log(1, "BundleComponentActivator : Exception invalidating", manager.getComponentMetadata(), e);
            }
            finally {
                this.m_componentRegistry.unregisterComponent(manager.getComponentMetadata().getName());
            }
        }
        if (this.m_configurationAdmin != null) {
            this.m_configurationAdmin.close();
        }
        this.log(4, "BundleComponentActivator : Bundle [" + this.m_context.getBundle().getBundleId() + "] STOPPED", null, null);
        this.m_context = null;
    }

    boolean isActive() {
        return this.m_active;
    }

    protected List getInstanceReferences() {
        return this.m_managers;
    }

    protected BundleContext getBundleContext() {
        return this.m_context;
    }

    protected ConfigurationAdmin getConfigurationAdmin() {
        return (ConfigurationAdmin)this.m_configurationAdmin.getService();
    }

    void enableComponent(String name) {
        ComponentManager[] cm = this.getSelectedComponents(name);
        if (cm == null) {
            return;
        }
        for (int i = 0; i < cm.length; ++i) {
            try {
                cm[i].enable();
                continue;
            }
            catch (Throwable t) {
                this.log(1, "Cannot enable component", cm[i].getComponentMetadata(), t);
            }
        }
    }

    void disableComponent(String name) {
        ComponentManager[] cm = this.getSelectedComponents(name);
        if (cm == null) {
            return;
        }
        for (int i = 0; i < cm.length; ++i) {
            try {
                this.log(4, "Disabling Component", cm[i].getComponentMetadata(), null);
                cm[i].disable();
                continue;
            }
            catch (Throwable t) {
                this.log(1, "Cannot disable component", cm[i].getComponentMetadata(), t);
            }
        }
    }

    private ComponentManager[] getSelectedComponents(String name) {
        if (name == null) {
            return this.m_managers.toArray(new ComponentManager[this.m_managers.size()]);
        }
        if (this.m_componentRegistry.getComponent(name) != null) {
            Iterator it = this.m_managers.iterator();
            while (it.hasNext()) {
                ComponentManager cm = (ComponentManager)it.next();
                if (!name.equals(cm.getComponentMetadata().getName())) continue;
                return new ComponentManager[]{cm};
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void schedule(Runnable task) {
        if (this.isActive()) {
            ComponentActorThread cat = this.m_componentActor;
            if (cat != null) {
                cat.schedule(task);
            } else {
                this.log(3, "Component Actor Thread not running, calling synchronously", null, null);
                try {
                    BundleComponentActivator bundleComponentActivator = this;
                    synchronized (bundleComponentActivator) {
                        task.run();
                    }
                }
                catch (Throwable t) {
                    this.log(3, "Unexpected problem executing task", null, t);
                }
            }
        } else {
            this.log(3, "BundleComponentActivator is not active; not scheduling " + task, null, null);
        }
    }

    void log(int level, String message, ComponentMetadata metadata, Throwable ex) {
        if (this.m_logLevel >= level) {
            Object logger;
            if (metadata != null) {
                message = "[" + metadata.getName() + "] " + message;
            }
            if ((logger = this.m_logService.getService()) == null) {
                Activator.log(level, this.getBundleContext().getBundle(), message, ex);
            } else {
                ((LogService)logger).log(level, message, ex);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

