/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.util.IdentityHashMap;
import org.apache.felix.scr.impl.AbstractComponentManager;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.ComponentContextImpl;
import org.apache.felix.scr.impl.ComponentMetadata;
import org.apache.felix.scr.impl.ImmediateComponentManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentInstance;

public class ServiceFactoryComponentManager
extends ImmediateComponentManager
implements ServiceFactory {
    private IdentityHashMap serviceContexts = new IdentityHashMap();

    public ServiceFactoryComponentManager(BundleComponentActivator activator, ComponentMetadata metadata, long componentId) {
        super(activator, metadata, componentId);
    }

    protected boolean createComponent() {
        return true;
    }

    protected void deleteComponent() {
    }

    protected Object getService() {
        return this;
    }

    public Object getInstance() {
        return null;
    }

    public Object getService(Bundle bundle, ServiceRegistration registration) {
        this.getActivator().log(4, "DelayedServiceFactoryServiceFactory.getService()", this.getComponentMetadata(), null);
        BundleComponentContext serviceContext = new BundleComponentContext(this, bundle);
        Object service = this.createImplementationObject(serviceContext);
        if (service != null) {
            serviceContext.setImplementationObject(service);
            this.serviceContexts.put(service, serviceContext);
            this.setStateConditional(32, 16);
        }
        return service;
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        this.getActivator().log(4, "DelayedServiceFactoryServiceFactory.ungetService()", this.getComponentMetadata(), null);
        ComponentContext serviceContext = (ComponentContext)this.serviceContexts.remove(service);
        this.disposeImplementationObject(service, serviceContext);
        if (this.serviceContexts.isEmpty()) {
            this.setStateConditional(16, 32);
        }
    }

    private static class BundleComponentContext
    extends ComponentContextImpl
    implements ComponentInstance {
        private Bundle m_usingBundle;
        private Object m_implementationObject;

        BundleComponentContext(AbstractComponentManager componentManager, Bundle usingBundle) {
            super(componentManager);
            this.m_usingBundle = usingBundle;
        }

        private void setImplementationObject(Object implementationObject) {
            this.m_implementationObject = implementationObject;
        }

        public Bundle getUsingBundle() {
            return this.m_usingBundle;
        }

        public ComponentInstance getComponentInstance() {
            return this;
        }

        public Object getInstance() {
            return this.m_implementationObject;
        }

        public void dispose() {
            this.getComponentManager().dispose();
        }
    }
}

