/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import org.osgi.service.component.ComponentException;

public class ReferenceMetadata {
    private String m_name = null;
    private String m_interface = null;
    private String m_cardinality = "1..1";
    private String m_target;
    private String m_bind = null;
    private String m_unbind = null;
    private String m_policy = "static";
    private boolean m_validated = false;
    private boolean m_isStatic = true;
    private boolean m_isOptional = false;
    private boolean m_isMultiple = false;

    public void setName(String name) {
        if (this.m_validated) {
            return;
        }
        this.m_name = name;
    }

    public void setInterface(String interfaceName) {
        if (this.m_validated) {
            return;
        }
        this.m_interface = interfaceName;
    }

    public void setCardinality(String cardinality) {
        if (this.m_validated) {
            return;
        }
        this.m_cardinality = cardinality;
        if (!(this.m_cardinality.equals("0..1") || this.m_cardinality.equals("0..n") || this.m_cardinality.equals("1..1") || this.m_cardinality.equals("1..n"))) {
            throw new IllegalArgumentException("Cardinality should take one of the following values: 0..1, 0..n, 1..1, 1..n");
        }
        if (this.m_cardinality.equals("0..1") || this.m_cardinality.equals("0..n")) {
            this.m_isOptional = true;
        }
        if (this.m_cardinality.equals("0..n") || this.m_cardinality.equals("1..n")) {
            this.m_isMultiple = true;
        }
    }

    public void setPolicy(String policy) {
        if (this.m_validated) {
            return;
        }
        if (!this.m_policy.equals("static") && !this.m_policy.equals("dynamic")) {
            throw new IllegalArgumentException("Policy must be either 'static' or 'dynamic'");
        }
        if (!policy.equals("static")) {
            this.m_isStatic = false;
        }
        this.m_policy = policy;
    }

    public void setTarget(String target) {
        if (this.m_validated) {
            return;
        }
        this.m_target = target == null || target.length() == 0 ? null : target;
    }

    public void setBind(String bind) {
        if (this.m_validated) {
            return;
        }
        this.m_bind = bind;
    }

    public void setUnbind(String unbind) {
        if (this.m_validated) {
            return;
        }
        this.m_unbind = unbind;
    }

    public String getName() {
        return this.m_name;
    }

    public String getInterface() {
        return this.m_interface;
    }

    public String getCardinality() {
        return this.m_cardinality;
    }

    public String getPolicy() {
        return this.m_policy;
    }

    public String getTarget() {
        return this.m_target;
    }

    public String getBind() {
        return this.m_bind;
    }

    public String getUnbind() {
        return this.m_unbind;
    }

    public boolean isStatic() {
        return this.m_isStatic;
    }

    public boolean isOptional() {
        return this.m_isOptional;
    }

    public boolean isMultiple() {
        return this.m_isMultiple;
    }

    public String getTargetPropertyName() {
        return this.getName() + ".target";
    }

    void validate() {
        if (this.m_name == null) {
            throw new ComponentException("the name for the reference must be set");
        }
        if (this.m_interface == null) {
            throw new ComponentException("the interface for the reference must be set");
        }
    }
}

