/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.osgi.service.component.ComponentException;

public class PropertyMetadata {
    private String m_name;
    private String m_type = "String";
    private Object m_value;
    private boolean m_validated = false;

    public void setName(String name) {
        if (this.m_validated) {
            return;
        }
        this.m_name = name;
    }

    public void setType(String type) {
        if (this.m_validated) {
            return;
        }
        this.m_type = type;
    }

    public void setValue(String value) {
        if (this.m_validated) {
            return;
        }
        this.m_value = this.toType(value);
    }

    public void setValues(String values) {
        Object[] array;
        ArrayList<Object> valueList = new ArrayList<Object>();
        StringTokenizer tokener = new StringTokenizer(values, "\r\n");
        while (tokener.hasMoreTokens()) {
            String value = tokener.nextToken().trim();
            if (value.length() <= 0) continue;
            valueList.add(this.toType(value));
        }
        if (this.m_type.equals("String")) {
            this.m_value = valueList.toArray(new String[valueList.size()]);
        } else if (this.m_type.equals("Long")) {
            array = new long[valueList.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = (Long)valueList.get(i);
            }
            this.m_value = array;
        } else if (this.m_type.equals("Double")) {
            array = new double[valueList.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = (long)((Double)valueList.get(i)).doubleValue();
            }
            this.m_value = array;
        } else if (this.m_type.equals("Float")) {
            array = new float[valueList.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = (long)((Float)valueList.get(i)).floatValue();
            }
            this.m_value = array;
        } else if (this.m_type.equals("Integer")) {
            array = new int[valueList.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = ((Integer)valueList.get(i)).intValue();
            }
            this.m_value = array;
        } else if (this.m_type.equals("Byte")) {
            array = new byte[valueList.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = ((Byte)valueList.get(i)).byteValue();
            }
            this.m_value = array;
        } else if (this.m_type.equals("Char")) {
            array = new char[valueList.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = ((Character)valueList.get(i)).charValue();
            }
            this.m_value = array;
        } else if (this.m_type.equals("Boolean")) {
            array = new boolean[valueList.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = (long)((Boolean)valueList.get(i)).booleanValue();
            }
            this.m_value = array;
        } else if (this.m_type.equals("Short")) {
            array = new short[valueList.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = ((Short)valueList.get(i)).shortValue();
            }
            this.m_value = array;
        } else {
            throw new IllegalArgumentException("Undefined property type '" + this.m_type + "'");
        }
    }

    public String getName() {
        return this.m_name;
    }

    public String getType() {
        return this.m_type;
    }

    public Object getValue() {
        return this.m_value;
    }

    public void validate() {
        if (this.m_name == null) {
            throw new ComponentException("Property name attribute is mandatory");
        }
    }

    private Object toType(String value) {
        if (this.m_type.equals("String")) {
            return String.valueOf(value);
        }
        if (this.m_type.equals("Long")) {
            return Long.valueOf(value);
        }
        if (this.m_type.equals("Double")) {
            return Double.valueOf(value);
        }
        if (this.m_type.equals("Float")) {
            return Float.valueOf(value);
        }
        if (this.m_type.equals("Integer")) {
            return Integer.valueOf(value);
        }
        if (this.m_type.equals("Byte")) {
            return Byte.valueOf(value);
        }
        if (this.m_type.equals("Char")) {
            char c = value.length() > 0 ? value.charAt(0) : (char)'\u0000';
            return new Character(c);
        }
        if (this.m_type.equals("Boolean")) {
            return Boolean.valueOf(value);
        }
        if (this.m_type.equals("Short")) {
            return Short.valueOf(value);
        }
        throw new IllegalArgumentException("Undefined property type '" + this.m_type + "'");
    }
}

