/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.felix.scr.impl.AbstractComponentManager;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.ComponentContextImpl;
import org.apache.felix.scr.impl.ComponentMetadata;
import org.apache.felix.scr.impl.DependencyManager;
import org.apache.felix.scr.impl.ReferenceMetadata;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.ComponentContext;

class ImmediateComponentManager
extends AbstractComponentManager {
    private Object m_implementationObject;
    private ComponentContext m_componentContext;
    private Dictionary m_factoryProperties;
    private Dictionary m_properties;
    private ServiceRegistration m_managedServiceRegistration;
    private Dictionary m_configurationProperties;
    static /* synthetic */ Class class$org$osgi$service$cm$ManagedService;
    static /* synthetic */ Class class$org$osgi$service$component$ComponentContext;

    ImmediateComponentManager(BundleComponentActivator activator, ComponentMetadata metadata, long componentId) {
        super(activator, metadata, componentId);
        if (!this.getComponentMetadata().isFactory()) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("service.pid", this.getComponentMetadata().getName());
            ((Dictionary)props).put("service.description", "ManagedService for Component " + this.getComponentMetadata().getName());
            ((Dictionary)props).put("service.vendor", "Apache Software Foundation");
            ManagedService ms = new ManagedService(){

                public void updated(Dictionary properties) {
                    ImmediateComponentManager.this.reconfigure(properties);
                }
            };
            this.m_managedServiceRegistration = activator.getBundleContext().registerService((class$org$osgi$service$cm$ManagedService == null ? (class$org$osgi$service$cm$ManagedService = ImmediateComponentManager.class$("org.osgi.service.cm.ManagedService")) : class$org$osgi$service$cm$ManagedService).getName(), (Object)ms, props);
        }
    }

    public void dispose() {
        if (this.m_managedServiceRegistration != null) {
            try {
                this.m_managedServiceRegistration.unregister();
                this.m_managedServiceRegistration = null;
            }
            catch (Throwable t) {
                this.getActivator().log(3, "Unexpected problem unregistering ManagedService", this.getComponentMetadata(), t);
            }
        }
        super.dispose();
    }

    protected boolean createComponent() {
        ComponentContextImpl tmpContext = new ComponentContextImpl(this);
        Object tmpComponent = this.createImplementationObject(tmpContext);
        if (tmpComponent == null) {
            return false;
        }
        this.m_componentContext = tmpContext;
        this.m_implementationObject = tmpComponent;
        return true;
    }

    protected void deleteComponent() {
        this.disposeImplementationObject(this.m_implementationObject, this.m_componentContext);
        this.m_implementationObject = null;
        this.m_componentContext = null;
        this.m_properties = null;
    }

    public Object getInstance() {
        return this.m_implementationObject;
    }

    protected Object createImplementationObject(ComponentContext componentContext) {
        Object implementationObject;
        try {
            Class c = this.getActivator().getBundleContext().getBundle().loadClass(this.getComponentMetadata().getImplementationClassName());
            implementationObject = c.newInstance();
        }
        catch (Exception ex) {
            this.getActivator().log(1, "Error during instantiation of the implementation object", this.getComponentMetadata(), ex);
            return null;
        }
        Iterator it = this.getDependencyManagers();
        while (it.hasNext()) {
            DependencyManager dm = (DependencyManager)it.next();
            if (dm.bind(implementationObject)) continue;
            this.getActivator().log(1, "Cannot create component instance due to failure to bind reference " + dm.getName(), this.getComponentMetadata(), null);
            it = this.getDependencyManagers();
            while (it.hasNext()) {
                dm = (DependencyManager)it.next();
                dm.unbind(implementationObject);
            }
            return null;
        }
        try {
            Method activateMethod = ImmediateComponentManager.getMethod(implementationObject.getClass(), "activate", new Class[]{class$org$osgi$service$component$ComponentContext == null ? (class$org$osgi$service$component$ComponentContext = ImmediateComponentManager.class$("org.osgi.service.component.ComponentContext")) : class$org$osgi$service$component$ComponentContext}, false);
            activateMethod.invoke(implementationObject, componentContext);
        }
        catch (NoSuchMethodException ex) {
            this.getActivator().log(4, "activate() method is not implemented", this.getComponentMetadata(), null);
        }
        catch (IllegalAccessException ex) {
            this.getActivator().log(4, "activate() method cannot be called", this.getComponentMetadata(), null);
        }
        catch (InvocationTargetException ex) {
            this.getActivator().log(1, "The activate method has thrown an exception", this.getComponentMetadata(), ex.getCause());
            it = this.getDependencyManagers();
            while (it.hasNext()) {
                DependencyManager dm = (DependencyManager)it.next();
                dm.unbind(implementationObject);
            }
            return null;
        }
        return implementationObject;
    }

    protected void disposeImplementationObject(Object implementationObject, ComponentContext componentContext) {
        try {
            Method deactivateMethod = ImmediateComponentManager.getMethod(implementationObject.getClass(), "deactivate", new Class[]{class$org$osgi$service$component$ComponentContext == null ? (class$org$osgi$service$component$ComponentContext = ImmediateComponentManager.class$("org.osgi.service.component.ComponentContext")) : class$org$osgi$service$component$ComponentContext}, false);
            deactivateMethod.invoke(implementationObject, componentContext);
        }
        catch (NoSuchMethodException ex) {
            this.getActivator().log(4, "deactivate() method is not implemented", this.getComponentMetadata(), null);
        }
        catch (IllegalAccessException ex) {
            this.getActivator().log(4, "deactivate() method cannot be called", this.getComponentMetadata(), null);
        }
        catch (InvocationTargetException ex) {
            this.getActivator().log(1, "The deactivate method has thrown an exception", this.getComponentMetadata(), ex.getCause());
        }
        Iterator it = this.getDependencyManagers();
        while (it.hasNext()) {
            DependencyManager dm = (DependencyManager)it.next();
            dm.unbind(implementationObject);
        }
    }

    protected Object getService() {
        return this.m_implementationObject;
    }

    protected void setFactoryProperties(Dictionary dictionary) {
        this.m_factoryProperties = this.copyTo(null, dictionary);
    }

    public Dictionary getProperties() {
        if (this.m_properties == null) {
            Dictionary props = this.copyTo(null, this.getComponentMetadata().getProperties());
            List depMetaData = this.getComponentMetadata().getDependencies();
            Iterator di = depMetaData.iterator();
            while (di.hasNext()) {
                ReferenceMetadata rm = (ReferenceMetadata)di.next();
                if (rm.getTarget() == null) continue;
                props.put(rm.getTargetPropertyName(), rm.getTarget());
            }
            this.copyTo(props, this.m_configurationProperties);
            this.copyTo(props, this.m_factoryProperties);
            props.put("component.name", this.getComponentMetadata().getName());
            props.put("component.id", new Long(this.getId()));
            this.m_properties = props;
        }
        return this.m_properties;
    }

    public void reconfigure(Dictionary configuration) {
        this.m_configurationProperties = configuration;
        this.m_properties = null;
        if ((this.getState() & 0x70) != 0) {
            this.reactivate();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

