/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.felix.scr.Reference;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.ComponentManager;
import org.apache.felix.scr.impl.ComponentMetadata;
import org.apache.felix.scr.impl.DependencyManager;
import org.apache.felix.scr.impl.ReferenceMetadata;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentInstance;

abstract class AbstractComponentManager
implements ComponentManager,
ComponentInstance {
    private long m_componentId;
    private int m_state;
    private ComponentMetadata m_componentMetadata;
    private List m_dependencyManagers;
    private BundleComponentActivator m_activator;
    private ServiceRegistration m_serviceRegistration;

    protected AbstractComponentManager(BundleComponentActivator activator, ComponentMetadata metadata, long componentId) {
        this.m_activator = activator;
        this.m_componentMetadata = metadata;
        this.m_componentId = componentId;
        this.m_state = 1;
        this.m_dependencyManagers = new ArrayList();
        this.getActivator().log(4, "Component created", this.m_componentMetadata, null);
    }

    public final void enable() {
        this.getActivator().schedule(new Runnable(){

            public void run() {
                AbstractComponentManager.this.enableInternal();
            }
        });
    }

    public final void activate() {
        this.getActivator().schedule(new Runnable(){

            public void run() {
                AbstractComponentManager.this.activateInternal();
            }
        });
    }

    public final void reconfigure() {
        this.getActivator().log(4, "Deactivating and Activating to reconfigure", this.m_componentMetadata, null);
        this.reactivate();
    }

    public final void reactivate() {
        this.deactivateInternal();
        this.getActivator().schedule(new Runnable(){

            public void run() {
                AbstractComponentManager.this.activateInternal();
            }
        });
    }

    public final void deactivate() {
        this.deactivateInternal();
    }

    public final void disable() {
        this.getActivator().schedule(new Runnable(){

            public void run() {
                AbstractComponentManager.this.disableInternal();
            }
        });
    }

    public void dispose() {
        this.disposeInternal();
    }

    public long getId() {
        return this.m_componentId;
    }

    public String getName() {
        return this.m_componentMetadata.getName();
    }

    public Bundle getBundle() {
        return this.getActivator().getBundleContext().getBundle();
    }

    public String getClassName() {
        return this.m_componentMetadata.getImplementationClassName();
    }

    public String getFactory() {
        return this.m_componentMetadata.getFactoryIdentifier();
    }

    public Reference[] getReferences() {
        if (this.m_dependencyManagers != null && this.m_dependencyManagers.size() > 0) {
            return this.m_dependencyManagers.toArray(new Reference[this.m_dependencyManagers.size()]);
        }
        return null;
    }

    public boolean isImmediate() {
        return this.m_componentMetadata.isImmediate();
    }

    public boolean isDefaultEnabled() {
        return this.m_componentMetadata.isEnabled();
    }

    public boolean isServiceFactory() {
        return this.m_componentMetadata.getServiceMetadata() != null && this.m_componentMetadata.getServiceMetadata().isServiceFactory();
    }

    public String[] getServices() {
        if (this.m_componentMetadata.getServiceMetadata() != null) {
            return this.m_componentMetadata.getServiceMetadata().getProvides();
        }
        return null;
    }

    private void enableInternal() {
        if (this.getState() == 256) {
            this.getActivator().log(1, "Destroyed Component cannot be enabled", this.m_componentMetadata, null);
            return;
        }
        if (this.getState() != 1) {
            this.getActivator().log(4, "Component is already enabled", this.m_componentMetadata, null);
            return;
        }
        this.getActivator().log(4, "Enabling component", this.m_componentMetadata, null);
        try {
            if (this.m_componentMetadata.getDependencies().size() != 0) {
                Iterator dependencyit = this.m_componentMetadata.getDependencies().iterator();
                while (dependencyit.hasNext()) {
                    ReferenceMetadata currentdependency = (ReferenceMetadata)dependencyit.next();
                    DependencyManager depmanager = new DependencyManager(this, currentdependency);
                    this.m_dependencyManagers.add(depmanager);
                }
            }
            this.setState(2);
            this.getActivator().log(4, "Component enabled", this.m_componentMetadata, null);
            this.activateInternal();
        }
        catch (Exception ex) {
            this.getActivator().log(1, "Failed enabling Component", this.m_componentMetadata, ex);
            this.disableInternal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateInternal() {
        AbstractComponentManager abstractComponentManager = this;
        synchronized (abstractComponentManager) {
            if (!this.setStateConditional(6, 8)) {
                return;
            }
            if (!this.isActive()) {
                this.getActivator().log(4, "Component cannot be activated because the Activator is being disposed", this.m_componentMetadata, null);
                this.setState(4);
                return;
            }
            this.getActivator().log(4, "Activating component", this.m_componentMetadata, null);
            Dictionary properties = this.getProperties();
            Iterator it = this.m_dependencyManagers.iterator();
            while (it.hasNext()) {
                DependencyManager dm = (DependencyManager)it.next();
                dm.setTargetFilter(properties);
                if (!dm.isSatisfied()) {
                    this.getActivator().log(3, "Dependency not satisfied: " + dm.getName(), this.m_componentMetadata, null);
                    this.setState(4);
                }
                if (this.getState() != 4) continue;
                return;
            }
            if (!this.createComponent()) {
                this.getActivator().log(1, "Component instance could not be created, activation failed", this.m_componentMetadata, null);
                this.setState(4);
                return;
            }
            this.setState(this.getSatisfiedState());
        }
        try {
            this.m_serviceRegistration = this.registerComponentService();
            this.getActivator().log(4, "Component activated", this.m_componentMetadata, null);
        }
        catch (IllegalStateException ise) {
            this.getActivator().log(4, "Component activation failed while registering the service", this.m_componentMetadata, ise);
        }
    }

    private synchronized void deactivateInternal() {
        if (!this.setStateConditional(120, 128)) {
            return;
        }
        this.getActivator().log(4, "Deactivating component", this.m_componentMetadata, null);
        this.unregisterComponentService();
        this.deleteComponent();
        this.setState(4);
        this.getActivator().log(4, "Component deactivated", this.m_componentMetadata, null);
    }

    private void disableInternal() {
        this.deactivateInternal();
        this.getActivator().log(4, "Disabling component", this.m_componentMetadata, null);
        Iterator it = this.m_dependencyManagers.iterator();
        while (it.hasNext()) {
            DependencyManager dm = (DependencyManager)it.next();
            dm.close();
        }
        this.m_dependencyManagers.clear();
        this.setState(1);
        this.getActivator().log(4, "Component disabled", this.m_componentMetadata, null);
    }

    private void disposeInternal() {
        this.disableInternal();
        this.setState(256);
        this.getActivator().log(4, "Component disposed", this.m_componentMetadata, null);
        this.m_activator = null;
        this.m_dependencyManagers = null;
    }

    protected abstract boolean createComponent();

    protected abstract void deleteComponent();

    protected abstract Object getService();

    private int getSatisfiedState() {
        if (this.m_componentMetadata.isFactory()) {
            return 64;
        }
        if (this.m_componentMetadata.isImmediate()) {
            return 16;
        }
        return 32;
    }

    protected ServiceRegistration registerComponentService() {
        if (this.getComponentMetadata().getServiceMetadata() != null) {
            this.getActivator().log(4, "registering services", this.getComponentMetadata(), null);
            Dictionary serviceProperties = this.copyTo(null, this.getProperties());
            return this.getActivator().getBundleContext().registerService(this.getComponentMetadata().getServiceMetadata().getProvides(), this.getService(), serviceProperties);
        }
        return null;
    }

    protected void unregisterComponentService() {
        if (this.m_serviceRegistration != null) {
            this.m_serviceRegistration.unregister();
            this.m_serviceRegistration = null;
            this.getActivator().log(4, "unregistering the services", this.getComponentMetadata(), null);
        }
    }

    BundleComponentActivator getActivator() {
        return this.m_activator;
    }

    private boolean isActive() {
        BundleComponentActivator bca = this.getActivator();
        return bca != null && bca.isActive();
    }

    Iterator getDependencyManagers() {
        return this.m_dependencyManagers.iterator();
    }

    DependencyManager getDependencyManager(String name) {
        Iterator it = this.getDependencyManagers();
        while (it.hasNext()) {
            DependencyManager dm = (DependencyManager)it.next();
            if (!name.equals(dm.getName())) continue;
            return dm;
        }
        return null;
    }

    public abstract Object getInstance();

    public abstract Dictionary getProperties();

    protected Dictionary copyTo(Dictionary target, Dictionary source) {
        if (target == null) {
            target = new Hashtable();
        }
        if (source != null && !source.isEmpty()) {
            Enumeration ce = source.keys();
            while (ce.hasMoreElements()) {
                Object key = ce.nextElement();
                ((Dictionary)target).put(key, source.get(key));
            }
        }
        return target;
    }

    ServiceReference getServiceReference() {
        return this.m_serviceRegistration != null ? this.m_serviceRegistration.getReference() : null;
    }

    public ComponentMetadata getComponentMetadata() {
        return this.m_componentMetadata;
    }

    public int getState() {
        return this.m_state;
    }

    protected synchronized void setState(int newState) {
        this.getActivator().log(4, "State transition : " + this.stateToString(this.m_state) + " -> " + this.stateToString(newState), this.m_componentMetadata, null);
        this.m_state = newState;
    }

    protected synchronized boolean setStateConditional(int requiredStates, int newState) {
        if ((this.getState() & requiredStates) != 0) {
            this.setState(newState);
            return true;
        }
        return false;
    }

    public String stateToString(int state) {
        switch (state) {
            case 256: {
                return "Destroyed";
            }
            case 1: {
                return "Disabled";
            }
            case 2: {
                return "Enabled";
            }
            case 4: {
                return "Unsatisfied";
            }
            case 8: {
                return "Activating";
            }
            case 16: {
                return "Active";
            }
            case 32: {
                return "Registered";
            }
            case 64: {
                return "Factory";
            }
            case 128: {
                return "Deactivating";
            }
        }
        return String.valueOf(state);
    }

    static Method getMethod(Class clazz, String name, Class[] parameterTypes, boolean only) throws NoSuchMethodException, InvocationTargetException {
        while (clazz != null) {
            try {
                Method method = clazz.getDeclaredMethod(name, parameterTypes);
                if (Modifier.isPublic(method.getModifiers()) || Modifier.isProtected(method.getModifiers())) {
                    method.setAccessible(true);
                    return method;
                }
                if (only) {
                    break;
                }
            }
            catch (NoSuchMethodException nsme) {
            }
            catch (Throwable throwable) {
                throw new InvocationTargetException(throwable, "Unexpected problem trying to get method " + name);
            }
            clazz = clazz.getSuperclass();
        }
        throw new NoSuchMethodException(name);
    }
}

