/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.felix.framework.InvokeHookCallback;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.ServiceRegistry;
import org.apache.felix.framework.util.ListenerHookInfoImpl;
import org.apache.felix.framework.util.Util;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.hooks.service.EventHook;
import org.osgi.framework.hooks.service.ListenerHook;
import org.osgi.framework.launch.Framework;

public class EventDispatcher {
    static final int LISTENER_BUNDLE_OFFSET = 0;
    static final int LISTENER_CLASS_OFFSET = 1;
    static final int LISTENER_OBJECT_OFFSET = 2;
    static final int LISTENER_FILTER_OFFSET = 3;
    static final int LISTENER_SECURITY_OFFSET = 4;
    static final int LISTENER_ARRAY_INCREMENT = 5;
    private Logger m_logger = null;
    private volatile ServiceRegistry m_serviceRegistry = null;
    private static final Object[] m_emptyList = new Object[0];
    private Object[] m_frameworkListeners = m_emptyList;
    private Object[] m_bundleListeners = m_emptyList;
    private Object[] m_syncBundleListeners = m_emptyList;
    private Object[] m_serviceListeners = m_emptyList;
    private static Thread m_thread = null;
    private static final String m_threadLock = new String("thread lock");
    private static int m_references = 0;
    private static volatile boolean m_stopping = false;
    private static final ArrayList m_requestList = new ArrayList();
    private static final ArrayList m_requestPool = new ArrayList();
    static /* synthetic */ Class array$Ljava$lang$Object;

    private EventDispatcher(Logger logger) {
        this.m_logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EventDispatcher start(Logger logger) {
        EventDispatcher eventDispatcher = new EventDispatcher(logger);
        String string = m_threadLock;
        synchronized (string) {
            if (m_thread == null || !m_thread.isAlive()) {
                m_stopping = false;
                m_thread = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            EventDispatcher.run();
                        }
                        finally {
                            String string = m_threadLock;
                            synchronized (string) {
                                m_thread = null;
                                m_stopping = false;
                                m_references = 0;
                                m_threadLock.notifyAll();
                            }
                        }
                    }
                }, "FelixDispatchQueue");
                m_thread.start();
            }
            ++m_references;
        }
        return eventDispatcher;
    }

    public void setServiceRegistry(ServiceRegistry sr) {
        this.m_serviceRegistry = sr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Object object = m_threadLock;
        synchronized (object) {
            if (m_thread == null || m_stopping) {
                return;
            }
            if (--m_references > 0) {
                return;
            }
            m_stopping = true;
        }
        object = m_requestList;
        synchronized (object) {
            m_requestList.notify();
        }
        object = m_threadLock;
        synchronized (object) {
            while (m_thread != null) {
                try {
                    m_threadLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Filter addListener(Bundle bundle, Class clazz, EventListener l, Filter filter) {
        if (l == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        if (!clazz.isInstance(l)) {
            throw new IllegalArgumentException("Listener not of type " + clazz.getName());
        }
        Filter oldFilter = this.updateListener(bundle, clazz, l, filter);
        if (oldFilter != null) {
            return oldFilter;
        }
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            Object[] listeners = null;
            Object acc = null;
            if (clazz == FrameworkListener.class) {
                listeners = this.m_frameworkListeners;
            } else if (clazz == BundleListener.class) {
                listeners = SynchronousBundleListener.class.isInstance(l) ? this.m_syncBundleListeners : this.m_bundleListeners;
            } else if (clazz == ServiceListener.class) {
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    acc = sm.getSecurityContext();
                }
                listeners = this.m_serviceListeners;
            } else {
                throw new IllegalArgumentException("Unknown listener: " + l.getClass());
            }
            if (listeners == m_emptyList) {
                listeners = new Object[]{bundle, clazz, l, filter, acc};
            } else {
                Object[] newList = new Object[listeners.length + 5];
                System.arraycopy(listeners, 0, newList, 0, listeners.length);
                newList[listeners.length + 0] = bundle;
                newList[listeners.length + 1] = clazz;
                newList[listeners.length + 2] = l;
                newList[listeners.length + 3] = filter;
                newList[listeners.length + 4] = acc;
                listeners = newList;
            }
            if (clazz == FrameworkListener.class) {
                this.m_frameworkListeners = listeners;
            } else if (clazz == BundleListener.class) {
                if (SynchronousBundleListener.class.isInstance(l)) {
                    this.m_syncBundleListeners = listeners;
                } else {
                    this.m_bundleListeners = listeners;
                }
            } else if (clazz == ServiceListener.class) {
                this.m_serviceListeners = listeners;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenerHook.ListenerInfo removeListener(Bundle bundle, Class clazz, EventListener l) {
        ListenerHook.ListenerInfo listenerInfo = null;
        if (l == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        if (!clazz.isInstance(l)) {
            throw new IllegalArgumentException("Listener not of type " + clazz.getName());
        }
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            Object[] listeners = null;
            if (clazz == FrameworkListener.class) {
                listeners = this.m_frameworkListeners;
            } else if (clazz == BundleListener.class) {
                listeners = SynchronousBundleListener.class.isInstance(l) ? this.m_syncBundleListeners : this.m_bundleListeners;
            } else if (clazz == ServiceListener.class) {
                listeners = this.m_serviceListeners;
            } else {
                throw new IllegalArgumentException("Unknown listener: " + l.getClass());
            }
            int idx = -1;
            for (int i = 0; i < listeners.length; i += 5) {
                if (!listeners[i + 0].equals(bundle) || listeners[i + 1] != clazz || listeners[i + 2] != l) continue;
                if (ServiceListener.class == clazz) {
                    listenerInfo = EventDispatcher.wrapListener(listeners, i, true);
                }
                idx = i;
                break;
            }
            if (idx >= 0) {
                if (listeners.length - 5 == 0) {
                    listeners = m_emptyList;
                } else {
                    Object[] newList = new Object[listeners.length - 5];
                    System.arraycopy(listeners, 0, newList, 0, idx);
                    if (idx < newList.length) {
                        System.arraycopy(listeners, idx + 5, newList, idx, newList.length - idx);
                    }
                    listeners = newList;
                }
            }
            if (clazz == FrameworkListener.class) {
                this.m_frameworkListeners = listeners;
            } else if (clazz == BundleListener.class) {
                if (SynchronousBundleListener.class.isInstance(l)) {
                    this.m_syncBundleListeners = listeners;
                } else {
                    this.m_bundleListeners = listeners;
                }
            } else if (clazz == ServiceListener.class) {
                this.m_serviceListeners = listeners;
            }
        }
        return listenerInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListeners(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            EventListener l;
            Class clazz;
            Bundle registeredBundle;
            int i;
            Object[] listeners = this.m_frameworkListeners;
            for (i = listeners.length - 5; i >= 0; i -= 5) {
                registeredBundle = (Bundle)listeners[i + 0];
                if (!bundle.equals(registeredBundle)) continue;
                clazz = (Class)listeners[i + 1];
                l = (EventListener)listeners[i + 2];
                this.removeListener(bundle, clazz, l);
            }
            listeners = this.m_bundleListeners;
            for (i = listeners.length - 5; i >= 0; i -= 5) {
                registeredBundle = (Bundle)listeners[i + 0];
                if (!bundle.equals(registeredBundle)) continue;
                clazz = (Class)listeners[i + 1];
                l = (EventListener)listeners[i + 2];
                this.removeListener(bundle, clazz, l);
            }
            listeners = this.m_syncBundleListeners;
            for (i = listeners.length - 5; i >= 0; i -= 5) {
                registeredBundle = (Bundle)listeners[i + 0];
                if (!bundle.equals(registeredBundle)) continue;
                clazz = (Class)listeners[i + 1];
                l = (EventListener)listeners[i + 2];
                this.removeListener(bundle, clazz, l);
            }
            listeners = this.m_serviceListeners;
            for (i = listeners.length - 5; i >= 0; i -= 5) {
                registeredBundle = (Bundle)listeners[i + 0];
                if (!bundle.equals(registeredBundle)) continue;
                clazz = (Class)listeners[i + 1];
                l = (EventListener)listeners[i + 2];
                this.removeListener(bundle, clazz, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Filter updateListener(Bundle bundle, Class clazz, EventListener l, Filter filter) {
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            Object[] listeners = null;
            if (clazz == FrameworkListener.class) {
                listeners = this.m_frameworkListeners;
            } else if (clazz == BundleListener.class) {
                listeners = SynchronousBundleListener.class.isInstance(l) ? this.m_syncBundleListeners : this.m_bundleListeners;
            } else if (clazz == ServiceListener.class) {
                listeners = this.m_serviceListeners;
            }
            for (int i = 0; i < listeners.length; i += 5) {
                if (!listeners[i + 0].equals(bundle) || listeners[i + 1] != clazz || listeners[i + 2] != l) continue;
                Filter oldFilter = null;
                if (clazz != FrameworkListener.class && clazz != BundleListener.class && clazz == ServiceListener.class) {
                    oldFilter = (Filter)listeners[i + 3];
                    listeners[i + 3] = filter;
                }
                return oldFilter;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection wrapAllServiceListeners(boolean removed) {
        Object[] listeners = null;
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            listeners = this.m_serviceListeners;
        }
        ArrayList<ListenerHook.ListenerInfo> existingListeners = new ArrayList<ListenerHook.ListenerInfo>();
        int i = 0;
        int j = 0;
        while (i < listeners.length) {
            existingListeners.add(EventDispatcher.wrapListener(listeners, i, removed));
            i += 5;
            ++j;
        }
        return existingListeners;
    }

    private static ListenerHook.ListenerInfo wrapListener(Object[] listeners, int offset, boolean removed) {
        Filter filter = (Filter)listeners[offset + 3];
        return new ListenerHookInfoImpl(((Bundle)listeners[offset + 0]).getBundleContext(), (ServiceListener)listeners[offset + 2], filter == null ? null : ((Object)filter).toString(), removed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireFrameworkEvent(FrameworkEvent event) {
        Object[] listeners = null;
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            listeners = this.m_frameworkListeners;
        }
        this.fireEventAsynchronously(this.m_logger, 0, listeners, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireBundleEvent(BundleEvent event) {
        Object[] listeners = null;
        Object[] syncListeners = null;
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            listeners = this.m_bundleListeners;
            syncListeners = this.m_syncBundleListeners;
        }
        EventDispatcher.fireEventImmediately(this.m_logger, 1, syncListeners, event, null);
        if (event.getType() != 128 && event.getType() != 256 && event.getType() != 512) {
            this.fireEventAsynchronously(this.m_logger, 1, listeners, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireServiceEvent(final ServiceEvent event, Dictionary oldProps, Framework felix) {
        List eventHooks;
        Object[] listeners = null;
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            listeners = this.m_serviceListeners;
        }
        if (this.m_serviceRegistry != null && (eventHooks = this.m_serviceRegistry.getEventHooks()) != null && eventHooks.size() > 0) {
            final ListenerBundleContextCollectionWrapper wrapper = new ListenerBundleContextCollectionWrapper(listeners);
            InvokeHookCallback callback = new InvokeHookCallback(){

                public void invokeHook(Object hook) {
                    ((EventHook)hook).event(event, wrapper);
                }
            };
            for (int i = 0; i < eventHooks.size(); ++i) {
                if (felix == null) continue;
                this.m_serviceRegistry.invokeHook((ServiceReference)eventHooks.get(i), felix, callback);
            }
            listeners = wrapper.getListeners();
        }
        EventDispatcher.fireEventImmediately(this.m_logger, 2, listeners, event, oldProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEventAsynchronously(Logger logger, int type, Object[] listeners, EventObject event) {
        if (m_stopping || m_thread == null) {
            return;
        }
        Request req = null;
        ArrayList arrayList = m_requestPool;
        synchronized (arrayList) {
            req = m_requestPool.size() > 0 ? (Request)m_requestPool.remove(0) : new Request();
        }
        req.m_logger = logger;
        req.m_type = type;
        req.m_listeners = listeners;
        req.m_event = event;
        arrayList = m_requestList;
        synchronized (arrayList) {
            m_requestList.add(req);
            m_requestList.notify();
        }
    }

    private static void fireEventImmediately(Logger logger, int type, Object[] listeners, EventObject event, Dictionary oldProps) {
        if (listeners.length > 0) {
            for (int i = listeners.length - 5; i >= 0; i -= 5) {
                Bundle bundle = (Bundle)listeners[i + 0];
                EventListener l = (EventListener)listeners[i + 2];
                Filter filter = (Filter)listeners[i + 3];
                Object acc = listeners[i + 4];
                try {
                    if (type == 0) {
                        EventDispatcher.invokeFrameworkListenerCallback(bundle, l, event);
                        continue;
                    }
                    if (type == 1) {
                        EventDispatcher.invokeBundleListenerCallback(bundle, l, event);
                        continue;
                    }
                    if (type != 2) continue;
                    EventDispatcher.invokeServiceListenerCallback(bundle, l, filter, acc, event, oldProps);
                    continue;
                }
                catch (Throwable th) {
                    logger.log(bundle, 1, "EventDispatcher: Error during dispatch.", th);
                }
            }
        }
    }

    private static void invokeFrameworkListenerCallback(Bundle bundle, final EventListener l, final EventObject event) {
        if (bundle.getState() == 8 || bundle.getState() == 32) {
            if (System.getSecurityManager() != null) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        ((FrameworkListener)l).frameworkEvent((FrameworkEvent)event);
                        return null;
                    }
                });
            } else {
                ((FrameworkListener)l).frameworkEvent((FrameworkEvent)event);
            }
        }
    }

    private static void invokeBundleListenerCallback(Bundle bundle, final EventListener l, final EventObject event) {
        if (SynchronousBundleListener.class.isAssignableFrom(l.getClass()) && (bundle.getState() == 8 || bundle.getState() == 16 || bundle.getState() == 32) || bundle.getState() == 8 || bundle.getState() == 32) {
            if (System.getSecurityManager() != null) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        ((BundleListener)l).bundleChanged((BundleEvent)event);
                        return null;
                    }
                });
            } else {
                ((BundleListener)l).bundleChanged((BundleEvent)event);
            }
        }
    }

    private static void invokeServiceListenerCallback(Bundle bundle, final EventListener l, Filter filter, Object acc, final EventObject event, Dictionary oldProps) {
        if (bundle.getState() != 8 && bundle.getState() != 16 && bundle.getState() != 32) {
            return;
        }
        ServiceReference ref = ((ServiceEvent)event).getServiceReference();
        boolean hasPermission = true;
        SecurityManager sm = System.getSecurityManager();
        if (acc != null && sm != null) {
            try {
                ServicePermission perm = new ServicePermission(ref, "get");
                sm.checkPermission(perm, acc);
            }
            catch (Exception ex) {
                hasPermission = false;
            }
        }
        if (hasPermission) {
            boolean matched;
            boolean bl = matched = filter == null || filter.match(((ServiceEvent)event).getServiceReference());
            if (matched) {
                if (l instanceof AllServiceListener || Util.isServiceAssignable(bundle, ((ServiceEvent)event).getServiceReference())) {
                    if (System.getSecurityManager() != null) {
                        AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                ((ServiceListener)l).serviceChanged((ServiceEvent)event);
                                return null;
                            }
                        });
                    } else {
                        ((ServiceListener)l).serviceChanged((ServiceEvent)event);
                    }
                }
            } else if (((ServiceEvent)event).getType() == 2 && filter.match(oldProps)) {
                final ServiceEvent se = new ServiceEvent(8, ((ServiceEvent)event).getServiceReference());
                if (System.getSecurityManager() != null) {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            ((ServiceListener)l).serviceChanged(se);
                            return null;
                        }
                    });
                } else {
                    ((ServiceListener)l).serviceChanged(se);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void run() {
        Request req = null;
        while (true) {
            ArrayList arrayList = m_requestList;
            synchronized (arrayList) {
                while (m_requestList.size() == 0 && !m_stopping) {
                    try {
                        m_requestList.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (m_requestList.size() == 0 && m_stopping) {
                    return;
                }
                req = (Request)m_requestList.remove(0);
            }
            EventDispatcher.fireEventImmediately(req.m_logger, req.m_type, req.m_listeners, req.m_event, null);
            arrayList = m_requestPool;
            synchronized (arrayList) {
                req.m_logger = null;
                req.m_type = -1;
                req.m_listeners = null;
                req.m_event = null;
                m_requestPool.add(req);
            }
        }
    }

    private static class Request {
        public static final int FRAMEWORK_EVENT = 0;
        public static final int BUNDLE_EVENT = 1;
        public static final int SERVICE_EVENT = 2;
        public Logger m_logger = null;
        public int m_type = -1;
        public Object[] m_listeners = null;
        public EventObject m_event = null;

        private Request() {
        }
    }

    static class ListenerBundleContextCollectionWrapper
    implements Collection {
        private Object[] m_listeners;

        ListenerBundleContextCollectionWrapper(Object[] listeners) {
            this.m_listeners = listeners;
        }

        Object[] getListeners() {
            return this.m_listeners;
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            this.m_listeners = new Object[0];
        }

        public boolean contains(Object o) {
            return this.indexOf(o) >= 0;
        }

        public boolean containsAll(Collection c) {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                if (this.contains(it.next())) continue;
                return false;
            }
            return true;
        }

        private int indexOf(Object o) {
            if (!(o instanceof BundleContext)) {
                return -1;
            }
            for (int i = this.m_listeners.length - 5; i >= 0; i -= 5) {
                Bundle bundle = (Bundle)this.m_listeners[i + 0];
                if (bundle == null || !bundle.getBundleContext().equals(o)) continue;
                return i;
            }
            return -1;
        }

        public boolean isEmpty() {
            return this.m_listeners.length == 0;
        }

        public Iterator iterator() {
            return new WrapperIterator();
        }

        public boolean remove(Object o) {
            return this.removeIndex(this.indexOf(o));
        }

        private boolean removeIndex(int idx) {
            if (idx < 0) {
                return false;
            }
            Object[] newListeners = new Object[this.m_listeners.length - 5];
            System.arraycopy(this.m_listeners, 0, newListeners, 0, idx);
            System.arraycopy(this.m_listeners, idx + 5, newListeners, idx, newListeners.length - idx);
            this.m_listeners = newListeners;
            return true;
        }

        public boolean removeAll(Collection c) {
            boolean rv = false;
            Iterator it = c.iterator();
            while (it.hasNext()) {
                if (!this.remove(it.next())) continue;
                rv = true;
            }
            return rv;
        }

        public boolean retainAll(Collection c) {
            boolean rv = false;
            Iterator it = this.iterator();
            while (it.hasNext()) {
                if (c.contains(it.next())) continue;
                it.remove();
                rv = true;
            }
            return rv;
        }

        public int size() {
            return this.m_listeners.length / 5;
        }

        public Object[] toArray() {
            Object[] array = new Object[this.size()];
            int idx = 0;
            Iterator it = this.iterator();
            while (it.hasNext()) {
                array[idx++] = it.next();
            }
            return array;
        }

        public Object[] toArray(Object[] a) {
            if (!a.getClass().equals(array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = EventDispatcher.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object)) {
                throw new ArrayStoreException();
            }
            return this.toArray();
        }

        private class WrapperIterator
        implements Iterator {
            int curIdx = 0;
            int lastIdx = -1;

            private WrapperIterator() {
            }

            public boolean hasNext() {
                return this.curIdx < ListenerBundleContextCollectionWrapper.this.m_listeners.length;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Bundle b = (Bundle)ListenerBundleContextCollectionWrapper.this.m_listeners[this.curIdx + 0];
                this.lastIdx = this.curIdx;
                this.curIdx += 5;
                return b.getBundleContext();
            }

            public void remove() {
                if (this.lastIdx < 0) {
                    throw new IllegalStateException();
                }
                ListenerBundleContextCollectionWrapper.this.removeIndex(this.lastIdx);
                this.curIdx = this.lastIdx;
                this.lastIdx = -1;
            }
        }
    }
}

