/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.apache.felix.framework.ExtensionManager;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.URLHandlers;
import org.apache.felix.framework.util.SecureAction;
import org.osgi.service.url.URLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerSetter;

public class URLHandlersStreamHandlerProxy
extends URLStreamHandler
implements URLStreamHandlerSetter,
InvocationHandler {
    private static final Class[] URL_PROXY_CLASS;
    private static final Class[] STRING_TYPES;
    private static final Method EQUALS;
    private static final Method GET_DEFAULT_PORT;
    private static final Method GET_HOST_ADDRESS;
    private static final Method HASH_CODE;
    private static final Method HOSTS_EQUAL;
    private static final Method OPEN_CONNECTION;
    private static final Method OPEN_CONNECTION_PROXY;
    private static final Method SAME_FILE;
    private static final Method TO_EXTERNAL_FORM;
    private final Object m_service;
    private final SecureAction m_action;
    private final URLStreamHandler m_builtIn;
    private final URL m_builtInURL;
    private final String m_protocol;
    private static final ThreadLocal m_loopCheck;

    public URLHandlersStreamHandlerProxy(String protocol, SecureAction action, URLStreamHandler builtIn, URL builtInURL) {
        this.m_protocol = protocol;
        this.m_service = null;
        this.m_action = action;
        this.m_builtIn = builtIn;
        this.m_builtInURL = builtInURL;
    }

    private URLHandlersStreamHandlerProxy(Object service, SecureAction action) {
        this.m_protocol = null;
        this.m_service = service;
        this.m_action = action;
        this.m_builtIn = null;
        this.m_builtInURL = null;
    }

    protected boolean equals(URL url1, URL url2) {
        Object svc = this.getStreamHandlerService();
        if (svc == null) {
            throw new IllegalStateException("Unknown protocol: " + url1.getProtocol());
        }
        if (svc instanceof URLStreamHandlerService) {
            return ((URLStreamHandlerService)svc).equals(url1, url2);
        }
        try {
            return (Boolean)EQUALS.invoke(svc, url1, url2);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Stream handler unavailable due to: " + ex.getMessage());
        }
    }

    protected int getDefaultPort() {
        Object svc = this.getStreamHandlerService();
        if (svc == null) {
            throw new IllegalStateException("Stream handler unavailable.");
        }
        if (svc instanceof URLStreamHandlerService) {
            return ((URLStreamHandlerService)svc).getDefaultPort();
        }
        try {
            return (Integer)GET_DEFAULT_PORT.invoke(svc, null);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Stream handler unavailable due to: " + ex.getMessage());
        }
    }

    protected InetAddress getHostAddress(URL url) {
        Object svc = this.getStreamHandlerService();
        if (svc == null) {
            throw new IllegalStateException("Unknown protocol: " + url.getProtocol());
        }
        if (svc instanceof URLStreamHandlerService) {
            return ((URLStreamHandlerService)svc).getHostAddress(url);
        }
        try {
            return (InetAddress)GET_HOST_ADDRESS.invoke(svc, url);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Stream handler unavailable due to: " + ex.getMessage());
        }
    }

    protected int hashCode(URL url) {
        Object svc = this.getStreamHandlerService();
        if (svc == null) {
            throw new IllegalStateException("Unknown protocol: " + url.getProtocol());
        }
        if (svc instanceof URLStreamHandlerService) {
            return ((URLStreamHandlerService)svc).hashCode(url);
        }
        try {
            return (Integer)HASH_CODE.invoke(svc, url);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Stream handler unavailable due to: " + ex.getMessage());
        }
    }

    protected boolean hostsEqual(URL url1, URL url2) {
        Object svc = this.getStreamHandlerService();
        if (svc == null) {
            throw new IllegalStateException("Unknown protocol: " + url1.getProtocol());
        }
        if (svc instanceof URLStreamHandlerService) {
            return ((URLStreamHandlerService)svc).hostsEqual(url1, url2);
        }
        try {
            return (Boolean)HOSTS_EQUAL.invoke(svc, url1, url2);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Stream handler unavailable due to: " + ex.getMessage());
        }
    }

    protected URLConnection openConnection(URL url) throws IOException {
        Object svc = this.getStreamHandlerService();
        if (svc == null) {
            throw new MalformedURLException("Unknown protocol: " + url.toString());
        }
        if (svc instanceof URLStreamHandlerService) {
            return ((URLStreamHandlerService)svc).openConnection(url);
        }
        try {
            if ("http".equals(url.getProtocol()) && "felix.extensions".equals(url.getHost()) && 9 == url.getPort()) {
                try {
                    Object handler = this.m_action.getDeclaredField(ExtensionManager.class, "m_extensionManager", null);
                    if (handler != null) {
                        return (URLConnection)this.m_action.invoke(this.m_action.getMethod(handler.getClass(), "openConnection", new Class[]{URL.class}), handler, new Object[]{url});
                    }
                    throw new IOException("Extensions not supported or ambiguous context.");
                }
                catch (IOException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new IOException(ex.getMessage());
                }
            }
            return (URLConnection)OPEN_CONNECTION.invoke(svc, url);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Stream handler unavailable due to: " + ex.getMessage());
        }
    }

    protected URLConnection openConnection(URL url, java.net.Proxy proxy) throws IOException {
        Object svc = this.getStreamHandlerService();
        if (svc == null) {
            throw new MalformedURLException("Unknown protocol: " + url.toString());
        }
        if (svc instanceof URLStreamHandlerService) {
            Method method;
            try {
                method = svc.getClass().getMethod("openConnection", URL_PROXY_CLASS);
            }
            catch (NoSuchMethodException e) {
                throw new UnsupportedOperationException(e);
            }
            try {
                this.m_action.setAccesssible(method);
                return (URLConnection)method.invoke(svc, url, proxy);
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new IOException(e.getMessage());
            }
        }
        try {
            return (URLConnection)OPEN_CONNECTION_PROXY.invoke(svc, url, proxy);
        }
        catch (Exception ex) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new IllegalStateException("Stream handler unavailable due to: " + ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseURL(URL url, String spec, int start, int limit) {
        Object svc = this.getStreamHandlerService();
        if (svc == null) {
            throw new IllegalStateException("Unknown protocol: " + url.getProtocol());
        }
        if (svc instanceof URLStreamHandlerService) {
            ((URLStreamHandlerService)svc).parseURL(this, url, spec, start, limit);
        } else {
            try {
                URL test = null;
                if (this.m_builtInURL != null) {
                    if (m_loopCheck.get() != null) {
                        test = new URL(new URL(this.m_builtInURL, url.toExternalForm()), spec, (URLStreamHandler)svc);
                    } else {
                        m_loopCheck.set(Thread.currentThread());
                        try {
                            test = new URL(new URL(this.m_builtInURL, url.toExternalForm()), spec);
                        }
                        finally {
                            m_loopCheck.set(null);
                        }
                    }
                } else {
                    test = this.m_action.createURL(url, spec, (URLStreamHandler)svc);
                }
                super.setURL(url, test.getProtocol(), test.getHost(), test.getPort(), test.getAuthority(), test.getUserInfo(), test.getPath(), test.getQuery(), test.getRef());
            }
            catch (Exception ex) {
                throw new IllegalStateException("Stream handler unavailable due to: " + ex.getMessage());
            }
        }
    }

    protected boolean sameFile(URL url1, URL url2) {
        Object svc = this.getStreamHandlerService();
        if (svc == null) {
            throw new IllegalStateException("Unknown protocol: " + url1.getProtocol());
        }
        if (svc instanceof URLStreamHandlerService) {
            return ((URLStreamHandlerService)svc).sameFile(url1, url2);
        }
        try {
            return (Boolean)SAME_FILE.invoke(svc, url1, url2);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Stream handler unavailable due to: " + ex.getMessage());
        }
    }

    public void setURL(URL url, String protocol, String host, int port, String authority, String userInfo, String path, String query, String ref) {
        super.setURL(url, protocol, host, port, authority, userInfo, path, query, ref);
    }

    public void setURL(URL url, String protocol, String host, int port, String file, String ref) {
        super.setURL(url, protocol, host, port, null, null, file, null, ref);
    }

    protected String toExternalForm(URL url) {
        return this.toExternalForm(url, this.getStreamHandlerService());
    }

    private String toExternalForm(URL url, Object svc) {
        if (svc == null) {
            throw new IllegalStateException("Unknown protocol: " + url.getProtocol());
        }
        if (svc instanceof URLStreamHandlerService) {
            return ((URLStreamHandlerService)svc).toExternalForm(url);
        }
        try {
            try {
                String result = (String)TO_EXTERNAL_FORM.invoke(svc, url);
                if (result != null && result.equals(url.getProtocol() + "://null")) {
                    result = url.getProtocol() + ":";
                }
                return result;
            }
            catch (InvocationTargetException ex) {
                Throwable t = ex.getTargetException();
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new IllegalStateException("Unknown throwable: " + t);
            }
        }
        catch (NullPointerException ex) {
            StringBuffer answer = new StringBuffer();
            answer.append(url.getProtocol());
            answer.append(':');
            String authority = url.getAuthority();
            if (authority != null && authority.length() > 0) {
                answer.append("//");
                answer.append(url.getAuthority());
            }
            String file = url.getFile();
            String ref = url.getRef();
            if (file != null) {
                answer.append(file);
            }
            if (ref != null) {
                answer.append('#');
                answer.append(ref);
            }
            return answer.toString();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Stream handler unavailable due to: " + ex.getMessage());
        }
    }

    private Object getStreamHandlerService() {
        try {
            Object framework = URLHandlers.getFrameworkFromContext();
            if (framework == null) {
                return this.m_builtIn;
            }
            Object service = null;
            service = framework instanceof Felix ? ((Felix)framework).getStreamHandlerService(this.m_protocol) : this.m_action.invoke(this.m_action.getMethod(framework.getClass(), "getStreamHandlerService", STRING_TYPES), framework, new Object[]{this.m_protocol});
            if (service == null) {
                return this.m_builtIn;
            }
            if (service instanceof URLStreamHandlerService) {
                return (URLStreamHandlerService)service;
            }
            return (URLStreamHandlerService)Proxy.newProxyInstance(URLStreamHandlerService.class.getClassLoader(), new Class[]{URLStreamHandlerService.class}, (InvocationHandler)new URLHandlersStreamHandlerProxy(service, this.m_action));
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            return this.m_builtIn;
        }
    }

    public Object invoke(Object obj, Method method, Object[] params) throws Throwable {
        Class[] types = method.getParameterTypes();
        if ("parseURL".equals(method.getName())) {
            types[0] = this.m_service.getClass().getClassLoader().loadClass(URLStreamHandlerSetter.class.getName());
            params[0] = Proxy.newProxyInstance(this.m_service.getClass().getClassLoader(), new Class[]{types[0]}, (InvocationHandler)((URLHandlersStreamHandlerProxy)params[0]));
        }
        return this.m_action.invokeDirect(this.m_action.getMethod(this.m_service.getClass(), method.getName(), types), this.m_service, params);
    }

    static {
        STRING_TYPES = new Class[]{String.class};
        SecureAction action = new SecureAction();
        try {
            EQUALS = URLStreamHandler.class.getDeclaredMethod("equals", URL.class, URL.class);
            action.setAccesssible(EQUALS);
            GET_DEFAULT_PORT = URLStreamHandler.class.getDeclaredMethod("getDefaultPort", null);
            action.setAccesssible(GET_DEFAULT_PORT);
            GET_HOST_ADDRESS = URLStreamHandler.class.getDeclaredMethod("getHostAddress", URL.class);
            action.setAccesssible(GET_HOST_ADDRESS);
            HASH_CODE = URLStreamHandler.class.getDeclaredMethod("hashCode", URL.class);
            action.setAccesssible(HASH_CODE);
            HOSTS_EQUAL = URLStreamHandler.class.getDeclaredMethod("hostsEqual", URL.class, URL.class);
            action.setAccesssible(HOSTS_EQUAL);
            OPEN_CONNECTION = URLStreamHandler.class.getDeclaredMethod("openConnection", URL.class);
            action.setAccesssible(OPEN_CONNECTION);
            SAME_FILE = URLStreamHandler.class.getDeclaredMethod("sameFile", URL.class, URL.class);
            action.setAccesssible(SAME_FILE);
            TO_EXTERNAL_FORM = URLStreamHandler.class.getDeclaredMethod("toExternalForm", URL.class);
            action.setAccesssible(TO_EXTERNAL_FORM);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        Method open_connection_proxy = null;
        Class[] url_proxy_class = null;
        try {
            url_proxy_class = new Class[]{URL.class, java.net.Proxy.class};
            open_connection_proxy = URLStreamHandler.class.getDeclaredMethod("openConnection", url_proxy_class);
            action.setAccesssible(open_connection_proxy);
        }
        catch (Throwable ex) {
            open_connection_proxy = null;
            url_proxy_class = null;
        }
        OPEN_CONNECTION_PROXY = open_connection_proxy;
        URL_PROXY_CLASS = url_proxy_class;
        m_loopCheck = new ThreadLocal();
    }
}

