/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.felix.framework.InvokeHookCallback;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.ServiceRegistrationImpl;
import org.apache.felix.framework.util.ConcurrentMap;
import org.apache.felix.framework.util.CopyOnWriteMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.service.EventHook;
import org.osgi.framework.hooks.service.FindHook;
import org.osgi.framework.hooks.service.ListenerHook;
import org.osgi.framework.launch.Framework;

public class ServiceRegistry {
    private final Logger m_logger;
    private AtomicCounter m_currentServiceId = new AtomicCounter(1L);
    private final ServiceRegistrationMap m_serviceRegsMap = new ServiceRegistrationMap();
    private final Map m_lockedRegsMap = new HashMap();
    private final Map m_inUseMap = new HashMap();
    private final ServiceRegistryCallbacks m_callbacks;
    private final Set m_eventHooks = Collections.synchronizedSet(new TreeSet(Collections.reverseOrder()));
    private final Set m_findHooks = Collections.synchronizedSet(new TreeSet(Collections.reverseOrder()));
    private final Set m_listenerHooks = Collections.synchronizedSet(new TreeSet(Collections.reverseOrder()));

    public ServiceRegistry(Logger logger, ServiceRegistryCallbacks callbacks) {
        this.m_logger = logger;
        this.m_callbacks = callbacks;
    }

    public ServiceReference[] getRegisteredServices(Bundle bundle) {
        ServiceRegistration[] regs = this.m_serviceRegsMap.get(bundle);
        if (regs != null) {
            ServiceReference[] refs = new ServiceReference[regs.length];
            for (int i = 0; i < refs.length; ++i) {
                refs[i] = regs[i].getReference();
            }
            return refs;
        }
        return null;
    }

    public ServiceRegistration registerService(Bundle bundle, String[] classNames, Object svcObj, Dictionary dict) {
        ServiceRegistrationImpl reg = null;
        reg = new ServiceRegistrationImpl(this, bundle, classNames, this.m_currentServiceId.nextId(), svcObj, dict);
        this.addHooks(classNames, svcObj, reg.getReference());
        this.m_serviceRegsMap.add(bundle, reg);
        if (this.m_callbacks != null) {
            this.m_callbacks.serviceChanged(new ServiceEvent(1, reg.getReference()), null);
        }
        return reg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterService(Bundle bundle, ServiceRegistration reg) {
        this.removeHook(reg.getReference());
        this.m_serviceRegsMap.remove(bundle, reg);
        if (this.m_callbacks != null) {
            this.m_callbacks.serviceChanged(new ServiceEvent(4, reg.getReference()), null);
        }
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            Bundle[] clients = this.getUsingBundles(reg.getReference());
            for (int i = 0; clients != null && i < clients.length; ++i) {
                while (this.ungetService(clients[i], reg.getReference())) {
                }
            }
            ((ServiceRegistrationImpl)reg).invalidate();
        }
    }

    public void unregisterServices(Bundle bundle) {
        ServiceRegistration[] regs = this.m_serviceRegsMap.get(bundle);
        for (int i = 0; regs != null && i < regs.length; ++i) {
            if (!((ServiceRegistrationImpl)regs[i]).isValid()) continue;
            regs[i].unregister();
        }
        this.m_serviceRegsMap.remove(bundle);
    }

    public List getServiceReferences(String className, Filter filter) {
        ArrayList<ServiceReference> list = new ArrayList<ServiceReference>();
        for (Map.Entry entry : this.m_serviceRegsMap.entrySet()) {
            ServiceRegistration[] regs = (ServiceRegistration[])entry.getValue();
            for (int regIdx = 0; regs != null && regIdx < regs.length; ++regIdx) {
                boolean matched = false;
                if (className == null && (filter == null || filter.match(regs[regIdx].getReference()))) {
                    matched = true;
                } else if (className != null) {
                    String[] objectClass = (String[])((ServiceRegistrationImpl)regs[regIdx]).getProperty("objectClass");
                    for (int classIdx = 0; classIdx < objectClass.length; ++classIdx) {
                        if (!objectClass[classIdx].equals(className) || filter != null && !filter.match(regs[regIdx].getReference())) continue;
                        matched = true;
                        break;
                    }
                }
                if (!matched) continue;
                list.add(regs[regIdx].getReference());
            }
        }
        return list;
    }

    public synchronized ServiceReference[] getServicesInUse(Bundle bundle) {
        UsageCount[] usages = (UsageCount[])this.m_inUseMap.get(bundle);
        if (usages != null) {
            ServiceReference[] refs = new ServiceReference[usages.length];
            for (int i = 0; i < refs.length; ++i) {
                refs[i] = usages[i].m_ref;
            }
            return refs;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(Bundle bundle, ServiceReference ref) {
        UsageCount usage = null;
        Object svcObj = null;
        ServiceRegistrationImpl reg = ((ServiceRegistrationImpl.ServiceReferenceImpl)ref).getRegistration();
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            Object o = this.m_lockedRegsMap.get(reg);
            while (o != null) {
                if (o.equals(Thread.currentThread())) {
                    throw new IllegalStateException("ServiceFactory.getService() resulted in a cycle.");
                }
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                o = this.m_lockedRegsMap.get(reg);
            }
            this.m_lockedRegsMap.put(reg, Thread.currentThread());
            if (reg.isValid()) {
                usage = this.getUsageCount(bundle, ref);
                if (usage == null) {
                    usage = this.addUsageCount(bundle, ref);
                }
                ++usage.m_count;
                svcObj = usage.m_svcObj;
            }
        }
        try {
            if (usage != null && svcObj == null) {
                svcObj = reg.getService(bundle);
            }
        }
        finally {
            serviceRegistry = this;
            synchronized (serviceRegistry) {
                if (!reg.isValid() || svcObj == null) {
                    this.flushUsageCount(bundle, ref);
                } else {
                    usage.m_svcObj = svcObj;
                }
                this.m_lockedRegsMap.remove(reg);
                this.notifyAll();
            }
        }
        return svcObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ungetService(Bundle bundle, ServiceReference ref) {
        UsageCount usage = null;
        ServiceRegistrationImpl reg = ((ServiceRegistrationImpl.ServiceReferenceImpl)ref).getRegistration();
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            Object o = this.m_lockedRegsMap.get(reg);
            while (o != null) {
                if (o.equals(Thread.currentThread())) {
                    throw new IllegalStateException("ServiceFactory.ungetService() resulted in a cycle.");
                }
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                o = this.m_lockedRegsMap.get(reg);
            }
            usage = this.getUsageCount(bundle, ref);
            if (usage == null) {
                return false;
            }
            this.m_lockedRegsMap.put(reg, Thread.currentThread());
        }
        try {
            if (usage.m_count == 1) {
                ((ServiceRegistrationImpl.ServiceReferenceImpl)ref).getRegistration().ungetService(bundle, usage.m_svcObj);
            }
        }
        finally {
            serviceRegistry = this;
            synchronized (serviceRegistry) {
                --usage.m_count;
                if (!reg.isValid() || usage.m_count <= 0) {
                    usage.m_svcObj = null;
                    this.flushUsageCount(bundle, ref);
                }
                this.m_lockedRegsMap.remove(reg);
                this.notifyAll();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ungetServices(Bundle bundle) {
        UsageCount[] usages;
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            usages = (UsageCount[])this.m_inUseMap.get(bundle);
        }
        if (usages == null) {
            return;
        }
        for (int i = 0; i < usages.length; ++i) {
            while (this.ungetService(bundle, usages[i].m_ref)) {
            }
        }
    }

    public synchronized Bundle[] getUsingBundles(ServiceReference ref) {
        Bundle[] bundles = null;
        for (Map.Entry entry : this.m_inUseMap.entrySet()) {
            Bundle bundle = (Bundle)entry.getKey();
            UsageCount[] usages = (UsageCount[])entry.getValue();
            for (int useIdx = 0; useIdx < usages.length; ++useIdx) {
                if (!usages[useIdx].m_ref.equals(ref)) continue;
                if (bundles == null) {
                    bundles = new Bundle[]{bundle};
                    continue;
                }
                Bundle[] nbs = new Bundle[bundles.length + 1];
                System.arraycopy(bundles, 0, nbs, 0, bundles.length);
                nbs[bundles.length] = bundle;
                bundles = nbs;
            }
        }
        return bundles;
    }

    void servicePropertiesModified(ServiceRegistration reg, Dictionary oldProps) {
        if (this.m_callbacks != null) {
            this.m_callbacks.serviceChanged(new ServiceEvent(2, reg.getReference()), oldProps);
        }
    }

    public Logger getLogger() {
        return this.m_logger;
    }

    private static ServiceRegistration[] addServiceRegistration(ServiceRegistration[] regs, ServiceRegistration reg) {
        if (regs == null) {
            regs = new ServiceRegistration[]{reg};
        } else {
            ServiceRegistration[] newRegs = new ServiceRegistration[regs.length + 1];
            System.arraycopy(regs, 0, newRegs, 0, regs.length);
            newRegs[regs.length] = reg;
            regs = newRegs;
        }
        return regs;
    }

    private static ServiceRegistration[] removeServiceRegistration(ServiceRegistration[] regs, ServiceRegistration reg) {
        for (int i = 0; regs != null && i < regs.length; ++i) {
            if (!regs[i].equals(reg)) continue;
            if (regs.length - 1 == 0) {
                regs = new ServiceRegistration[]{};
                continue;
            }
            ServiceRegistration[] newRegs = new ServiceRegistration[regs.length - 1];
            System.arraycopy(regs, 0, newRegs, 0, i);
            if (i < newRegs.length) {
                System.arraycopy(regs, i + 1, newRegs, i, newRegs.length - i);
            }
            regs = newRegs;
        }
        return regs;
    }

    private UsageCount getUsageCount(Bundle bundle, ServiceReference ref) {
        UsageCount[] usages = (UsageCount[])this.m_inUseMap.get(bundle);
        for (int i = 0; usages != null && i < usages.length; ++i) {
            if (!usages[i].m_ref.equals(ref)) continue;
            return usages[i];
        }
        return null;
    }

    private UsageCount addUsageCount(Bundle bundle, ServiceReference ref) {
        UsageCount[] usages = (UsageCount[])this.m_inUseMap.get(bundle);
        UsageCount usage = new UsageCount();
        usage.m_ref = ref;
        if (usages == null) {
            usages = new UsageCount[]{usage};
        } else {
            UsageCount[] newUsages = new UsageCount[usages.length + 1];
            System.arraycopy(usages, 0, newUsages, 0, usages.length);
            newUsages[usages.length] = usage;
            usages = newUsages;
        }
        this.m_inUseMap.put(bundle, usages);
        return usage;
    }

    private void flushUsageCount(Bundle bundle, ServiceReference ref) {
        UsageCount[] usages = (UsageCount[])this.m_inUseMap.get(bundle);
        for (int i = 0; usages != null && i < usages.length; ++i) {
            if (!usages[i].m_ref.equals(ref)) continue;
            if (usages.length - 1 == 0) {
                usages = null;
                continue;
            }
            UsageCount[] newUsages = new UsageCount[usages.length - 1];
            System.arraycopy(usages, 0, newUsages, 0, i);
            if (i < newUsages.length) {
                System.arraycopy(usages, i + 1, newUsages, i, newUsages.length - i);
            }
            usages = newUsages;
        }
        if (usages != null) {
            this.m_inUseMap.put(bundle, usages);
        } else {
            this.m_inUseMap.remove(bundle);
        }
    }

    private void addHooks(String[] classNames, Object svcObj, ServiceReference ref) {
        if (ServiceRegistry.isHook(classNames, EventHook.class, svcObj)) {
            this.m_eventHooks.add(ref);
        }
        if (ServiceRegistry.isHook(classNames, FindHook.class, svcObj)) {
            this.m_findHooks.add(ref);
        }
        if (ServiceRegistry.isHook(classNames, ListenerHook.class, svcObj)) {
            this.m_listenerHooks.add(ref);
        }
    }

    static boolean isHook(String[] classNames, Class hookClass, Object svcObj) {
        if (svcObj instanceof ServiceFactory) {
            return Arrays.asList(classNames).contains(hookClass.getName());
        }
        if (hookClass.isAssignableFrom(svcObj.getClass())) {
            String hookName = hookClass.getName();
            for (int i = 0; i < classNames.length; ++i) {
                if (!classNames[i].equals(hookName)) continue;
                return true;
            }
        }
        return false;
    }

    private void removeHook(ServiceReference ref) {
        Object svcObj = ((ServiceRegistrationImpl.ServiceReferenceImpl)ref).getRegistration().getService();
        String[] classNames = (String[])ref.getProperty("objectClass");
        if (ServiceRegistry.isHook(classNames, EventHook.class, svcObj)) {
            this.m_eventHooks.remove(ref);
        }
        if (ServiceRegistry.isHook(classNames, FindHook.class, svcObj)) {
            this.m_findHooks.remove(ref);
        }
        if (ServiceRegistry.isHook(classNames, ListenerHook.class, svcObj)) {
            this.m_listenerHooks.remove(ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getEventHooks() {
        Set set = this.m_eventHooks;
        synchronized (set) {
            return new ArrayList(this.m_eventHooks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getFindHooks() {
        Set set = this.m_findHooks;
        synchronized (set) {
            return new ArrayList(this.m_findHooks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getListenerHooks() {
        Set set = this.m_listenerHooks;
        synchronized (set) {
            return new ArrayList(this.m_listenerHooks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeHook(ServiceReference ref, Framework framework, InvokeHookCallback callback) {
        Object hook = this.getService(framework, ref);
        try {
            callback.invokeHook(hook);
        }
        catch (Throwable th) {
            this.m_logger.log(ref, 2, "Problem invoking Service Registry Hook", th);
        }
        finally {
            this.ungetService(framework, ref);
        }
    }

    private static class AtomicCounter {
        private long m_next;

        AtomicCounter(long start) {
            this.m_next = start;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Long nextId() {
            AtomicCounter atomicCounter = this;
            synchronized (atomicCounter) {
                return new Long(this.m_next++);
            }
        }
    }

    static class ServiceRegistrationMap {
        private final ConcurrentMap m_map = CopyOnWriteMap.newHashMap();

        ServiceRegistrationMap() {
        }

        ServiceRegistration[] get(Bundle bundle) {
            return (ServiceRegistration[])this.m_map.get(bundle);
        }

        public Set entrySet() {
            return this.m_map.entrySet();
        }

        void remove(Bundle bundle) {
            this.m_map.remove(bundle);
        }

        void remove(Bundle bundle, ServiceRegistration reg) {
            ServiceRegistration[] newRegs;
            ServiceRegistration[] regs;
            while (!this.putOrReplace(bundle, regs = (ServiceRegistration[])this.m_map.get(bundle), newRegs = ServiceRegistry.removeServiceRegistration(regs, reg))) {
            }
        }

        void add(Bundle bundle, ServiceRegistration reg) {
            ServiceRegistration[] newRegs;
            ServiceRegistration[] regs;
            while (!this.putOrReplace(bundle, regs = (ServiceRegistration[])this.m_map.get(bundle), newRegs = ServiceRegistry.addServiceRegistration(regs, reg))) {
            }
        }

        boolean putOrReplace(Bundle bundle, ServiceRegistration[] oldReg, ServiceRegistration[] newReg) {
            if (!this.m_map.containsKey(bundle)) {
                return this.m_map.putIfAbsent(bundle, newReg) == null;
            }
            return this.m_map.replace(bundle, oldReg, newReg);
        }
    }

    public static interface ServiceRegistryCallbacks {
        public void serviceChanged(ServiceEvent var1, Dictionary var2);
    }

    private static class UsageCount {
        public int m_count = 0;
        public ServiceReference m_ref = null;
        public Object m_svcObj = null;

        private UsageCount() {
        }
    }
}

