/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.AccessControlException;
import java.security.AllPermission;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import org.apache.felix.framework.BundleImpl;
import org.apache.felix.framework.BundleProtectionDomain;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.ModuleImpl;
import org.apache.felix.framework.URLHandlersBundleURLConnection;
import org.apache.felix.framework.util.StringMap;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.util.manifestparser.Capability;
import org.apache.felix.framework.util.manifestparser.ManifestParser;
import org.apache.felix.framework.util.manifestparser.R4Attribute;
import org.apache.felix.framework.util.manifestparser.R4Directive;
import org.apache.felix.moduleloader.ICapability;
import org.apache.felix.moduleloader.IContent;
import org.apache.felix.moduleloader.IModule;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

class ExtensionManager
extends URLStreamHandler
implements IContent {
    static final ExtensionManager m_extensionManager;
    private final Logger m_logger;
    private final Map m_headerMap = new StringMap(false);
    private final IModule m_systemBundleModule;
    private ICapability[] m_capabilities = null;
    private Set m_exportNames = null;
    private Object m_securityContext = null;
    private final List<Bundle> m_extensions;
    private volatile Bundle[] m_extensionsCache;
    private final Set m_names;
    private final Map m_sourceToExtensions;
    public static final String DEFAULT_PROPERTIES_FILE_VALUE = "default.properties";

    private ExtensionManager() {
        this.m_logger = null;
        this.m_systemBundleModule = null;
        this.m_extensions = new ArrayList<Bundle>();
        this.m_extensionsCache = new Bundle[0];
        this.m_names = new HashSet();
        this.m_sourceToExtensions = new HashMap();
    }

    ExtensionManager(Logger logger, Felix felix) {
        this.m_systemBundleModule = new ExtensionManagerModule(felix);
        this.m_extensions = null;
        this.m_names = null;
        this.m_sourceToExtensions = null;
        this.m_logger = logger;
        this.m_headerMap.put("Bundle-Version", felix.getConfig().get("felix.version"));
        this.m_headerMap.put("Bundle-SymbolicName", "org.apache.felix.framework");
        this.m_headerMap.put("Bundle-Name", "System Bundle");
        this.m_headerMap.put("Bundle-Description", "This bundle is system specific; it implements various system services.");
        this.m_headerMap.put("Export-Service", "org.osgi.service.packageadmin.PackageAdmin,org.osgi.service.startlevel.StartLevel,org.osgi.service.url.URLHandlers");
        String syspkgs = (String)felix.getConfig().get("org.osgi.framework.system.packages");
        syspkgs = syspkgs == null ? ExtensionManager.loadDefaultSystemPackages(this.m_logger) : syspkgs;
        String extra = (String)felix.getConfig().get("org.osgi.framework.system.packages.extra");
        syspkgs = extra == null ? syspkgs : syspkgs + "," + extra;
        this.m_headerMap.put("Bundle-ManifestVersion", "2");
        this.m_headerMap.put("Export-Package", syspkgs);
        try {
            ManifestParser mp = new ManifestParser(this.m_logger, felix.getConfig(), this.m_systemBundleModule, this.m_headerMap);
            ICapability[] caps = ExtensionManager.aliasSymbolicName(mp.getCapabilities());
            this.setCapabilities(caps);
        }
        catch (Exception ex) {
            this.m_capabilities = new ICapability[0];
            this.m_logger.log(1, "Error parsing system bundle export statement: " + syspkgs, ex);
        }
    }

    private static ICapability[] aliasSymbolicName(ICapability[] caps) {
        if (caps == null) {
            return new ICapability[0];
        }
        ICapability[] aliasCaps = new ICapability[caps.length];
        System.arraycopy(caps, 0, aliasCaps, 0, caps.length);
        block0: for (int capIdx = 0; capIdx < aliasCaps.length; ++capIdx) {
            R4Attribute[] attrs = ((Capability)aliasCaps[capIdx]).getAttributes();
            for (int i = 0; i < attrs.length; ++i) {
                if (!attrs[i].getName().equalsIgnoreCase("bundle-symbolic-name")) continue;
                R4Attribute[] aliasAttrs = new R4Attribute[attrs.length];
                System.arraycopy(attrs, 0, aliasAttrs, 0, attrs.length);
                aliasAttrs[i] = new R4Attribute("bundle-symbolic-name", new String[]{(String)attrs[i].getValue(), "system.bundle"}, false);
                aliasCaps[capIdx] = new Capability(caps[capIdx].getModule(), caps[capIdx].getNamespace(), ((Capability)caps[capIdx]).getDirectives(), aliasAttrs);
                continue block0;
            }
        }
        return aliasCaps;
    }

    public IModule getModule() {
        return this.m_systemBundleModule;
    }

    public synchronized Object getSecurityContext() {
        return this.m_securityContext;
    }

    public synchronized void setSecurityContext(Object securityContext) {
        this.m_securityContext = securityContext;
    }

    synchronized void addExtensionBundle(Felix felix, BundleImpl bundle) throws SecurityException, BundleException, Exception {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new AdminPermission(bundle, "extensionLifecycle"));
            }
            catch (SecurityException ex) {
                throw new AccessControlException(ex.getMessage());
            }
        }
        if (!((BundleProtectionDomain)bundle.getProtectionDomain()).impliesDirect(new AllPermission())) {
            throw new SecurityException("Extension Bundles must have AllPermission");
        }
        R4Directive dir = ManifestParser.parseExtensionBundleHeader((String)bundle.getCurrentModule().getHeaders().get("Fragment-Host"));
        if (!"framework".equals(dir.getValue())) {
            throw new BundleException("Unsupported Extension Bundle type: " + dir.getValue(), new UnsupportedOperationException("Unsupported Extension Bundle type!"));
        }
        ICapability[] exports = null;
        try {
            exports = ManifestParser.parseExportHeader(this.m_systemBundleModule, (String)bundle.getCurrentModule().getHeaders().get("Export-Package"), this.m_systemBundleModule.getSymbolicName(), this.m_systemBundleModule.getVersion());
            exports = ExtensionManager.aliasSymbolicName(exports);
        }
        catch (Exception ex) {
            this.m_logger.log(1, "Error parsing extension bundle export statement: " + bundle.getCurrentModule().getHeaders().get("Export-Package"), ex);
            return;
        }
        if (m_extensionManager == null) {
            this.m_logger.log(2, "Unable to add extension bundle to FrameworkClassLoader - Maybe not an URLClassLoader?");
            throw new UnsupportedOperationException("Unable to add extension bundle to FrameworkClassLoader - Maybe not an URLClassLoader?");
        }
        m_extensionManager.addExtension(felix, bundle);
        ICapability[] temp = new ICapability[this.m_capabilities.length + exports.length];
        System.arraycopy(this.m_capabilities, 0, temp, 0, this.m_capabilities.length);
        System.arraycopy(exports, 0, temp, this.m_capabilities.length, exports.length);
        this.setCapabilities(temp);
        felix.setBundleStateAndNotify(bundle, 4);
    }

    void startExtensionBundle(Felix felix, BundleImpl bundle) {
        String activatorClass = (String)bundle.getCurrentModule().getHeaders().get("Felix-Activator");
        if (activatorClass != null) {
            try {
                BundleActivator activator = (BundleActivator)felix.getClass().getClassLoader().loadClass(activatorClass.trim()).newInstance();
                felix.m_activatorList.add(activator);
                BundleContext context = felix._getBundleContext();
                bundle.setBundleContext(context);
                if (felix.getState() == 32 || felix.getState() == 8) {
                    Felix.m_secureAction.startActivator(activator, context);
                }
            }
            catch (Throwable ex) {
                this.m_logger.log(2, "Unable to start Felix Extension Activator", ex);
            }
        }
    }

    void removeExtensions(Felix felix) {
        if (m_extensionManager != null) {
            m_extensionManager._removeExtensions(felix);
        }
    }

    private void setCapabilities(ICapability[] capabilities) {
        this.m_capabilities = capabilities;
        this.m_headerMap.put("Export-Package", this.convertCapabilitiesToHeaders(this.m_headerMap));
    }

    private String convertCapabilitiesToHeaders(Map headers) {
        StringBuffer exportSB = new StringBuffer("");
        HashSet<String> exportNames = new HashSet<String>();
        for (int i = 0; this.m_capabilities != null && i < this.m_capabilities.length; ++i) {
            if (!this.m_capabilities[i].getNamespace().equals("package")) continue;
            if (exportSB.length() > 0) {
                exportSB.append(", ");
            }
            exportSB.append(((Capability)this.m_capabilities[i]).getPackageName());
            exportSB.append("; version=\"");
            exportSB.append(((Capability)this.m_capabilities[i]).getPackageVersion().toString());
            exportSB.append("\"");
            exportNames.add(((Capability)this.m_capabilities[i]).getPackageName());
        }
        this.m_exportNames = exportNames;
        return exportSB.toString();
    }

    public URLConnection openConnection(URL url) throws IOException {
        String path = url.getPath();
        if (path.trim().equals("/")) {
            return new URLHandlersBundleURLConnection(url);
        }
        Bundle[] extensions = this.m_extensionsCache;
        URL result = null;
        for (Bundle extBundle : extensions) {
            try {
                result = ((BundleImpl)extBundle).getCurrentModule().getEntry(path);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (result == null) continue;
            return result.openConnection();
        }
        throw new IOException("Resource not provided by any extension!");
    }

    protected InetAddress getHostAddress(URL u) {
        return null;
    }

    private synchronized void addExtension(Object source, Bundle extension) {
        ArrayList<Bundle> sourceExtensions = (ArrayList<Bundle>)this.m_sourceToExtensions.get(source);
        if (sourceExtensions == null) {
            sourceExtensions = new ArrayList<Bundle>();
            this.m_sourceToExtensions.put(source, sourceExtensions);
        }
        sourceExtensions.add(extension);
        this._add(extension.getSymbolicName(), extension);
        this.m_extensionsCache = this.m_extensions.toArray(new Bundle[this.m_extensions.size()]);
    }

    private synchronized void _removeExtensions(Object source) {
        if (this.m_sourceToExtensions.remove(source) == null) {
            return;
        }
        this.m_extensions.clear();
        this.m_names.clear();
        for (List extensions : this.m_sourceToExtensions.values()) {
            for (Bundle bundle : extensions) {
                this._add(bundle.getSymbolicName(), bundle);
            }
        }
        this.m_extensionsCache = this.m_extensions.toArray(new Bundle[this.m_extensions.size()]);
    }

    private void _add(String name, Bundle extension) {
        if (!this.m_names.contains(name)) {
            this.m_names.add(name);
            this.m_extensions.add(extension);
        }
    }

    public void close() {
    }

    public Enumeration getEntries() {
        return new Enumeration(){

            public boolean hasMoreElements() {
                return false;
            }

            public Object nextElement() throws NoSuchElementException {
                throw new NoSuchElementException();
            }
        };
    }

    public boolean hasEntry(String name) {
        return false;
    }

    public byte[] getEntryAsBytes(String name) {
        return null;
    }

    public InputStream getEntryAsStream(String name) throws IOException {
        return null;
    }

    public IContent getEntryAsContent(String name) {
        return null;
    }

    public String getEntryAsNativeLibrary(String name) {
        return null;
    }

    static String loadDefaultSystemPackages(Logger logger) {
        URL propURL = ExtensionManager.class.getClassLoader().getResource(DEFAULT_PROPERTIES_FILE_VALUE);
        if (propURL != null) {
            InputStream is = null;
            try {
                is = propURL.openConnection().getInputStream();
                Properties props = new Properties();
                props.load(is);
                is.close();
                Enumeration<?> e = props.propertyNames();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    props.setProperty(name, Util.substVars(props.getProperty(name), name, null, props));
                }
                return props.getProperty("org.osgi.framework.system.packages");
            }
            catch (Exception ex) {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException ex2) {
                    // empty catch block
                }
                logger.log(1, "Unable to load any configuration properties.", ex);
            }
        }
        return "";
    }

    static {
        ExtensionManager extensionManager = new ExtensionManager();
        try {
            new URL("http://felix.extensions:9/").openConnection();
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            Felix.m_secureAction.addURLToURLClassLoader(Felix.m_secureAction.createURL(Felix.m_secureAction.createURL(null, "http:", extensionManager), "http://felix.extensions:9/", extensionManager), Felix.class.getClassLoader());
        }
        catch (Throwable ex) {
            extensionManager = null;
        }
        m_extensionManager = extensionManager;
    }

    class ExtensionManagerModule
    extends ModuleImpl {
        private final Version m_version;

        ExtensionManagerModule(Felix felix) {
            super(ExtensionManager.this.m_logger, felix, "0", felix.getBootPackages(), felix.getBootPackageWildcards());
            this.m_version = new Version((String)felix.getConfig().get("felix.version"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map getHeaders() {
            ExtensionManager extensionManager = ExtensionManager.this;
            synchronized (extensionManager) {
                return ExtensionManager.this.m_headerMap;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ICapability[] getCapabilities() {
            ExtensionManager extensionManager = ExtensionManager.this;
            synchronized (extensionManager) {
                return ExtensionManager.this.m_capabilities;
            }
        }

        public String getSymbolicName() {
            return "org.apache.felix.framework";
        }

        public Version getVersion() {
            return this.m_version;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Class getClassByDelegation(String name) throws ClassNotFoundException {
            ExtensionManager extensionManager = ExtensionManager.this;
            synchronized (extensionManager) {
                if (!ExtensionManager.this.m_exportNames.contains(Util.getClassPackage(name))) {
                    throw new ClassNotFoundException(name);
                }
            }
            return this.getClass().getClassLoader().loadClass(name);
        }

        public URL getResourceByDelegation(String name) {
            return this.getClass().getClassLoader().getResource(name);
        }

        public Enumeration getResourcesByDelegation(String name) {
            try {
                return this.getClass().getClassLoader().getResources(name);
            }
            catch (IOException ex) {
                return null;
            }
        }

        public Logger getLogger() {
            return ExtensionManager.this.m_logger;
        }

        public Map getConfig() {
            return null;
        }

        public Felix.FelixResolver getResolver() {
            return null;
        }

        public void attachFragmentContents(IContent[] fragmentContents) throws Exception {
            throw new UnsupportedOperationException("Should not be used!");
        }

        public void close() {
        }

        public IContent getContent() {
            return ExtensionManager.this;
        }

        public URL getEntry(String name) {
            return null;
        }

        public boolean hasInputStream(int index, String urlPath) {
            return this.getClass().getClassLoader().getResource(urlPath) != null;
        }

        public InputStream getInputStream(int index, String urlPath) {
            return this.getClass().getClassLoader().getResourceAsStream(urlPath);
        }
    }
}

