/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.felix.framework.util.ConcurrentMap;

abstract class AbstractCopyOnWriteMap
implements Map,
ConcurrentMap,
Serializable {
    private static final long serialVersionUID = 4508989182041753878L;
    private volatile Map delegate;
    private final transient EntrySet entrySet = new EntrySet();
    private final transient KeySet keySet = new KeySet();
    private final transient Values values = new Values();
    private final transient Object lock = new Object();

    static void notNull(String name, Object check) {
        if (check == null) {
            throw new IllegalArgumentException(name + " cannot be null");
        }
    }

    protected AbstractCopyOnWriteMap(Map map) {
        AbstractCopyOnWriteMap.notNull("map", map);
        this.delegate = map;
    }

    protected AbstractCopyOnWriteMap() {
        this(Collections.EMPTY_MAP);
    }

    abstract Map copy(Map var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        Object object = this.lock;
        synchronized (object) {
            Map map = this.copy();
            map.clear();
            this.set(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object remove(Object key) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.delegate.containsKey(key)) {
                return null;
            }
            Map map = this.copy();
            Object result = map.remove(key);
            this.set(map);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object key, Object value) {
        Object object = this.lock;
        synchronized (object) {
            if (this.delegate.containsKey(key) && this.equals(value, this.delegate.get(key))) {
                Map map = this.copy();
                map.remove(key);
                this.set(map);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replace(Object key, Object oldValue, Object newValue) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.delegate.containsKey(key) || !this.equals(oldValue, this.delegate.get(key))) {
                return false;
            }
            Map map = this.copy();
            map.put(key, newValue);
            this.set(map);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object replace(Object key, Object value) {
        Object object = this.lock;
        synchronized (object) {
            Object object2;
            if (!this.delegate.containsKey(key)) {
                return null;
            }
            Map map = this.copy();
            try {
                object2 = map.put(key, value);
                this.set(map);
            }
            catch (Throwable throwable) {
                this.set(map);
                throw throwable;
            }
            return object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object put(Object key, Object value) {
        Object object = this.lock;
        synchronized (object) {
            Map map = this.copy();
            AbstractCopyOnWriteMap.notNull("copy", map);
            Object result = map.put(key, value);
            this.set(map);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object putIfAbsent(Object key, Object value) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.delegate.containsKey(key)) {
                Map map = this.copy();
                Object result = map.put(key, value);
                this.set(map);
                return result;
            }
            return this.delegate.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void putAll(Map t) {
        Object object = this.lock;
        synchronized (object) {
            Map map = this.copy();
            map.putAll(t);
            this.set(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map copy() {
        Object object = this.lock;
        synchronized (object) {
            return this.copy(this.delegate);
        }
    }

    protected void set(Map map) {
        this.delegate = map;
    }

    public final Set entrySet() {
        return this.entrySet;
    }

    public final Set keySet() {
        return this.keySet;
    }

    public final Collection values() {
        return this.values;
    }

    public final boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    public final boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    public final Object get(Object key) {
        return this.delegate.get(key);
    }

    public final boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public final int size() {
        return this.delegate.size();
    }

    public final boolean equals(Object o) {
        return ((Object)this.delegate).equals(o);
    }

    public final int hashCode() {
        return ((Object)this.delegate).hashCode();
    }

    protected final Map getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    private boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    protected static abstract class CollectionView
    implements Collection {
        protected CollectionView() {
        }

        abstract Collection getDelegate();

        public final boolean contains(Object o) {
            return this.getDelegate().contains(o);
        }

        public final boolean containsAll(Collection c) {
            return this.getDelegate().containsAll(c);
        }

        public final Iterator iterator() {
            return new UnmodifiableIterator(this.getDelegate().iterator());
        }

        public final boolean isEmpty() {
            return this.getDelegate().isEmpty();
        }

        public final int size() {
            return this.getDelegate().size();
        }

        public final Object[] toArray() {
            return this.getDelegate().toArray();
        }

        public final Object[] toArray(Object[] a) {
            return this.getDelegate().toArray(a);
        }

        public int hashCode() {
            return ((Object)this.getDelegate()).hashCode();
        }

        public boolean equals(Object obj) {
            return ((Object)this.getDelegate()).equals(obj);
        }

        public String toString() {
            return this.getDelegate().toString();
        }

        public final boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public final boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }
    }

    private static class UnmodifiableIterator
    implements Iterator {
        private final Iterator delegate;

        public UnmodifiableIterator(Iterator delegate) {
            this.delegate = delegate;
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public Object next() {
            return this.delegate.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class EntrySet
    extends CollectionView
    implements Set {
        private EntrySet() {
        }

        Collection getDelegate() {
            return AbstractCopyOnWriteMap.this.delegate.entrySet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = AbstractCopyOnWriteMap.this.lock;
            synchronized (object) {
                Map map = AbstractCopyOnWriteMap.this.copy();
                map.entrySet().clear();
                AbstractCopyOnWriteMap.this.set(map);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object o) {
            Object object = AbstractCopyOnWriteMap.this.lock;
            synchronized (object) {
                if (!this.contains(o)) {
                    return false;
                }
                Map map = AbstractCopyOnWriteMap.this.copy();
                boolean result = map.entrySet().remove(o);
                AbstractCopyOnWriteMap.this.set(map);
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeAll(Collection c) {
            Object object = AbstractCopyOnWriteMap.this.lock;
            synchronized (object) {
                Map map = AbstractCopyOnWriteMap.this.copy();
                boolean result = map.entrySet().removeAll(c);
                AbstractCopyOnWriteMap.this.set(map);
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean retainAll(Collection c) {
            Object object = AbstractCopyOnWriteMap.this.lock;
            synchronized (object) {
                Map map = AbstractCopyOnWriteMap.this.copy();
                boolean result = map.entrySet().retainAll(c);
                AbstractCopyOnWriteMap.this.set(map);
                return result;
            }
        }
    }

    private final class Values
    extends CollectionView {
        private Values() {
        }

        Collection getDelegate() {
            return AbstractCopyOnWriteMap.this.delegate.values();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = AbstractCopyOnWriteMap.this.lock;
            synchronized (object) {
                Map map = AbstractCopyOnWriteMap.this.copy();
                map.values().clear();
                AbstractCopyOnWriteMap.this.set(map);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object o) {
            Object object = AbstractCopyOnWriteMap.this.lock;
            synchronized (object) {
                if (!this.contains(o)) {
                    return false;
                }
                Map map = AbstractCopyOnWriteMap.this.copy();
                boolean result = map.values().remove(o);
                AbstractCopyOnWriteMap.this.set(map);
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeAll(Collection c) {
            Object object = AbstractCopyOnWriteMap.this.lock;
            synchronized (object) {
                Map map = AbstractCopyOnWriteMap.this.copy();
                boolean result = map.values().removeAll(c);
                AbstractCopyOnWriteMap.this.set(map);
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean retainAll(Collection c) {
            Object object = AbstractCopyOnWriteMap.this.lock;
            synchronized (object) {
                Map map = AbstractCopyOnWriteMap.this.copy();
                boolean result = map.values().retainAll(c);
                AbstractCopyOnWriteMap.this.set(map);
                return result;
            }
        }
    }

    private class KeySet
    extends CollectionView
    implements Set {
        private KeySet() {
        }

        Collection getDelegate() {
            return AbstractCopyOnWriteMap.this.delegate.keySet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = AbstractCopyOnWriteMap.this.lock;
            synchronized (object) {
                Map map = AbstractCopyOnWriteMap.this.copy();
                map.keySet().clear();
                AbstractCopyOnWriteMap.this.set(map);
            }
        }

        public boolean remove(Object o) {
            return AbstractCopyOnWriteMap.this.remove(o) != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeAll(Collection c) {
            Object object = AbstractCopyOnWriteMap.this.lock;
            synchronized (object) {
                Map map = AbstractCopyOnWriteMap.this.copy();
                boolean result = map.keySet().removeAll(c);
                AbstractCopyOnWriteMap.this.set(map);
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean retainAll(Collection c) {
            Object object = AbstractCopyOnWriteMap.this.lock;
            synchronized (object) {
                Map map = AbstractCopyOnWriteMap.this.copy();
                boolean result = map.keySet().retainAll(c);
                AbstractCopyOnWriteMap.this.set(map);
                return result;
            }
        }
    }
}

