/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.felix.framework.BundleImpl;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.ModuleImpl;
import org.apache.felix.moduleloader.IModule;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.RequiredBundle;

class RequiredBundleImpl
implements RequiredBundle {
    private final Felix m_felix;
    private final BundleImpl m_bundle;
    private volatile String m_toString = null;
    private volatile String m_versionString = null;

    public RequiredBundleImpl(Felix felix, BundleImpl bundle) {
        this.m_felix = felix;
        this.m_bundle = bundle;
    }

    public String getSymbolicName() {
        return this.m_bundle.getSymbolicName();
    }

    public Bundle getBundle() {
        return this.m_bundle;
    }

    public Bundle[] getRequiringBundles() {
        if (this.m_bundle.isStale()) {
            return null;
        }
        ArrayList<IModule> moduleList = new ArrayList<IModule>();
        IModule[] modules = this.m_bundle.getModules();
        for (int modIdx = 0; modules != null && modIdx < modules.length; ++modIdx) {
            IModule[] dependents = ((ModuleImpl)modules[modIdx]).getDependentRequirers();
            for (int depIdx = 0; dependents != null && depIdx < dependents.length; ++depIdx) {
                moduleList.add(dependents[modIdx]);
            }
        }
        HashSet<Bundle> bundleSet = new HashSet<Bundle>();
        for (int modIdx = 0; modIdx < moduleList.size(); ++modIdx) {
            Bundle bundle = ((IModule)moduleList.get(modIdx)).getBundle();
            if (bundle == null) continue;
            bundleSet.add(bundle);
        }
        return bundleSet.toArray(new Bundle[bundleSet.size()]);
    }

    public Version getVersion() {
        return this.m_bundle.getCurrentModule().getVersion();
    }

    public boolean isRemovalPending() {
        return this.m_bundle.isRemovalPending();
    }

    public String toString() {
        if (this.m_toString == null) {
            this.m_toString = this.m_bundle.getSymbolicName() + "; version=" + this.m_bundle.getCurrentModule().getVersion();
        }
        return this.m_toString;
    }
}

