/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.searchpolicy;

import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.util.manifestparser.Capability;
import org.apache.felix.moduleloader.ICapability;
import org.apache.felix.moduleloader.IModule;
import org.osgi.framework.Version;

public class PackageSource
implements Comparable {
    public IModule m_module = null;
    public ICapability m_capability = null;

    public PackageSource(IModule module, ICapability capability) {
        this.m_module = module;
        this.m_capability = capability;
    }

    public int compareTo(Object o) {
        PackageSource ps = (PackageSource)o;
        Version thisVersion = null;
        Version version = null;
        if (this.m_capability.getNamespace().equals("package")) {
            thisVersion = ((Capability)this.m_capability).getPackageVersion();
            version = ((Capability)ps.m_capability).getPackageVersion();
        } else if (this.m_capability.getNamespace().equals("module")) {
            thisVersion = (Version)this.m_capability.getProperties().get("bundle-version");
            version = (Version)ps.m_capability.getProperties().get("bundle-version");
        }
        if (thisVersion != null && version != null) {
            long id;
            int cmp = thisVersion.compareTo(version);
            if (cmp < 0) {
                return 1;
            }
            if (cmp > 0) {
                return -1;
            }
            long thisId = Util.getBundleIdFromModuleId(this.m_module.getId());
            if (thisId < (id = Util.getBundleIdFromModuleId(ps.m_module.getId()))) {
                return -1;
            }
            if (thisId > id) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.m_capability == null ? 0 : this.m_capability.hashCode());
        result = 31 * result + (this.m_module == null ? 0 : this.m_module.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        PackageSource ps = (PackageSource)o;
        return this.m_module.equals(ps.m_module) && this.m_capability == ps.m_capability;
    }
}

