/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.IOException;
import java.net.ContentHandler;
import java.net.ContentHandlerFactory;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.felix.framework.URLHandlers;
import org.apache.felix.framework.util.SecureAction;

class URLHandlersContentHandlerProxy
extends ContentHandler {
    private static final Object[] SERVICE_RANKING_PARAMS = new Object[]{"service.ranking"};
    private static final Object[] SERVICE_ID_PARAMS = new Object[]{"service.id"};
    private static final Class[] STRING_TYPES = new Class[]{class$java$lang$String == null ? (class$java$lang$String = URLHandlersContentHandlerProxy.class$("java.lang.String")) : class$java$lang$String};
    private static final Class[] STRING_STRING_TYPES = new Class[]{class$java$lang$String == null ? (class$java$lang$String = URLHandlersContentHandlerProxy.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = URLHandlersContentHandlerProxy.class$("java.lang.String")) : class$java$lang$String};
    private static final String CONTENT_HANDLER_PACKAGE_PROP = "java.content.handler.pkgs";
    private static final String DEFAULT_CONTENT_HANDLER_PACKAGE = "sun.net.www.content|com.ibm.oti.net.www.content|gnu.java.net.content|org.apache.harmony.luni.internal.net.www.content|COM.newmonics.www.content";
    private static final Map m_builtIn = new HashMap();
    private static final String m_pkgs;
    private final ContentHandlerFactory m_factory;
    private final String m_mimeType;
    private final SecureAction m_action;
    private final Object[] m_filter;
    static /* synthetic */ Class class$java$lang$String;

    public URLHandlersContentHandlerProxy(String mimeType, SecureAction action, ContentHandlerFactory factory) {
        this.m_mimeType = mimeType;
        this.m_action = action;
        this.m_factory = factory;
        this.m_filter = new Object[]{"java.net.ContentHandler", "(&(objectClass=java.net.ContentHandler)(url.content.mimetype=" + mimeType + "))"};
    }

    public Object getContent(URLConnection urlc) throws IOException {
        ContentHandler svc = this.getContentHandlerService();
        if (svc == null) {
            return urlc.getInputStream();
        }
        return svc.getContent(urlc);
    }

    private ContentHandler getContentHandlerService() {
        Object framework = URLHandlers.getFrameworkFromContext();
        if (framework == null) {
            return this.getBuiltIn();
        }
        try {
            Object context = this.m_action.invoke(this.m_action.getMethod(framework.getClass(), "getBundleContext", null), framework, null);
            Class<?> contextClass = context.getClass();
            Object[] refs = (Object[])this.m_action.invoke(this.m_action.getMethod(contextClass, "getServiceReferences", STRING_STRING_TYPES), context, this.m_filter);
            Object ref = null;
            int highestRank = -1;
            long currentId = -1L;
            if (refs != null) {
                for (int i = 0; refs != null && i < refs.length; ++i) {
                    int rank;
                    Class<?> refClass = refs[i].getClass();
                    Long idObj = (Long)this.m_action.invoke(this.m_action.getMethod(refClass, "getProperty", STRING_TYPES), refs[i], SERVICE_ID_PARAMS);
                    Integer rankObj = (Integer)this.m_action.invoke(this.m_action.getMethod(refClass, "getProperty", STRING_TYPES), refs[i], SERVICE_RANKING_PARAMS);
                    int n = rank = rankObj == null ? 0 : rankObj;
                    if (rank <= highestRank && (rank != highestRank || idObj >= currentId)) continue;
                    ref = refs[i];
                    highestRank = rank;
                    currentId = idObj;
                }
            }
            ContentHandler service = null;
            if (ref != null) {
                Class<?> serviceRef = null;
                Class<?>[] interfaces = ref.getClass().getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    if (!"org.osgi.framework.ServiceReference".equals(interfaces[i].getName())) continue;
                    serviceRef = interfaces[i];
                    break;
                }
                service = (ContentHandler)this.m_action.invoke(this.m_action.getMethod(contextClass, "getService", new Class[]{serviceRef}), context, new Object[]{ref});
            }
            if (service == null) {
                service = this.getBuiltIn();
            }
            return service;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContentHandler getBuiltIn() {
        ContentHandler result;
        Map map = m_builtIn;
        synchronized (map) {
            if (m_builtIn.containsKey(this.m_mimeType)) {
                return (ContentHandler)m_builtIn.get(this.m_mimeType);
            }
        }
        if (this.m_factory != null && (result = this.m_factory.createContentHandler(this.m_mimeType)) != null) {
            return this.addToCache(this.m_mimeType, result);
        }
        String fixedType = this.m_mimeType.replace('.', '_').replace('/', '.').replace('-', '_');
        StringTokenizer pkgTok = new StringTokenizer(m_pkgs, "| ");
        while (pkgTok.hasMoreTokens()) {
            String pkg = pkgTok.nextToken().trim();
            String className = pkg + "." + fixedType;
            try {
                Class handler = this.m_action.forName(className);
                if (handler == null) continue;
                return this.addToCache(this.m_mimeType, (ContentHandler)handler.newInstance());
            }
            catch (Exception ex) {
            }
        }
        return this.addToCache(this.m_mimeType, null);
    }

    private synchronized ContentHandler addToCache(String mimeType, ContentHandler handler) {
        if (!m_builtIn.containsKey(mimeType)) {
            m_builtIn.put(mimeType, handler);
            return handler;
        }
        return (ContentHandler)m_builtIn.get(mimeType);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String pkgs = new SecureAction().getSystemProperty(CONTENT_HANDLER_PACKAGE_PROP, "");
        m_pkgs = pkgs.equals("") ? DEFAULT_CONTENT_HANDLER_PACKAGE : pkgs + "|" + DEFAULT_CONTENT_HANDLER_PACKAGE;
    }
}

