/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.net.ContentHandler;
import java.net.ContentHandlerFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.felix.framework.URLHandlersBundleStreamHandler;
import org.apache.felix.framework.URLHandlersContentHandlerProxy;
import org.apache.felix.framework.URLHandlersStreamHandlerProxy;
import org.apache.felix.framework.util.SecureAction;
import org.apache.felix.framework.util.SecurityManagerEx;

class URLHandlers
implements URLStreamHandlerFactory,
ContentHandlerFactory {
    private static final SecureAction m_secureAction = new SecureAction();
    private static volatile SecurityManagerEx m_sm = null;
    private static volatile URLHandlers m_handler = null;
    private static Map m_classloaderToFrameworkLists = new HashMap();
    private static final List m_frameworks = new ArrayList();
    private static int m_counter = 0;
    private static Map m_contentHandlerCache = null;
    private static Map m_streamHandlerCache = null;
    private static URLStreamHandlerFactory m_streamHandlerFactory;
    private static ContentHandlerFactory m_contentHandlerFactory;
    private static final String STREAM_HANDLER_PACKAGE_PROP = "java.protocol.handler.pkgs";
    private static final String DEFAULT_STREAM_HANDLER_PACKAGE = "sun.net.www.protocol|com.ibm.oti.net.www.protocol|gnu.java.net.protocol|wonka.net|com.acunia.wonka.net|org.apache.harmony.luni.internal.net.www.protocol|weblogic.utils|weblogic.net|javax.net.ssl|COM.newmonics.www.protocols";
    private static Object m_rootURLHandlers;
    private static final String m_streamPkgs;
    private static final Map m_builtIn;
    private static final boolean m_loaded;
    private static final Map m_handlerToURL;
    static /* synthetic */ Class class$org$apache$felix$framework$URLHandlersStreamHandlerProxy;
    static /* synthetic */ Class class$org$apache$felix$framework$URLHandlersContentHandlerProxy;
    static /* synthetic */ Class class$org$osgi$service$url$URLStreamHandlerService;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$net$URLStreamHandlerFactory;
    static /* synthetic */ Class class$org$apache$felix$framework$URLHandlers;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$net$URLConnection;
    static /* synthetic */ Class class$java$net$ContentHandlerFactory;
    static /* synthetic */ Class class$org$apache$felix$framework$searchpolicy$ModuleImpl$ModuleClassLoader;
    static /* synthetic */ Class class$java$lang$Class;

    private void init(String protocol) {
        try {
            m_handlerToURL.put(this.getBuiltInStreamHandler(protocol, null), new URL(protocol + ":"));
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URLHandlers() {
        this.init("file");
        this.init("ftp");
        this.init("http");
        this.init("https");
        this.getBuiltInStreamHandler("jar", null);
        m_sm = new SecurityManagerEx();
        Class clazz = class$java$net$URL == null ? (class$java$net$URL = URLHandlers.class$("java.net.URL")) : class$java$net$URL;
        synchronized (clazz) {
            try {
                URL.setURLStreamHandlerFactory(this);
                m_streamHandlerFactory = this;
                m_rootURLHandlers = this;
            }
            catch (Error err) {
                try {
                    m_streamHandlerFactory = (URLStreamHandlerFactory)m_secureAction.swapStaticFieldIfNotClass(class$java$net$URL == null ? (class$java$net$URL = URLHandlers.class$("java.net.URL")) : class$java$net$URL, class$java$net$URLStreamHandlerFactory == null ? (class$java$net$URLStreamHandlerFactory = URLHandlers.class$("java.net.URLStreamHandlerFactory")) : class$java$net$URLStreamHandlerFactory, class$org$apache$felix$framework$URLHandlers == null ? (class$org$apache$felix$framework$URLHandlers = URLHandlers.class$("org.apache.felix.framework.URLHandlers")) : class$org$apache$felix$framework$URLHandlers, "streamHandlerLock");
                    if (m_streamHandlerFactory == null) {
                        throw err;
                    }
                    if (!m_streamHandlerFactory.getClass().getName().equals((class$org$apache$felix$framework$URLHandlers == null ? (class$org$apache$felix$framework$URLHandlers = URLHandlers.class$("org.apache.felix.framework.URLHandlers")) : class$org$apache$felix$framework$URLHandlers).getName())) {
                        URL.setURLStreamHandlerFactory(this);
                        m_rootURLHandlers = this;
                    } else if ((class$org$apache$felix$framework$URLHandlers == null ? (class$org$apache$felix$framework$URLHandlers = URLHandlers.class$("org.apache.felix.framework.URLHandlers")) : class$org$apache$felix$framework$URLHandlers) != m_streamHandlerFactory.getClass()) {
                        try {
                            m_secureAction.invoke(m_secureAction.getDeclaredMethod(m_streamHandlerFactory.getClass(), "registerFrameworkListsForContextSearch", new Class[]{class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = URLHandlers.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader, class$java$util$List == null ? (class$java$util$List = URLHandlers.class$("java.util.List")) : class$java$util$List}), m_streamHandlerFactory, new Object[]{(class$org$apache$felix$framework$URLHandlers == null ? (class$org$apache$felix$framework$URLHandlers = URLHandlers.class$("org.apache.felix.framework.URLHandlers")) : class$org$apache$felix$framework$URLHandlers).getClassLoader(), m_frameworks});
                            m_rootURLHandlers = m_streamHandlerFactory;
                        }
                        catch (Exception ex) {
                            new RuntimeException(ex.getMessage());
                        }
                    }
                }
                catch (Exception e) {
                    throw err;
                }
            }
            try {
                URLConnection.setContentHandlerFactory(this);
                m_contentHandlerFactory = this;
            }
            catch (Error err) {
                try {
                    m_contentHandlerFactory = (ContentHandlerFactory)m_secureAction.swapStaticFieldIfNotClass(class$java$net$URLConnection == null ? (class$java$net$URLConnection = URLHandlers.class$("java.net.URLConnection")) : class$java$net$URLConnection, class$java$net$ContentHandlerFactory == null ? (class$java$net$ContentHandlerFactory = URLHandlers.class$("java.net.ContentHandlerFactory")) : class$java$net$ContentHandlerFactory, class$org$apache$felix$framework$URLHandlers == null ? (class$org$apache$felix$framework$URLHandlers = URLHandlers.class$("org.apache.felix.framework.URLHandlers")) : class$org$apache$felix$framework$URLHandlers, null);
                    if (m_contentHandlerFactory == null) {
                        throw err;
                    }
                    if (!m_contentHandlerFactory.getClass().getName().equals((class$org$apache$felix$framework$URLHandlers == null ? (class$org$apache$felix$framework$URLHandlers = URLHandlers.class$("org.apache.felix.framework.URLHandlers")) : class$org$apache$felix$framework$URLHandlers).getName())) {
                        URLConnection.setContentHandlerFactory(this);
                    }
                }
                catch (Exception ex) {
                    throw err;
                }
            }
        }
        if (m_streamHandlerFactory != this && (class$org$apache$felix$framework$URLHandlers == null ? (class$org$apache$felix$framework$URLHandlers = URLHandlers.class$("org.apache.felix.framework.URLHandlers")) : class$org$apache$felix$framework$URLHandlers).getName().equals(m_streamHandlerFactory.getClass().getName())) {
            m_sm = null;
            m_handlerToURL.clear();
            m_builtIn.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerFrameworkListsForContextSearch(ClassLoader index, List frameworkLists) {
        Class clazz = class$java$net$URL == null ? (class$java$net$URL = URLHandlers.class$("java.net.URL")) : class$java$net$URL;
        synchronized (clazz) {
            Map map = m_classloaderToFrameworkLists;
            synchronized (map) {
                m_classloaderToFrameworkLists.put(index, frameworkLists);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unregisterFrameworkListsForContextSearch(ClassLoader index) {
        Class clazz = class$java$net$URL == null ? (class$java$net$URL = URLHandlers.class$("java.net.URL")) : class$java$net$URL;
        synchronized (clazz) {
            Map map = m_classloaderToFrameworkLists;
            synchronized (map) {
                m_classloaderToFrameworkLists.remove(index);
                if (m_classloaderToFrameworkLists.isEmpty()) {
                    List list = m_frameworks;
                    synchronized (list) {
                        if (m_frameworks.isEmpty()) {
                            try {
                                m_secureAction.swapStaticFieldIfNotClass(class$java$net$URL == null ? (class$java$net$URL = URLHandlers.class$("java.net.URL")) : class$java$net$URL, class$java$net$URLStreamHandlerFactory == null ? (class$java$net$URLStreamHandlerFactory = URLHandlers.class$("java.net.URLStreamHandlerFactory")) : class$java$net$URLStreamHandlerFactory, null, "streamHandlerLock");
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            if (m_streamHandlerFactory.getClass() != (class$org$apache$felix$framework$URLHandlers == null ? (class$org$apache$felix$framework$URLHandlers = URLHandlers.class$("org.apache.felix.framework.URLHandlers")) : class$org$apache$felix$framework$URLHandlers)) {
                                URL.setURLStreamHandlerFactory(m_streamHandlerFactory);
                            }
                            try {
                                m_secureAction.swapStaticFieldIfNotClass(class$java$net$URLConnection == null ? (class$java$net$URLConnection = URLHandlers.class$("java.net.URLConnection")) : class$java$net$URLConnection, class$java$net$ContentHandlerFactory == null ? (class$java$net$ContentHandlerFactory = URLHandlers.class$("java.net.ContentHandlerFactory")) : class$java$net$ContentHandlerFactory, null, null);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            if (m_contentHandlerFactory.getClass() != (class$org$apache$felix$framework$URLHandlers == null ? (class$org$apache$felix$framework$URLHandlers = URLHandlers.class$("org.apache.felix.framework.URLHandlers")) : class$org$apache$felix$framework$URLHandlers)) {
                                URLConnection.setContentHandlerFactory(m_contentHandlerFactory);
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URLStreamHandler getBuiltInStreamHandler(String protocol, URLStreamHandlerFactory factory) {
        URLStreamHandler result;
        Map map = m_builtIn;
        synchronized (map) {
            if (m_builtIn.containsKey(protocol)) {
                return (URLStreamHandler)m_builtIn.get(protocol);
            }
        }
        if (factory != null && (result = factory.createURLStreamHandler(protocol)) != null) {
            return this.addToCache(protocol, result);
        }
        StringTokenizer pkgTok = new StringTokenizer(m_streamPkgs, "| ");
        while (pkgTok.hasMoreTokens()) {
            String pkg = pkgTok.nextToken().trim();
            String className = pkg + "." + protocol + ".Handler";
            try {
                Class handler = m_secureAction.forName(className);
                if (handler == null) continue;
                return this.addToCache(protocol, (URLStreamHandler)handler.newInstance());
            }
            catch (Exception ex) {
            }
        }
        return this.addToCache(protocol, null);
    }

    private synchronized URLStreamHandler addToCache(String protocol, URLStreamHandler result) {
        if (!m_builtIn.containsKey(protocol)) {
            m_builtIn.put(protocol, result);
            return result;
        }
        return (URLStreamHandler)m_builtIn.get(protocol);
    }

    public URLStreamHandler createURLStreamHandler(String protocol) {
        URLStreamHandler handler = this.getFromStreamCache(protocol);
        if (handler != null) {
            return handler;
        }
        if (protocol.equals("bundle")) {
            return this.addToStreamCache(protocol, new URLHandlersBundleStreamHandler(m_secureAction));
        }
        handler = this.getBuiltInStreamHandler(protocol, m_streamHandlerFactory != this ? m_streamHandlerFactory : null);
        return this.addToStreamCache(protocol, new URLHandlersStreamHandlerProxy(protocol, m_secureAction, handler, (URL)m_handlerToURL.get(handler)));
    }

    public ContentHandler createContentHandler(String mimeType) {
        ContentHandler handler = this.getFromContentCache(mimeType);
        if (handler != null) {
            return handler;
        }
        return this.addToContentCache(mimeType, new URLHandlersContentHandlerProxy(mimeType, m_secureAction, m_contentHandlerFactory != this ? m_contentHandlerFactory : null));
    }

    private synchronized ContentHandler addToContentCache(String mimeType, ContentHandler handler) {
        if (m_contentHandlerCache == null) {
            m_contentHandlerCache = new HashMap();
        }
        return (ContentHandler)this.addToCache(m_contentHandlerCache, mimeType, handler);
    }

    private synchronized ContentHandler getFromContentCache(String mimeType) {
        return m_contentHandlerCache != null ? m_contentHandlerCache.get(mimeType) : null;
    }

    private synchronized URLStreamHandler addToStreamCache(String protocol, URLStreamHandler handler) {
        if (m_streamHandlerCache == null) {
            m_streamHandlerCache = new HashMap();
        }
        return (URLStreamHandler)this.addToCache(m_streamHandlerCache, protocol, handler);
    }

    private synchronized URLStreamHandler getFromStreamCache(String protocol) {
        return m_streamHandlerCache != null ? m_streamHandlerCache.get(protocol) : null;
    }

    private Object addToCache(Map cache, String key, Object value) {
        if (value == null) {
            return null;
        }
        Object result = cache.get(key);
        if (result == null) {
            cache.put(key, value);
            result = value;
        }
        return result;
    }

    synchronized void flush() {
        Object proxy;
        Iterator iter;
        if (m_streamHandlerCache != null) {
            iter = m_streamHandlerCache.values().iterator();
            while (iter.hasNext()) {
                proxy = iter.next();
                if (!(proxy instanceof URLHandlersStreamHandlerProxy)) continue;
                ((URLHandlersStreamHandlerProxy)proxy).flush();
            }
        }
        if (m_contentHandlerCache != null) {
            iter = m_contentHandlerCache.values().iterator();
            while (iter.hasNext()) {
                proxy = iter.next();
                if (!(proxy instanceof URLHandlersContentHandlerProxy)) continue;
                ((URLHandlersContentHandlerProxy)proxy).flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerFrameworkInstance(Object framework, boolean enable) {
        List list = m_frameworks;
        synchronized (list) {
            if (enable) {
                if (m_handler == null) {
                    m_handler = new URLHandlers();
                }
                m_frameworks.add(framework);
            }
            ++m_counter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterFrameworkInstance(Object framework) {
        List list = m_frameworks;
        synchronized (list) {
            --m_counter;
            if (m_frameworks.remove(framework)) {
                try {
                    m_secureAction.invoke(m_secureAction.getDeclaredMethod(m_rootURLHandlers.getClass(), "flush", null), m_rootURLHandlers, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (m_frameworks.isEmpty()) {
                    try {
                        m_secureAction.invoke(m_secureAction.getDeclaredMethod(m_rootURLHandlers.getClass(), "unregisterFrameworkListsForContextSearch", new Class[]{class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = URLHandlers.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader}), m_rootURLHandlers, new Object[]{(class$org$apache$felix$framework$URLHandlers == null ? (class$org$apache$felix$framework$URLHandlers = URLHandlers.class$("org.apache.felix.framework.URLHandlers")) : class$org$apache$felix$framework$URLHandlers).getClassLoader()});
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    m_handler = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getFrameworkFromContext() {
        Map map = m_classloaderToFrameworkLists;
        synchronized (map) {
            if (m_classloaderToFrameworkLists.isEmpty()) {
                List list = m_frameworks;
                synchronized (list) {
                    if (m_counter == 1 && m_frameworks.size() == 1) {
                        return m_frameworks.get(0);
                    }
                }
            }
        }
        Class[] stack = m_sm.getClassContext();
        Class targetClass = null;
        for (int i = 0; i < stack.length; ++i) {
            if (stack[i].getClassLoader() == null || !(class$org$apache$felix$framework$searchpolicy$ModuleImpl$ModuleClassLoader == null ? URLHandlers.class$("org.apache.felix.framework.searchpolicy.ModuleImpl$ModuleClassLoader") : class$org$apache$felix$framework$searchpolicy$ModuleImpl$ModuleClassLoader).getName().equals(stack[i].getClassLoader().getClass().getName())) continue;
            targetClass = stack[i];
            break;
        }
        if (targetClass != null) {
            Map map2 = m_classloaderToFrameworkLists;
            synchronized (map2) {
                ClassLoader index = targetClass.getClassLoader().getClass().getClassLoader();
                List frameworks = (List)m_classloaderToFrameworkLists.get(index);
                if (frameworks == null && index == (class$org$apache$felix$framework$URLHandlers == null ? (class$org$apache$felix$framework$URLHandlers = URLHandlers.class$("org.apache.felix.framework.URLHandlers")) : class$org$apache$felix$framework$URLHandlers).getClassLoader()) {
                    frameworks = m_frameworks;
                }
                if (frameworks != null) {
                    List list = frameworks;
                    synchronized (list) {
                        for (int i = 0; i < frameworks.size(); ++i) {
                            Object framework = frameworks.get(i);
                            try {
                                Class[] classArray = new Class[1];
                                Class clazz = classArray[0] = class$java$lang$Class == null ? URLHandlers.class$("java.lang.Class") : class$java$lang$Class;
                                if (m_secureAction.invoke(m_secureAction.getDeclaredMethod(framework.getClass(), "getBundle", classArray), framework, new Object[]{targetClass}) == null) continue;
                                return framework;
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                }
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        m_builtIn = new HashMap();
        String pkgs = new SecureAction().getSystemProperty(STREAM_HANDLER_PACKAGE_PROP, "");
        m_streamPkgs = pkgs.equals("") ? DEFAULT_STREAM_HANDLER_PACKAGE : pkgs + "|" + DEFAULT_STREAM_HANDLER_PACKAGE;
        m_loaded = null != (class$org$apache$felix$framework$URLHandlersStreamHandlerProxy == null ? (class$org$apache$felix$framework$URLHandlersStreamHandlerProxy = URLHandlers.class$("org.apache.felix.framework.URLHandlersStreamHandlerProxy")) : class$org$apache$felix$framework$URLHandlersStreamHandlerProxy) && null != (class$org$apache$felix$framework$URLHandlersContentHandlerProxy == null ? (class$org$apache$felix$framework$URLHandlersContentHandlerProxy = URLHandlers.class$("org.apache.felix.framework.URLHandlersContentHandlerProxy")) : class$org$apache$felix$framework$URLHandlersContentHandlerProxy) && null != (class$org$osgi$service$url$URLStreamHandlerService == null ? (class$org$osgi$service$url$URLStreamHandlerService = URLHandlers.class$("org.osgi.service.url.URLStreamHandlerService")) : class$org$osgi$service$url$URLStreamHandlerService);
        m_handlerToURL = new HashMap();
    }
}

