/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.IOException;
import java.net.ContentHandler;
import java.net.ContentHandlerFactory;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.felix.framework.URLHandlers;
import org.apache.felix.framework.URLHandlersServiceTracker;
import org.apache.felix.framework.util.SecureAction;

class URLHandlersContentHandlerProxy
extends ContentHandler {
    private static final String CONTENT_HANDLER_PACKAGE_PROP = "java.content.handler.pkgs";
    private static final String DEFAULT_CONTENT_HANDLER_PACKAGE = "sun.net.www.content|com.ibm.oti.net.www.content|gnu.java.net.content|org.apache.harmony.luni.internal.net.www.content|COM.newmonics.www.content";
    private static final Map m_builtIn = new HashMap();
    private final ContentHandlerFactory m_factory;
    private final Map m_trackerMap = new HashMap();
    private final String m_mimeType;
    private final SecureAction m_action;
    static /* synthetic */ Class class$java$net$ContentHandler;
    static /* synthetic */ Class class$org$apache$felix$framework$URLHandlersServiceTracker;
    static /* synthetic */ Class class$org$apache$felix$framework$Felix;
    static /* synthetic */ Class class$java$lang$String;

    public URLHandlersContentHandlerProxy(String mimeType, SecureAction action, ContentHandlerFactory factory) {
        this.m_mimeType = mimeType;
        this.m_action = action;
        this.m_factory = factory;
    }

    public Object getContent(URLConnection urlc) throws IOException {
        ContentHandler svc = this.getContentHandlerService();
        if (svc == null) {
            return urlc.getInputStream();
        }
        return svc.getContent(urlc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContentHandler getContentHandlerService() {
        Object tracker;
        Object framework = URLHandlers.getFrameworkFromContext();
        if (framework == null) {
            return this.getBuiltIn();
        }
        Map map = this.m_trackerMap;
        synchronized (map) {
            tracker = this.m_trackerMap.get(framework);
        }
        try {
            ContentHandler result;
            if (tracker == null) {
                String filter = "(&(objectClass=" + (class$java$net$ContentHandler == null ? (class$java$net$ContentHandler = URLHandlersContentHandlerProxy.class$("java.net.ContentHandler")) : class$java$net$ContentHandler).getName() + ")(" + "url.content.mimetype" + "=" + this.m_mimeType + "))";
                tracker = this.m_action.invoke(this.m_action.getConstructor(framework.getClass().getClassLoader().loadClass((class$org$apache$felix$framework$URLHandlersServiceTracker == null ? (class$org$apache$felix$framework$URLHandlersServiceTracker = URLHandlersContentHandlerProxy.class$("org.apache.felix.framework.URLHandlersServiceTracker")) : class$org$apache$felix$framework$URLHandlersServiceTracker).getName()), new Class[]{framework.getClass().getClassLoader().loadClass((class$org$apache$felix$framework$Felix == null ? (class$org$apache$felix$framework$Felix = URLHandlersContentHandlerProxy.class$("org.apache.felix.framework.Felix")) : class$org$apache$felix$framework$Felix).getName()), class$java$lang$String == null ? (class$java$lang$String = URLHandlersContentHandlerProxy.class$("java.lang.String")) : class$java$lang$String}), new Object[]{framework, filter});
                Map map2 = this.m_trackerMap;
                synchronized (map2) {
                    if (!this.m_trackerMap.containsKey(framework)) {
                        this.m_trackerMap.put(framework, tracker);
                    } else {
                        tracker = this.m_trackerMap.get(framework);
                    }
                }
            }
            if ((result = tracker instanceof URLHandlersServiceTracker ? (ContentHandler)((URLHandlersServiceTracker)tracker).getService() : (ContentHandler)this.m_action.invoke(this.m_action.getMethod(tracker.getClass(), "getService", null), tracker, null)) == null) {
                result = this.getBuiltIn();
            }
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContentHandler getBuiltIn() {
        ContentHandler result;
        Map map = m_builtIn;
        synchronized (map) {
            if (m_builtIn.containsKey(this.m_mimeType)) {
                return (ContentHandler)m_builtIn.get(this.m_mimeType);
            }
        }
        if (this.m_factory != null && (result = this.m_factory.createContentHandler(this.m_mimeType)) != null) {
            return this.addToCache(this.m_mimeType, result);
        }
        String pkgs = this.m_action.getSystemProperty(CONTENT_HANDLER_PACKAGE_PROP, "");
        pkgs = pkgs.equals("") ? DEFAULT_CONTENT_HANDLER_PACKAGE : pkgs + "|" + DEFAULT_CONTENT_HANDLER_PACKAGE;
        String fixedType = this.m_mimeType.replace('.', '_').replace('/', '.').replace('-', '_');
        StringTokenizer pkgTok = new StringTokenizer(pkgs, "| ");
        while (pkgTok.hasMoreTokens()) {
            String pkg = pkgTok.nextToken().trim();
            String className = pkg + "." + fixedType;
            try {
                Class handler = this.m_action.forName(className);
                if (handler == null) continue;
                return this.addToCache(this.m_mimeType, (ContentHandler)handler.newInstance());
            }
            catch (Exception ex) {
            }
        }
        return this.addToCache(this.m_mimeType, null);
    }

    private synchronized ContentHandler addToCache(String mimeType, ContentHandler handler) {
        if (!m_builtIn.containsKey(mimeType)) {
            m_builtIn.put(mimeType, handler);
            return handler;
        }
        return (ContentHandler)m_builtIn.get(mimeType);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

