/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import org.apache.felix.framework.ServiceReferenceImpl;
import org.apache.felix.framework.ServiceRegistry;
import org.apache.felix.framework.util.StringMap;
import org.apache.felix.framework.util.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

class ServiceRegistrationImpl
implements ServiceRegistration {
    private ServiceRegistry m_registry = null;
    private Bundle m_bundle = null;
    private String[] m_classes = null;
    private Long m_serviceId = null;
    private Object m_svcObj = null;
    private ServiceFactory m_factory = null;
    private volatile Map m_propMap = new StringMap(false);
    private ServiceReferenceImpl m_ref = null;
    private boolean m_isUnregistering = false;

    public ServiceRegistrationImpl(ServiceRegistry registry, Bundle bundle, String[] classes, Long serviceId, Object svcObj, Dictionary dict) {
        this.m_registry = registry;
        this.m_bundle = bundle;
        this.m_classes = classes;
        this.m_serviceId = serviceId;
        this.m_svcObj = svcObj;
        this.m_factory = this.m_svcObj instanceof ServiceFactory ? (ServiceFactory)this.m_svcObj : null;
        this.initializeProperties(dict);
        this.m_ref = new ServiceReferenceImpl(this, this.m_bundle);
    }

    protected synchronized boolean isValid() {
        return this.m_svcObj != null;
    }

    protected synchronized void invalidate() {
        this.m_svcObj = null;
    }

    public ServiceReference getReference() {
        if (!this.isValid()) {
            throw new IllegalStateException("The service registration is no longer valid.");
        }
        return this.m_ref;
    }

    public void setProperties(Dictionary dict) {
        if (!this.isValid()) {
            throw new IllegalStateException("The service registration is no longer valid.");
        }
        this.initializeProperties(dict);
        this.m_registry.servicePropertiesModified(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister() {
        ServiceRegistrationImpl serviceRegistrationImpl = this;
        synchronized (serviceRegistrationImpl) {
            if (!this.isValid() || this.m_isUnregistering) {
                throw new IllegalStateException("Service already unregistered.");
            }
            this.m_isUnregistering = true;
        }
        this.m_registry.unregisterService(this.m_bundle, this);
        serviceRegistrationImpl = this;
        synchronized (serviceRegistrationImpl) {
            this.m_svcObj = null;
            this.m_factory = null;
        }
    }

    protected boolean isClassAccessible(Class clazz) {
        try {
            Class<?> sourceClass = this.m_factory != null ? this.m_factory.getClass() : this.m_svcObj.getClass();
            Class targetClass = Util.loadClassUsingClass(sourceClass, clazz.getName());
            return targetClass == clazz;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected Object getProperty(String key) {
        return this.m_propMap.get(key);
    }

    protected String[] getPropertyKeys() {
        Set s = this.m_propMap.keySet();
        return s.toArray(new String[s.size()]);
    }

    protected Bundle[] getUsingBundles() {
        return this.m_registry.getUsingBundles(this.m_ref);
    }

    protected Object getService(Bundle acqBundle) {
        if (this.m_factory != null) {
            try {
                if (System.getSecurityManager() != null) {
                    return AccessController.doPrivileged(new ServiceFactoryPrivileged(acqBundle, null));
                }
                return this.getFactoryUnchecked(acqBundle);
            }
            catch (Exception ex) {
                this.m_registry.getLogger().log(1, "ServiceRegistrationImpl: Error getting service.", ex);
                return null;
            }
        }
        return this.m_svcObj;
    }

    protected void ungetService(Bundle relBundle, Object svcObj) {
        if (this.m_factory != null) {
            try {
                if (System.getSecurityManager() != null) {
                    AccessController.doPrivileged(new ServiceFactoryPrivileged(relBundle, svcObj));
                } else {
                    this.ungetFactoryUnchecked(relBundle, svcObj);
                }
            }
            catch (Exception ex) {
                this.m_registry.getLogger().log(1, "ServiceRegistrationImpl: Error ungetting service.", ex);
            }
        }
    }

    private void initializeProperties(Dictionary dict) {
        StringMap props = new StringMap(false);
        if (dict != null) {
            Enumeration keys = dict.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                if (props.get(key) == null) {
                    props.put(key, dict.get(key));
                    continue;
                }
                throw new IllegalArgumentException("Duplicate service property: " + key);
            }
        }
        props.put("objectClass", this.m_classes);
        props.put("service.id", this.m_serviceId);
        this.m_propMap = props;
    }

    private Object getFactoryUnchecked(Bundle bundle) {
        Object svcObj = this.m_factory.getService(bundle, this);
        if (svcObj != null) {
            for (int i = 0; i < this.m_classes.length; ++i) {
                Class clazz = Util.loadClassUsingClass(svcObj.getClass(), this.m_classes[i]);
                if (clazz != null && clazz.isAssignableFrom(svcObj.getClass())) continue;
                return null;
            }
        }
        return svcObj;
    }

    private void ungetFactoryUnchecked(Bundle bundle, Object svcObj) {
        this.m_factory.ungetService(bundle, this, svcObj);
    }

    private class ServiceFactoryPrivileged
    implements PrivilegedExceptionAction {
        private Bundle m_bundle = null;
        private Object m_svcObj = null;

        public ServiceFactoryPrivileged(Bundle bundle, Object svcObj) {
            this.m_bundle = bundle;
            this.m_svcObj = svcObj;
        }

        public Object run() throws Exception {
            if (this.m_svcObj == null) {
                return ServiceRegistrationImpl.this.getFactoryUnchecked(this.m_bundle);
            }
            ServiceRegistrationImpl.this.ungetFactoryUnchecked(this.m_bundle, this.m_svcObj);
            return null;
        }
    }
}

