/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.IOException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.felix.framework.Logger;
import org.apache.felix.moduleloader.IContentLoader;
import org.apache.felix.moduleloader.IModule;
import org.apache.felix.moduleloader.ModuleImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

abstract class BundleInfo {
    private Logger m_logger = null;
    private boolean m_removalPending = false;
    private IModule[] m_modules = null;
    private int m_state = 0;
    private BundleActivator m_activator = null;
    private BundleContext m_context = null;
    private Map m_cachedHeaders = new HashMap();
    private long m_cachedHeadersTimestamp;
    private boolean m_stale = false;
    private boolean m_extension = false;
    private int m_lockCount = 0;
    private Thread m_lockThread = null;

    public BundleInfo(Logger logger, IModule module) {
        IModule[] iModuleArray;
        this.m_logger = logger;
        if (module == null) {
            iModuleArray = new IModule[]{};
        } else {
            IModule[] iModuleArray2 = new IModule[1];
            iModuleArray = iModuleArray2;
            iModuleArray2[0] = module;
        }
        this.m_modules = iModuleArray;
        this.m_state = 2;
        this.m_stale = false;
        this.m_activator = null;
        this.m_context = null;
    }

    public Logger getLogger() {
        return this.m_logger;
    }

    public synchronized boolean isRemovalPending() {
        return this.m_removalPending;
    }

    public synchronized void setRemovalPending(boolean removalPending) {
        this.m_removalPending = removalPending;
    }

    public synchronized IModule[] getModules() {
        return this.m_modules;
    }

    public synchronized boolean hasModule(IModule module) {
        for (int i = 0; i < this.m_modules.length; ++i) {
            if (this.m_modules[i] != module) continue;
            return true;
        }
        return false;
    }

    public synchronized IModule getCurrentModule() {
        return this.m_modules[this.m_modules.length - 1];
    }

    public synchronized void addModule(IModule module) {
        IModule[] dest = new IModule[this.m_modules.length + 1];
        System.arraycopy(this.m_modules, 0, dest, 0, this.m_modules.length);
        dest[this.m_modules.length] = module;
        this.m_modules = dest;
    }

    public synchronized void markModulesStale() {
        for (int i = 0; i < this.m_modules.length; ++i) {
            ((ModuleImpl)this.m_modules[i]).setStale();
        }
    }

    public abstract String getSymbolicName();

    public abstract long getBundleId();

    public abstract String getLocation();

    public abstract int getStartLevel(int var1);

    public abstract void setStartLevel(int var1);

    public abstract Map getCurrentHeader();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getCurrentLocalizedHeader(String locale) {
        Map map = this.m_cachedHeaders;
        synchronized (map) {
            if (this.getLastModified() > this.m_cachedHeadersTimestamp) {
                this.m_cachedHeaders.clear();
            } else if (this.m_cachedHeaders.containsKey(locale)) {
                return (Map)this.m_cachedHeaders.get(locale);
            }
        }
        Map rawHeaders = this.getCurrentHeader();
        HashMap headers = new HashMap(rawHeaders.size());
        headers.putAll(rawHeaders);
        boolean needsLocalization = false;
        Iterator it = headers.values().iterator();
        while (it.hasNext()) {
            if (!((String)it.next()).startsWith("%")) continue;
            needsLocalization = true;
            break;
        }
        if (!needsLocalization) {
            this.updateHeaderCache(locale, headers);
            return headers;
        }
        IContentLoader loader = this.getCurrentModule().getContentLoader();
        String basename = (String)headers.get("Bundle-Localization");
        if (basename == null) {
            basename = "OSGI-INF/l10n/bundle";
        }
        List resourceList = this.createResourceList(basename, locale);
        Properties mergedProperties = new Properties();
        Iterator<Object> it2 = resourceList.iterator();
        while (it2.hasNext()) {
            URL temp = loader.getResource(it2.next() + ".properties");
            if (temp == null) continue;
            try {
                mergedProperties.load(temp.openConnection().getInputStream());
            }
            catch (IOException ex) {}
        }
        it2 = headers.entrySet().iterator();
        while (it2.hasNext()) {
            Map.Entry entry = (Map.Entry)it2.next();
            String value = (String)entry.getValue();
            if (!value.startsWith("%")) continue;
            String key = value.substring(value.indexOf("%") + 1);
            String newvalue = mergedProperties.getProperty(key);
            if (newvalue == null) {
                newvalue = key;
            }
            entry.setValue(newvalue);
        }
        this.updateHeaderCache(locale, headers);
        return headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHeaderCache(String locale, Map localizedHeaders) {
        Map map = this.m_cachedHeaders;
        synchronized (map) {
            this.m_cachedHeaders.put(locale, localizedHeaders);
            this.m_cachedHeadersTimestamp = System.currentTimeMillis();
        }
    }

    private List createResourceList(String basename, String locale) {
        ArrayList<String> result = new ArrayList<String>(4);
        StringBuffer tempLocale = new StringBuffer(basename);
        result.add(tempLocale.toString());
        if (locale.length() > 0) {
            StringTokenizer tokens = new StringTokenizer(locale, "_");
            while (tokens.hasMoreTokens()) {
                tempLocale.append("_").append(tokens.nextToken());
                result.add(tempLocale.toString());
            }
        }
        return result;
    }

    public synchronized int getState() {
        return this.m_state;
    }

    public synchronized void setState(int i) {
        this.m_state = i;
    }

    public abstract long getLastModified();

    public abstract void setLastModified(long var1);

    public abstract int getPersistentState();

    public abstract void setPersistentStateInactive();

    public abstract void setPersistentStateActive();

    public abstract void setPersistentStateUninstalled();

    public synchronized BundleContext getBundleContext() {
        return this.m_context;
    }

    public synchronized void setBundleContext(BundleContext context) {
        this.m_context = context;
    }

    public synchronized BundleActivator getActivator() {
        return this.m_activator;
    }

    public synchronized void setActivator(BundleActivator activator) {
        this.m_activator = activator;
    }

    public synchronized boolean isStale() {
        return this.m_stale;
    }

    public synchronized void setStale() {
        this.m_stale = true;
    }

    public synchronized boolean isExtension() {
        return this.m_extension;
    }

    public synchronized void setExtension(boolean extension) {
        this.m_extension = extension;
    }

    public synchronized boolean isLockable() {
        return this.m_lockCount == 0 || this.m_lockThread == Thread.currentThread();
    }

    public synchronized void lock() {
        if (this.m_lockCount > 0 && this.m_lockThread != Thread.currentThread()) {
            throw new IllegalStateException("Bundle is locked by another thread.");
        }
        ++this.m_lockCount;
        this.m_lockThread = Thread.currentThread();
    }

    public synchronized void unlock() {
        if (this.m_lockCount == 0) {
            throw new IllegalStateException("Bundle is not locked.");
        }
        if (this.m_lockCount > 0 && this.m_lockThread != Thread.currentThread()) {
            throw new IllegalStateException("Bundle is locked by another thread.");
        }
        --this.m_lockCount;
        if (this.m_lockCount == 0) {
            this.m_lockThread = null;
        }
    }

    public synchronized void syncLock(BundleInfo info) {
        this.m_lockCount = info.m_lockCount;
        this.m_lockThread = info.m_lockThread;
    }

    public synchronized void setProtectionDomain(ProtectionDomain pd) {
        this.getCurrentModule().getContentLoader().setSecurityContext(pd);
    }

    public synchronized ProtectionDomain getProtectionDomain() {
        ProtectionDomain pd = null;
        for (int i = this.m_modules.length - 1; i >= 0 && pd == null; --i) {
            pd = (ProtectionDomain)this.m_modules[i].getContentLoader().getSecurityContext();
        }
        return pd;
    }
}

