/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.File;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.PropertyPermission;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.FelixBundle;
import org.apache.felix.framework.FilterImpl;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.ext.FelixBundleContext;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;

class BundleContextImpl
implements FelixBundleContext {
    private Logger m_logger = null;
    private Felix m_felix = null;
    private FelixBundle m_bundle = null;
    private boolean m_valid = true;

    protected BundleContextImpl(Logger logger, Felix felix, FelixBundle bundle) {
        this.m_logger = logger;
        this.m_felix = felix;
        this.m_bundle = bundle;
    }

    protected void invalidate() {
        this.m_valid = false;
    }

    public void addRequirement(String s) throws BundleException {
        throw new BundleException("Not implemented yet.");
    }

    public void removeRequirement() throws BundleException {
        throw new BundleException("Not implemented yet.");
    }

    public void addCapability() throws BundleException {
        throw new BundleException("Not implemented yet.");
    }

    public void removeCapability() throws BundleException {
        throw new BundleException("Not implemented yet.");
    }

    public String getProperty(String name) {
        this.checkValidity();
        SecurityManager sm = System.getSecurityManager();
        if (!(sm == null || "org.osgi.framework.version".equals(name) || "org.osgi.framework.vendor".equals(name) || "org.osgi.framework.language".equals(name) || "org.osgi.framework.os.name".equals(name) || "org.osgi.framework.os.version".equals(name) || "org.osgi.framework.processor".equals(name))) {
            sm.checkPermission(new PropertyPermission(name, "read"));
        }
        return this.m_felix.getProperty(name);
    }

    public Bundle getBundle() {
        this.checkValidity();
        return this.m_bundle;
    }

    public Filter createFilter(String expr) throws InvalidSyntaxException {
        this.checkValidity();
        return new FilterImpl(this.m_logger, expr);
    }

    public Bundle installBundle(String location) throws BundleException {
        return this.installBundle(location, null);
    }

    public Bundle installBundle(String location, InputStream is) throws BundleException {
        this.checkValidity();
        Bundle result = null;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            result = this.m_felix.installBundle(location, is);
            sm.checkPermission(new AdminPermission(result, "lifecycle"));
        } else {
            result = this.m_felix.installBundle(location, is);
        }
        return result;
    }

    public Bundle getBundle(long id) {
        this.checkValidity();
        return this.m_felix.getBundle(id);
    }

    public Bundle[] getBundles() {
        this.checkValidity();
        return this.m_felix.getBundles();
    }

    public void addBundleListener(BundleListener l) {
        this.checkValidity();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && l instanceof SynchronousBundleListener) {
            sm.checkPermission(new AdminPermission(this.m_bundle, "listener"));
        }
        this.m_felix.addBundleListener(this.m_bundle, l);
    }

    public void removeBundleListener(BundleListener l) {
        this.checkValidity();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && l instanceof SynchronousBundleListener) {
            sm.checkPermission(new AdminPermission(this.m_bundle, "listener"));
        }
        this.m_felix.removeBundleListener(this.m_bundle, l);
    }

    public void addServiceListener(ServiceListener l) {
        try {
            this.addServiceListener(l, null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
    }

    public void addServiceListener(ServiceListener l, String s) throws InvalidSyntaxException {
        this.checkValidity();
        this.m_felix.addServiceListener(this.m_bundle, l, s);
    }

    public void removeServiceListener(ServiceListener l) {
        this.checkValidity();
        this.m_felix.removeServiceListener(this.m_bundle, l);
    }

    public void addFrameworkListener(FrameworkListener l) {
        this.checkValidity();
        this.m_felix.addFrameworkListener(this.m_bundle, l);
    }

    public void removeFrameworkListener(FrameworkListener l) {
        this.checkValidity();
        this.m_felix.removeFrameworkListener(this.m_bundle, l);
    }

    public ServiceRegistration registerService(String clazz, Object svcObj, Dictionary dict) {
        return this.registerService(new String[]{clazz}, svcObj, dict);
    }

    public ServiceRegistration registerService(String[] clazzes, Object svcObj, Dictionary dict) {
        this.checkValidity();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && clazzes != null) {
            for (int i = 0; i < clazzes.length; ++i) {
                sm.checkPermission(new ServicePermission(clazzes[i], "register"));
            }
        }
        return this.m_felix.registerService(this.m_bundle, clazzes, svcObj, dict);
    }

    public ServiceReference getServiceReference(String clazz) {
        this.checkValidity();
        try {
            ServiceReference[] refs = this.getServiceReferences(clazz, null);
            return this.getBestServiceReference(refs);
        }
        catch (InvalidSyntaxException ex) {
            this.m_logger.log(1, "BundleContextImpl: " + ex);
            return null;
        }
    }

    private ServiceReference getBestServiceReference(ServiceReference[] refs) {
        if (refs == null) {
            return null;
        }
        if (refs.length == 1) {
            return refs[0];
        }
        ServiceReference bestRef = refs[0];
        for (int i = 1; i < refs.length; ++i) {
            if (bestRef.compareTo(refs[i]) >= 0) continue;
            bestRef = refs[i];
        }
        return bestRef;
    }

    public ServiceReference[] getAllServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        this.checkValidity();
        return this.m_felix.getAllowedServiceReferences(this.m_bundle, clazz, filter, false);
    }

    public ServiceReference[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        this.checkValidity();
        return this.m_felix.getAllowedServiceReferences(this.m_bundle, clazz, filter, true);
    }

    public Object getService(ServiceReference ref) {
        this.checkValidity();
        if (ref == null) {
            throw new NullPointerException("Specified service reference cannot be null.");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            String[] objectClass = (String[])ref.getProperty("objectClass");
            if (objectClass == null) {
                return null;
            }
            boolean hasPermission = false;
            for (int i = 0; i < objectClass.length && !hasPermission; ++i) {
                try {
                    sm.checkPermission(new ServicePermission(objectClass[i], "get"));
                    hasPermission = true;
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (!hasPermission) {
                throw new SecurityException("No permission");
            }
        }
        return this.m_felix.getService(this.m_bundle, ref);
    }

    public boolean ungetService(ServiceReference ref) {
        this.checkValidity();
        if (ref == null) {
            throw new NullPointerException("Specified service reference cannot be null.");
        }
        return this.m_felix.ungetService(this.m_bundle, ref);
    }

    public File getDataFile(String s) {
        this.checkValidity();
        return this.m_felix.getDataFile(this.m_bundle, s);
    }

    private void checkValidity() {
        if (this.m_valid) {
            switch (this.m_bundle.getInfo().getState()) {
                case 8: 
                case 16: 
                case 32: {
                    return;
                }
            }
        }
        throw new IllegalStateException("Invalid BundleContext.");
    }
}

