/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.ContentHandler;
import java.net.ContentHandlerFactory;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.felix.framework.URLHandlersBundleStreamHandler;
import org.apache.felix.framework.URLHandlersContentHandlerProxy;
import org.apache.felix.framework.URLHandlersStreamHandlerProxy;
import org.apache.felix.framework.util.SecureAction;
import org.apache.felix.framework.util.SecurityManagerEx;

class URLHandlers
implements URLStreamHandlerFactory,
ContentHandlerFactory {
    private static final String FELIX_2_0_CLASSLOADER_CLASS_NAME = "org.apache.felix.framework.ModuleImpl$ModuleClassLoader";
    private static final String STREAM_HANDLER_PACKAGE_PROP = "java.protocol.handler.pkgs";
    private static final String CONTENT_HANDLER_PACKAGE_PROP = "java.content.handler.pkgs";
    private static final String DEFAULT_STREAM_HANDLER_PACKAGE = "sun.net.www.protocol|com.ibm.oti.net.www.protocol|gnu.java.net.protocol|wonka.net|com.acunia.wonka.net|org.apache.harmony.luni.internal.net.www.protocol|weblogic.utils|weblogic.net|javax.net.ssl|COM.newmonics.www.protocols";
    private static final String DEFAULT_CONTENT_HANDLER_PACKAGE = "sun.net.www.content|com.ibm.oti.net.www.content|gnu.java.net.content|org.apache.harmony.luni.internal.net.www.content|COM.newmonics.www.content";
    private static final SecureAction m_secureAction = new SecureAction();
    private static SecurityManagerEx m_sm = null;
    private static URLHandlers m_handler = null;
    private static Map m_classloaderToFrameworkLists = new HashMap();
    private static final List m_frameworks = new ArrayList();
    private static Map m_contentHandlerCache = null;
    private static Map m_streamHandlerCache = null;
    private static URLStreamHandlerFactory m_streamHandlerFactory;
    private static ContentHandlerFactory m_contentHandlerFactory;
    private static Object m_rootURLHandlers;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$net$URLStreamHandlerFactory;
    static /* synthetic */ Class class$org$apache$felix$framework$URLHandlers;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$net$URLConnection;
    static /* synthetic */ Class class$java$net$ContentHandlerFactory;
    static /* synthetic */ Class class$org$apache$felix$framework$searchpolicy$ContentClassLoader;
    static /* synthetic */ Class class$java$lang$Class;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URLHandlers() {
        Class clazz = class$java$net$URL == null ? (class$java$net$URL = URLHandlers.class$("java.net.URL")) : class$java$net$URL;
        synchronized (clazz) {
            try {
                URL.setURLStreamHandlerFactory(this);
                m_streamHandlerFactory = this;
                m_rootURLHandlers = m_streamHandlerFactory;
            }
            catch (Error err) {
                try {
                    m_streamHandlerFactory = (URLStreamHandlerFactory)m_secureAction.swapStaticFieldIfNotClass(class$java$net$URL == null ? (class$java$net$URL = URLHandlers.class$("java.net.URL")) : class$java$net$URL, class$java$net$URLStreamHandlerFactory == null ? (class$java$net$URLStreamHandlerFactory = URLHandlers.class$("java.net.URLStreamHandlerFactory")) : class$java$net$URLStreamHandlerFactory, class$org$apache$felix$framework$URLHandlers == null ? (class$org$apache$felix$framework$URLHandlers = URLHandlers.class$("org.apache.felix.framework.URLHandlers")) : class$org$apache$felix$framework$URLHandlers, "streamHandlerLock");
                    if (m_streamHandlerFactory == null) {
                        throw err;
                    }
                    if (!m_streamHandlerFactory.getClass().getName().equals((class$org$apache$felix$framework$URLHandlers == null ? (class$org$apache$felix$framework$URLHandlers = URLHandlers.class$("org.apache.felix.framework.URLHandlers")) : class$org$apache$felix$framework$URLHandlers).getName())) {
                        URL.setURLStreamHandlerFactory(this);
                        m_rootURLHandlers = this;
                    } else if ((class$org$apache$felix$framework$URLHandlers == null ? (class$org$apache$felix$framework$URLHandlers = URLHandlers.class$("org.apache.felix.framework.URLHandlers")) : class$org$apache$felix$framework$URLHandlers) != m_streamHandlerFactory.getClass()) {
                        try {
                            m_secureAction.invoke(m_secureAction.getDeclaredMethod(m_streamHandlerFactory.getClass(), "registerFrameworkListsForContextSearch", new Class[]{class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = URLHandlers.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader, class$java$util$List == null ? (class$java$util$List = URLHandlers.class$("java.util.List")) : class$java$util$List}), m_streamHandlerFactory, new Object[]{(class$org$apache$felix$framework$URLHandlers == null ? (class$org$apache$felix$framework$URLHandlers = URLHandlers.class$("org.apache.felix.framework.URLHandlers")) : class$org$apache$felix$framework$URLHandlers).getClassLoader(), m_frameworks});
                            m_rootURLHandlers = m_streamHandlerFactory;
                        }
                        catch (Exception ex) {
                            new RuntimeException(ex.getMessage());
                        }
                    }
                }
                catch (Exception e) {
                    throw err;
                }
            }
            try {
                URLConnection.setContentHandlerFactory(this);
                m_contentHandlerFactory = this;
            }
            catch (Error err) {
                try {
                    m_contentHandlerFactory = (ContentHandlerFactory)m_secureAction.swapStaticFieldIfNotClass(class$java$net$URLConnection == null ? (class$java$net$URLConnection = URLHandlers.class$("java.net.URLConnection")) : class$java$net$URLConnection, class$java$net$ContentHandlerFactory == null ? (class$java$net$ContentHandlerFactory = URLHandlers.class$("java.net.ContentHandlerFactory")) : class$java$net$ContentHandlerFactory, class$org$apache$felix$framework$URLHandlers == null ? (class$org$apache$felix$framework$URLHandlers = URLHandlers.class$("org.apache.felix.framework.URLHandlers")) : class$org$apache$felix$framework$URLHandlers, null);
                    if (m_contentHandlerFactory == null) {
                        throw err;
                    }
                    if (!m_contentHandlerFactory.getClass().getName().equals((class$org$apache$felix$framework$URLHandlers == null ? (class$org$apache$felix$framework$URLHandlers = URLHandlers.class$("org.apache.felix.framework.URLHandlers")) : class$org$apache$felix$framework$URLHandlers).getName())) {
                        URLConnection.setContentHandlerFactory(this);
                    }
                }
                catch (Exception ex) {
                    throw err;
                }
            }
        }
        if (m_streamHandlerFactory == this || !(class$org$apache$felix$framework$URLHandlers == null ? (class$org$apache$felix$framework$URLHandlers = URLHandlers.class$("org.apache.felix.framework.URLHandlers")) : class$org$apache$felix$framework$URLHandlers).getName().equals(m_streamHandlerFactory.getClass().getName())) {
            m_sm = new SecurityManagerEx();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerFrameworkListsForContextSearch(ClassLoader index, List frameworkLists) {
        Class clazz = class$java$net$URL == null ? (class$java$net$URL = URLHandlers.class$("java.net.URL")) : class$java$net$URL;
        synchronized (clazz) {
            Map map = m_classloaderToFrameworkLists;
            synchronized (map) {
                m_classloaderToFrameworkLists.put(index, frameworkLists);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unregisterFrameworkListsForContextSearch(ClassLoader index) {
        Class clazz = class$java$net$URL == null ? (class$java$net$URL = URLHandlers.class$("java.net.URL")) : class$java$net$URL;
        synchronized (clazz) {
            Map map = m_classloaderToFrameworkLists;
            synchronized (map) {
                m_classloaderToFrameworkLists.remove(index);
                if (m_classloaderToFrameworkLists.isEmpty()) {
                    List list = m_frameworks;
                    synchronized (list) {
                        if (m_frameworks.isEmpty()) {
                            try {
                                m_secureAction.swapStaticFieldIfNotClass(class$java$net$URL == null ? (class$java$net$URL = URLHandlers.class$("java.net.URL")) : class$java$net$URL, class$java$net$URLStreamHandlerFactory == null ? (class$java$net$URLStreamHandlerFactory = URLHandlers.class$("java.net.URLStreamHandlerFactory")) : class$java$net$URLStreamHandlerFactory, null, "streamHandlerLock");
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            if (m_streamHandlerFactory.getClass() != (class$org$apache$felix$framework$URLHandlers == null ? (class$org$apache$felix$framework$URLHandlers = URLHandlers.class$("org.apache.felix.framework.URLHandlers")) : class$org$apache$felix$framework$URLHandlers)) {
                                URL.setURLStreamHandlerFactory(m_streamHandlerFactory);
                            }
                            try {
                                m_secureAction.swapStaticFieldIfNotClass(class$java$net$URLConnection == null ? (class$java$net$URLConnection = URLHandlers.class$("java.net.URLConnection")) : class$java$net$URLConnection, class$java$net$ContentHandlerFactory == null ? (class$java$net$ContentHandlerFactory = URLHandlers.class$("java.net.ContentHandlerFactory")) : class$java$net$ContentHandlerFactory, null, null);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            if (m_contentHandlerFactory.getClass() != (class$org$apache$felix$framework$URLHandlers == null ? (class$org$apache$felix$framework$URLHandlers = URLHandlers.class$("org.apache.felix.framework.URLHandlers")) : class$org$apache$felix$framework$URLHandlers)) {
                                URLConnection.setContentHandlerFactory(m_contentHandlerFactory);
                            }
                        }
                    }
                }
            }
        }
    }

    public URLStreamHandler createURLStreamHandler(String protocol) {
        URLHandlers uRLHandlers = this;
        synchronized (uRLHandlers) {
            URLStreamHandler handler = m_streamHandlerCache != null ? m_streamHandlerCache.get(protocol) : null;
            if (handler != null) {
                return handler;
            }
            if (protocol.equals("bundle")) {
                return this.addToStreamCache(protocol, new URLHandlersBundleStreamHandler(m_secureAction));
            }
            if (protocol.equals("felix")) {
                return this.addToStreamCache(protocol, new URLStreamHandler(){

                    protected URLConnection openConnection(URL url) throws IOException {
                        Object framework = URLHandlers.getFrameworkFromContext();
                        try {
                            Object handler = m_secureAction.getDeclaredField(framework.getClass(), "m_extensionManager", framework);
                            return (URLConnection)m_secureAction.invoke(m_secureAction.getMethod(handler.getClass(), "openConnection", new Class[]{class$java$net$URL == null ? (class$java$net$URL = URLHandlers.class$("java.net.URL")) : class$java$net$URL}), handler, new Object[]{url});
                        }
                        catch (Exception ex) {
                            throw new IOException(ex.getMessage());
                        }
                    }
                });
            }
            if (m_streamHandlerFactory != this && (handler = this.addToStreamCache(protocol, m_streamHandlerFactory.createURLStreamHandler(protocol))) != null) {
                return handler;
            }
            String pkgs = m_secureAction.getSystemProperty(STREAM_HANDLER_PACKAGE_PROP, "");
            pkgs = pkgs.equals("") ? DEFAULT_STREAM_HANDLER_PACKAGE : pkgs + "|" + DEFAULT_STREAM_HANDLER_PACKAGE;
            StringTokenizer pkgTok = new StringTokenizer(pkgs, "| ");
            while (pkgTok.hasMoreTokens()) {
                String pkg = pkgTok.nextToken().trim();
                String className = pkg + "." + protocol + ".Handler";
                try {
                    if (m_secureAction.forName(className) == null) continue;
                    return null;
                }
                catch (Exception ex) {
                }
            }
            try {
                return this.addToStreamCache(protocol, new URLHandlersStreamHandlerProxy(protocol, m_secureAction));
            }
            catch (NoClassDefFoundError e) {
                try {
                    Class<?> obj = this.getClass().getClassLoader().loadClass("org.apache.felix.framework.URLHandlersStreamHandlerProxy");
                    Constructor<?> c1 = obj.getConstructor(protocol.getClass(), m_secureAction.getClass());
                    return (URLStreamHandler)c1.newInstance(protocol, m_secureAction);
                }
                catch (Exception ex) {
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentHandler createContentHandler(String mimeType) {
        URLHandlers uRLHandlers = this;
        synchronized (uRLHandlers) {
            ContentHandler handler = m_contentHandlerCache != null ? m_contentHandlerCache.get(mimeType) : null;
            if (handler != null) {
                return handler;
            }
            if (m_contentHandlerFactory != this && (handler = this.addToContentCache(mimeType, m_contentHandlerFactory.createContentHandler(mimeType))) != null) {
                return handler;
            }
            String pkgs = m_secureAction.getSystemProperty(CONTENT_HANDLER_PACKAGE_PROP, "");
            pkgs = pkgs.equals("") ? DEFAULT_CONTENT_HANDLER_PACKAGE : pkgs + "|" + DEFAULT_CONTENT_HANDLER_PACKAGE;
            String fixedType = mimeType.replace('.', '_').replace('/', '.').replace('-', '_');
            StringTokenizer pkgTok = new StringTokenizer(pkgs, "| ");
            while (pkgTok.hasMoreTokens()) {
                String pkg = pkgTok.nextToken().trim();
                String className = pkg + "." + fixedType;
                try {
                    if (m_secureAction.forName(className) == null) continue;
                    return null;
                }
                catch (Exception ex) {
                }
            }
            return this.addToContentCache(mimeType, new URLHandlersContentHandlerProxy(mimeType, m_secureAction));
        }
    }

    private ContentHandler addToContentCache(String mimeType, ContentHandler handler) {
        if (handler == null) {
            return null;
        }
        if (m_contentHandlerCache == null) {
            m_contentHandlerCache = new HashMap();
            m_contentHandlerCache.put(mimeType, handler);
        } else {
            ContentHandler result = (ContentHandler)m_contentHandlerCache.get(mimeType);
            if (result == null) {
                m_contentHandlerCache.put(mimeType, handler);
            } else {
                handler = result;
            }
        }
        return handler;
    }

    private URLStreamHandler addToStreamCache(String protocol, URLStreamHandler handler) {
        if (handler == null) {
            return null;
        }
        if (m_streamHandlerCache == null) {
            m_streamHandlerCache = new HashMap();
            m_streamHandlerCache.put(protocol, handler);
        } else {
            URLStreamHandler result = (URLStreamHandler)m_streamHandlerCache.get(protocol);
            if (result == null) {
                m_streamHandlerCache.put(protocol, handler);
            } else {
                handler = result;
            }
        }
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerFrameworkInstance(Object framework, boolean enable) {
        List list = m_frameworks;
        synchronized (list) {
            if (enable) {
                if (m_handler == null) {
                    m_handler = new URLHandlers();
                }
                m_frameworks.add(framework);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterFrameworkInstance(Object framework) {
        List list = m_frameworks;
        synchronized (list) {
            if (m_frameworks.remove(framework) && m_frameworks.isEmpty()) {
                if (m_handler == m_rootURLHandlers) {
                    URLHandlers.unregisterFrameworkListsForContextSearch((class$org$apache$felix$framework$URLHandlers == null ? (class$org$apache$felix$framework$URLHandlers = URLHandlers.class$("org.apache.felix.framework.URLHandlers")) : class$org$apache$felix$framework$URLHandlers).getClassLoader());
                } else {
                    try {
                        m_secureAction.invoke(m_secureAction.getDeclaredMethod(m_rootURLHandlers.getClass(), "unregisterFrameworkListsForContextSearch", new Class[]{class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = URLHandlers.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader}), m_rootURLHandlers, new Object[]{(class$org$apache$felix$framework$URLHandlers == null ? (class$org$apache$felix$framework$URLHandlers = URLHandlers.class$("org.apache.felix.framework.URLHandlers")) : class$org$apache$felix$framework$URLHandlers).getClassLoader()});
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                m_handler = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getFrameworkFromContext() {
        Class[] stack = m_sm.getClassContext();
        Class targetClass = null;
        for (int i = 0; i < stack.length; ++i) {
            if (stack[i].getClassLoader() == null) continue;
            String className = stack[i].getClassLoader().getClass().getName();
            if (!(class$org$apache$felix$framework$searchpolicy$ContentClassLoader == null ? URLHandlers.class$("org.apache.felix.framework.searchpolicy.ContentClassLoader") : class$org$apache$felix$framework$searchpolicy$ContentClassLoader).getName().equals(className) && !FELIX_2_0_CLASSLOADER_CLASS_NAME.equals(className)) continue;
            targetClass = stack[i];
            break;
        }
        if (targetClass != null) {
            Map map = m_classloaderToFrameworkLists;
            synchronized (map) {
                ClassLoader index = targetClass.getClassLoader().getClass().getClassLoader();
                List frameworks = (List)m_classloaderToFrameworkLists.get(index);
                if (frameworks == null && index == (class$org$apache$felix$framework$URLHandlers == null ? (class$org$apache$felix$framework$URLHandlers = URLHandlers.class$("org.apache.felix.framework.URLHandlers")) : class$org$apache$felix$framework$URLHandlers).getClassLoader()) {
                    frameworks = m_frameworks;
                }
                if (frameworks != null) {
                    List list = frameworks;
                    synchronized (list) {
                        for (int i = 0; i < frameworks.size(); ++i) {
                            Object framework = frameworks.get(i);
                            try {
                                Class[] classArray = new Class[1];
                                Class clazz = classArray[0] = class$java$lang$Class == null ? URLHandlers.class$("java.lang.Class") : class$java$lang$Class;
                                if (m_secureAction.invoke(m_secureAction.getDeclaredMethod(framework.getClass(), "getBundle", classArray), framework, new Object[]{targetClass}) == null) continue;
                                return framework;
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                }
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

