/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.searchpolicy;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.felix.framework.searchpolicy.ContentLoaderImpl;
import org.apache.felix.framework.util.Util;
import org.apache.felix.moduleloader.IContent;
import org.apache.felix.moduleloader.IContentLoader;
import org.apache.felix.moduleloader.JarContent;
import org.apache.felix.moduleloader.ResourceNotFoundException;

public class ContentClassLoader
extends SecureClassLoader {
    private static final Constructor m_dexFileClassConstructor;
    private static final Method m_dexFileClassLoadClass;
    private ContentLoaderImpl m_contentLoader = null;
    private ProtectionDomain m_protectionDomain = null;
    private Map m_jarContentToDexFile = null;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public ContentClassLoader(ContentLoaderImpl contentLoader, ProtectionDomain protectionDomain) {
        this.m_contentLoader = contentLoader;
        this.m_protectionDomain = protectionDomain;
        if (m_dexFileClassConstructor != null) {
            this.m_jarContentToDexFile = new HashMap();
        }
    }

    public IContentLoader getContentLoader() {
        return this.m_contentLoader;
    }

    protected Class loadClassFromModule(String name) throws ClassNotFoundException {
        Class clazz = this.findClass(name);
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class clazz = null;
        ContentClassLoader contentClassLoader = this;
        synchronized (contentClassLoader) {
            clazz = this.findLoadedClass(name);
        }
        if (clazz == null) {
            clazz = this.m_contentLoader.getSearchPolicy().findClass(name);
        }
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class findClass(String name) throws ClassNotFoundException {
        Class<?> clazz = null;
        ContentClassLoader contentClassLoader = this;
        synchronized (contentClassLoader) {
            clazz = this.findLoadedClass(name);
        }
        if (clazz == null) {
            String actual = name.replace('.', '/') + ".class";
            byte[] bytes = null;
            IContent content = null;
            for (int i = 0; bytes == null && i < this.m_contentLoader.getClassPath().length; ++i) {
                bytes = this.m_contentLoader.getClassPath()[i].getEntry(actual);
                content = this.m_contentLoader.getClassPath()[i];
            }
            if (bytes != null) {
                ContentClassLoader contentClassLoader2 = this;
                synchronized (contentClassLoader2) {
                    clazz = this.findLoadedClass(name);
                    if (clazz == null) {
                        String pkgName = Util.getClassPackage(name);
                        if (pkgName.length() > 0 && this.getPackage(pkgName) == null) {
                            Object[] params = this.m_contentLoader.getSearchPolicy().definePackage(pkgName);
                            if (params != null) {
                                this.definePackage(pkgName, (String)params[0], (String)params[1], (String)params[2], (String)params[3], (String)params[4], (String)params[5], null);
                            } else {
                                this.definePackage(pkgName, null, null, null, null, null, null, null);
                            }
                        }
                        if (content instanceof JarContent) {
                            try {
                                clazz = this.getDexFileClass((JarContent)content, name, this);
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                        if (clazz == null) {
                            clazz = this.m_protectionDomain != null ? this.defineClass(name, bytes, 0, bytes.length, this.m_protectionDomain) : this.defineClass(name, bytes, 0, bytes.length);
                        }
                    }
                }
            }
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class getDexFileClass(JarContent content, String name, ClassLoader loader) throws Exception {
        if (this.m_jarContentToDexFile == null) {
            return null;
        }
        Object dexFile = null;
        if (!this.m_jarContentToDexFile.containsKey(content)) {
            try {
                dexFile = m_dexFileClassConstructor.newInstance(content.getFile());
            }
            finally {
                this.m_jarContentToDexFile.put(content, dexFile);
            }
        } else {
            dexFile = this.m_jarContentToDexFile.get(content);
        }
        if (dexFile != null) {
            return (Class)m_dexFileClassLoadClass.invoke(dexFile, name.replace('.', '/'), loader);
        }
        return null;
    }

    public URL getResourceFromModule(String name) {
        try {
            return this.findResource(name);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public URL getResource(String name) {
        try {
            return this.m_contentLoader.getSearchPolicy().findResource(name);
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            return null;
        }
    }

    protected URL findResource(String name) {
        try {
            return this.m_contentLoader.getSearchPolicy().findResource(name);
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            return null;
        }
    }

    protected Enumeration findResources(String name) {
        try {
            return this.m_contentLoader.getSearchPolicy().findResources(name);
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            return null;
        }
    }

    protected String findLibrary(String name) {
        return this.m_contentLoader.getSearchPolicy().findLibrary(name);
    }

    public String toString() {
        return this.m_contentLoader.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Constructor<?> dexFileClassConstructor = null;
        Method dexFileClassLoadClass = null;
        try {
            Class<?> dexFileClass = Class.forName("android.dalvik.DexFile");
            dexFileClassConstructor = dexFileClass.getConstructor(class$java$io$File == null ? (class$java$io$File = ContentClassLoader.class$("java.io.File")) : class$java$io$File);
            dexFileClassLoadClass = dexFileClass.getMethod("loadClass", class$java$lang$String == null ? (class$java$lang$String = ContentClassLoader.class$("java.lang.String")) : class$java$lang$String, class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = ContentClassLoader.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
        }
        catch (Exception ex) {
            dexFileClassConstructor = null;
            dexFileClassLoadClass = null;
        }
        m_dexFileClassConstructor = dexFileClassConstructor;
        m_dexFileClassLoadClass = dexFileClassLoadClass;
    }
}

