/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.cache;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.cache.BundleArchive;
import org.apache.felix.framework.util.SecureAction;

public class BundleCache {
    public static final String CACHE_BUFSIZE_PROP = "felix.cache.bufsize";
    public static final String CACHE_DIR_PROP = "felix.cache.dir";
    public static final String CACHE_PROFILE_DIR_PROP = "felix.cache.profiledir";
    public static final String CACHE_PROFILE_PROP = "felix.cache.profile";
    protected static transient int BUFSIZE = 4096;
    protected static final transient String CACHE_DIR_NAME = ".felix";
    protected static final transient String BUNDLE_DIR_PREFIX = "bundle";
    private Map m_configMap = null;
    private Logger m_logger = null;
    private File m_profileDir = null;
    private BundleArchive[] m_archives = null;
    private static SecureAction m_secureAction = new SecureAction();

    public BundleCache(Logger logger, Map configMap) throws Exception {
        this.m_configMap = configMap;
        this.m_logger = logger;
        this.initialize();
    }

    static SecureAction getSecureAction() {
        return m_secureAction;
    }

    public synchronized BundleArchive[] getArchives() throws Exception {
        return this.m_archives;
    }

    public synchronized BundleArchive getArchive(long id) throws Exception {
        for (int i = 0; i < this.m_archives.length; ++i) {
            if (this.m_archives[i].getId() != id) continue;
            return this.m_archives[i];
        }
        return null;
    }

    public synchronized int getArchiveIndex(BundleArchive ba) {
        for (int i = 0; i < this.m_archives.length; ++i) {
            if (this.m_archives[i] != ba) continue;
            return i;
        }
        return -1;
    }

    public synchronized BundleArchive create(long id, String location, InputStream is) throws Exception {
        File archiveRootDir = new File(this.m_profileDir, BUNDLE_DIR_PREFIX + Long.toString(id));
        try {
            BundleArchive ba = new BundleArchive(this.m_logger, archiveRootDir, id, location, is);
            BundleArchive[] tmp = new BundleArchive[this.m_archives.length + 1];
            System.arraycopy(this.m_archives, 0, tmp, 0, this.m_archives.length);
            tmp[this.m_archives.length] = ba;
            this.m_archives = tmp;
            return ba;
        }
        catch (Exception ex) {
            if (m_secureAction.fileExists(archiveRootDir) && !BundleCache.deleteDirectoryTree(archiveRootDir)) {
                this.m_logger.log(1, this.getClass().getName() + ": Unable to delete the archive directory - " + archiveRootDir);
            }
            throw ex;
        }
    }

    public synchronized void remove(BundleArchive ba) throws Exception {
        if (ba != null) {
            ba.dispose();
            int idx = this.getArchiveIndex(ba);
            if (idx >= 0) {
                BundleArchive[] tmp = new BundleArchive[this.m_archives.length - 1];
                System.arraycopy(this.m_archives, 0, tmp, 0, idx);
                if (idx < tmp.length) {
                    System.arraycopy(this.m_archives, idx + 1, tmp, idx, tmp.length - idx);
                }
                this.m_archives = tmp;
            }
        }
    }

    public synchronized File getSystemBundleDataFile(String fileName) throws Exception {
        File sbDir = new File(this.m_profileDir, BUNDLE_DIR_PREFIX + Long.toString(0L));
        if (!BundleCache.getSecureAction().fileExists(sbDir) && !BundleCache.getSecureAction().mkdirs(sbDir)) {
            this.m_logger.log(1, this.getClass().getName() + ": Unable to create system bundle directory.");
            throw new IOException("Unable to create system bundle directory.");
        }
        if (fileName.length() > 0 && fileName.charAt(0) == File.separatorChar) {
            throw new IllegalArgumentException("The data file path must be relative, not absolute.");
        }
        if (fileName.indexOf("..") >= 0) {
            throw new IllegalArgumentException("The data file path cannot contain a reference to the \"..\" directory.");
        }
        return new File(sbDir, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void copyStreamToFile(InputStream is, File outputFile) throws IOException {
        OutputStream os;
        block6: {
            os = null;
            try {
                os = BundleCache.getSecureAction().getFileOutputStream(outputFile);
                os = new BufferedOutputStream(os, BUFSIZE);
                byte[] b = new byte[BUFSIZE];
                int len = 0;
                while ((len = is.read(b)) != -1) {
                    os.write(b, 0, len);
                }
                Object var6_5 = null;
                if (is == null) break block6;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
                throw throwable;
            }
            is.close();
        }
        if (os != null) {
            os.close();
        }
    }

    protected static boolean deleteDirectoryTree(File target) {
        if (!BundleCache.getSecureAction().fileExists(target)) {
            return true;
        }
        if (BundleCache.getSecureAction().isFileDirectory(target)) {
            File[] files = BundleCache.getSecureAction().listDirectory(target);
            for (int i = 0; i < files.length; ++i) {
                BundleCache.deleteDirectoryTree(files[i]);
            }
        }
        return BundleCache.getSecureAction().deleteFile(target);
    }

    private void initialize() throws Exception {
        try {
            String sBufSize = (String)this.m_configMap.get(CACHE_BUFSIZE_PROP);
            if (sBufSize != null) {
                BUFSIZE = Integer.parseInt(sBufSize);
            }
        }
        catch (NumberFormatException ne) {
            // empty catch block
        }
        String profileDirStr = (String)this.m_configMap.get(CACHE_PROFILE_DIR_PROP);
        if (profileDirStr != null) {
            this.m_profileDir = new File(profileDirStr);
        } else {
            String profileName;
            String cacheDirStr = (String)this.m_configMap.get(CACHE_DIR_PROP);
            if (cacheDirStr == null) {
                cacheDirStr = System.getProperty("user.home");
                cacheDirStr = cacheDirStr.endsWith(File.separator) ? cacheDirStr : cacheDirStr + File.separator;
                cacheDirStr = cacheDirStr + CACHE_DIR_NAME;
            }
            if ((profileName = (String)this.m_configMap.get(CACHE_PROFILE_PROP)) == null) {
                throw new IllegalArgumentException("No profile name or directory has been specified.");
            }
            if (profileName.indexOf(File.separator) >= 0) {
                throw new IllegalArgumentException("The profile name cannot contain the file separator character.");
            }
            this.m_profileDir = new File(cacheDirStr, profileName);
        }
        if (!BundleCache.getSecureAction().fileExists(this.m_profileDir) && !BundleCache.getSecureAction().mkdirs(this.m_profileDir)) {
            this.m_logger.log(1, this.getClass().getName() + ": Unable to create directory: " + this.m_profileDir);
            throw new RuntimeException("Unable to create profile directory.");
        }
        ArrayList<BundleArchive> archiveList = new ArrayList<BundleArchive>();
        File[] children = BundleCache.getSecureAction().listDirectory(this.m_profileDir);
        for (int i = 0; children != null && i < children.length; ++i) {
            if (!children[i].getName().startsWith(BUNDLE_DIR_PREFIX) || children[i].getName().equals(BUNDLE_DIR_PREFIX + Long.toString(0L))) continue;
            try {
                archiveList.add(new BundleArchive(this.m_logger, children[i]));
                continue;
            }
            catch (Exception ex) {
                this.m_logger.log(1, this.getClass().getName() + ": Error creating archive.", ex);
            }
        }
        this.m_archives = archiveList.toArray(new BundleArchive[archiveList.size()]);
    }
}

