/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.felix.ipojo.EventDispatcher;
import org.apache.felix.ipojo.IPojoFactory;
import org.apache.felix.ipojo.InstanceCreator;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.parser.ManifestMetadataParser;
import org.apache.felix.ipojo.parser.ParseException;
import org.apache.felix.ipojo.parser.ParseUtils;
import org.apache.felix.ipojo.util.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;

public class Extender
implements SynchronousBundleListener,
BundleActivator {
    static boolean DISPATCHER_ENABLED = true;
    static boolean SYNCHRONOUS_PROCESSING_ENABLED = false;
    private static final String ENABLING_DISPATCHER = "ipojo.internal.dispatcher";
    private static final String SYNCHRONOUS_PROCESSING = "ipojo.processing.synchronous";
    private static final String IPOJO_HEADER = "iPOJO-Components";
    private static final String IPOJO_HEADER_ALT = "IPOJO-Components";
    private static final String IPOJO_EXTENSION = "IPOJO-Extension";
    private static BundleContext m_context;
    private Logger m_logger;
    private InstanceCreator m_creator;
    private Bundle m_bundle;
    private List m_factoryTypes = new ArrayList();
    private final List m_unboundTypes = new ArrayList();
    private final CreatorThread m_processor = new CreatorThread();

    public void bundleChanged(BundleEvent event) {
        if (event.getBundle() == this.m_bundle) {
            return;
        }
        switch (event.getType()) {
            case 2: {
                this.m_processor.addBundle(event.getBundle());
                break;
            }
            case 256: {
                this.m_processor.removeBundle(event.getBundle());
                this.closeManagementFor(event.getBundle());
                break;
            }
        }
    }

    private void closeManagementFor(Bundle bundle) {
        ManagedAbstractFactoryType mft;
        ArrayList<ManagedAbstractFactoryType> toRemove = new ArrayList<ManagedAbstractFactoryType>();
        this.m_creator.removeInstancesFromBundle(bundle.getBundleId());
        for (int k = 0; k < this.m_factoryTypes.size(); ++k) {
            mft = (ManagedAbstractFactoryType)this.m_factoryTypes.get(k);
            if (mft.m_created != null) {
                List cfs = (List)mft.m_created.remove(bundle);
                for (int i = 0; cfs != null && i < cfs.size(); ++i) {
                    IPojoFactory factory = (IPojoFactory)cfs.get(i);
                    this.m_creator.removeFactory(factory);
                    factory.stop();
                }
            }
            if (mft.m_bundle != bundle) continue;
            if (mft.m_created != null) {
                Iterator iterator = mft.m_created.keySet().iterator();
                while (iterator.hasNext()) {
                    Bundle key = (Bundle)iterator.next();
                    List list = (List)mft.m_created.get(key);
                    for (int i = 0; i < list.size(); ++i) {
                        IPojoFactory factory = (IPojoFactory)list.get(i);
                        factory.stop();
                        this.m_unboundTypes.add(new UnboundComponentType(mft.m_type, factory.m_componentMetadata, factory.getBundleContext().getBundle()));
                    }
                }
            }
            toRemove.add(mft);
        }
        for (int i = 0; i < toRemove.size(); ++i) {
            mft = (ManagedAbstractFactoryType)toRemove.get(i);
            this.m_logger.log(3, "The factory type: " + mft.m_type + " is no more available");
            mft.m_bundle = null;
            mft.m_clazz = null;
            mft.m_created = null;
            mft.m_type = null;
            this.m_factoryTypes.remove(mft);
        }
    }

    private void startManagementFor(Bundle bundle) {
        String header;
        Dictionary dict = bundle.getHeaders();
        String typeHeader = (String)dict.get(IPOJO_EXTENSION);
        if (typeHeader != null) {
            this.parseAbstractFactoryType(bundle, typeHeader);
        }
        if ((header = (String)dict.get(IPOJO_HEADER)) == null) {
            header = (String)dict.get(IPOJO_HEADER_ALT);
        }
        if (header != null) {
            try {
                this.parse(bundle, header);
            }
            catch (IOException e) {
                this.m_logger.log(1, "An exception occurs during the parsing of the bundle " + bundle.getBundleId(), e);
            }
            catch (ParseException e) {
                this.m_logger.log(1, "A parse exception occurs during the parsing of the bundle " + bundle.getBundleId(), e);
            }
        }
    }

    private void parseAbstractFactoryType(Bundle bundle, String header) {
        String[] arr = ParseUtils.split(header, ",");
        for (int i = 0; arr != null && i < arr.length; ++i) {
            Class clazz;
            String[] arr2 = ParseUtils.split(arr[i], ":");
            String[] nameparts = ParseUtils.split(arr2[0].trim(), " \t");
            String type = nameparts.length == 1 ? nameparts[0] : nameparts[0] + ":" + nameparts[1];
            try {
                clazz = bundle.loadClass(arr2[1]);
            }
            catch (ClassNotFoundException e) {
                this.m_logger.log(1, "Cannot load the extension " + type, e);
                return;
            }
            ManagedAbstractFactoryType mft = new ManagedAbstractFactoryType(clazz, type, bundle);
            this.m_factoryTypes.add(mft);
            this.m_logger.log(4, "New factory type available: " + type);
            for (int j = this.m_unboundTypes.size() - 1; j >= 0; --j) {
                UnboundComponentType unbound = (UnboundComponentType)this.m_unboundTypes.get(j);
                if (!unbound.m_type.equals(type)) continue;
                this.createAbstractFactory(unbound.m_bundle, unbound.m_description);
                this.m_unboundTypes.remove(unbound);
            }
        }
    }

    private void parse(Bundle bundle, String components) throws IOException, ParseException {
        ManifestMetadataParser parser = new ManifestMetadataParser();
        parser.parseHeader(components);
        Element[] metadata = parser.getComponentsMetadata();
        for (int i = 0; i < metadata.length; ++i) {
            this.createAbstractFactory(bundle, metadata[i]);
        }
        Dictionary[] instances = parser.getInstances();
        for (int i = 0; instances != null && i < instances.length; ++i) {
            this.m_creator.addInstance(instances[i], bundle.getBundleId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext context) {
        m_context = context;
        this.m_bundle = context.getBundle();
        this.m_creator = new InstanceCreator(context);
        this.m_logger = new Logger(m_context, "IPOJO-Extender");
        Extender.enablingDispatcher(context, this.m_logger);
        Extender.enablingSynchronousProcessing(context, this.m_logger);
        if (DISPATCHER_ENABLED) {
            EventDispatcher.create(context);
        }
        this.startManagementFor(this.m_bundle);
        if (!SYNCHRONOUS_PROCESSING_ENABLED) {
            new Thread(this.m_processor).start();
        }
        Extender extender = this;
        synchronized (extender) {
            m_context.addBundleListener((BundleListener)this);
            for (int i = 0; i < context.getBundles().length; ++i) {
                if (context.getBundles()[i].getState() != 32) continue;
                this.m_processor.addBundle(context.getBundles()[i]);
            }
        }
        this.m_logger.log(3, "iPOJO Runtime started");
    }

    public void stop(BundleContext context) {
        this.m_processor.stop();
        m_context.removeBundleListener((BundleListener)this);
        if (DISPATCHER_ENABLED) {
            EventDispatcher.dispose();
        }
        for (int k = 0; k < this.m_factoryTypes.size(); ++k) {
            ManagedAbstractFactoryType mft = (ManagedAbstractFactoryType)this.m_factoryTypes.get(k);
            if (mft.m_created == null) continue;
            Iterator iterator = mft.m_created.keySet().iterator();
            while (iterator.hasNext()) {
                Bundle key = (Bundle)iterator.next();
                List list = (List)mft.m_created.get(key);
                for (int i = 0; i < list.size(); ++i) {
                    IPojoFactory factory = (IPojoFactory)list.get(i);
                    this.m_creator.removeFactory(factory);
                    factory.dispose();
                }
            }
        }
        this.m_factoryTypes = null;
        this.m_creator = null;
        this.m_logger.log(3, "iPOJO Runtime stopped");
        m_context = null;
    }

    public static BundleContext getIPOJOBundleContext() {
        return m_context;
    }

    private static void enablingDispatcher(BundleContext context, Logger logger) {
        String flag = context.getProperty(ENABLING_DISPATCHER);
        if (flag == null) {
            String key = ENABLING_DISPATCHER.replace('.', '-');
            flag = (String)context.getBundle().getHeaders().get(key);
        }
        if (flag != null && flag.equalsIgnoreCase("true")) {
            DISPATCHER_ENABLED = true;
            logger.log(3, "iPOJO Internal Event Dispatcher enables");
            return;
        }
        DISPATCHER_ENABLED = false;
        logger.log(3, "iPOJO Internal Event Dispatcher disables");
    }

    private static void enablingSynchronousProcessing(BundleContext context, Logger logger) {
        String flag = context.getProperty(SYNCHRONOUS_PROCESSING);
        if (flag == null) {
            String key = SYNCHRONOUS_PROCESSING.replace('.', '-');
            flag = (String)context.getBundle().getHeaders().get(key);
        }
        if (flag != null && flag.equalsIgnoreCase("true")) {
            SYNCHRONOUS_PROCESSING_ENABLED = true;
            logger.log(3, "iPOJO Asynchronous processing disabled");
            return;
        }
        SYNCHRONOUS_PROCESSING_ENABLED = false;
        logger.log(3, "iPOJO synchrnous processing disables");
    }

    private void createAbstractFactory(Bundle bundle, Element metadata) {
        ManagedAbstractFactoryType factoryType = null;
        String typeName = metadata.getNameSpace() == null ? metadata.getName() : metadata.getNameSpace() + ":" + metadata.getName();
        for (int i = 0; i < this.m_factoryTypes.size(); ++i) {
            ManagedAbstractFactoryType type = (ManagedAbstractFactoryType)this.m_factoryTypes.get(i);
            if (!type.m_type.equals(typeName)) continue;
            factoryType = type;
            break;
        }
        if (factoryType == null) {
            this.m_logger.log(2, "Type of component not available: " + typeName);
            this.m_unboundTypes.add(new UnboundComponentType(typeName, metadata, bundle));
            return;
        }
        Class clazz = factoryType.m_clazz;
        try {
            Constructor cst = clazz.getConstructor(BundleContext.class, Element.class);
            IPojoFactory factory = (IPojoFactory)cst.newInstance(this.getBundleContext(bundle), metadata);
            if (factoryType.m_created == null) {
                factoryType.m_created = new HashMap();
                ArrayList<IPojoFactory> list = new ArrayList<IPojoFactory>();
                list.add(factory);
                factoryType.m_created.put(bundle, list);
            } else {
                ArrayList<IPojoFactory> list = (ArrayList<IPojoFactory>)factoryType.m_created.get(bundle);
                if (list == null) {
                    list = new ArrayList<IPojoFactory>();
                    list.add(factory);
                    factoryType.m_created.put(bundle, list);
                } else {
                    list.add(factory);
                }
            }
            factory.start();
            this.m_creator.addFactory(factory);
        }
        catch (SecurityException e) {
            this.m_logger.log(1, "Cannot instantiate an abstract factory from " + clazz.getName(), e);
        }
        catch (NoSuchMethodException e) {
            this.m_logger.log(1, "Cannot instantiate an abstract factory from " + clazz.getName() + ": the given class constructor cannot be found");
        }
        catch (IllegalArgumentException e) {
            this.m_logger.log(1, "Cannot instantiate an abstract factory from " + clazz.getName(), e);
        }
        catch (InstantiationException e) {
            this.m_logger.log(1, "Cannot instantiate an abstract factory from " + clazz.getName(), e);
        }
        catch (IllegalAccessException e) {
            this.m_logger.log(1, "Cannot instantiate an abstract factory from " + clazz.getName(), e);
        }
        catch (InvocationTargetException e) {
            this.m_logger.log(1, "Cannot instantiate an abstract factory from " + clazz.getName(), e.getTargetException());
        }
    }

    public BundleContext getBundleContext(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        Method meth = null;
        try {
            meth = bundle.getClass().getMethod("getBundleContext", new Class[0]);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (meth == null) {
            try {
                meth = bundle.getClass().getMethod("getContext", new Class[0]);
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        if (meth != null) {
            if (!meth.isAccessible()) {
                meth.setAccessible(true);
            }
            try {
                return (BundleContext)meth.invoke((Object)bundle, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                this.m_logger.log(1, "Cannot get the BundleContext by invoking " + meth.getName(), e);
                return null;
            }
            catch (IllegalAccessException e) {
                this.m_logger.log(1, "Cannot get the BundleContext by invoking " + meth.getName(), e);
                return null;
            }
            catch (InvocationTargetException e) {
                this.m_logger.log(1, "Cannot get the BundleContext by invoking " + meth.getName(), e.getTargetException());
                return null;
            }
        }
        Field[] fields = bundle.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!(class$org$osgi$framework$BundleContext == null ? Extender.class$("org.osgi.framework.BundleContext") : class$org$osgi$framework$BundleContext).isAssignableFrom(fields[i].getType())) continue;
            if (!fields[i].isAccessible()) {
                fields[i].setAccessible(true);
            }
            try {
                return (BundleContext)fields[i].get(bundle);
            }
            catch (IllegalArgumentException e) {
                this.m_logger.log(1, "Cannot get the BundleContext by invoking " + fields[i].getName(), e);
                return null;
            }
            catch (IllegalAccessException e) {
                this.m_logger.log(1, "Cannot get the BundleContext by invoking " + fields[i].getName(), e);
                return null;
            }
        }
        this.m_logger.log(1, "Cannot find the BundleContext for " + bundle.getSymbolicName(), null);
        return null;
    }

    private class CreatorThread
    implements Runnable {
        private boolean m_started = true;
        private List m_bundles = new ArrayList();

        private CreatorThread() {
        }

        public synchronized void addBundle(Bundle bundle) {
            if (SYNCHRONOUS_PROCESSING_ENABLED) {
                Extender.this.m_logger.log(4, "Analyzing " + bundle.getBundleId());
                Extender.this.startManagementFor(bundle);
            } else {
                this.m_bundles.add(bundle);
                this.notifyAll();
                Extender.this.m_logger.log(4, "Creator thread is going to analyze the bundle " + bundle.getBundleId() + " List : " + this.m_bundles);
            }
        }

        public synchronized void removeBundle(Bundle bundle) {
            this.m_bundles.remove(bundle);
        }

        public synchronized void stop() {
            this.m_started = false;
            this.m_bundles.clear();
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean started;
            Extender.this.m_logger.log(4, "Creator thread is starting");
            CreatorThread creatorThread = this;
            synchronized (creatorThread) {
                started = this.m_started;
            }
            while (started) {
                Bundle bundle;
                CreatorThread creatorThread2 = this;
                synchronized (creatorThread2) {
                    while (this.m_started && this.m_bundles.isEmpty()) {
                        try {
                            Extender.this.m_logger.log(4, "Creator thread is waiting - Nothing to do");
                            this.wait();
                        }
                        catch (InterruptedException e) {}
                    }
                    if (!this.m_started) {
                        Extender.this.m_logger.log(4, "Creator thread is stopping");
                        return;
                    }
                    bundle = (Bundle)this.m_bundles.remove(0);
                }
                Extender.this.m_logger.log(4, "Creator thread is processing " + bundle.getBundleId());
                try {
                    Extender.this.startManagementFor(bundle);
                }
                catch (Throwable e) {
                    Extender.this.m_logger.log(1, "An error occurs when analyzing the content or starting the management of " + bundle.getBundleId(), e);
                }
                creatorThread2 = this;
                synchronized (creatorThread2) {
                    started = this.m_started;
                }
            }
        }
    }

    private static final class UnboundComponentType {
        private final Element m_description;
        private final Bundle m_bundle;
        private final String m_type;

        protected UnboundComponentType(String type, Element description, Bundle bundle) {
            this.m_type = type;
            this.m_description = description;
            this.m_bundle = bundle;
        }
    }

    private static final class ManagedAbstractFactoryType {
        String m_type;
        Class m_clazz;
        Bundle m_bundle;
        private Map m_created;

        protected ManagedAbstractFactoryType(Class factory, String type, Bundle bundle) {
            this.m_bundle = bundle;
            this.m_clazz = factory;
            this.m_type = type;
        }
    }
}

