/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handlers.providedservice;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.IPOJOServiceFactory;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.handlers.providedservice.CreationStrategy;
import org.apache.felix.ipojo.handlers.providedservice.ProvidedServiceHandler;
import org.apache.felix.ipojo.handlers.providedservice.ProvidedServiceListener;
import org.apache.felix.ipojo.util.Callback;
import org.apache.felix.ipojo.util.Property;
import org.apache.felix.ipojo.util.SecurityHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProvidedService
implements ServiceFactory {
    public static final int REGISTERED = 1;
    public static final int UNREGISTERED = 0;
    public static final int SINGLETON_STRATEGY = 0;
    public static final int SERVICE_STRATEGY = 1;
    public static final int STATIC_STRATEGY = 2;
    public static final int INSTANCE_STRATEGY = 3;
    public static final int CUSTOM_STRATEGY = -1;
    public static final String ALL_SPECIFICATIONS_FOR_CONTROLLERS = "ALL";
    private String[] m_serviceSpecifications = new String[0];
    private ServiceRegistration m_serviceRegistration;
    private ProvidedServiceHandler m_handler;
    private Map<String, Property> m_properties = new TreeMap<String, Property>();
    private final int m_policy;
    private final CreationStrategy m_strategy;
    private volatile boolean m_wasUpdated;
    private Map<String, ServiceController> m_controllers = new HashMap<String, ServiceController>();
    private Callback m_postRegistration;
    private Callback m_postUnregistration;
    private Dictionary m_publishedProperties = new Properties();
    private List<ProvidedServiceListener> m_listeners = new ArrayList<ProvidedServiceListener>();

    public ProvidedService(ProvidedServiceHandler handler, String[] specification, int factoryPolicy, Class creationStrategyClass, Dictionary conf) {
        CreationStrategy strategy;
        this.m_handler = handler;
        this.m_serviceSpecifications = specification;
        this.m_policy = creationStrategyClass == null ? factoryPolicy : -1;
        try {
            this.addProperty(new Property("instance.name", null, null, handler.getInstanceManager().getInstanceName(), String.class.getName(), handler.getInstanceManager(), handler));
            this.addProperty(new Property("factory.name", null, null, handler.getInstanceManager().getFactory().getFactoryName(), String.class.getName(), handler.getInstanceManager(), handler));
            if (handler.getInstanceManager().getFactory().getVersion() != null) {
                this.addProperty(new Property("factory.version", null, null, handler.getInstanceManager().getFactory().getVersion(), String.class.getName(), handler.getInstanceManager(), handler));
            }
            if (conf.get("service.pid") != null) {
                this.addProperty(new Property("service.pid", null, null, (String)conf.get("service.pid"), String.class.getName(), handler.getInstanceManager(), handler));
            }
            if (conf.get("service.ranking") != null) {
                this.addProperty(new Property("service.ranking", null, null, (String)conf.get("service.ranking"), "int", handler.getInstanceManager(), handler));
            }
            if (conf.get("service.vendor") != null) {
                this.addProperty(new Property("service.vendor", null, null, (String)conf.get("service.vendor"), String.class.getName(), handler.getInstanceManager(), handler));
            }
            if (conf.get("service.description") != null) {
                this.addProperty(new Property("service.description", null, null, (String)conf.get("service.description"), String.class.getName(), handler.getInstanceManager(), handler));
            }
        }
        catch (ConfigurationException e) {
            this.m_handler.error("An exception occurs when adding instance.name and factory.name property : " + e.getMessage());
        }
        if (creationStrategyClass != null) {
            try {
                strategy = (CreationStrategy)creationStrategyClass.newInstance();
            }
            catch (IllegalAccessException e) {
                strategy = null;
                this.m_handler.error("[" + this.m_handler.getInstanceManager().getInstanceName() + "] The customized service object creation policy " + "(" + creationStrategyClass.getName() + ") is not accessible: " + e.getMessage(), e);
                this.getInstanceManager().stop();
            }
            catch (InstantiationException e) {
                strategy = null;
                this.m_handler.error("[" + this.m_handler.getInstanceManager().getInstanceName() + "] The customized service object creation policy " + "(" + creationStrategyClass.getName() + ") cannot be instantiated: " + e.getMessage(), e);
                this.getInstanceManager().stop();
            }
        } else {
            switch (factoryPolicy) {
                case 0: {
                    strategy = new SingletonStrategy();
                    break;
                }
                case 1: 
                case 2: {
                    strategy = new FactoryStrategy();
                    break;
                }
                case 3: {
                    strategy = new PerInstanceStrategy();
                    break;
                }
                default: {
                    strategy = null;
                    List<String> specs = Arrays.asList(this.m_serviceSpecifications);
                    this.m_handler.error("[" + this.m_handler.getInstanceManager().getInstanceName() + "] Unknown creation policy for " + specs + " : " + factoryPolicy);
                    this.getInstanceManager().stop();
                }
            }
        }
        this.m_strategy = strategy;
    }

    protected void setProperties(Property[] props) {
        for (Property prop : props) {
            this.addProperty(prop);
        }
    }

    private synchronized void addProperty(Property prop) {
        this.m_properties.put(prop.getName(), prop);
    }

    private synchronized boolean removeProperty(String name) {
        return this.m_properties.remove(name) != null;
    }

    public ServiceReference getServiceReference() {
        if (this.m_serviceRegistration == null) {
            return null;
        }
        return this.m_serviceRegistration.getReference();
    }

    public Object getService(Bundle bundle, ServiceRegistration registration) {
        if (this.getInstanceManager().getState() == 2) {
            return this.m_strategy.getService(bundle, registration);
        }
        return null;
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        this.m_strategy.ungetService(bundle, registration, service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerService() {
        ServiceRegistration reg = null;
        Properties serviceProperties = null;
        ProvidedService providedService = this;
        synchronized (providedService) {
            if (this.m_serviceRegistration != null) {
                return;
            }
            if (this.m_handler.getInstanceManager().getState() == 2 && this.isAtLeastAServiceControllerValid()) {
                BundleContext bc = this.m_handler.getInstanceManager().getContext();
                if (SecurityHelper.hasPermissionToRegisterServices(this.m_serviceSpecifications, bc) && SecurityHelper.canRegisterService(bc)) {
                    serviceProperties = this.getServiceProperties();
                    this.m_strategy.onPublication(this.getInstanceManager(), this.getServiceSpecificationsToRegister(), serviceProperties);
                    reg = this.m_serviceRegistration = bc.registerService(this.getServiceSpecificationsToRegister(), (Object)this, (Dictionary)serviceProperties);
                } else {
                    throw new SecurityException("The bundle " + bc.getBundle().getBundleId() + " does not have the" + " permission to register the services " + Arrays.asList(this.m_serviceSpecifications));
                }
            }
        }
        if (this.m_wasUpdated && SecurityHelper.canUpdateService(reg)) {
            Properties updated = this.getServiceProperties();
            reg.setProperties((Dictionary)updated);
            this.m_publishedProperties = updated;
            this.m_wasUpdated = false;
        }
        providedService = this;
        synchronized (providedService) {
            if (this.m_postRegistration != null) {
                try {
                    this.m_postRegistration.call(new Object[]{this.m_serviceRegistration.getReference()});
                }
                catch (Exception e) {
                    this.m_handler.error("Cannot invoke the post-registration callback " + this.m_postRegistration.getMethod(), e);
                }
            }
        }
        this.notifyListeners(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterService() {
        ServiceReference ref = null;
        ProvidedService providedService = this;
        synchronized (providedService) {
            if (this.m_serviceRegistration != null) {
                ref = this.m_serviceRegistration.getReference();
                this.m_serviceRegistration.unregister();
                this.m_serviceRegistration = null;
            }
            this.m_strategy.onUnpublication();
            if (this.m_postUnregistration != null && ref != null) {
                try {
                    this.m_postUnregistration.call(new Object[]{ref});
                }
                catch (Exception e) {
                    this.m_handler.error("Cannot invoke the post-unregistration callback " + this.m_postUnregistration.getMethod(), e);
                }
            }
        }
        if (ref != null) {
            this.notifyListeners(-1);
        }
    }

    public int getState() {
        if (this.m_serviceRegistration == null) {
            return 0;
        }
        return 1;
    }

    protected InstanceManager getInstanceManager() {
        return this.m_handler.getInstanceManager();
    }

    private Properties getServiceProperties() {
        Properties serviceProperties = new Properties();
        for (Property p : this.m_properties.values()) {
            Object value = p.getValue();
            if (value == null || value == Property.NO_VALUE) continue;
            serviceProperties.put(p.getName(), value);
        }
        return serviceProperties;
    }

    public synchronized Property[] getProperties() {
        return this.m_properties.values().toArray(new Property[this.m_properties.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        boolean doCallListener = false;
        ProvidedService providedService = this;
        synchronized (providedService) {
            if (this.m_serviceRegistration != null) {
                Properties updated = this.getServiceProperties();
                Dictionary oldProps = (Dictionary)((Properties)this.m_publishedProperties).clone();
                Dictionary newProps = (Dictionary)updated.clone();
                newProps.remove("instance.name");
                oldProps.remove("instance.name");
                newProps.remove("service.id");
                oldProps.remove("service.id");
                newProps.remove("service.pid");
                oldProps.remove("service.pid");
                newProps.remove("factory.name");
                oldProps.remove("factory.name");
                newProps.remove("service.factoryPid");
                oldProps.remove("service.factoryPid");
                if (oldProps.size() != newProps.size()) {
                    if (SecurityHelper.canUpdateService(this.m_serviceRegistration)) {
                        this.m_handler.info("Updating Registration : " + oldProps.size() + " / " + newProps.size());
                        this.m_publishedProperties = updated;
                        this.m_serviceRegistration.setProperties((Dictionary)updated);
                        doCallListener = true;
                    }
                } else {
                    Enumeration keys = oldProps.keys();
                    boolean hasChanged = false;
                    while (!hasChanged && keys.hasMoreElements()) {
                        String k = (String)keys.nextElement();
                        Object val = oldProps.get(k);
                        if (val.equals(updated.get(k))) continue;
                        hasChanged = true;
                    }
                    if (hasChanged && SecurityHelper.canUpdateService(this.m_serviceRegistration)) {
                        this.m_handler.info("Updating Registration : " + updated);
                        this.m_publishedProperties = updated;
                        this.m_serviceRegistration.setProperties((Dictionary)updated);
                        doCallListener = true;
                    }
                }
            } else {
                this.m_wasUpdated = true;
            }
        }
        if (doCallListener) {
            this.notifyListeners(0);
        }
    }

    protected void addProperties(Dictionary props) {
        Enumeration keys = props.keys();
        boolean updated = false;
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object value = props.get(key);
            Property property = this.m_properties.get(key);
            if (property != null) {
                if (property.getValue() != null && value.equals(property.getValue())) continue;
                this.m_properties.get(key).setValue(value);
                updated = true;
                continue;
            }
            try {
                property = new Property(key, null, null, value, this.getInstanceManager(), this.m_handler);
                this.addProperty(property);
                updated = true;
            }
            catch (ConfigurationException e) {
                this.m_handler.error("The propagated property " + key + " cannot be created correctly : " + e.getMessage());
            }
        }
        if (updated) {
            this.m_handler.info("Update triggered by adding properties " + props);
            this.update();
        }
    }

    protected void deleteProperties(Dictionary props) {
        Enumeration keys = props.keys();
        boolean mustUpdate = false;
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            mustUpdate = mustUpdate || this.removeProperty(key);
        }
        if (mustUpdate) {
            this.m_handler.info("Update triggered when removing properties : " + props);
            this.update();
        }
    }

    public String[] getServiceSpecifications() {
        return this.m_serviceSpecifications;
    }

    public ServiceRegistration getServiceRegistration() {
        return this.m_serviceRegistration;
    }

    public void setController(String field, boolean value, String specification) {
        if (specification == null) {
            this.m_controllers.put(ALL_SPECIFICATIONS_FOR_CONTROLLERS, new ServiceController(field, value));
        } else {
            this.m_controllers.put(specification, new ServiceController(field, value));
        }
    }

    public ServiceController getController(String field) {
        for (ServiceController controller : this.m_controllers.values()) {
            if (!field.equals(controller.m_field)) continue;
            return controller;
        }
        return null;
    }

    public ServiceController getControllerBySpecification(String spec) {
        return this.m_controllers.get(spec);
    }

    private boolean isAtLeastAServiceControllerValid() {
        if (this.m_controllers.isEmpty()) {
            return true;
        }
        for (ServiceController controller : this.m_controllers.values()) {
            if (!controller.getValue()) continue;
            return true;
        }
        return false;
    }

    private String[] getServiceSpecificationsToRegister() {
        ServiceController ctrl;
        if (this.m_controllers.isEmpty()) {
            return this.m_serviceSpecifications;
        }
        ArrayList<String> l = new ArrayList<String>();
        if (this.m_controllers.containsKey(ALL_SPECIFICATIONS_FOR_CONTROLLERS) && (ctrl = this.m_controllers.get(ALL_SPECIFICATIONS_FOR_CONTROLLERS)).m_value) {
            l.addAll(Arrays.asList(this.m_serviceSpecifications));
        }
        for (String spec : this.m_controllers.keySet()) {
            ServiceController ctrl2 = this.m_controllers.get(spec);
            if (ctrl2.m_value) {
                if (ALL_SPECIFICATIONS_FOR_CONTROLLERS.equals(spec) || l.contains(spec)) continue;
                l.add(spec);
                continue;
            }
            l.remove(spec);
        }
        return l.toArray(new String[l.size()]);
    }

    public void setPostRegistrationCallback(Callback cb) {
        this.m_postRegistration = cb;
    }

    public void setPostUnregistrationCallback(Callback cb) {
        this.m_postUnregistration = cb;
    }

    public int getPolicy() {
        return this.m_policy;
    }

    public Class<? extends CreationStrategy> getCreationStrategy() {
        return this.m_strategy.getClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ProvidedServiceListener listener) {
        if (listener == null) {
            throw new NullPointerException("null listener");
        }
        List<ProvidedServiceListener> list = this.m_listeners;
        synchronized (list) {
            this.m_listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ProvidedServiceListener listener) {
        if (listener == null) {
            throw new NullPointerException("null listener");
        }
        List<ProvidedServiceListener> list = this.m_listeners;
        synchronized (list) {
            int i = -1;
            for (int j = this.m_listeners.size() - 1; j >= 0; --j) {
                if (this.m_listeners.get(j) != listener) continue;
                i = j;
                break;
            }
            if (i == -1) {
                throw new NoSuchElementException("no such listener");
            }
            this.m_listeners.remove(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(int direction) {
        ArrayList<ProvidedServiceListener> tmp;
        List<ProvidedServiceListener> list = this.m_listeners;
        synchronized (list) {
            tmp = new ArrayList<ProvidedServiceListener>(this.m_listeners);
        }
        for (ProvidedServiceListener l : tmp) {
            try {
                if (direction > 0) {
                    l.serviceRegistered(this.m_handler.getInstanceManager(), this);
                    continue;
                }
                if (direction < 0) {
                    l.serviceUnregistered(this.m_handler.getInstanceManager(), this);
                    continue;
                }
                l.serviceModified(this.m_handler.getInstanceManager(), this);
            }
            catch (Throwable e) {
                this.m_handler.warn(String.format("[%s] A ProvidedServiceListener has failed: %s", this.m_handler.getInstanceManager().getInstanceName(), e.getMessage()), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        List<ProvidedServiceListener> list = this.m_listeners;
        synchronized (list) {
            this.m_listeners.clear();
        }
    }

    private class PerInstanceStrategy
    extends CreationStrategy
    implements IPOJOServiceFactory,
    InvocationHandler {
        private Map m_instances = new HashMap();

        private PerInstanceStrategy() {
        }

        public Object invoke(Object arg0, Method arg1, Object[] arg2) {
            if (PerInstanceStrategy.isGetServiceMethod(arg1)) {
                return this.getService((ComponentInstance)arg2[0]);
            }
            if (PerInstanceStrategy.isUngetServiceMethod(arg1)) {
                this.ungetService((ComponentInstance)arg2[0], arg2[1]);
                return null;
            }
            if (arg1.getName().equals("equals") && arg2 != null && arg2.length == 1) {
                return this.equals(arg2[0]);
            }
            if (arg1.getName().equals("hashCode")) {
                return this.hashCode();
            }
            throw new UnsupportedOperationException("This service requires an advanced creation policy. Before calling the service, call the getService(ComponentInstance) method to get the service object. - Method called: " + arg1.getName());
        }

        public Object getService(ComponentInstance instance) {
            Object obj = this.m_instances.get(instance);
            if (obj == null) {
                obj = ProvidedService.this.m_handler.getInstanceManager().createPojoObject();
                this.m_instances.put(instance, obj);
            }
            return obj;
        }

        public void ungetService(ComponentInstance instance, Object svcObject) {
            Object pojo = this.m_instances.remove(instance);
            ProvidedService.this.m_handler.getInstanceManager().deletePojoObject(pojo);
        }

        public void onPublication(InstanceManager instance, String[] interfaces, Properties props) {
        }

        public void onUnpublication() {
            Collection col = this.m_instances.values();
            Iterator it = col.iterator();
            while (it.hasNext()) {
                ProvidedService.this.m_handler.getInstanceManager().deletePojoObject(it.next());
            }
            this.m_instances.clear();
        }

        public Object getService(Bundle arg0, ServiceRegistration arg1) {
            Object proxy = Proxy.newProxyInstance(ProvidedService.this.getInstanceManager().getClazz().getClassLoader(), this.getSpecificationsWithIPOJOServiceFactory(ProvidedService.this.m_serviceSpecifications, ProvidedService.this.m_handler.getInstanceManager().getContext()), (InvocationHandler)this);
            return proxy;
        }

        public void ungetService(Bundle arg0, ServiceRegistration arg1, Object arg2) {
        }

        private Class[] getSpecificationsWithIPOJOServiceFactory(String[] specs, BundleContext bc) {
            Class[] classes = new Class[specs.length + 1];
            int i = 0;
            for (i = 0; i < specs.length; ++i) {
                try {
                    classes[i] = bc.getBundle().loadClass(specs[i]);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            classes[i] = IPOJOServiceFactory.class;
            return classes;
        }
    }

    private class FactoryStrategy
    extends CreationStrategy {
        private FactoryStrategy() {
        }

        public void onPublication(InstanceManager instance, String[] interfaces, Properties props) {
        }

        public void onUnpublication() {
        }

        public Object getService(Bundle arg0, ServiceRegistration arg1) {
            return ProvidedService.this.m_handler.getInstanceManager().createPojoObject();
        }

        public void ungetService(Bundle arg0, ServiceRegistration arg1, Object arg2) {
            ProvidedService.this.m_handler.getInstanceManager().deletePojoObject(arg2);
        }
    }

    private class SingletonStrategy
    extends CreationStrategy {
        private SingletonStrategy() {
        }

        public void onPublication(InstanceManager instance, String[] interfaces, Properties props) {
        }

        public void onUnpublication() {
        }

        public Object getService(Bundle arg0, ServiceRegistration arg1) {
            return ProvidedService.this.m_handler.getInstanceManager().getPojoObject();
        }

        public void ungetService(Bundle arg0, ServiceRegistration arg1, Object arg2) {
        }
    }

    class ServiceController {
        private boolean m_value;
        private final String m_field;

        public ServiceController(String field, boolean value) {
            this.m_field = field;
            this.m_value = value;
        }

        public String getField() {
            return this.m_field;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean getValue() {
            ProvidedService providedService = ProvidedService.this;
            synchronized (providedService) {
                return this.m_value;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(Boolean value) {
            ProvidedService providedService = ProvidedService.this;
            synchronized (providedService) {
                if (value != this.m_value) {
                    this.m_value = value;
                    ProvidedService.this.unregisterService();
                    if (ProvidedService.this.getServiceSpecificationsToRegister().length != 0) {
                        ProvidedService.this.registerService();
                    }
                }
            }
        }
    }
}

