/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handlers.dependency;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.ContextSource;
import org.apache.felix.ipojo.Handler;
import org.apache.felix.ipojo.IPojoContext;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.PolicyServiceContext;
import org.apache.felix.ipojo.PrimitiveHandler;
import org.apache.felix.ipojo.architecture.HandlerDescription;
import org.apache.felix.ipojo.handlers.dependency.Dependency;
import org.apache.felix.ipojo.handlers.dependency.DependencyCallback;
import org.apache.felix.ipojo.handlers.dependency.DependencyConfigurationChecker;
import org.apache.felix.ipojo.handlers.dependency.DependencyHandlerDescription;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.parser.MethodMetadata;
import org.apache.felix.ipojo.parser.PojoMetadata;
import org.apache.felix.ipojo.util.DependencyMetadataHelper;
import org.apache.felix.ipojo.util.DependencyModel;
import org.apache.felix.ipojo.util.DependencyStateListener;
import org.apache.felix.ipojo.util.InstanceConfigurationSource;
import org.apache.felix.ipojo.util.SystemPropertiesSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyHandler
extends PrimitiveHandler
implements DependencyStateListener,
Pojo {
    private InstanceManager __IM;
    public static final String PROXY_SETTINGS_PROPERTY = "ipojo.proxy";
    public static final String PROXY_TYPE_PROPERTY = "ipojo.proxy.type";
    public static final String SMART_PROXY = "smart";
    public static final String DYNAMIC_PROXY = "dynamic-proxy";
    public static final String PROXY_ENABLED = "enabled";
    public static final String PROXY_DISABLED = "disabled";
    private boolean __Fm_dependencies;
    private final List<Dependency> m_dependencies;
    private boolean __Fm_started;
    private boolean m_started;
    private boolean __Fm_description;
    private DependencyHandlerDescription m_description;
    private boolean __Fm_instanceConfigurationSource;
    private InstanceConfigurationSource m_instanceConfigurationSource;
    private boolean __MgetDependencies;
    private boolean __Mvalidate$org_apache_felix_ipojo_util_DependencyModel;
    private boolean __Minvalidate$org_apache_felix_ipojo_util_DependencyModel;
    private boolean __McheckContext;
    private boolean __Mconfigure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary;
    private boolean __MmanageContextSources$java_util_Dictionary;
    private boolean __McomputeFilter$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary$java_util_Dictionary$boolean$java_lang_String;
    private boolean __MupdateFilterIfFromIsEnabled$java_util_Dictionary$org_apache_felix_ipojo_metadata_Element$java_lang_String$boolean$java_lang_String;
    private boolean __MisProxy$org_apache_felix_ipojo_metadata_Element;
    private boolean __MgetProxySetting;
    private boolean __MaddCallbacksToDependency$org_apache_felix_ipojo_metadata_Element$org_apache_felix_ipojo_handlers_dependency_Dependency;
    private boolean __McreateDependencyHandler$org_apache_felix_ipojo_handlers_dependency_Dependency$java_lang_String$int;
    private boolean __McreateAndCheckFilter$java_lang_String;
    private boolean __MgetFacetedBundleContext$org_apache_felix_ipojo_metadata_Element;
    private boolean __MgetServiceSpecificationAttribute$org_apache_felix_ipojo_metadata_Element;
    private boolean __MgetRequiresFilters$java_lang_Object;
    private boolean __Mstart;
    private boolean __Mstop;
    private boolean __MonCreation$java_lang_Object;
    private boolean __MgetDescription;
    private boolean __Mreconfigure$java_util_Dictionary;
    private boolean __MstateChanged$int;

    List __getm_dependencies() {
        if (!this.__Fm_dependencies) {
            return this.m_dependencies;
        }
        return (List)this.__IM.onGet(this, "m_dependencies");
    }

    void __setm_dependencies(List list) {
        if (!this.__Fm_dependencies) {
            this.m_dependencies = list;
            return;
        }
        this.__IM.onSet(this, "m_dependencies", list);
    }

    boolean __getm_started() {
        if (!this.__Fm_started) {
            return this.m_started;
        }
        Object object = this.__IM.onGet(this, "m_started");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setm_started(boolean bl) {
        if (!this.__Fm_started) {
            this.m_started = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet(this, "m_started", bl2);
    }

    DependencyHandlerDescription __getm_description() {
        if (!this.__Fm_description) {
            return this.m_description;
        }
        return (DependencyHandlerDescription)this.__IM.onGet(this, "m_description");
    }

    void __setm_description(DependencyHandlerDescription dependencyHandlerDescription) {
        if (!this.__Fm_description) {
            this.m_description = dependencyHandlerDescription;
            return;
        }
        this.__IM.onSet(this, "m_description", dependencyHandlerDescription);
    }

    InstanceConfigurationSource __getm_instanceConfigurationSource() {
        if (!this.__Fm_instanceConfigurationSource) {
            return this.m_instanceConfigurationSource;
        }
        return (InstanceConfigurationSource)this.__IM.onGet(this, "m_instanceConfigurationSource");
    }

    void __setm_instanceConfigurationSource(InstanceConfigurationSource instanceConfigurationSource) {
        if (!this.__Fm_instanceConfigurationSource) {
            this.m_instanceConfigurationSource = instanceConfigurationSource;
            return;
        }
        this.__IM.onSet(this, "m_instanceConfigurationSource", instanceConfigurationSource);
    }

    public DependencyHandler() {
        this(null);
    }

    private DependencyHandler(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setm_dependencies(new ArrayList());
    }

    public static String getDependencyIdentifier(Dependency dep) {
        StringBuilder identifier = new StringBuilder("{");
        if (dep.getId() != null) {
            identifier.append("id=").append(dep.getId());
        }
        if (dep.getField() != null) {
            if (identifier.length() > 1) {
                identifier.append(", ");
            }
            identifier.append("field=").append(dep.getField());
        }
        if (dep.getCallbacks() != null && dep.getCallbacks().length > 0) {
            if (identifier.length() > 1) {
                identifier.append(", ");
            }
            identifier.append("method=").append(dep.getCallbacks()[0].getMethodName());
        }
        if (dep.getSpecification() != null) {
            if (identifier.length() > 1) {
                identifier.append(", ");
            }
            identifier.append("specification=").append(dep.getSpecification().getName());
        }
        identifier.append("}");
        return identifier.toString();
    }

    public Dependency[] getDependencies() {
        Dependency[] dependencyArray;
        if (!this.__MgetDependencies) {
            return this.__M_getDependencies();
        }
        try {
            this.__IM.onEntry(this, "getDependencies", new Object[0]);
            dependencyArray = this.__M_getDependencies();
            this.__IM.onExit(this, "getDependencies", dependencyArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "getDependencies", throwable);
            throw throwable;
        }
        return dependencyArray;
    }

    private Dependency[] __M_getDependencies() {
        return this.__getm_dependencies().toArray(new Dependency[this.__getm_dependencies().size()]);
    }

    @Override
    public void validate(DependencyModel dep) {
        if (!this.__Mvalidate$org_apache_felix_ipojo_util_DependencyModel) {
            this.__M_validate(dep);
            return;
        }
        try {
            this.__IM.onEntry(this, "validate$org_apache_felix_ipojo_util_DependencyModel", new Object[]{dep});
            this.__M_validate(dep);
            this.__IM.onExit(this, "validate$org_apache_felix_ipojo_util_DependencyModel", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "validate$org_apache_felix_ipojo_util_DependencyModel", throwable);
            throw throwable;
        }
    }

    private void __M_validate(DependencyModel dep) {
        this.checkContext();
    }

    @Override
    public void invalidate(DependencyModel dep) {
        if (!this.__Minvalidate$org_apache_felix_ipojo_util_DependencyModel) {
            this.__M_invalidate(dep);
            return;
        }
        try {
            this.__IM.onEntry(this, "invalidate$org_apache_felix_ipojo_util_DependencyModel", new Object[]{dep});
            this.__M_invalidate(dep);
            this.__IM.onExit(this, "invalidate$org_apache_felix_ipojo_util_DependencyModel", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "invalidate$org_apache_felix_ipojo_util_DependencyModel", throwable);
            throw throwable;
        }
    }

    private void __M_invalidate(DependencyModel dep) {
        this.setValidity(false);
    }

    protected void checkContext() {
        if (!this.__McheckContext) {
            this.__M_checkContext();
            return;
        }
        try {
            this.__IM.onEntry(this, "checkContext", new Object[0]);
            this.__M_checkContext();
            this.__IM.onExit(this, "checkContext", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "checkContext", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_checkContext() {
        if (!this.__getm_started()) {
            return;
        }
        List list = this.__getm_dependencies();
        synchronized (list) {
            boolean initialState = this.getValidity();
            boolean valid = true;
            for (Dependency dep : this.__getm_dependencies()) {
                if (dep.getState() == 1) continue;
                valid = false;
                break;
            }
            if (valid) {
                if (!initialState) {
                    this.setValidity(true);
                }
            } else if (initialState) {
                this.setValidity(false);
            }
        }
    }

    @Override
    public void configure(Element componentMetadata, Dictionary configuration) throws ConfigurationException {
        if (!this.__Mconfigure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary) {
            this.__M_configure(componentMetadata, configuration);
            return;
        }
        try {
            this.__IM.onEntry(this, "configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", new Object[]{componentMetadata, configuration});
            this.__M_configure(componentMetadata, configuration);
            this.__IM.onExit(this, "configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", throwable);
            throw throwable;
        }
    }

    private void __M_configure(Element componentMetadata, Dictionary configuration) throws ConfigurationException {
        PojoMetadata manipulation = this.getFactory().getPojoMetadata();
        boolean atLeastOneField = false;
        Element[] deps = componentMetadata.getElements("Requires");
        Dictionary filtersConfiguration = this.getRequiresFilters(configuration.get("requires.filters"));
        Dictionary fromConfiguration = (Dictionary)configuration.get("requires.from");
        for (int i = 0; deps != null && i < deps.length; ++i) {
            String agg;
            Element dependencyElement = deps[i];
            String field = dependencyElement.getAttribute("field");
            String serviceSpecification = this.getServiceSpecificationAttribute(dependencyElement);
            String opt = dependencyElement.getAttribute("optional");
            boolean optional = opt != null && opt.equalsIgnoreCase("true");
            String defaultImpl = dependencyElement.getAttribute("default-implementation");
            String exception = dependencyElement.getAttribute("exception");
            String to = dependencyElement.getAttribute("timeout");
            int timeout = 0;
            if (to != null) {
                timeout = Integer.parseInt(to);
            }
            boolean aggregate = (agg = dependencyElement.getAttribute("aggregate")) != null && agg.equalsIgnoreCase("true");
            String identity = dependencyElement.getAttribute("id");
            String nul = dependencyElement.getAttribute("nullable");
            boolean nullable = nul == null || nul.equalsIgnoreCase("true");
            boolean isProxy = this.isProxy(dependencyElement);
            BundleContext context = this.getFacetedBundleContext(dependencyElement);
            String filter = this.computeFilter(dependencyElement, filtersConfiguration, fromConfiguration, aggregate, identity);
            Filter fil = this.createAndCheckFilter(filter);
            Class spec = null;
            if (serviceSpecification != null) {
                spec = DependencyMetadataHelper.loadSpecification(serviceSpecification, this.getInstanceManager().getContext());
            }
            int policy = DependencyMetadataHelper.getPolicy(dependencyElement);
            Comparator cmp = DependencyMetadataHelper.getComparator(dependencyElement, this.getInstanceManager().getGlobalContext());
            Dependency dep = new Dependency(this, field, spec, fil, optional, aggregate, nullable, isProxy, identity, context, policy, cmp, defaultImpl, exception);
            dep.setTimeout(timeout);
            this.addCallbacksToDependency(dependencyElement, dep);
            String paramIndex = dependencyElement.getAttribute("constructor-parameter");
            if (paramIndex != null) {
                int index = Integer.parseInt(paramIndex);
                dep.addConstructorInjection(index);
            }
            DependencyConfigurationChecker.ensure(dep, dependencyElement, manipulation);
            this.__getm_dependencies().add(dep);
            if (dep.getField() == null) continue;
            this.getInstanceManager().register(manipulation.getField(dep.getField()), dep);
            atLeastOneField = true;
        }
        if (atLeastOneField) {
            MethodMetadata[] methods = manipulation.getMethods();
            for (MethodMetadata method : methods) {
                for (Dependency dep : this.__getm_dependencies()) {
                    this.getInstanceManager().register(method, dep);
                }
            }
            for (String inner : manipulation.getInnerClasses()) {
                MethodMetadata[] meths = manipulation.getMethodsFromInnerClass(inner);
                if (meths == null) continue;
                for (MethodMetadata method : meths) {
                    for (Dependency dep : this.__getm_dependencies()) {
                        this.getInstanceManager().register(method, inner, dep);
                    }
                }
            }
        }
        this.__setm_description(new DependencyHandlerDescription(this, this.getDependencies()));
        this.manageContextSources(configuration);
    }

    private void manageContextSources(Dictionary<String, Object> configuration) {
        if (!this.__MmanageContextSources$java_util_Dictionary) {
            this.__M_manageContextSources(configuration);
            return;
        }
        try {
            this.__IM.onEntry(this, "manageContextSources$java_util_Dictionary", new Object[]{configuration});
            this.__M_manageContextSources(configuration);
            this.__IM.onExit(this, "manageContextSources$java_util_Dictionary", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "manageContextSources$java_util_Dictionary", throwable);
            throw throwable;
        }
    }

    private void __M_manageContextSources(Dictionary<String, Object> configuration) {
        this.__setm_instanceConfigurationSource(new InstanceConfigurationSource(configuration));
        SystemPropertiesSource systemPropertiesSource = new SystemPropertiesSource();
        for (Dependency dependency : this.__getm_dependencies()) {
            if (dependency.getFilter() == null) continue;
            dependency.getContextSourceManager().addContextSource(this.__getm_instanceConfigurationSource());
            dependency.getContextSourceManager().addContextSource(systemPropertiesSource);
            for (Handler handler : this.getInstanceManager().getRegisteredHandlers()) {
                if (!(handler instanceof ContextSource)) continue;
                dependency.getContextSourceManager().addContextSource((ContextSource)((Object)handler));
            }
        }
    }

    private String computeFilter(Element dependencyElement, Dictionary filtersConfiguration, Dictionary fromConfiguration, boolean aggregate, String identity) {
        String string;
        if (!this.__McomputeFilter$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary$java_util_Dictionary$boolean$java_lang_String) {
            return this.__M_computeFilter(dependencyElement, filtersConfiguration, fromConfiguration, aggregate, identity);
        }
        try {
            this.__IM.onEntry(this, "computeFilter$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary$java_util_Dictionary$boolean$java_lang_String", new Object[]{dependencyElement, filtersConfiguration, fromConfiguration, new Boolean(aggregate), identity});
            string = this.__M_computeFilter(dependencyElement, filtersConfiguration, fromConfiguration, aggregate, identity);
            this.__IM.onExit(this, "computeFilter$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary$java_util_Dictionary$boolean$java_lang_String", string);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "computeFilter$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary$java_util_Dictionary$boolean$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_computeFilter(Element dependencyElement, Dictionary filtersConfiguration, Dictionary fromConfiguration, boolean aggregate, String identity) {
        String filter = dependencyElement.getAttribute("filter");
        if (filtersConfiguration != null && identity != null && filtersConfiguration.get(identity) != null) {
            filter = (String)filtersConfiguration.get(identity);
        }
        filter = this.updateFilterIfFromIsEnabled(fromConfiguration, dependencyElement, filter, aggregate, identity);
        return filter;
    }

    private String updateFilterIfFromIsEnabled(Dictionary fromConfiguration, Element dependencyElement, String filter, boolean aggregate, String identity) {
        String string;
        if (!this.__MupdateFilterIfFromIsEnabled$java_util_Dictionary$org_apache_felix_ipojo_metadata_Element$java_lang_String$boolean$java_lang_String) {
            return this.__M_updateFilterIfFromIsEnabled(fromConfiguration, dependencyElement, filter, aggregate, identity);
        }
        try {
            this.__IM.onEntry(this, "updateFilterIfFromIsEnabled$java_util_Dictionary$org_apache_felix_ipojo_metadata_Element$java_lang_String$boolean$java_lang_String", new Object[]{fromConfiguration, dependencyElement, filter, new Boolean(aggregate), identity});
            string = this.__M_updateFilterIfFromIsEnabled(fromConfiguration, dependencyElement, filter, aggregate, identity);
            this.__IM.onExit(this, "updateFilterIfFromIsEnabled$java_util_Dictionary$org_apache_felix_ipojo_metadata_Element$java_lang_String$boolean$java_lang_String", string);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "updateFilterIfFromIsEnabled$java_util_Dictionary$org_apache_felix_ipojo_metadata_Element$java_lang_String$boolean$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_updateFilterIfFromIsEnabled(Dictionary fromConfiguration, Element dependencyElement, String filter, boolean aggregate, String identity) {
        String from = dependencyElement.getAttribute("from");
        if (fromConfiguration != null && identity != null && fromConfiguration.get(identity) != null) {
            from = (String)fromConfiguration.get(identity);
        }
        if (from != null) {
            String fromFilter = "(|(instance.name=" + from + ")(service.pid=" + from + "))";
            if (aggregate) {
                this.warn("The 'from' attribute is incompatible with aggregate requirements: only one provider will match : " + fromFilter);
            }
            filter = filter != null ? "(&" + fromFilter + filter + ")" : fromFilter;
        }
        return filter;
    }

    private boolean isProxy(Element dependencyElement) {
        boolean bl;
        if (!this.__MisProxy$org_apache_felix_ipojo_metadata_Element) {
            return this.__M_isProxy(dependencyElement);
        }
        try {
            this.__IM.onEntry(this, "isProxy$org_apache_felix_ipojo_metadata_Element", new Object[]{dependencyElement});
            bl = this.__M_isProxy(dependencyElement);
            this.__IM.onExit(this, "isProxy$org_apache_felix_ipojo_metadata_Element", new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "isProxy$org_apache_felix_ipojo_metadata_Element", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_isProxy(Element dependencyElement) {
        boolean isProxy = true;
        String setting = this.getProxySetting();
        if (setting == null || PROXY_ENABLED.equals(setting)) {
            isProxy = true;
        } else if (PROXY_DISABLED.equals(setting)) {
            isProxy = false;
        }
        String proxy = dependencyElement.getAttribute("proxy");
        if (proxy != null) {
            if (proxy.equals("false")) {
                isProxy = false;
            } else if (proxy.equals("true")) {
                if (!isProxy) {
                    this.warn("The configuration of a service dependency overrides the proxy mode");
                }
                isProxy = true;
            }
        }
        return isProxy;
    }

    private String getProxySetting() {
        String string;
        if (!this.__MgetProxySetting) {
            return this.__M_getProxySetting();
        }
        try {
            this.__IM.onEntry(this, "getProxySetting", new Object[0]);
            string = this.__M_getProxySetting();
            this.__IM.onExit(this, "getProxySetting", string);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "getProxySetting", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getProxySetting() {
        String setting = this.getInstanceManager().getContext().getProperty(PROXY_SETTINGS_PROPERTY);
        if (setting == null) {
            setting = System.getProperty(PROXY_SETTINGS_PROPERTY);
        }
        return setting;
    }

    private void addCallbacksToDependency(Element dependencyElement, Dependency dep) throws ConfigurationException {
        if (!this.__MaddCallbacksToDependency$org_apache_felix_ipojo_metadata_Element$org_apache_felix_ipojo_handlers_dependency_Dependency) {
            this.__M_addCallbacksToDependency(dependencyElement, dep);
            return;
        }
        try {
            this.__IM.onEntry(this, "addCallbacksToDependency$org_apache_felix_ipojo_metadata_Element$org_apache_felix_ipojo_handlers_dependency_Dependency", new Object[]{dependencyElement, dep});
            this.__M_addCallbacksToDependency(dependencyElement, dep);
            this.__IM.onExit(this, "addCallbacksToDependency$org_apache_felix_ipojo_metadata_Element$org_apache_felix_ipojo_handlers_dependency_Dependency", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "addCallbacksToDependency$org_apache_felix_ipojo_metadata_Element$org_apache_felix_ipojo_handlers_dependency_Dependency", throwable);
            throw throwable;
        }
    }

    private void __M_addCallbacksToDependency(Element dependencyElement, Dependency dep) throws ConfigurationException {
        Element[] cbs = dependencyElement.getElements("Callback");
        for (int j = 0; cbs != null && j < cbs.length; ++j) {
            if (!cbs[j].containsAttribute("method") || !cbs[j].containsAttribute("type")) {
                throw new ConfigurationException("Requirement Callback : a dependency callback must contain a method and a type (bind or unbind) attribute");
            }
            String method = cbs[j].getAttribute("method");
            String type = cbs[j].getAttribute("type");
            int methodType = 1;
            if ("bind".equalsIgnoreCase(type)) {
                methodType = 0;
            } else if ("modified".equalsIgnoreCase(type)) {
                methodType = 2;
            }
            dep.addDependencyCallback(this.createDependencyHandler(dep, method, methodType));
        }
    }

    protected DependencyCallback createDependencyHandler(Dependency dep, String method, int type) {
        DependencyCallback dependencyCallback;
        if (!this.__McreateDependencyHandler$org_apache_felix_ipojo_handlers_dependency_Dependency$java_lang_String$int) {
            return this.__M_createDependencyHandler(dep, method, type);
        }
        try {
            this.__IM.onEntry(this, "createDependencyHandler$org_apache_felix_ipojo_handlers_dependency_Dependency$java_lang_String$int", new Object[]{dep, method, new Integer(type)});
            dependencyCallback = this.__M_createDependencyHandler(dep, method, type);
            this.__IM.onExit(this, "createDependencyHandler$org_apache_felix_ipojo_handlers_dependency_Dependency$java_lang_String$int", dependencyCallback);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "createDependencyHandler$org_apache_felix_ipojo_handlers_dependency_Dependency$java_lang_String$int", throwable);
            throw throwable;
        }
        return dependencyCallback;
    }

    private DependencyCallback __M_createDependencyHandler(Dependency dep, String method, int type) {
        return new DependencyCallback(dep, method, type);
    }

    private Filter createAndCheckFilter(String filter) throws ConfigurationException {
        Filter filter2;
        if (!this.__McreateAndCheckFilter$java_lang_String) {
            return this.__M_createAndCheckFilter(filter);
        }
        try {
            this.__IM.onEntry(this, "createAndCheckFilter$java_lang_String", new Object[]{filter});
            filter2 = this.__M_createAndCheckFilter(filter);
            this.__IM.onExit(this, "createAndCheckFilter$java_lang_String", filter2);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "createAndCheckFilter$java_lang_String", throwable);
            throw throwable;
        }
        return filter2;
    }

    private Filter __M_createAndCheckFilter(String filter) throws ConfigurationException {
        Filter fil = null;
        if (filter != null) {
            try {
                fil = this.getInstanceManager().getContext().createFilter(filter);
            }
            catch (InvalidSyntaxException e) {
                throw new ConfigurationException("A requirement filter is invalid : " + filter, e);
            }
        }
        return fil;
    }

    private BundleContext getFacetedBundleContext(Element dep) {
        BundleContext bundleContext;
        if (!this.__MgetFacetedBundleContext$org_apache_felix_ipojo_metadata_Element) {
            return this.__M_getFacetedBundleContext(dep);
        }
        try {
            this.__IM.onEntry(this, "getFacetedBundleContext$org_apache_felix_ipojo_metadata_Element", new Object[]{dep});
            bundleContext = this.__M_getFacetedBundleContext(dep);
            this.__IM.onExit(this, "getFacetedBundleContext$org_apache_felix_ipojo_metadata_Element", bundleContext);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "getFacetedBundleContext$org_apache_felix_ipojo_metadata_Element", throwable);
            throw throwable;
        }
        return bundleContext;
    }

    private BundleContext __M_getFacetedBundleContext(Element dep) {
        String scope = dep.getAttribute("scope");
        BundleContext context = this.getInstanceManager().getContext();
        if (scope != null) {
            if (scope.equalsIgnoreCase("global") || ((IPojoContext)this.getInstanceManager().getContext()).getServiceContext() == null) {
                context = new PolicyServiceContext(this.getInstanceManager().getGlobalContext(), this.getInstanceManager().getLocalServiceContext(), 2);
            } else if (scope.equalsIgnoreCase("composite")) {
                context = new PolicyServiceContext(this.getInstanceManager().getGlobalContext(), this.getInstanceManager().getLocalServiceContext(), 0);
            } else if (scope.equalsIgnoreCase("composite+global")) {
                context = new PolicyServiceContext(this.getInstanceManager().getGlobalContext(), this.getInstanceManager().getLocalServiceContext(), 1);
            }
        }
        return context;
    }

    private String getServiceSpecificationAttribute(Element dep) {
        String string;
        if (!this.__MgetServiceSpecificationAttribute$org_apache_felix_ipojo_metadata_Element) {
            return this.__M_getServiceSpecificationAttribute(dep);
        }
        try {
            this.__IM.onEntry(this, "getServiceSpecificationAttribute$org_apache_felix_ipojo_metadata_Element", new Object[]{dep});
            string = this.__M_getServiceSpecificationAttribute(dep);
            this.__IM.onExit(this, "getServiceSpecificationAttribute$org_apache_felix_ipojo_metadata_Element", string);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "getServiceSpecificationAttribute$org_apache_felix_ipojo_metadata_Element", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getServiceSpecificationAttribute(Element dep) {
        String serviceSpecification = dep.getAttribute("interface");
        if (serviceSpecification != null) {
            this.warn("The 'interface' attribute is deprecated, use the 'specification' attribute instead");
        } else {
            serviceSpecification = dep.getAttribute("specification");
        }
        return serviceSpecification;
    }

    private Dictionary getRequiresFilters(Object requiresFiltersValue) throws ConfigurationException {
        Dictionary dictionary;
        if (!this.__MgetRequiresFilters$java_lang_Object) {
            return this.__M_getRequiresFilters(requiresFiltersValue);
        }
        try {
            this.__IM.onEntry(this, "getRequiresFilters$java_lang_Object", new Object[]{requiresFiltersValue});
            dictionary = this.__M_getRequiresFilters(requiresFiltersValue);
            this.__IM.onExit(this, "getRequiresFilters$java_lang_Object", dictionary);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "getRequiresFilters$java_lang_Object", throwable);
            throw throwable;
        }
        return dictionary;
    }

    private Dictionary __M_getRequiresFilters(Object requiresFiltersValue) throws ConfigurationException {
        if (requiresFiltersValue != null && requiresFiltersValue.getClass().isArray()) {
            String[] filtersArray = (String[])requiresFiltersValue;
            if (filtersArray.length % 2 != 0) {
                throw new ConfigurationException("A requirement filter is invalid : " + requiresFiltersValue);
            }
            Hashtable<String, String> requiresFilters = new Hashtable<String, String>();
            for (int i = 0; i < filtersArray.length; i += 2) {
                ((Dictionary)requiresFilters).put(filtersArray[i], filtersArray[i + 1]);
            }
            return requiresFilters;
        }
        return (Dictionary)requiresFiltersValue;
    }

    @Override
    public void start() {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry(this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit(this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "start", throwable);
            throw throwable;
        }
    }

    private void __M_start() {
        for (Dependency dep : this.__getm_dependencies()) {
            dep.start();
        }
        this.__setm_started(true);
        this.setValidity(false);
        this.checkContext();
    }

    @Override
    public void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry(this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit(this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "stop", throwable);
            throw throwable;
        }
    }

    private void __M_stop() {
        this.__setm_started(false);
        for (Dependency dep : this.__getm_dependencies()) {
            dep.stop();
        }
    }

    @Override
    public void onCreation(Object instance) {
        if (!this.__MonCreation$java_lang_Object) {
            this.__M_onCreation(instance);
            return;
        }
        try {
            this.__IM.onEntry(this, "onCreation$java_lang_Object", new Object[]{instance});
            this.__M_onCreation(instance);
            this.__IM.onExit(this, "onCreation$java_lang_Object", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "onCreation$java_lang_Object", throwable);
            throw throwable;
        }
    }

    private void __M_onCreation(Object instance) {
        for (Dependency dep : this.__getm_dependencies()) {
            dep.onObjectCreation(instance);
        }
    }

    @Override
    public HandlerDescription getDescription() {
        HandlerDescription handlerDescription;
        if (!this.__MgetDescription) {
            return this.__M_getDescription();
        }
        try {
            this.__IM.onEntry(this, "getDescription", new Object[0]);
            handlerDescription = this.__M_getDescription();
            this.__IM.onExit(this, "getDescription", handlerDescription);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "getDescription", throwable);
            throw throwable;
        }
        return handlerDescription;
    }

    private HandlerDescription __M_getDescription() {
        return this.__getm_description();
    }

    @Override
    public void reconfigure(Dictionary configuration) {
        if (!this.__Mreconfigure$java_util_Dictionary) {
            this.__M_reconfigure(configuration);
            return;
        }
        try {
            this.__IM.onEntry(this, "reconfigure$java_util_Dictionary", new Object[]{configuration});
            this.__M_reconfigure(configuration);
            this.__IM.onExit(this, "reconfigure$java_util_Dictionary", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "reconfigure$java_util_Dictionary", throwable);
            throw throwable;
        }
    }

    private void __M_reconfigure(Dictionary configuration) {
        this.__getm_instanceConfigurationSource().reconfigure(configuration);
    }

    @Override
    public void stateChanged(int state) {
        if (!this.__MstateChanged$int) {
            this.__M_stateChanged(state);
            return;
        }
        try {
            this.__IM.onEntry(this, "stateChanged$int", new Object[]{new Integer(state)});
            this.__M_stateChanged(state);
            this.__IM.onExit(this, "stateChanged$int", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "stateChanged$int", throwable);
            throw throwable;
        }
    }

    private void __M_stateChanged(int state) {
        if (state == -1) {
            for (Dependency dep : this.__getm_dependencies()) {
                dep.cleanup();
            }
        }
        super.stateChanged(state);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("m_dependencies")) {
                this.__Fm_dependencies = true;
            }
            if (set.contains("m_description")) {
                this.__Fm_description = true;
            }
            if (set.contains("m_instanceConfigurationSource")) {
                this.__Fm_instanceConfigurationSource = true;
            }
            if (set.contains("m_started")) {
                this.__Fm_started = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("getDependencies")) {
                this.__MgetDependencies = true;
            }
            if (set.contains("validate$org_apache_felix_ipojo_util_DependencyModel")) {
                this.__Mvalidate$org_apache_felix_ipojo_util_DependencyModel = true;
            }
            if (set.contains("invalidate$org_apache_felix_ipojo_util_DependencyModel")) {
                this.__Minvalidate$org_apache_felix_ipojo_util_DependencyModel = true;
            }
            if (set.contains("checkContext")) {
                this.__McheckContext = true;
            }
            if (set.contains("configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary")) {
                this.__Mconfigure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary = true;
            }
            if (set.contains("manageContextSources$java_util_Dictionary")) {
                this.__MmanageContextSources$java_util_Dictionary = true;
            }
            if (set.contains("computeFilter$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary$java_util_Dictionary$boolean$java_lang_String")) {
                this.__McomputeFilter$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary$java_util_Dictionary$boolean$java_lang_String = true;
            }
            if (set.contains("updateFilterIfFromIsEnabled$java_util_Dictionary$org_apache_felix_ipojo_metadata_Element$java_lang_String$boolean$java_lang_String")) {
                this.__MupdateFilterIfFromIsEnabled$java_util_Dictionary$org_apache_felix_ipojo_metadata_Element$java_lang_String$boolean$java_lang_String = true;
            }
            if (set.contains("isProxy$org_apache_felix_ipojo_metadata_Element")) {
                this.__MisProxy$org_apache_felix_ipojo_metadata_Element = true;
            }
            if (set.contains("getProxySetting")) {
                this.__MgetProxySetting = true;
            }
            if (set.contains("addCallbacksToDependency$org_apache_felix_ipojo_metadata_Element$org_apache_felix_ipojo_handlers_dependency_Dependency")) {
                this.__MaddCallbacksToDependency$org_apache_felix_ipojo_metadata_Element$org_apache_felix_ipojo_handlers_dependency_Dependency = true;
            }
            if (set.contains("createDependencyHandler$org_apache_felix_ipojo_handlers_dependency_Dependency$java_lang_String$int")) {
                this.__McreateDependencyHandler$org_apache_felix_ipojo_handlers_dependency_Dependency$java_lang_String$int = true;
            }
            if (set.contains("createAndCheckFilter$java_lang_String")) {
                this.__McreateAndCheckFilter$java_lang_String = true;
            }
            if (set.contains("getFacetedBundleContext$org_apache_felix_ipojo_metadata_Element")) {
                this.__MgetFacetedBundleContext$org_apache_felix_ipojo_metadata_Element = true;
            }
            if (set.contains("getServiceSpecificationAttribute$org_apache_felix_ipojo_metadata_Element")) {
                this.__MgetServiceSpecificationAttribute$org_apache_felix_ipojo_metadata_Element = true;
            }
            if (set.contains("getRequiresFilters$java_lang_Object")) {
                this.__MgetRequiresFilters$java_lang_Object = true;
            }
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("onCreation$java_lang_Object")) {
                this.__MonCreation$java_lang_Object = true;
            }
            if (set.contains("getDescription")) {
                this.__MgetDescription = true;
            }
            if (set.contains("reconfigure$java_util_Dictionary")) {
                this.__Mreconfigure$java_util_Dictionary = true;
            }
            if (set.contains("stateChanged$int")) {
                this.__MstateChanged$int = true;
            }
        }
    }

    @Override
    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

