/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.extender.internal;

import org.apache.felix.ipojo.ConfigurationTracker;
import org.apache.felix.ipojo.EventDispatcher;
import org.apache.felix.ipojo.extender.internal.BundleProcessor;
import org.apache.felix.ipojo.extender.internal.LifecycleQueueService;
import org.apache.felix.ipojo.extender.internal.linker.DeclarationLinker;
import org.apache.felix.ipojo.extender.internal.processor.ChainedBundleProcessor;
import org.apache.felix.ipojo.extender.internal.processor.ComponentsBundleProcessor;
import org.apache.felix.ipojo.extender.internal.processor.ConfigurationProcessor;
import org.apache.felix.ipojo.extender.internal.processor.ExtensionBundleProcessor;
import org.apache.felix.ipojo.extender.internal.processor.QueuingActivationProcessor;
import org.apache.felix.ipojo.extender.internal.queue.ExecutorQueueService;
import org.apache.felix.ipojo.extender.internal.queue.PrefixedThreadFactory;
import org.apache.felix.ipojo.extender.internal.queue.SynchronousQueueService;
import org.apache.felix.ipojo.extender.internal.queue.pref.HeaderPreferenceSelection;
import org.apache.felix.ipojo.extender.internal.queue.pref.Preference;
import org.apache.felix.ipojo.extender.internal.queue.pref.PreferenceQueueService;
import org.apache.felix.ipojo.extender.internal.queue.pref.enforce.EnforcedQueueService;
import org.apache.felix.ipojo.util.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public class Extender
implements BundleActivator {
    static boolean DISPATCHER_ENABLED = true;
    static boolean SYNCHRONOUS_PROCESSING_ENABLED = false;
    private static final String ENABLING_DISPATCHER = "ipojo.internal.dispatcher";
    private static final String SYNCHRONOUS_PROCESSING = "ipojo.processing.synchronous";
    private static BundleContext m_context;
    private Logger m_logger;
    private Bundle m_bundle;
    private ChainedBundleProcessor m_processor;
    private DeclarationLinker m_linker;
    private LifecycleQueueService m_queueService;
    private BundleTracker m_tracker;

    public void start(BundleContext context) throws Exception {
        m_context = context;
        this.m_bundle = context.getBundle();
        this.m_logger = new Logger(m_context, "IPOJO-Main-Extender");
        Extender.enablingDispatcher(context, this.m_logger);
        Extender.enablingSynchronousProcessing(context, this.m_logger);
        if (DISPATCHER_ENABLED) {
            EventDispatcher.create(context);
        }
        ConfigurationTracker.initialize();
        BundleProcessor extensionBundleProcessor = new ExtensionBundleProcessor(this.m_logger);
        BundleProcessor componentsProcessor = new ComponentsBundleProcessor(this.m_logger);
        BundleProcessor configurationProcessor = new ConfigurationProcessor(this.m_logger);
        if (SYNCHRONOUS_PROCESSING_ENABLED) {
            this.m_queueService = new EnforcedQueueService(new HeaderPreferenceSelection(), new SynchronousQueueService(context), Preference.SYNC, this.m_logger);
        } else {
            SynchronousQueueService sync = new SynchronousQueueService(context);
            ExecutorQueueService async = new ExecutorQueueService(context, 1, new PrefixedThreadFactory("[iPOJO] "));
            this.m_queueService = new PreferenceQueueService(new HeaderPreferenceSelection(), sync, async);
            extensionBundleProcessor = new QueuingActivationProcessor(extensionBundleProcessor, this.m_queueService);
            componentsProcessor = new QueuingActivationProcessor(componentsProcessor, this.m_queueService);
            configurationProcessor = new QueuingActivationProcessor(configurationProcessor, this.m_queueService);
        }
        this.m_queueService.start();
        this.m_linker = new DeclarationLinker(context, this.m_queueService);
        this.m_linker.start();
        this.m_processor = ChainedBundleProcessor.create(extensionBundleProcessor, componentsProcessor, configurationProcessor);
        this.m_processor.start();
        this.m_processor.activate(this.m_bundle);
        this.m_tracker = new BundleTracker(context, 32, new BundleTrackerCustomizer(){

            public Object addingBundle(Bundle bundle, BundleEvent event) {
                if (bundle.getBundleId() == Extender.this.m_bundle.getBundleId()) {
                    return null;
                }
                Extender.this.m_processor.activate(bundle);
                return bundle;
            }

            public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
            }

            public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
                Extender.this.m_processor.deactivate(bundle);
            }
        });
        this.m_tracker.open();
        this.m_logger.log(3, "iPOJO Main Extender started");
    }

    public void stop(BundleContext context) throws Exception {
        this.m_tracker.close();
        this.m_processor.deactivate(this.m_bundle);
        ConfigurationTracker.shutdown();
        this.m_processor.stop();
        if (DISPATCHER_ENABLED) {
            EventDispatcher.dispose();
        }
        this.m_linker.stop();
        this.m_queueService.stop();
        this.m_logger.log(3, "iPOJO Main Extender stopped");
        m_context = null;
    }

    public static BundleContext getIPOJOBundleContext() {
        return m_context;
    }

    private static void enablingDispatcher(BundleContext context, Logger logger) {
        String flag = context.getProperty(ENABLING_DISPATCHER);
        if (flag == null) {
            String key = ENABLING_DISPATCHER.replace('.', '-');
            flag = (String)context.getBundle().getHeaders().get(key);
        }
        if (flag != null && flag.equalsIgnoreCase("true")) {
            DISPATCHER_ENABLED = true;
            logger.log(3, "iPOJO Internal Event Dispatcher enables");
            return;
        }
        DISPATCHER_ENABLED = false;
        logger.log(3, "iPOJO Internal Event Dispatcher disables");
    }

    private static void enablingSynchronousProcessing(BundleContext context, Logger logger) {
        String flag = context.getProperty(SYNCHRONOUS_PROCESSING);
        if (flag == null) {
            String key = SYNCHRONOUS_PROCESSING.replace('.', '-');
            flag = (String)context.getBundle().getHeaders().get(key);
        }
        if (flag != null && flag.equalsIgnoreCase("true")) {
            SYNCHRONOUS_PROCESSING_ENABLED = true;
            logger.log(3, "iPOJO Asynchronous processing disabled");
            return;
        }
        SYNCHRONOUS_PROCESSING_ENABLED = false;
        logger.log(3, "iPOJO synchronous processing disabled");
    }
}

