/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.IPOJOServiceFactory;
import org.apache.felix.ipojo.context.ServiceReferenceImpl;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.util.ContextSourceManager;
import org.apache.felix.ipojo.util.DependencyStateListener;
import org.apache.felix.ipojo.util.ServiceReferenceRankingComparator;
import org.apache.felix.ipojo.util.Tracker;
import org.apache.felix.ipojo.util.TrackerCustomizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DependencyModel
implements TrackerCustomizer {
    public static final int BROKEN = -1;
    public static final int UNRESOLVED = 0;
    public static final int RESOLVED = 1;
    public static final int DYNAMIC_BINDING_POLICY = 0;
    public static final int STATIC_BINDING_POLICY = 1;
    public static final int DYNAMIC_PRIORITY_BINDING_POLICY = 2;
    private final ContextSourceManager m_contextSourceManager;
    private boolean m_aggregate;
    private boolean m_optional;
    private Class m_specification;
    private Comparator<ServiceReference> m_comparator;
    private Filter m_filter;
    private BundleContext m_context;
    private final DependencyStateListener m_listener;
    private int m_state;
    private int m_policy = 0;
    private Tracker m_tracker;
    private final List<ServiceReference> m_matchingRefs = new ArrayList<ServiceReference>();
    private final ComponentInstance m_instance;
    private Map<ServiceReference, Object> m_serviceObjects = new HashMap<ServiceReference, Object>();

    public DependencyModel(Class specification, boolean aggregate, boolean optional, Filter filter, Comparator<ServiceReference> comparator, int policy, BundleContext context, DependencyStateListener listener, ComponentInstance ci) {
        this.m_specification = specification;
        this.m_aggregate = aggregate;
        this.m_optional = optional;
        this.m_filter = filter;
        this.m_comparator = comparator;
        this.m_context = context;
        this.m_policy = policy;
        if (this.m_policy == 2 && this.m_comparator == null) {
            this.m_comparator = new ServiceReferenceRankingComparator();
        }
        this.m_state = 0;
        this.m_listener = listener;
        this.m_instance = ci;
        if (this.m_filter != null) {
            try {
                this.m_contextSourceManager = new ContextSourceManager(this);
            }
            catch (InvalidSyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            this.m_contextSourceManager = null;
        }
    }

    public void start() {
        this.m_state = 0;
        this.m_tracker = new Tracker(this.m_context, this.m_specification.getName(), (TrackerCustomizer)this);
        this.m_tracker.open();
        if (this.m_contextSourceManager != null) {
            this.m_contextSourceManager.start();
        }
        this.computeDependencyState();
    }

    public void stop() {
        if (this.m_tracker != null) {
            this.m_tracker.close();
            this.m_tracker = null;
        }
        this.m_matchingRefs.clear();
        this.ungetAllServices();
        this.m_state = 0;
        if (this.m_contextSourceManager != null) {
            this.m_contextSourceManager.stop();
        }
    }

    private void ungetAllServices() {
        for (Map.Entry<ServiceReference, Object> entry : this.m_serviceObjects.entrySet()) {
            ServiceReference ref = entry.getKey();
            Object svc = entry.getValue();
            if (this.m_tracker != null) {
                this.m_tracker.ungetService(ref);
            }
            if (!(svc instanceof IPOJOServiceFactory)) continue;
            ((IPOJOServiceFactory)svc).ungetService(this.m_instance, svc);
        }
        this.m_serviceObjects.clear();
    }

    public boolean isFrozen() {
        return false;
    }

    public void unfreeze() {
    }

    public boolean match(ServiceReference ref) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeDependencyState() {
        if (this.m_state == -1) {
            return;
        }
        boolean mustCallValidate = false;
        boolean mustCallInvalidate = false;
        DependencyModel dependencyModel = this;
        synchronized (dependencyModel) {
            if (this.m_optional || !this.m_matchingRefs.isEmpty()) {
                if (this.m_state == 0) {
                    this.m_state = 1;
                    mustCallValidate = true;
                }
            } else if (this.m_state == 1) {
                this.m_state = 0;
                mustCallInvalidate = true;
            }
        }
        if (mustCallInvalidate) {
            this.invalidate();
        } else if (mustCallValidate) {
            this.validate();
        }
    }

    @Override
    public boolean addingService(ServiceReference ref) {
        return this.m_state != -1 && !this.isFrozen();
    }

    @Override
    public void addedService(ServiceReference ref) {
        if (this.matchAgainstFilter(ref) && this.match(ref)) {
            this.manageArrival(ref);
        }
    }

    private boolean matchAgainstFilter(ServiceReference ref) {
        boolean match = true;
        if (this.m_filter != null) {
            match = ref instanceof ServiceReferenceImpl ? this.m_filter.match(((ServiceReferenceImpl)ref).getProperties()) : this.m_filter.match(ref);
        }
        return match;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void manageArrival(ServiceReference ref) {
        int size;
        int state = this.m_state;
        DependencyModel dependencyModel = this;
        synchronized (dependencyModel) {
            this.m_matchingRefs.add(ref);
            if (this.m_comparator != null && (this.m_policy == 2 || this.m_tracker.getUsedServiceReferences() == null || this.m_tracker.getUsedServiceReferences().isEmpty())) {
                Collections.sort(this.m_matchingRefs, this.m_comparator);
            }
            size = this.m_matchingRefs.size();
        }
        if (this.m_aggregate) {
            this.onServiceArrival(ref);
            if (state == 0) {
                this.computeDependencyState();
            }
        } else if (size == 1) {
            this.onServiceArrival(ref);
            this.computeDependencyState();
        } else if (this.m_policy == 2 && this.m_matchingRefs.get(0) == ref) {
            this.onServiceDeparture(this.m_matchingRefs.get(1));
            this.onServiceArrival(ref);
        }
    }

    @Override
    public void removedService(ServiceReference ref, Object svc) {
        if (this.m_matchingRefs.contains(ref)) {
            this.manageDeparture(ref, svc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void manageDeparture(ServiceReference ref, Object svc) {
        this.ungetService(ref);
        if (this.isFrozen() && svc != null) {
            if (this.m_state != -1) {
                ComponentInstance instance;
                this.m_state = -1;
                this.invalidate();
                DependencyModel dependencyModel = this;
                synchronized (dependencyModel) {
                    instance = this.m_instance;
                }
                instance.stop();
                this.unfreeze();
                instance.start();
            }
        } else {
            DependencyModel instance = this;
            synchronized (instance) {
                this.m_matchingRefs.remove(ref);
            }
            if (svc == null) {
                this.computeDependencyState();
            } else {
                if (this.m_comparator != null && this.m_policy == 0 && !this.m_aggregate) {
                    Collections.sort(this.m_matchingRefs, this.m_comparator);
                }
                this.onServiceDeparture(ref);
                ServiceReference newRef = this.getServiceReference();
                if (newRef == null) {
                    this.computeDependencyState();
                } else if (!this.m_aggregate) {
                    this.onServiceArrival(newRef);
                }
            }
        }
    }

    @Override
    public void modifiedService(ServiceReference ref, Object arg1) {
        if (this.m_matchingRefs.contains(ref)) {
            if (!this.matchAgainstFilter(ref) && this.match(ref)) {
                this.manageDeparture(ref, arg1);
            } else {
                this.manageModification(ref);
            }
        } else if (this.matchAgainstFilter(ref) && this.match(ref)) {
            this.manageArrival(ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceReference getServiceReference() {
        DependencyModel dependencyModel = this;
        synchronized (dependencyModel) {
            if (this.m_matchingRefs.isEmpty()) {
                return null;
            }
            return this.m_matchingRefs.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceReference[] getServiceReferences() {
        DependencyModel dependencyModel = this;
        synchronized (dependencyModel) {
            if (this.m_matchingRefs.isEmpty()) {
                return null;
            }
            return this.m_matchingRefs.toArray(new ServiceReference[this.m_matchingRefs.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServiceReference> getUsedServiceReferences() {
        DependencyModel dependencyModel = this;
        synchronized (dependencyModel) {
            int size = this.m_matchingRefs.size();
            List<ServiceReference> usedByTracker = null;
            if (this.m_tracker != null) {
                usedByTracker = this.m_tracker.getUsedServiceReferences();
            }
            if (size == 0 || usedByTracker == null) {
                return null;
            }
            ArrayList<ServiceReference> list = new ArrayList<ServiceReference>(1);
            for (ServiceReference ref : this.m_matchingRefs) {
                if (!usedByTracker.contains(ref)) continue;
                list.add(ref);
                if (this.isAggregate()) continue;
                return list;
            }
            return list;
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.m_instance;
    }

    public int getSize() {
        return this.m_matchingRefs.size();
    }

    public abstract void onServiceArrival(ServiceReference var1);

    public abstract void onServiceDeparture(ServiceReference var1);

    public abstract void onServiceModification(ServiceReference var1);

    public void manageModification(ServiceReference ref) {
        if (this.m_policy == 2) {
            int indexBefore = this.m_matchingRefs.indexOf(ref);
            Collections.sort(this.m_matchingRefs, this.m_comparator);
            if (indexBefore != this.m_matchingRefs.indexOf(ref) && !this.m_aggregate) {
                this.onServiceDeparture(this.m_matchingRefs.get(1));
                this.onServiceArrival(ref);
            }
        } else {
            this.onServiceModification(ref);
        }
    }

    public abstract void onDependencyReconfiguration(ServiceReference[] var1, ServiceReference[] var2);

    private void invalidate() {
        this.m_listener.invalidate(this);
    }

    private void validate() {
        this.m_listener.validate(this);
    }

    public int getState() {
        return this.m_state;
    }

    public Class getSpecification() {
        return this.m_specification;
    }

    public void setSpecification(Class specification) {
        if (this.m_tracker != null) {
            throw new UnsupportedOperationException("Dynamic specification change is not yet supported");
        }
        this.m_specification = specification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilter(Filter filter) {
        this.m_filter = filter;
        if (this.m_tracker != null) {
            ArrayList<ServiceReference> toRemove = new ArrayList<ServiceReference>();
            ArrayList<ServiceReference> toAdd = new ArrayList<ServiceReference>();
            ServiceReference usedRef = null;
            DependencyModel dependencyModel = this;
            synchronized (dependencyModel) {
                ServiceReference[] refs;
                if (!this.m_aggregate && !this.m_matchingRefs.isEmpty()) {
                    usedRef = this.m_matchingRefs.get(0);
                }
                if ((refs = this.m_tracker.getServiceReferences()) == null) {
                    toRemove.addAll(this.m_matchingRefs);
                    this.m_matchingRefs.clear();
                } else {
                    ArrayList<ServiceReference> matching = new ArrayList<ServiceReference>();
                    for (ServiceReference ref : refs) {
                        if (!this.matchAgainstFilter(ref) || !this.match(ref)) continue;
                        matching.add(ref);
                    }
                    for (ServiceReference ref : this.m_matchingRefs) {
                        if (matching.contains(ref)) continue;
                        toRemove.add(ref);
                    }
                    this.m_matchingRefs.removeAll(toRemove);
                    for (ServiceReference ref : matching) {
                        if (this.m_matchingRefs.contains(ref)) continue;
                        this.m_matchingRefs.add(ref);
                        toAdd.add(ref);
                    }
                    if (this.m_comparator != null) {
                        Collections.sort(this.m_matchingRefs, this.m_comparator);
                        Collections.sort(toAdd, this.m_comparator);
                        Collections.sort(toRemove, this.m_comparator);
                    }
                }
            }
            if (this.m_aggregate) {
                ServiceReference[] rem = null;
                ServiceReference[] add = null;
                if (!toAdd.isEmpty()) {
                    add = toAdd.toArray(new ServiceReference[toAdd.size()]);
                }
                if (!toRemove.isEmpty()) {
                    rem = toRemove.toArray(new ServiceReference[toRemove.size()]);
                }
                if (rem != null || add != null) {
                    this.onDependencyReconfiguration(rem, add);
                }
            } else {
                int size;
                ServiceReference newRef = null;
                List<ServiceReference> list = this.m_matchingRefs;
                synchronized (list) {
                    size = this.m_matchingRefs.size();
                    if (size > 0) {
                        newRef = this.m_matchingRefs.get(0);
                    }
                }
                if (usedRef == null) {
                    if (size > 0) {
                        this.onDependencyReconfiguration(null, new ServiceReference[]{newRef});
                    }
                } else if (toRemove.contains(usedRef)) {
                    if (size > 0) {
                        this.onDependencyReconfiguration(new ServiceReference[]{usedRef}, new ServiceReference[]{newRef});
                    } else {
                        this.onDependencyReconfiguration(new ServiceReference[]{usedRef}, null);
                    }
                } else if (this.m_policy == 2 && newRef != usedRef) {
                    this.onDependencyReconfiguration(new ServiceReference[]{usedRef}, new ServiceReference[]{newRef});
                }
            }
            this.computeDependencyState();
        }
    }

    public String getFilter() {
        if (this.m_filter == null) {
            return null;
        }
        return this.m_filter.toString();
    }

    public synchronized void setAggregate(boolean isAggregate) {
        block5: {
            block6: {
                block4: {
                    if (this.m_tracker != null) break block4;
                    this.m_aggregate = isAggregate;
                    break block5;
                }
                if (this.m_aggregate || !isAggregate) break block6;
                this.m_aggregate = true;
                if (this.m_state != 1) break block5;
                for (int i = 1; i < this.m_matchingRefs.size(); ++i) {
                    this.onServiceArrival(this.m_matchingRefs.get(i));
                }
                break block5;
            }
            if (this.m_aggregate && !isAggregate) {
                this.m_aggregate = false;
                if (this.m_state == 1) {
                    for (int i = 1; i < this.m_matchingRefs.size(); ++i) {
                        this.onServiceDeparture(this.m_matchingRefs.get(i));
                    }
                }
            }
        }
    }

    public synchronized boolean isAggregate() {
        return this.m_aggregate;
    }

    public void setOptionality(boolean isOptional) {
        if (this.m_tracker == null) {
            this.m_optional = isOptional;
        } else {
            this.computeDependencyState();
        }
    }

    public boolean isOptional() {
        return this.m_optional;
    }

    public int getBindingPolicy() {
        return this.m_policy;
    }

    public void setBindingPolicy() {
        throw new UnsupportedOperationException("Binding Policy change is not yet supported");
    }

    public void setComparator(Comparator<ServiceReference> cmp) {
        this.m_comparator = cmp;
    }

    public synchronized String getComparator() {
        if (this.m_comparator != null) {
            return this.m_comparator.getClass().getName();
        }
        return null;
    }

    public void setBundleContext(BundleContext context) {
        if (this.m_tracker != null) {
            throw new UnsupportedOperationException("Dynamic bundle (i.e. service) context change is not supported");
        }
        this.m_context = context;
    }

    public Object getService(ServiceReference ref) {
        return this.getService(ref, true);
    }

    public Object getService(ServiceReference ref, boolean store) {
        Object svc = this.m_tracker.getService(ref);
        if (svc instanceof IPOJOServiceFactory) {
            Object obj = ((IPOJOServiceFactory)svc).getService(this.m_instance);
            if (store) {
                this.m_serviceObjects.put(ref, svc);
            }
            return obj;
        }
        if (store) {
            this.m_serviceObjects.put(ref, svc);
        }
        return svc;
    }

    public void ungetService(ServiceReference ref) {
        this.m_tracker.ungetService(ref);
        Object obj = this.m_serviceObjects.remove(ref);
        if (obj != null && obj instanceof IPOJOServiceFactory) {
            ((IPOJOServiceFactory)obj).ungetService(this.m_instance, obj);
        }
    }

    public static Comparator getComparator(Element dep, BundleContext context) throws ConfigurationException {
        Comparator<ServiceReference> cmp = null;
        String comp = dep.getAttribute("comparator");
        if (comp != null) {
            if (comp.equalsIgnoreCase("osgi")) {
                cmp = new ServiceReferenceRankingComparator();
            } else {
                try {
                    Class cla = context.getBundle().loadClass(comp);
                    cmp = (Comparator)cla.newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new ConfigurationException("Cannot load a customized comparator", e);
                }
                catch (IllegalAccessException e) {
                    throw new ConfigurationException("Cannot create a customized comparator", e);
                }
                catch (InstantiationException e) {
                    throw new ConfigurationException("Cannot create a customized comparator", e);
                }
            }
        }
        return cmp;
    }

    public static Class loadSpecification(String specification, BundleContext context) throws ConfigurationException {
        Class spec;
        try {
            spec = context.getBundle().loadClass(specification);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("A required specification cannot be loaded : " + specification, e);
        }
        return spec;
    }

    public static int getPolicy(Element dep) throws ConfigurationException {
        String policy = dep.getAttribute("policy");
        if (policy == null || policy.equalsIgnoreCase("dynamic")) {
            return 0;
        }
        if (policy.equalsIgnoreCase("dynamic-priority")) {
            return 2;
        }
        if (policy.equalsIgnoreCase("static")) {
            return 1;
        }
        throw new ConfigurationException("Binding policy unknown : " + policy);
    }

    public ContextSourceManager getContextSourceManager() {
        return this.m_contextSourceManager;
    }
}

