/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.List;
import org.apache.felix.ipojo.ContextListener;
import org.apache.felix.ipojo.ContextSource;
import org.apache.felix.ipojo.util.DependencyModel;
import org.apache.felix.ipojo.util.Tracker;
import org.apache.felix.ipojo.util.TrackerCustomizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextSourceManager
implements ContextListener {
    public static final String VARIABLE_START = "${";
    public static final char VARIABLE_END = '}';
    public static final List<Character> FORBIDDEN_CHARACTERS = Arrays.asList(Character.valueOf('('), Character.valueOf(')'), Character.valueOf('&'), Character.valueOf('|'), Character.valueOf('!'), Character.valueOf('='), Character.valueOf('*'), Character.valueOf(' '));
    private DependencyModel m_dependency;
    private List<ContextSource> m_sources = new ArrayList<ContextSource>(1);
    private List<String> m_variables;
    private String m_filter;
    private BundleContext m_context;
    private Tracker m_tracker;

    public ContextSourceManager(DependencyModel dependency) throws InvalidSyntaxException {
        this.m_filter = dependency.getFilter();
        this.m_variables = ContextSourceManager.extractVariablesFromFilter(this.m_filter);
        this.m_dependency = dependency;
        this.m_context = dependency.getComponentInstance().getContext();
    }

    public static String substitute(String str, Dictionary values) {
        int len = str.length();
        StringBuilder builder = new StringBuilder(len);
        int prev = 0;
        int start = str.indexOf(VARIABLE_START);
        int end = str.indexOf(125, start);
        while (start != -1 && end != -1) {
            String key = str.substring(start + 2, end);
            Object value = values.get(key);
            if (value == null) {
                builder.append(str.substring(prev, end + 1));
            } else {
                builder.append(str.substring(prev, start));
                builder.append(value);
            }
            prev = end + 1;
            if (prev >= str.length()) break;
            start = str.indexOf(VARIABLE_START, prev);
            if (start == -1) continue;
            end = str.indexOf(125, start);
        }
        builder.append(str.substring(prev));
        return builder.toString();
    }

    public static List<String> extractVariablesFromFilter(String filter) throws InvalidSyntaxException {
        ArrayList<String> variables = new ArrayList<String>();
        int start = filter.indexOf(VARIABLE_START);
        int end = filter.indexOf(125, start);
        while (start != -1) {
            if (end == -1) {
                throw new InvalidSyntaxException("The filter contains an unfinished variable", filter);
            }
            String key = filter.substring(start + VARIABLE_START.length(), end);
            if (key.length() == 0) {
                throw new InvalidSyntaxException("The filter variable '${}' is not a valid variable", filter);
            }
            Character forbidden = ContextSourceManager.containsForbiddenCharacter(key);
            if (forbidden != null) {
                throw new InvalidSyntaxException("The filter variable '${" + key + "}' contains a forbidden " + "character : '" + forbidden + "'", filter);
            }
            variables.add(key);
            int prev = end + 1;
            if (prev >= filter.length()) break;
            start = filter.indexOf(VARIABLE_START, prev);
            if (start == -1) continue;
            end = filter.indexOf(125, start);
        }
        return variables;
    }

    private static Character containsForbiddenCharacter(String key) {
        for (Character character : FORBIDDEN_CHARACTERS) {
            if (key.indexOf(character.charValue()) == -1) continue;
            return character;
        }
        return null;
    }

    public void start() {
        if (this.m_tracker == null) {
            this.m_tracker = new Tracker(this.m_context, ContextSource.class.getName(), (TrackerCustomizer)new SourceTracker());
        }
        this.m_tracker.open();
        this.computeFilter();
    }

    public void stop() {
        if (this.m_tracker != null) {
            this.m_tracker.close();
            this.m_tracker = null;
        }
        this.setFilter(this.m_filter);
        for (ContextSource source : this.m_sources) {
            source.unregisterContextListener(this);
        }
        this.m_sources.clear();
    }

    private void setFilter(String filter) {
        if (!filter.equals(this.m_dependency.getFilter())) {
            try {
                this.m_dependency.setFilter(this.m_context.createFilter(filter));
            }
            catch (InvalidSyntaxException e) {
                throw new IllegalStateException("A context filter is invalid : " + filter, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeFilter() {
        String fil = this.m_filter;
        ContextSourceManager contextSourceManager = this;
        synchronized (contextSourceManager) {
            for (ContextSource m_source : this.m_sources) {
                Dictionary props = m_source.getContext();
                fil = ContextSourceManager.substitute(fil, props);
            }
        }
        if (!fil.equals(this.m_dependency.getFilter())) {
            this.setFilter(fil);
        }
    }

    @Override
    public synchronized void update(ContextSource source, String property, Object value) {
        this.computeFilter();
    }

    public void addContextSource(ContextSource source) {
        this.m_sources.add(source);
        this.computeFilter();
        source.registerContextListener(this, this.m_variables.toArray(new String[this.m_variables.size()]));
    }

    public void removeContextSource(ContextSource source) {
        source.unregisterContextListener(this);
        this.m_sources.remove(source);
        this.computeFilter();
    }

    private class SourceTracker
    implements TrackerCustomizer {
        private SourceTracker() {
        }

        public void addedService(ServiceReference reference) {
            System.out.println("Source added");
            ContextSourceManager.this.addContextSource((ContextSource)ContextSourceManager.this.m_tracker.getService(reference));
        }

        public boolean addingService(ServiceReference reference) {
            return true;
        }

        public void modifiedService(ServiceReference reference, Object service) {
        }

        public void removedService(ServiceReference reference, Object service) {
            ContextSourceManager.this.removeContextSource((ContextSource)service);
        }
    }
}

