/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handlers.providedservice;

import java.lang.reflect.Field;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.PrimitiveHandler;
import org.apache.felix.ipojo.architecture.ComponentTypeDescription;
import org.apache.felix.ipojo.architecture.HandlerDescription;
import org.apache.felix.ipojo.architecture.PropertyDescription;
import org.apache.felix.ipojo.handlers.dependency.Dependency;
import org.apache.felix.ipojo.handlers.dependency.DependencyHandler;
import org.apache.felix.ipojo.handlers.providedservice.CreationStrategy;
import org.apache.felix.ipojo.handlers.providedservice.ProvidedService;
import org.apache.felix.ipojo.handlers.providedservice.ProvidedServiceHandlerDescription;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.parser.FieldMetadata;
import org.apache.felix.ipojo.parser.ManifestMetadataParser;
import org.apache.felix.ipojo.parser.ParseException;
import org.apache.felix.ipojo.parser.ParseUtils;
import org.apache.felix.ipojo.parser.PojoMetadata;
import org.apache.felix.ipojo.util.Callback;
import org.apache.felix.ipojo.util.Property;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

public class ProvidedServiceHandler
extends PrimitiveHandler
implements Pojo {
    private InstanceManager __IM;
    private boolean __Fm_providedServices;
    private ProvidedService[] m_providedServices;
    private boolean __Fm_description;
    private ProvidedServiceHandlerDescription m_description;
    private boolean __MaddProvidedService$org_apache_felix_ipojo_handlers_providedservice_ProvidedService;
    private boolean __MgetProvidedServices;
    private boolean __Mconfigure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary;
    private boolean __McomputeInterfacesAndSuperClasses$java_lang_String__$java_lang_String$org_osgi_framework_Bundle$java_util_Set$java_util_Set;
    private boolean __McollectInterfaces$java_lang_Class$java_util_Set$org_osgi_framework_Bundle;
    private boolean __McollectInterfacesFromClass$java_lang_Class$java_util_Set$org_osgi_framework_Bundle;
    private boolean __McollectParentClassesFromClass$java_lang_Class$java_util_Set$org_osgi_framework_Bundle;
    private boolean __McheckProvidedService$org_apache_felix_ipojo_handlers_providedservice_ProvidedService;
    private boolean __MgetAttachedDependency$org_apache_felix_ipojo_metadata_Element;
    private boolean __MisDependencyCorrect$org_apache_felix_ipojo_handlers_dependency_Dependency$org_apache_felix_ipojo_metadata_Element;
    private boolean __Mstop;
    private boolean __Mstart;
    private boolean __MonSet$java_lang_Object$java_lang_String$java_lang_Object;
    private boolean __MonGet$java_lang_Object$java_lang_String$java_lang_Object;
    private boolean __MstateChanged$int;
    private boolean __MaddProperties$java_util_Dictionary;
    private boolean __MremoveProperties$java_util_Dictionary;
    private boolean __MgetDescription;
    private boolean __Mreconfigure$java_util_Dictionary;
    private boolean __MinitializeComponentFactory$org_apache_felix_ipojo_architecture_ComponentTypeDescription$org_apache_felix_ipojo_metadata_Element;

    ProvidedService[] __getm_providedServices() {
        if (!this.__Fm_providedServices) {
            return this.m_providedServices;
        }
        return (ProvidedService[])this.__IM.onGet(this, "m_providedServices");
    }

    void __setm_providedServices(ProvidedService[] providedServiceArray) {
        if (!this.__Fm_providedServices) {
            this.m_providedServices = providedServiceArray;
            return;
        }
        this.__IM.onSet(this, "m_providedServices", providedServiceArray);
    }

    ProvidedServiceHandlerDescription __getm_description() {
        if (!this.__Fm_description) {
            return this.m_description;
        }
        return (ProvidedServiceHandlerDescription)this.__IM.onGet(this, "m_description");
    }

    void __setm_description(ProvidedServiceHandlerDescription providedServiceHandlerDescription) {
        if (!this.__Fm_description) {
            this.m_description = providedServiceHandlerDescription;
            return;
        }
        this.__IM.onSet(this, "m_description", providedServiceHandlerDescription);
    }

    public ProvidedServiceHandler() {
        this(null);
    }

    private ProvidedServiceHandler(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setm_providedServices(new ProvidedService[0]);
    }

    private void addProvidedService(ProvidedService svc) {
        if (!this.__MaddProvidedService$org_apache_felix_ipojo_handlers_providedservice_ProvidedService) {
            this.__M_addProvidedService(svc);
            return;
        }
        try {
            this.__IM.onEntry(this, "addProvidedService$org_apache_felix_ipojo_handlers_providedservice_ProvidedService", new Object[]{svc});
            this.__M_addProvidedService(svc);
            this.__IM.onExit(this, "addProvidedService$org_apache_felix_ipojo_handlers_providedservice_ProvidedService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "addProvidedService$org_apache_felix_ipojo_handlers_providedservice_ProvidedService", throwable);
            throw throwable;
        }
    }

    private void __M_addProvidedService(ProvidedService svc) {
        for (int i = 0; i < this.__getm_providedServices().length; ++i) {
            if (this.__getm_providedServices()[i] != svc) continue;
            return;
        }
        if (this.__getm_providedServices().length > 0) {
            ProvidedService[] newPS = new ProvidedService[this.__getm_providedServices().length + 1];
            System.arraycopy(this.__getm_providedServices(), 0, newPS, 0, this.__getm_providedServices().length);
            newPS[this.__getm_providedServices().length] = svc;
            this.__setm_providedServices(newPS);
        } else {
            this.__setm_providedServices(new ProvidedService[]{svc});
        }
    }

    public ProvidedService[] getProvidedServices() {
        ProvidedService[] providedServiceArray;
        if (!this.__MgetProvidedServices) {
            return this.__M_getProvidedServices();
        }
        try {
            this.__IM.onEntry(this, "getProvidedServices", new Object[0]);
            providedServiceArray = this.__M_getProvidedServices();
            this.__IM.onExit(this, "getProvidedServices", providedServiceArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "getProvidedServices", throwable);
            throw throwable;
        }
        return providedServiceArray;
    }

    private ProvidedService[] __M_getProvidedServices() {
        return this.__getm_providedServices();
    }

    public void configure(Element componentMetadata, Dictionary configuration) throws ConfigurationException {
        if (!this.__Mconfigure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary) {
            this.__M_configure(componentMetadata, configuration);
            return;
        }
        try {
            this.__IM.onEntry(this, "configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", new Object[]{componentMetadata, configuration});
            this.__M_configure(componentMetadata, configuration);
            this.__IM.onExit(this, "configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", throwable);
            throw throwable;
        }
    }

    private void __M_configure(Element componentMetadata, Dictionary configuration) throws ConfigurationException {
        this.__setm_providedServices(new ProvidedService[0]);
        Element[] providedServices = componentMetadata.getElements("Provides");
        for (int i = 0; i < providedServices.length; ++i) {
            Element[] controllers;
            Element[] props;
            Callback cb;
            String[] serviceSpecifications = ParseUtils.parseArrays(providedServices[i].getAttribute("specifications"));
            int factory = 0;
            Class custom = null;
            String strategy = providedServices[i].getAttribute("strategy");
            if (strategy == null) {
                strategy = providedServices[i].getAttribute("factory");
            }
            if (strategy != null) {
                if ("singleton".equalsIgnoreCase(strategy)) {
                    factory = 0;
                } else if ("service".equalsIgnoreCase(strategy)) {
                    factory = 1;
                } else if ("method".equalsIgnoreCase(strategy)) {
                    factory = 2;
                } else if ("instance".equalsIgnoreCase(strategy)) {
                    factory = 3;
                } else {
                    try {
                        custom = this.getInstanceManager().getContext().getBundle().loadClass(strategy);
                        if (!CreationStrategy.class.isAssignableFrom(custom)) {
                            throw new ConfigurationException("The custom creation policy class " + custom.getName() + " does not implement " + CreationStrategy.class.getName());
                        }
                    }
                    catch (ClassNotFoundException e) {
                        throw new ConfigurationException("The custom creation policy class " + strategy + " cannot be loaded ", e);
                    }
                }
            }
            ProvidedService svc = new ProvidedService(this, serviceSpecifications, factory, custom, configuration);
            String post = providedServices[i].getAttribute("post-registration");
            if (post != null) {
                cb = new Callback(post, new Class[]{ServiceReference.class}, false, this.getInstanceManager());
                svc.setPostRegistrationCallback(cb);
            }
            if ((post = providedServices[i].getAttribute("post-unregistration")) != null) {
                cb = new Callback(post, new Class[]{ServiceReference.class}, false, this.getInstanceManager());
                svc.setPostUnregistrationCallback(cb);
            }
            if ((props = providedServices[i].getElements("Property")) != null) {
                Property[] properties = new Property[props.length];
                for (int j = 0; j < props.length; ++j) {
                    Property prop;
                    String name = props[j].getAttribute("name");
                    String value = props[j].getAttribute("value");
                    String type = props[j].getAttribute("type");
                    String field = props[j].getAttribute("field");
                    properties[j] = prop = new Property(name, field, null, value, type, this.getInstanceManager(), this);
                    Object object = configuration.get(prop.getName());
                    if (object != null) {
                        prop.setValue(object);
                    }
                    if (field == null) continue;
                    this.getInstanceManager().register(new FieldMetadata(field, type), this);
                }
                svc.setProperties(properties);
            }
            if ((controllers = providedServices[i].getElements("Controller")) != null) {
                for (int k = 0; k < controllers.length; ++k) {
                    String field = controllers[k].getAttribute("field");
                    if (field == null) {
                        throw new ConfigurationException("The field attribute of a controller is mandatory");
                    }
                    String v = controllers[k].getAttribute("value");
                    boolean value = v == null || !v.equalsIgnoreCase("false");
                    String s = controllers[k].getAttribute("specification");
                    if (s == null) {
                        s = "ALL";
                    }
                    svc.setController(field, value, s);
                    this.getInstanceManager().register(new FieldMetadata(field, "boolean"), this);
                }
            }
            if (!this.checkProvidedService(svc)) {
                StringBuffer itfs = new StringBuffer();
                for (int j = 0; j < serviceSpecifications.length; ++j) {
                    itfs.append(' ');
                    itfs.append(serviceSpecifications[j]);
                }
                throw new ConfigurationException("The provided service" + itfs + " is not valid");
            }
            this.addProvidedService(svc);
            this.__setm_description(new ProvidedServiceHandlerDescription(this, this.__getm_providedServices()));
        }
    }

    private void computeInterfacesAndSuperClasses(String[] specs, String parent, Bundle bundle, Set interfaces, Set classes) throws ClassNotFoundException {
        if (!this.__McomputeInterfacesAndSuperClasses$java_lang_String__$java_lang_String$org_osgi_framework_Bundle$java_util_Set$java_util_Set) {
            this.__M_computeInterfacesAndSuperClasses(specs, parent, bundle, interfaces, classes);
            return;
        }
        try {
            this.__IM.onEntry(this, "computeInterfacesAndSuperClasses$java_lang_String__$java_lang_String$org_osgi_framework_Bundle$java_util_Set$java_util_Set", new Object[]{specs, parent, bundle, interfaces, classes});
            this.__M_computeInterfacesAndSuperClasses(specs, parent, bundle, interfaces, classes);
            this.__IM.onExit(this, "computeInterfacesAndSuperClasses$java_lang_String__$java_lang_String$org_osgi_framework_Bundle$java_util_Set$java_util_Set", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "computeInterfacesAndSuperClasses$java_lang_String__$java_lang_String$org_osgi_framework_Bundle$java_util_Set$java_util_Set", throwable);
            throw throwable;
        }
    }

    private void __M_computeInterfacesAndSuperClasses(String[] specs, String parent, Bundle bundle, Set interfaces, Set classes) throws ClassNotFoundException {
        for (int i = 0; i < specs.length; ++i) {
            interfaces.add(specs[i]);
            Class clazz = bundle.loadClass(specs[i]);
            this.collectInterfaces(clazz, interfaces, bundle);
        }
        if (parent != null) {
            Class clazz = bundle.loadClass(parent);
            this.collectInterfacesFromClass(clazz, interfaces, bundle);
            classes.add(parent);
            this.collectParentClassesFromClass(clazz, classes, bundle);
        }
    }

    private void collectInterfaces(Class clazz, Set acc, Bundle bundle) throws ClassNotFoundException {
        if (!this.__McollectInterfaces$java_lang_Class$java_util_Set$org_osgi_framework_Bundle) {
            this.__M_collectInterfaces(clazz, acc, bundle);
            return;
        }
        try {
            this.__IM.onEntry(this, "collectInterfaces$java_lang_Class$java_util_Set$org_osgi_framework_Bundle", new Object[]{clazz, acc, bundle});
            this.__M_collectInterfaces(clazz, acc, bundle);
            this.__IM.onExit(this, "collectInterfaces$java_lang_Class$java_util_Set$org_osgi_framework_Bundle", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "collectInterfaces$java_lang_Class$java_util_Set$org_osgi_framework_Bundle", throwable);
            throw throwable;
        }
    }

    private void __M_collectInterfaces(Class clazz, Set acc, Bundle bundle) throws ClassNotFoundException {
        Class<?>[] clazzes = clazz.getInterfaces();
        for (int i = 0; i < clazzes.length; ++i) {
            acc.add(clazzes[i].getName());
            this.collectInterfaces(clazzes[i], acc, bundle);
        }
    }

    private void collectInterfacesFromClass(Class clazz, Set acc, Bundle bundle) throws ClassNotFoundException {
        if (!this.__McollectInterfacesFromClass$java_lang_Class$java_util_Set$org_osgi_framework_Bundle) {
            this.__M_collectInterfacesFromClass(clazz, acc, bundle);
            return;
        }
        try {
            this.__IM.onEntry(this, "collectInterfacesFromClass$java_lang_Class$java_util_Set$org_osgi_framework_Bundle", new Object[]{clazz, acc, bundle});
            this.__M_collectInterfacesFromClass(clazz, acc, bundle);
            this.__IM.onExit(this, "collectInterfacesFromClass$java_lang_Class$java_util_Set$org_osgi_framework_Bundle", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "collectInterfacesFromClass$java_lang_Class$java_util_Set$org_osgi_framework_Bundle", throwable);
            throw throwable;
        }
    }

    private void __M_collectInterfacesFromClass(Class clazz, Set acc, Bundle bundle) throws ClassNotFoundException {
        Class<?>[] clazzes = clazz.getInterfaces();
        for (int i = 0; i < clazzes.length; ++i) {
            acc.add(clazzes[i].getName());
            this.collectInterfaces(clazzes[i], acc, bundle);
        }
        Class sup = clazz.getSuperclass();
        if (sup != null) {
            this.collectInterfacesFromClass(sup, acc, bundle);
        }
    }

    private void collectParentClassesFromClass(Class clazz, Set acc, Bundle bundle) throws ClassNotFoundException {
        if (!this.__McollectParentClassesFromClass$java_lang_Class$java_util_Set$org_osgi_framework_Bundle) {
            this.__M_collectParentClassesFromClass(clazz, acc, bundle);
            return;
        }
        try {
            this.__IM.onEntry(this, "collectParentClassesFromClass$java_lang_Class$java_util_Set$org_osgi_framework_Bundle", new Object[]{clazz, acc, bundle});
            this.__M_collectParentClassesFromClass(clazz, acc, bundle);
            this.__IM.onExit(this, "collectParentClassesFromClass$java_lang_Class$java_util_Set$org_osgi_framework_Bundle", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "collectParentClassesFromClass$java_lang_Class$java_util_Set$org_osgi_framework_Bundle", throwable);
            throw throwable;
        }
    }

    private void __M_collectParentClassesFromClass(Class clazz, Set acc, Bundle bundle) throws ClassNotFoundException {
        Class parent = clazz.getSuperclass();
        if (parent != null) {
            acc.add(parent.getName());
            this.collectParentClassesFromClass(parent, acc, bundle);
        }
    }

    private boolean checkProvidedService(ProvidedService svc) throws ConfigurationException {
        boolean bl;
        if (!this.__McheckProvidedService$org_apache_felix_ipojo_handlers_providedservice_ProvidedService) {
            return this.__M_checkProvidedService(svc);
        }
        try {
            this.__IM.onEntry(this, "checkProvidedService$org_apache_felix_ipojo_handlers_providedservice_ProvidedService", new Object[]{svc});
            bl = this.__M_checkProvidedService(svc);
            this.__IM.onExit(this, "checkProvidedService$org_apache_felix_ipojo_handlers_providedservice_ProvidedService", new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "checkProvidedService$org_apache_felix_ipojo_handlers_providedservice_ProvidedService", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_checkProvidedService(ProvidedService svc) throws ConfigurationException {
        for (int i = 0; i < svc.getServiceSpecifications().length; ++i) {
            String specName = svc.getServiceSpecifications()[i];
            try {
                Class spec = this.getInstanceManager().getFactory().loadClass(specName);
                Field specField = spec.getField("specification");
                Object specif = specField.get(null);
                if (specif instanceof String) {
                    Element specification = ManifestMetadataParser.parse((String)specif);
                    Element[] deps = specification.getElements("requires");
                    for (int j = 0; deps != null && j < deps.length; ++j) {
                        Dependency dep = this.getAttachedDependency(deps[j]);
                        if (dep != null) {
                            dep.setServiceLevelDependency();
                        }
                        this.isDependencyCorrect(dep, deps[j]);
                    }
                    continue;
                }
                throw new ConfigurationException("Service Providing: The specification field of the service specification " + svc.getServiceSpecifications()[i] + " needs to be a String");
            }
            catch (NoSuchFieldException e) {
                return true;
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("Service Providing: The service specification " + svc.getServiceSpecifications()[i] + " cannot be loaded", e);
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException("Service Providing: The field 'specification' of the service specification " + svc.getServiceSpecifications()[i] + " is not accessible", e);
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException("Service Providing: The field 'specification' of the service specification " + svc.getServiceSpecifications()[i] + " is not accessible", e);
            }
            catch (ParseException e) {
                throw new ConfigurationException("Service Providing: The field 'specification' of the service specification " + svc.getServiceSpecifications()[i] + " does not contain a valid String", e);
            }
        }
        return true;
    }

    private Dependency getAttachedDependency(Element element) {
        Dependency dependency;
        if (!this.__MgetAttachedDependency$org_apache_felix_ipojo_metadata_Element) {
            return this.__M_getAttachedDependency(element);
        }
        try {
            this.__IM.onEntry(this, "getAttachedDependency$org_apache_felix_ipojo_metadata_Element", new Object[]{element});
            dependency = this.__M_getAttachedDependency(element);
            this.__IM.onExit(this, "getAttachedDependency$org_apache_felix_ipojo_metadata_Element", dependency);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "getAttachedDependency$org_apache_felix_ipojo_metadata_Element", throwable);
            throw throwable;
        }
        return dependency;
    }

    private Dependency __M_getAttachedDependency(Element element) {
        DependencyHandler handler = (DependencyHandler)this.getHandler("org.apache.felix.ipojo:requires");
        if (handler == null) {
            return null;
        }
        String identity = element.getAttribute("id");
        if (identity != null) {
            for (int i = 0; i < handler.getDependencies().length; ++i) {
                if (!handler.getDependencies()[i].getId().equals(identity)) continue;
                return handler.getDependencies()[i];
            }
        }
        String requirement = element.getAttribute("specification");
        for (int i = 0; i < handler.getDependencies().length; ++i) {
            if (!handler.getDependencies()[i].getSpecification().getName().equals(requirement)) continue;
            return handler.getDependencies()[i];
        }
        return null;
    }

    private void isDependencyCorrect(Dependency dep, Element elem) throws ConfigurationException {
        if (!this.__MisDependencyCorrect$org_apache_felix_ipojo_handlers_dependency_Dependency$org_apache_felix_ipojo_metadata_Element) {
            this.__M_isDependencyCorrect(dep, elem);
            return;
        }
        try {
            this.__IM.onEntry(this, "isDependencyCorrect$org_apache_felix_ipojo_handlers_dependency_Dependency$org_apache_felix_ipojo_metadata_Element", new Object[]{dep, elem});
            this.__M_isDependencyCorrect(dep, elem);
            this.__IM.onExit(this, "isDependencyCorrect$org_apache_felix_ipojo_handlers_dependency_Dependency$org_apache_felix_ipojo_metadata_Element", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "isDependencyCorrect$org_apache_felix_ipojo_handlers_dependency_Dependency$org_apache_felix_ipojo_metadata_Element", throwable);
            throw throwable;
        }
    }

    private void __M_isDependencyCorrect(Dependency dep, Element elem) throws ConfigurationException {
        String filter2;
        boolean agg;
        String optional = elem.getAttribute("optional");
        boolean opt = optional != null && optional.equalsIgnoreCase("true");
        String aggregate = elem.getAttribute("aggregate");
        boolean bl = agg = aggregate != null && aggregate.equalsIgnoreCase("true");
        if (dep == null && !opt) {
            throw new ConfigurationException("Service Providing: The requirement " + elem.getAttribute("specification") + " is not present in the implementation and is declared as a mandatory service-level requirement");
        }
        if (dep != null && dep.isAggregate() && !agg) {
            throw new ConfigurationException("Service Providing: The requirement " + elem.getAttribute("specification") + " is aggregate in the implementation and is declared as a simple service-level requirement");
        }
        String filter = elem.getAttribute("filter");
        if (!(dep == null || filter == null || (filter2 = dep.getFilter()) != null && filter2.equalsIgnoreCase(filter))) {
            throw new ConfigurationException("Service Providing: The specification requirement " + elem.getAttribute("specification") + " has not the same filter as declared in the service-level requirement");
        }
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry(this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit(this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "stop", throwable);
            throw throwable;
        }
    }

    private void __M_stop() {
    }

    public void start() {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry(this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit(this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "start", throwable);
            throw throwable;
        }
    }

    private void __M_start() {
    }

    public void onSet(Object pojo, String fieldName, Object value) {
        if (!this.__MonSet$java_lang_Object$java_lang_String$java_lang_Object) {
            this.__M_onSet(pojo, fieldName, value);
            return;
        }
        try {
            this.__IM.onEntry(this, "onSet$java_lang_Object$java_lang_String$java_lang_Object", new Object[]{pojo, fieldName, value});
            this.__M_onSet(pojo, fieldName, value);
            this.__IM.onExit(this, "onSet$java_lang_Object$java_lang_String$java_lang_Object", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "onSet$java_lang_Object$java_lang_String$java_lang_Object", throwable);
            throw throwable;
        }
    }

    private void __M_onSet(Object pojo, String fieldName, Object value) {
        for (int i = 0; i < this.__getm_providedServices().length; ++i) {
            ProvidedService.ServiceController ctrl;
            ProvidedService svc = this.__getm_providedServices()[i];
            boolean update = false;
            for (int j = 0; j < svc.getProperties().length; ++j) {
                Property prop = svc.getProperties()[j];
                if (!fieldName.equals(prop.getField()) || prop.getValue().equals(value)) continue;
                prop.setValue(value);
                update = true;
            }
            if (update) {
                svc.update();
            }
            if ((ctrl = svc.getController(fieldName)) == null) continue;
            if (value instanceof Boolean) {
                ctrl.setValue((Boolean)value);
                continue;
            }
            this.warn("Boolean value expected for the service controler " + fieldName);
        }
    }

    public Object onGet(Object pojo, String fieldName, Object value) {
        Object object;
        if (!this.__MonGet$java_lang_Object$java_lang_String$java_lang_Object) {
            return this.__M_onGet(pojo, fieldName, value);
        }
        try {
            this.__IM.onEntry(this, "onGet$java_lang_Object$java_lang_String$java_lang_Object", new Object[]{pojo, fieldName, value});
            object = this.__M_onGet(pojo, fieldName, value);
            this.__IM.onExit(this, "onGet$java_lang_Object$java_lang_String$java_lang_Object", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "onGet$java_lang_Object$java_lang_String$java_lang_Object", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __M_onGet(Object pojo, String fieldName, Object value) {
        for (int i = 0; i < this.__getm_providedServices().length; ++i) {
            ProvidedService svc = this.__getm_providedServices()[i];
            for (int j = 0; j < svc.getProperties().length; ++j) {
                Property prop = svc.getProperties()[j];
                if (!fieldName.equals(prop.getField())) continue;
                return prop.onGet(pojo, fieldName, value);
            }
            ProvidedService.ServiceController ctrl = svc.getController(fieldName);
            if (ctrl == null) continue;
            return new Boolean(ctrl.getValue());
        }
        return value;
    }

    public void stateChanged(int state) {
        if (!this.__MstateChanged$int) {
            this.__M_stateChanged(state);
            return;
        }
        try {
            this.__IM.onEntry(this, "stateChanged$int", new Object[]{new Integer(state)});
            this.__M_stateChanged(state);
            this.__IM.onExit(this, "stateChanged$int", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "stateChanged$int", throwable);
            throw throwable;
        }
    }

    private void __M_stateChanged(int state) {
        if (state == 1) {
            for (int i = 0; i < this.__getm_providedServices().length; ++i) {
                this.__getm_providedServices()[i].unregisterService();
            }
            return;
        }
        if (state == 2) {
            for (int i = 0; i < this.__getm_providedServices().length; ++i) {
                this.__getm_providedServices()[i].registerService();
            }
            return;
        }
    }

    public void addProperties(Dictionary dict) {
        if (!this.__MaddProperties$java_util_Dictionary) {
            this.__M_addProperties(dict);
            return;
        }
        try {
            this.__IM.onEntry(this, "addProperties$java_util_Dictionary", new Object[]{dict});
            this.__M_addProperties(dict);
            this.__IM.onExit(this, "addProperties$java_util_Dictionary", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "addProperties$java_util_Dictionary", throwable);
            throw throwable;
        }
    }

    private void __M_addProperties(Dictionary dict) {
        for (int i = 0; i < this.__getm_providedServices().length; ++i) {
            this.__getm_providedServices()[i].addProperties(dict);
            this.__getm_providedServices()[i].update();
        }
    }

    public void removeProperties(Dictionary dict) {
        if (!this.__MremoveProperties$java_util_Dictionary) {
            this.__M_removeProperties(dict);
            return;
        }
        try {
            this.__IM.onEntry(this, "removeProperties$java_util_Dictionary", new Object[]{dict});
            this.__M_removeProperties(dict);
            this.__IM.onExit(this, "removeProperties$java_util_Dictionary", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "removeProperties$java_util_Dictionary", throwable);
            throw throwable;
        }
    }

    private void __M_removeProperties(Dictionary dict) {
        for (int i = 0; i < this.__getm_providedServices().length; ++i) {
            this.__getm_providedServices()[i].deleteProperties(dict);
            this.__getm_providedServices()[i].update();
        }
    }

    public HandlerDescription getDescription() {
        HandlerDescription handlerDescription;
        if (!this.__MgetDescription) {
            return this.__M_getDescription();
        }
        try {
            this.__IM.onEntry(this, "getDescription", new Object[0]);
            handlerDescription = this.__M_getDescription();
            this.__IM.onExit(this, "getDescription", handlerDescription);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "getDescription", throwable);
            throw throwable;
        }
        return handlerDescription;
    }

    private HandlerDescription __M_getDescription() {
        return this.__getm_description();
    }

    public void reconfigure(Dictionary dict) {
        if (!this.__Mreconfigure$java_util_Dictionary) {
            this.__M_reconfigure(dict);
            return;
        }
        try {
            this.__IM.onEntry(this, "reconfigure$java_util_Dictionary", new Object[]{dict});
            this.__M_reconfigure(dict);
            this.__IM.onExit(this, "reconfigure$java_util_Dictionary", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "reconfigure$java_util_Dictionary", throwable);
            throw throwable;
        }
    }

    private void __M_reconfigure(Dictionary dict) {
        for (int j = 0; j < this.getProvidedServices().length; ++j) {
            ProvidedService svc = this.getProvidedServices()[j];
            Property[] props = svc.getProperties();
            boolean update = false;
            for (int k = 0; k < props.length; ++k) {
                if (dict.get(props[k].getName()) == null) continue;
                update = true;
                props[k].setValue(dict.get(props[k].getName()));
            }
            if (!update) continue;
            svc.update();
        }
    }

    public void initializeComponentFactory(ComponentTypeDescription desc, Element metadata) throws ConfigurationException {
        if (!this.__MinitializeComponentFactory$org_apache_felix_ipojo_architecture_ComponentTypeDescription$org_apache_felix_ipojo_metadata_Element) {
            this.__M_initializeComponentFactory(desc, metadata);
            return;
        }
        try {
            this.__IM.onEntry(this, "initializeComponentFactory$org_apache_felix_ipojo_architecture_ComponentTypeDescription$org_apache_felix_ipojo_metadata_Element", new Object[]{desc, metadata});
            this.__M_initializeComponentFactory(desc, metadata);
            this.__IM.onExit(this, "initializeComponentFactory$org_apache_felix_ipojo_architecture_ComponentTypeDescription$org_apache_felix_ipojo_metadata_Element", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "initializeComponentFactory$org_apache_felix_ipojo_architecture_ComponentTypeDescription$org_apache_felix_ipojo_metadata_Element", throwable);
            throw throwable;
        }
    }

    private void __M_initializeComponentFactory(ComponentTypeDescription desc, Element metadata) throws ConfigurationException {
        Element[] provides = metadata.getElements("provides");
        PojoMetadata manipulation = this.getFactory().getPojoMetadata();
        for (int i = 0; i < provides.length; ++i) {
            String[] serviceSpecification = manipulation.getInterfaces();
            String parent = manipulation.getSuperClass();
            HashSet<String> interfaces = new HashSet<String>();
            HashSet parentClasses = new HashSet();
            try {
                this.computeInterfacesAndSuperClasses(serviceSpecification, parent, desc.getBundleContext().getBundle(), interfaces, parentClasses);
                this.getLogger().log(3, "Collected interfaces from " + metadata.getAttribute("classname") + " : " + interfaces);
                this.getLogger().log(3, "Collected super classes from " + metadata.getAttribute("classname") + " : " + parentClasses);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("An interface or parent class cannot be loaded", e);
            }
            String serviceSpecificationStr = provides[i].getAttribute("specifications");
            if (serviceSpecificationStr == null && (serviceSpecificationStr = provides[i].getAttribute("interface")) != null) {
                this.warn("The 'interface' attribute is deprecated, use the 'specifications' attribute instead of 'interface'");
            }
            if (serviceSpecificationStr != null) {
                List itfs = ParseUtils.parseArraysAsList(serviceSpecificationStr);
                for (int j = 0; j < itfs.size(); ++j) {
                    if (interfaces.contains(itfs.get(j)) || parentClasses.contains(itfs.get(j)) || desc.getFactory().getClassName().equals(itfs.get(j))) continue;
                    desc.getFactory().getLogger().log(1, "The specification " + itfs.get(j) + " is not implemented by " + metadata.getAttribute("classname"));
                }
                interfaces = new HashSet(itfs);
            }
            if (interfaces.isEmpty()) {
                this.warn("No service interface found in the class hierarchy, use the implementation class");
                interfaces.add(desc.getFactory().getClassName());
            }
            StringBuffer specs = null;
            HashSet set = new HashSet(interfaces);
            set.remove(Pojo.class.getName());
            for (String spec : set) {
                desc.addProvidedServiceSpecification(spec);
                if (specs == null) {
                    specs = new StringBuffer("{");
                    specs.append(spec);
                    continue;
                }
                specs.append(',');
                specs.append(spec);
            }
            specs.append('}');
            provides[i].addAttribute(new Attribute("specifications", specs.toString()));
            Element[] props = provides[i].getElements("property");
            for (int j = 0; props != null && j < props.length; ++j) {
                String name = props[j].getAttribute("name");
                String value = props[j].getAttribute("value");
                String type = props[j].getAttribute("type");
                String field = props[j].getAttribute("field");
                if (field != null && name == null) {
                    name = field;
                }
                if (type == null) {
                    if (field == null) {
                        throw new ConfigurationException("The property " + name + " has neither type nor field.");
                    }
                    FieldMetadata fieldMeta = manipulation.getField(field);
                    if (fieldMeta == null) {
                        throw new ConfigurationException("A declared property was not found in the implementation class : " + field);
                    }
                    type = fieldMeta.getFieldType();
                    props[j].addAttribute(new Attribute("type", type));
                }
                boolean immutable = false;
                String imm = props[j].getAttribute("immutable");
                if (imm != null && imm.equalsIgnoreCase("true")) {
                    immutable = true;
                }
                PropertyDescription pd = new PropertyDescription(name, type, value, immutable);
                desc.addProperty(pd);
                String man = props[j].getAttribute("mandatory");
                if (man == null || !man.equalsIgnoreCase("true")) continue;
                pd.setMandatory();
            }
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("m_description")) {
                this.__Fm_description = true;
            }
            if (set.contains("m_providedServices")) {
                this.__Fm_providedServices = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("addProvidedService$org_apache_felix_ipojo_handlers_providedservice_ProvidedService")) {
                this.__MaddProvidedService$org_apache_felix_ipojo_handlers_providedservice_ProvidedService = true;
            }
            if (set.contains("getProvidedServices")) {
                this.__MgetProvidedServices = true;
            }
            if (set.contains("configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary")) {
                this.__Mconfigure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary = true;
            }
            if (set.contains("computeInterfacesAndSuperClasses$java_lang_String__$java_lang_String$org_osgi_framework_Bundle$java_util_Set$java_util_Set")) {
                this.__McomputeInterfacesAndSuperClasses$java_lang_String__$java_lang_String$org_osgi_framework_Bundle$java_util_Set$java_util_Set = true;
            }
            if (set.contains("collectInterfaces$java_lang_Class$java_util_Set$org_osgi_framework_Bundle")) {
                this.__McollectInterfaces$java_lang_Class$java_util_Set$org_osgi_framework_Bundle = true;
            }
            if (set.contains("collectInterfacesFromClass$java_lang_Class$java_util_Set$org_osgi_framework_Bundle")) {
                this.__McollectInterfacesFromClass$java_lang_Class$java_util_Set$org_osgi_framework_Bundle = true;
            }
            if (set.contains("collectParentClassesFromClass$java_lang_Class$java_util_Set$org_osgi_framework_Bundle")) {
                this.__McollectParentClassesFromClass$java_lang_Class$java_util_Set$org_osgi_framework_Bundle = true;
            }
            if (set.contains("checkProvidedService$org_apache_felix_ipojo_handlers_providedservice_ProvidedService")) {
                this.__McheckProvidedService$org_apache_felix_ipojo_handlers_providedservice_ProvidedService = true;
            }
            if (set.contains("getAttachedDependency$org_apache_felix_ipojo_metadata_Element")) {
                this.__MgetAttachedDependency$org_apache_felix_ipojo_metadata_Element = true;
            }
            if (set.contains("isDependencyCorrect$org_apache_felix_ipojo_handlers_dependency_Dependency$org_apache_felix_ipojo_metadata_Element")) {
                this.__MisDependencyCorrect$org_apache_felix_ipojo_handlers_dependency_Dependency$org_apache_felix_ipojo_metadata_Element = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("onSet$java_lang_Object$java_lang_String$java_lang_Object")) {
                this.__MonSet$java_lang_Object$java_lang_String$java_lang_Object = true;
            }
            if (set.contains("onGet$java_lang_Object$java_lang_String$java_lang_Object")) {
                this.__MonGet$java_lang_Object$java_lang_String$java_lang_Object = true;
            }
            if (set.contains("stateChanged$int")) {
                this.__MstateChanged$int = true;
            }
            if (set.contains("addProperties$java_util_Dictionary")) {
                this.__MaddProperties$java_util_Dictionary = true;
            }
            if (set.contains("removeProperties$java_util_Dictionary")) {
                this.__MremoveProperties$java_util_Dictionary = true;
            }
            if (set.contains("getDescription")) {
                this.__MgetDescription = true;
            }
            if (set.contains("reconfigure$java_util_Dictionary")) {
                this.__Mreconfigure$java_util_Dictionary = true;
            }
            if (set.contains("initializeComponentFactory$org_apache_felix_ipojo_architecture_ComponentTypeDescription$org_apache_felix_ipojo_metadata_Element")) {
                this.__MinitializeComponentFactory$org_apache_felix_ipojo_architecture_ComponentTypeDescription$org_apache_felix_ipojo_metadata_Element = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

