/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handlers.dependency;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.felix.ipojo.handlers.dependency.Dependency;
import org.apache.felix.ipojo.util.Callback;
import org.osgi.framework.ServiceReference;

public class DependencyCallback
extends Callback {
    public static final int BIND = 0;
    public static final int UNBIND = 1;
    public static final int MODIFIED = 2;
    private int m_methodType;
    private String[] m_argument;
    private String m_method;
    private Dependency m_dependency;

    public DependencyCallback(Dependency dep, String method, int methodType) {
        super(method, (String[])null, false, dep.getHandler().getInstanceManager());
        this.m_methodType = methodType;
        this.m_dependency = dep;
        this.m_method = method;
    }

    public int getMethodType() {
        return this.m_methodType;
    }

    public String getMethodName() {
        return this.m_method;
    }

    public void setArgument(String[] arg) {
        this.m_argument = arg;
    }

    protected void searchMethod() {
        if (this.m_argument != null) {
            Method[] methods = this.m_dependency.getHandler().getInstanceManager().getClazz().getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                int argIndex;
                Class<?>[] clazzes;
                if (!methods[i].getName().equals(this.m_method) || (clazzes = methods[i].getParameterTypes()).length != this.m_argument.length) continue;
                for (argIndex = 0; argIndex < this.m_argument.length && this.m_argument[argIndex].equals(clazzes[argIndex].getName()); ++argIndex) {
                }
                if (argIndex != this.m_argument.length) continue;
                this.m_methodObj = methods[i];
                if (!this.m_methodObj.isAccessible()) {
                    this.m_methodObj.setAccessible(true);
                }
                return;
            }
        }
        this.searchParentMethod();
        if (this.m_methodObj == null) {
            this.m_dependency.getHandler().error("The method " + this.m_method + " cannot be called : method not found");
            this.m_dependency.getHandler().getInstanceManager().stop();
        } else if (!this.m_methodObj.isAccessible()) {
            this.m_methodObj.setAccessible(true);
        }
    }

    private void searchParentMethod() {
        Method[] methods = this.m_dependency.getHandler().getInstanceManager().getClazz().getMethods();
        block5: for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(this.m_method)) continue;
            Class<?>[] clazzes = methods[i].getParameterTypes();
            switch (clazzes.length) {
                case 0: {
                    this.m_methodObj = methods[i];
                    this.m_argument = new String[0];
                    return;
                }
                case 1: {
                    if (clazzes[0].getName().equals(ServiceReference.class.getName())) {
                        this.m_methodObj = methods[i];
                        this.m_argument = new String[]{ServiceReference.class.getName()};
                        return;
                    }
                    if (!clazzes[0].getName().equals(this.m_dependency.getSpecification().getName())) continue block5;
                    this.m_methodObj = methods[i];
                    this.m_argument = new String[]{this.m_dependency.getSpecification().getName()};
                    return;
                }
                case 2: {
                    if (clazzes[0].getName().equals(this.m_dependency.getSpecification().getName()) && clazzes[1].getName().equals(ServiceReference.class.getName())) {
                        this.m_methodObj = methods[i];
                        this.m_argument = new String[]{this.m_dependency.getSpecification().getName(), ServiceReference.class.getName()};
                        return;
                    }
                    if (clazzes[0].getName().equals(this.m_dependency.getSpecification().getName()) && clazzes[1].getName().equals(Map.class.getName())) {
                        this.m_methodObj = methods[i];
                        this.m_argument = new String[]{this.m_dependency.getSpecification().getName(), Map.class.getName()};
                        return;
                    }
                    if (!clazzes[0].getName().equals(this.m_dependency.getSpecification().getName()) || !clazzes[1].getName().equals(Dictionary.class.getName())) continue block5;
                    this.m_methodObj = methods[i];
                    this.m_argument = new String[]{this.m_dependency.getSpecification().getName(), Dictionary.class.getName()};
                    return;
                }
            }
        }
    }

    protected void call(ServiceReference ref, Object obj) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (this.m_methodObj == null) {
            this.searchMethod();
        }
        switch (this.m_argument.length) {
            case 0: {
                this.call(new Object[0]);
                break;
            }
            case 1: {
                if (this.m_argument[0].equals(ServiceReference.class.getName())) {
                    this.call(new Object[]{ref});
                    break;
                }
                this.call(new Object[]{obj});
                break;
            }
            case 2: {
                if (this.m_argument[1].equals(ServiceReference.class.getName())) {
                    this.call(new Object[]{obj, ref});
                    break;
                }
                if (this.m_argument[1].equals(Dictionary.class.getName())) {
                    this.call(new Object[]{obj, this.getPropertiesInDictionary(ref)});
                    break;
                }
                this.call(new Object[]{obj, this.getPropertiesInMap(ref)});
                break;
            }
        }
    }

    private Dictionary getPropertiesInDictionary(ServiceReference ref) {
        String[] keys = ref.getPropertyKeys();
        Properties dict = new Properties();
        for (int i = 0; i < keys.length; ++i) {
            ((Dictionary)dict).put(keys[i], ref.getProperty(keys[i]));
        }
        return dict;
    }

    private Map getPropertiesInMap(ServiceReference ref) {
        String[] keys = ref.getPropertyKeys();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], ref.getProperty(keys[i]));
        }
        return map;
    }

    protected void callOnInstance(Object instance, ServiceReference ref, Object obj) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (this.m_methodObj == null) {
            this.searchMethod();
        }
        switch (this.m_argument.length) {
            case 0: {
                this.call(instance, new Object[0]);
                break;
            }
            case 1: {
                if (this.m_argument[0].equals(ServiceReference.class.getName())) {
                    this.call(instance, new Object[]{ref});
                    break;
                }
                this.call(instance, new Object[]{obj});
                break;
            }
            case 2: {
                if (this.m_argument[1].equals(ServiceReference.class.getName())) {
                    this.call(instance, new Object[]{obj, ref});
                    break;
                }
                if (this.m_argument[1].equals(Dictionary.class.getName())) {
                    this.call(instance, new Object[]{obj, this.getPropertiesInDictionary(ref)});
                    break;
                }
                this.call(instance, new Object[]{obj, this.getPropertiesInMap(ref)});
                break;
            }
        }
    }
}

