/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handlers.dependency;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.ConstructorInjector;
import org.apache.felix.ipojo.FieldInterceptor;
import org.apache.felix.ipojo.MethodInterceptor;
import org.apache.felix.ipojo.Nullable;
import org.apache.felix.ipojo.PolicyServiceContext;
import org.apache.felix.ipojo.handlers.dependency.DependencyCallback;
import org.apache.felix.ipojo.handlers.dependency.DependencyHandler;
import org.apache.felix.ipojo.handlers.dependency.NullableObject;
import org.apache.felix.ipojo.handlers.dependency.ProxyGenerator;
import org.apache.felix.ipojo.handlers.dependency.ServiceCollection;
import org.apache.felix.ipojo.handlers.dependency.ServiceUsage;
import org.apache.felix.ipojo.util.DependencyModel;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;

public class Dependency
extends DependencyModel
implements FieldInterceptor,
MethodInterceptor,
ConstructorInjector {
    private final DependencyHandler m_handler;
    private final String m_field;
    private DependencyCallback[] m_callbacks;
    private boolean m_isServiceLevelRequirement;
    private boolean m_isFrozen;
    private boolean m_isStarted;
    private ServiceUsage m_usage;
    private int m_type;
    private Object m_nullable;
    private final String m_di;
    private final boolean m_supportNullable;
    private String m_id;
    private boolean m_isProxy;
    private Object m_proxyObject;
    private int m_index = -1;

    public Dependency(DependencyHandler handler, String field, Class spec, Filter filter, boolean isOptional, boolean isAggregate, boolean nullable, boolean isProxy, String identity, BundleContext context, int policy, Comparator cmp, String defaultImplem) {
        super(spec, isAggregate, isOptional, filter, cmp, policy, context, handler, handler.getInstanceManager());
        this.m_handler = handler;
        this.m_field = field;
        this.m_isProxy = isProxy;
        this.m_usage = field != null ? new ServiceUsage() : null;
        this.m_supportNullable = nullable;
        this.m_di = defaultImplem;
        if (identity == null) {
            if (spec != null) {
                this.m_id = spec.getName();
            }
        } else {
            this.m_id = identity;
        }
    }

    public void setSpecification(Class spec) {
        super.setSpecification(spec);
        if (this.m_id == null) {
            this.m_id = spec.getName();
        }
    }

    public String getField() {
        return this.m_field;
    }

    protected void addDependencyCallback(DependencyCallback callback) {
        if (this.m_callbacks == null) {
            this.m_callbacks = new DependencyCallback[]{callback};
        } else {
            DependencyCallback[] newCallbacks = new DependencyCallback[this.m_callbacks.length + 1];
            System.arraycopy(this.m_callbacks, 0, newCallbacks, 0, this.m_callbacks.length);
            newCallbacks[this.m_callbacks.length] = callback;
            this.m_callbacks = newCallbacks;
        }
    }

    protected void addConstructorInjection(int index) throws ConfigurationException {
        this.m_index = index;
        this.m_usage = new ServiceUsage();
        this.m_handler.getInstanceManager().register(index, this);
    }

    public synchronized void stop() {
        this.m_isStarted = false;
        super.stop();
    }

    public DependencyHandler getHandler() {
        return this.m_handler;
    }

    public synchronized boolean isFrozen() {
        return this.m_isFrozen;
    }

    public synchronized void unfreeze() {
        this.m_isFrozen = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onObjectCreation(Object pojo) {
        ServiceReference[] refs;
        Dependency dependency = this;
        synchronized (dependency) {
            if (!this.m_isStarted) {
                return;
            }
            if (this.getBindingPolicy() == 1) {
                this.m_isFrozen = true;
            }
            if (this.isOptional() && this.getSize() == 0) {
                return;
            }
            refs = this.getServiceReferences();
        }
        if (refs == null) {
            return;
        }
        for (int j = 0; this.m_callbacks != null && j < this.m_callbacks.length; ++j) {
            if (this.m_callbacks[j].getMethodType() != 0) continue;
            if (this.isAggregate()) {
                for (int i = 0; i < refs.length; ++i) {
                    Object svc = this.getService(refs[i]);
                    if (svc != null) {
                        this.invokeCallback(this.m_callbacks[j], refs[i], svc, pojo);
                        continue;
                    }
                    this.removedService(refs[i], null);
                }
                continue;
            }
            Object svc = this.getService(refs[0]);
            if (svc != null) {
                this.invokeCallback(this.m_callbacks[j], refs[0], svc, pojo);
                continue;
            }
            this.removedService(refs[0], null);
        }
    }

    private void callUnbindMethod(ServiceReference ref) {
        if (this.m_handler.getInstanceManager().getState() > 0 && this.m_handler.getInstanceManager().getPojoObjects() != null) {
            for (int i = 0; this.m_callbacks != null && i < this.m_callbacks.length; ++i) {
                if (this.m_callbacks[i].getMethodType() != 1) continue;
                this.invokeCallback(this.m_callbacks[i], ref, this.getService(ref, false), null);
            }
        }
    }

    private void invokeCallback(DependencyCallback callback, ServiceReference ref, Object svcObject, Object pojo) {
        try {
            if (pojo == null) {
                callback.call(ref, svcObject);
            } else {
                callback.callOnInstance(pojo, ref, svcObject);
            }
        }
        catch (NoSuchMethodException e) {
            this.m_handler.error("The method " + callback.getMethodName() + " does not exist in the implementation class " + this.m_handler.getInstanceManager().getClassName(), e);
            this.m_handler.getInstanceManager().stop();
        }
        catch (IllegalAccessException e) {
            this.m_handler.error("The method " + callback.getMethodName() + " is not accessible in the implementation class " + this.m_handler.getInstanceManager().getClassName(), e);
            this.m_handler.getInstanceManager().stop();
        }
        catch (InvocationTargetException e) {
            this.m_handler.error("The method " + callback.getMethodName() + " in the implementation class " + this.m_handler.getInstanceManager().getClassName() + " throws an exception : " + e.getTargetException().getMessage(), e.getTargetException());
            this.m_handler.getInstanceManager().stop();
        }
    }

    private void callModifyMethod(ServiceReference ref) {
        if (this.m_handler.getInstanceManager().getState() > 0 && this.m_handler.getInstanceManager().getPojoObjects() != null) {
            for (int i = 0; this.m_callbacks != null && i < this.m_callbacks.length; ++i) {
                if (this.m_callbacks[i].getMethodType() != 2) continue;
                this.invokeCallback(this.m_callbacks[i], ref, this.getService(ref), null);
            }
        }
    }

    private void callBindMethod(ServiceReference ref) {
        if (this.m_handler.getInstanceManager().getState() > 0 && this.m_handler.getInstanceManager().getPojoObjects() != null) {
            for (int i = 0; this.m_callbacks != null && i < this.m_callbacks.length; ++i) {
                if (this.m_callbacks[i].getMethodType() != 0) continue;
                Object svc = this.getService(ref);
                if (svc != null) {
                    this.invokeCallback(this.m_callbacks[i], ref, svc, null);
                    continue;
                }
                this.removedService(ref, null);
            }
        }
    }

    private Object createNullableObject() {
        try {
            NullableClassLoader cl = new NullableClassLoader(this.getHandler().getInstanceManager().getClazz().getClassLoader(), this.getSpecification().getClassLoader());
            this.m_nullable = Proxy.newProxyInstance(cl, new Class[]{this.getSpecification(), Nullable.class}, (InvocationHandler)new NullableObject());
        }
        catch (NoClassDefFoundError e) {
            throw new IllegalStateException("Cannot create the Nullable object, a referenced class cannot be loaded", e);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Cannot create the Nullable object, an unexpected error occurs", e);
        }
        return this.m_nullable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.isOptional() && !this.isAggregate()) {
            if (this.m_di == null) {
                if (this.m_supportNullable) {
                    this.createNullableObject();
                }
            } else {
                try {
                    Class clazz = this.getHandler().getInstanceManager().getContext().getBundle().loadClass(this.m_di);
                    this.m_nullable = clazz.newInstance();
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Cannot load the default-implementation " + this.m_di, e);
                }
                catch (InstantiationException e) {
                    throw new IllegalStateException("Cannot load the default-implementation " + this.m_di, e);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Cannot load the default-implementation " + this.m_di, e);
                }
                catch (Throwable e) {
                    throw new IllegalStateException("Cannot load the default-implementation (unexpected exception) " + this.m_di, e);
                }
            }
        }
        if (this.m_isProxy) {
            if (this.isAggregate()) {
                this.m_proxyObject = new ServiceCollection(this);
            } else if (this.getSpecification().isInterface()) {
                String type = this.getHandler().getInstanceManager().getContext().getProperty("ipojo.proxy.type");
                if (type == null) {
                    type = System.getProperty("ipojo.proxy.type");
                }
                if (type == null || type.equals("smart")) {
                    SmartProxyFactory proxyFactory = new SmartProxyFactory(this.getClass().getClassLoader());
                    this.m_proxyObject = proxyFactory.getProxy(this.getSpecification(), this);
                } else {
                    DynamicProxyFactory proxyFactory = new DynamicProxyFactory();
                    this.m_proxyObject = proxyFactory.getProxy(this.getSpecification());
                }
            } else {
                this.m_handler.warn("Cannot create a proxy for a service dependency which is not an interface - disabling proxy for " + this.getId());
            }
        }
        super.start();
        Dependency dependency = this;
        synchronized (dependency) {
            if (this.getBindingPolicy() == 1 && this.m_handler.getInstanceManager().getPojoObjects() != null) {
                this.m_isFrozen = true;
            }
            this.m_isStarted = true;
        }
    }

    protected DependencyCallback[] getCallbacks() {
        return this.m_callbacks;
    }

    public void setServiceLevelDependency() {
        this.m_isServiceLevelRequirement = true;
        this.setBundleContext(new PolicyServiceContext(this.m_handler.getInstanceManager().getGlobalContext(), this.m_handler.getInstanceManager().getLocalServiceContext(), 0));
    }

    public String getId() {
        return this.m_id;
    }

    public boolean isServiceLevelRequirement() {
        return this.m_isServiceLevelRequirement;
    }

    public void onServiceArrival(ServiceReference reference) {
        this.callBindMethod(reference);
    }

    public void onServiceModification(ServiceReference reference) {
        this.callModifyMethod(reference);
    }

    public void onServiceDeparture(ServiceReference ref) {
        this.callUnbindMethod(ref);
    }

    public void onDependencyReconfiguration(ServiceReference[] departs, ServiceReference[] arrivals) {
        int i;
        for (i = 0; departs != null && i < departs.length; ++i) {
            this.callUnbindMethod(departs[i]);
        }
        for (i = 0; arrivals != null && i < arrivals.length; ++i) {
            this.callBindMethod(arrivals[i]);
        }
    }

    public void resetLocalCache() {
        if (this.m_usage != null) {
            ServiceUsage.Usage usage = (ServiceUsage.Usage)this.m_usage.get();
            if (usage.m_stack > 0) {
                this.createServiceObject(usage);
            }
        }
    }

    public List getServiceReferencesAsList() {
        ServiceReference[] refs = super.getServiceReferences();
        if (refs == null) {
            return null;
        }
        return Arrays.asList(refs);
    }

    public Object getService() {
        if (!this.m_isProxy) {
            throw new IllegalStateException("The dependency is not a proxied dependency");
        }
        ServiceUsage.Usage usage = (ServiceUsage.Usage)this.m_usage.get();
        if (usage.m_stack == 0) {
            if (usage.m_componentStack > 0) {
                this.createServiceObject(usage);
                usage.inc();
                this.m_usage.set(usage);
                if (this.isAggregate()) {
                    Object obj = usage.m_object;
                    if (obj instanceof Set) {
                        ArrayList list = new ArrayList();
                        list.addAll((Set)obj);
                        return list;
                    }
                    return obj;
                }
                return usage.m_object;
            }
            if (this.isAggregate()) {
                ServiceReference[] refs = this.getServiceReferences();
                if (refs == null) {
                    return new ArrayList(0);
                }
                ArrayList<Object> objs = new ArrayList<Object>(refs.length);
                for (int i = 0; refs != null && i < refs.length; ++i) {
                    ServiceReference ref = refs[i];
                    objs.add(this.getService(ref));
                }
                return objs;
            }
            ServiceReference ref = this.getServiceReference();
            if (ref != null) {
                return this.getService(ref);
            }
            throw new RuntimeException("Service " + this.getSpecification() + " unavailable");
        }
        if (this.isAggregate()) {
            Object obj = usage.m_object;
            if (obj instanceof Set) {
                ArrayList list = new ArrayList();
                list.addAll((Set)obj);
                return list;
            }
            return obj;
        }
        return usage.m_object;
    }

    public Object onGet(Object pojo, String fieldName, Object value) {
        ServiceUsage.Usage usage = (ServiceUsage.Usage)this.m_usage.get();
        if (usage.m_stack == 0) {
            this.createServiceObject(usage);
            usage.inc();
            this.m_usage.set(usage);
        }
        if (!this.m_isProxy) {
            return usage.m_object;
        }
        return this.m_proxyObject;
    }

    private void createServiceObject(ServiceUsage.Usage usage) {
        ServiceReference[] refs = this.getServiceReferences();
        if (!this.isAggregate()) {
            if (refs == null) {
                if (this.m_nullable == null && this.m_supportNullable) {
                    this.m_handler.warn("[" + this.m_handler.getInstanceManager().getInstanceName() + "] The dependency is not optional, however no service object can be injected in " + this.m_field + " -> " + this.getSpecification().getName());
                    this.createNullableObject();
                }
                usage.m_object = this.m_nullable;
            } else {
                ServiceReference ref = this.getServiceReference();
                usage.m_object = this.getService(ref);
            }
        } else if (this.m_type == 0) {
            try {
                if (refs == null) {
                    usage.m_object = (Object[])Array.newInstance(this.getSpecification(), 0);
                }
                Object[] objs = (Object[])Array.newInstance(this.getSpecification(), refs.length);
                for (int i = 0; refs != null && i < refs.length; ++i) {
                    ServiceReference ref = refs[i];
                    objs[i] = this.getService(ref);
                }
                usage.m_object = objs;
            }
            catch (ArrayStoreException e) {
                this.m_handler.error("Cannot create the array - Check that the bundle can access the service interface", e);
                throw new RuntimeException("Cannot create the array - Check that the bundle can access the service interface", e);
            }
        } else if (this.m_type == 1) {
            if (refs == null) {
                usage.m_object = new ArrayList(0);
            } else {
                ArrayList<Object> objs = new ArrayList<Object>(refs.length);
                for (int i = 0; refs != null && i < refs.length; ++i) {
                    ServiceReference ref = refs[i];
                    objs.add(this.getService(ref));
                }
                usage.m_object = objs;
            }
        } else if (this.m_type == 2) {
            if (refs == null) {
                usage.m_object = new Vector(0);
            } else {
                Vector<Object> objs = new Vector<Object>(refs.length);
                for (int i = 0; refs != null && i < refs.length; ++i) {
                    ServiceReference ref = refs[i];
                    objs.add(this.getService(ref));
                }
                usage.m_object = objs;
            }
        } else if (this.m_type == 3) {
            if (refs == null) {
                usage.m_object = new HashSet(0);
            } else {
                HashSet<Object> objs = new HashSet<Object>(refs.length);
                for (int i = 0; refs != null && i < refs.length; ++i) {
                    ServiceReference ref = refs[i];
                    objs.add(this.getService(ref));
                }
                usage.m_object = objs;
            }
        }
    }

    public void onSet(Object pojo, String fieldName, Object value) {
    }

    public void onEntry(Object pojo, Member method, Object[] args) {
        if (this.m_usage != null) {
            ServiceUsage.Usage usage = (ServiceUsage.Usage)this.m_usage.get();
            usage.incComponentStack();
            if (usage.m_stack > 0) {
                usage.inc();
                this.m_usage.set(usage);
            }
        }
    }

    public void onError(Object pojo, Member method, Throwable throwable) {
    }

    public void onExit(Object pojo, Member method, Object returnedObj) {
    }

    public void onFinally(Object pojo, Member method) {
        if (this.m_usage != null) {
            ServiceUsage.Usage usage = (ServiceUsage.Usage)this.m_usage.get();
            usage.decComponentStack();
            if (usage.m_stack > 0 && usage.dec()) {
                usage.clear();
                this.m_usage.set(usage);
            }
        }
    }

    public boolean supportsNullable() {
        return this.m_supportNullable;
    }

    public String getDefaultImplementation() {
        return this.m_di;
    }

    public boolean isProxy() {
        return this.m_isProxy;
    }

    public void setProxy(boolean proxy) {
        this.m_isProxy = proxy;
    }

    protected void setType(int type) {
        this.setAggregate(true);
        this.m_type = type;
    }

    public int getConstructorParameterIndex() {
        return this.m_index;
    }

    public Object getConstructorParameter(int index) {
        if (this.m_index == index && this.m_proxyObject != null) {
            return this.m_proxyObject;
        }
        return null;
    }

    public Class getConstructorParameterType(int index) {
        if (this.m_index == index && this.m_proxyObject != null) {
            if (this.isAggregate()) {
                switch (this.m_type) {
                    case 1: {
                        return List.class;
                    }
                    case 3: {
                        return Set.class;
                    }
                }
                return null;
            }
            return this.getSpecification();
        }
        return null;
    }

    private class DynamicProxyFactory
    implements InvocationHandler {
        private Method m_hashCodeMethod;
        private Method m_equalsMethod;
        private Method m_toStringMethod;

        public DynamicProxyFactory() {
            try {
                this.m_hashCodeMethod = Object.class.getMethod("hashCode", null);
                this.m_equalsMethod = Object.class.getMethod("equals", Object.class);
                this.m_toStringMethod = Object.class.getMethod("toString", null);
            }
            catch (NoSuchMethodException e) {
                throw new NoSuchMethodError(e.getMessage());
            }
        }

        public Object getProxy(Class spec) {
            return Proxy.newProxyInstance(Dependency.this.getHandler().getInstanceManager().getClazz().getClassLoader(), new Class[]{spec}, (InvocationHandler)this);
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
            Object svc = Dependency.this.getService();
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass == Object.class) {
                if (method.equals(this.m_hashCodeMethod)) {
                    return new Integer(this.hashCode());
                }
                if (method.equals(this.m_equalsMethod)) {
                    return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
                }
                if (method.equals(this.m_toStringMethod)) {
                    return this.toString();
                }
                throw new InternalError("Unexpected Object method dispatched: " + method);
            }
            return method.invoke(svc, args);
        }
    }

    private class SmartProxyFactory
    extends ClassLoader {
        private ClassLoader m_handlerCL;

        public SmartProxyFactory(ClassLoader parent) {
            super(Dependency.this.getHandler().getInstanceManager().getFactory().getBundleClassLoader());
            this.m_handlerCL = parent;
        }

        protected Class getProxyClass(Class clazz) {
            byte[] clz = ProxyGenerator.dumpProxy(clazz);
            String cn = clazz.getName();
            if (cn.startsWith("java.")) {
                cn = "$" + cn;
            }
            return this.defineClass(cn + "$$Proxy", clz, 0, clz.length);
        }

        public Object getProxy(Class spec, Dependency dep) {
            try {
                Class clazz = this.getProxyClass(Dependency.this.getSpecification());
                Constructor constructor = clazz.getConstructor(clazz.getClassLoader().loadClass(Dependency.class.getName()));
                return constructor.newInstance(dep);
            }
            catch (Throwable e) {
                Dependency.this.m_handler.error("Cannot create the proxy object", e);
                Dependency.this.m_handler.getInstanceManager().stop();
                return null;
            }
        }

        public Class loadClass(String name) throws ClassNotFoundException {
            try {
                return Dependency.this.getHandler().getInstanceManager().getContext().getBundle().loadClass(name);
            }
            catch (ClassNotFoundException e) {
                return this.m_handlerCL.loadClass(name);
            }
        }
    }

    private static class NullableClassLoader
    extends ClassLoader {
        private ClassLoader m_component;
        private ClassLoader m_specification;

        public NullableClassLoader(ClassLoader cmp, ClassLoader spec) {
            this.m_component = cmp;
            this.m_specification = spec;
        }

        public Class loadClass(String name) throws ClassNotFoundException {
            try {
                return this.m_component.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                return this.m_specification.loadClass(name);
            }
        }
    }
}

