/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.extender.internal.queue;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.felix.ipojo.extender.internal.AbstractService;
import org.apache.felix.ipojo.extender.internal.LifecycleQueueService;
import org.apache.felix.ipojo.extender.internal.queue.JobInfoCallable;
import org.apache.felix.ipojo.extender.internal.queue.Statistic;
import org.apache.felix.ipojo.extender.queue.Callback;
import org.apache.felix.ipojo.extender.queue.JobInfo;
import org.apache.felix.ipojo.extender.queue.QueueService;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutorQueueService
extends AbstractService
implements LifecycleQueueService {
    private static final int DEFAULT_QUEUE_SIZE = 3;
    private final ExecutorService m_executorService;
    private final Statistic m_statistic = new Statistic();

    public ExecutorQueueService(BundleContext bundleContext) {
        this(bundleContext, 3);
    }

    public ExecutorQueueService(BundleContext bundleContext, int size) {
        this(bundleContext, Executors.newFixedThreadPool(size));
    }

    public ExecutorQueueService(BundleContext bundleContext, int size, ThreadFactory threadFactory) {
        this(bundleContext, Executors.newFixedThreadPool(size, threadFactory));
    }

    private ExecutorQueueService(BundleContext bundleContext, ExecutorService executorService) {
        super(bundleContext, QueueService.class);
        this.m_executorService = executorService;
    }

    @Override
    public void stop() {
        this.m_executorService.shutdown();
        super.stop();
    }

    @Override
    protected Dictionary<String, ?> getServiceProperties() {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("ipojo.queue.mode", "async");
        return properties;
    }

    @Override
    public int getFinished() {
        return this.m_statistic.getFinishedCounter().get();
    }

    @Override
    public int getWaiters() {
        return this.m_statistic.getWaiters().size();
    }

    @Override
    public int getCurrents() {
        return this.m_statistic.getCurrentsCounter().get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<JobInfo> getWaitersInfo() {
        ArrayList<JobInfo> snapshot;
        List<JobInfo> list = this.m_statistic.getWaiters();
        synchronized (list) {
            snapshot = new ArrayList<JobInfo>(this.m_statistic.getWaiters());
        }
        return Collections.unmodifiableList(snapshot);
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable, Callback<T> callback, String description) {
        return this.m_executorService.submit(new JobInfoCallable<T>(this.m_statistic, callable, callback, description));
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable, String description) {
        return this.submit(callable, null, description);
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        return this.submit(callable, "No description");
    }
}

