/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.architecture;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.felix.ipojo.Factory;
import org.apache.felix.ipojo.IPojoFactory;
import org.apache.felix.ipojo.architecture.CustomHandlerInfo;
import org.apache.felix.ipojo.architecture.PropertyDescription;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentTypeDescription {
    private final IPojoFactory m_factory;
    private String[] m_providedServiceSpecification = new String[0];
    private PropertyDescription[] m_properties = new PropertyDescription[0];
    private Dictionary m_handlerInfoSlot = new Hashtable();

    public ComponentTypeDescription(IPojoFactory factory) {
        this.m_factory = factory;
    }

    public IPojoFactory getFactory() {
        return this.m_factory;
    }

    public String toString() {
        return this.getDescription().toString();
    }

    public String getClassName() {
        return this.m_factory.getClassName();
    }

    public String getVersion() {
        return this.m_factory.getVersion();
    }

    public PropertyDescription[] getProperties() {
        return this.m_properties;
    }

    public void addProperty(String name, String value) {
        this.addProperty(name, value, false);
    }

    public void addProperty(String name, String value, boolean immutable) {
        PropertyDescription prop = new PropertyDescription(name, String.class.getName(), value);
        this.addProperty(prop);
    }

    public void addProperty(PropertyDescription pd) {
        String name = pd.getName();
        for (int i = 0; i < this.m_properties.length; ++i) {
            PropertyDescription desc = this.m_properties[i];
            if (!desc.getName().equals(name)) continue;
            return;
        }
        PropertyDescription[] newProps = new PropertyDescription[this.m_properties.length + 1];
        System.arraycopy(this.m_properties, 0, newProps, 0, this.m_properties.length);
        newProps[this.m_properties.length] = pd;
        this.m_properties = newProps;
    }

    public void setHandlerInfo(String handlerNs, String handlerName, CustomHandlerInfo info) {
        String fullHandlerName = handlerNs + ":" + handlerName;
        if (info == null) {
            this.m_handlerInfoSlot.remove(fullHandlerName);
        } else {
            this.m_handlerInfoSlot.put(fullHandlerName, info);
        }
    }

    public CustomHandlerInfo getHandlerInfo(String handlerNs, String handlerName) {
        String fullHandlerName = handlerNs + ":" + handlerName;
        return (CustomHandlerInfo)this.m_handlerInfoSlot.get(fullHandlerName);
    }

    public String[] getprovidedServiceSpecification() {
        return this.m_providedServiceSpecification;
    }

    public void addProvidedServiceSpecification(String serviceSpecification) {
        String[] newSs = new String[this.m_providedServiceSpecification.length + 1];
        System.arraycopy(this.m_providedServiceSpecification, 0, newSs, 0, this.m_providedServiceSpecification.length);
        newSs[this.m_providedServiceSpecification.length] = serviceSpecification;
        this.m_providedServiceSpecification = newSs;
    }

    public String getName() {
        return this.m_factory.getName();
    }

    public Dictionary<String, Object> getPropertiesToPublish() {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put("factory.name", this.m_factory.getName());
        props.put("service.pid", this.m_factory.getName());
        String v = this.getVersion();
        if (v != null) {
            props.put("factory.version", v);
        }
        props.put("component.providedServiceSpecifications", this.m_providedServiceSpecification);
        props.put("component.properties", this.m_properties);
        props.put("component.description", this);
        for (PropertyDescription m_property : this.m_properties) {
            if (!m_property.isImmutable() || m_property.getValue() == null) continue;
            props.put(m_property.getName(), m_property.getObjectValue(this.m_factory.getBundleContext()));
        }
        props.put("factory.state", this.m_factory.getState());
        return props;
    }

    public String[] getFactoryInterfacesToPublish() {
        return new String[]{Factory.class.getName()};
    }

    public Element getDescription() {
        int i;
        Element desc = new Element("Factory", "");
        desc.addAttribute(new Attribute("name", this.m_factory.getName()));
        desc.addAttribute(new Attribute("bundle", Long.toString(this.m_factory.getBundleContext().getBundle().getBundleId())));
        String state = "valid";
        if (this.m_factory.getState() == 0) {
            state = "invalid";
        }
        desc.addAttribute(new Attribute("state", state));
        Element req = new Element("RequiredHandlers", "");
        req.addAttribute(new Attribute("list", this.m_factory.getRequiredHandlers().toString()));
        Element missing = new Element("MissingHandlers", "");
        missing.addAttribute(new Attribute("list", this.m_factory.getMissingHandlers().toString()));
        desc.addElement(req);
        desc.addElement(missing);
        for (i = 0; i < this.m_providedServiceSpecification.length; ++i) {
            Element prov = new Element("provides", "");
            prov.addAttribute(new Attribute("specification", this.m_providedServiceSpecification[i]));
            desc.addElement(prov);
        }
        for (i = 0; i < this.m_properties.length; ++i) {
            Element prop = new Element("property", "");
            prop.addAttribute(new Attribute("name", this.m_properties[i].getName()));
            prop.addAttribute(new Attribute("type", this.m_properties[i].getType()));
            if (this.m_properties[i].isMandatory() && this.m_properties[i].getValue() == null) {
                prop.addAttribute(new Attribute("value", "REQUIRED"));
            } else {
                prop.addAttribute(new Attribute("value", this.m_properties[i].getValue()));
            }
            desc.addElement(prop);
        }
        if (this.m_handlerInfoSlot.size() > 0) {
            Enumeration keys = this.m_handlerInfoSlot.keys();
            while (keys.hasMoreElements()) {
                String fullHandlerName = (String)keys.nextElement();
                CustomHandlerInfo handlerInfo = (CustomHandlerInfo)this.m_handlerInfoSlot.get(fullHandlerName);
                desc.addElement(handlerInfo.getDescription());
            }
        }
        return desc;
    }

    public BundleContext getBundleContext() {
        return this.m_factory.getBundleContext();
    }
}

