/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.IPojoFactory;
import org.apache.felix.ipojo.MissingHandlerException;
import org.apache.felix.ipojo.UnacceptableConfiguration;
import org.apache.felix.ipojo.extender.internal.Extender;
import org.apache.felix.ipojo.util.Logger;
import org.apache.felix.ipojo.util.ServiceLocator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.cm.ConfigurationPermission;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationTracker
implements ConfigurationListener {
    private static ConfigurationTracker m_singleton;
    private final ServiceRegistration m_registration;
    private final BundleContext m_context;
    private final Logger m_logger;
    private Map<String, IPojoFactory> m_factories = new HashMap<String, IPojoFactory>();

    public ConfigurationTracker() {
        this.m_context = Extender.getIPOJOBundleContext();
        this.m_logger = new Logger(this.m_context, "iPOJO Configuration Admin listener", 3);
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.description", "iPOJO Configuration Admin Listener");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        this.m_registration = this.m_context.registerService(ConfigurationListener.class.getName(), (Object)this, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() {
        Class<ConfigurationTracker> clazz = ConfigurationTracker.class;
        synchronized (ConfigurationTracker.class) {
            if (m_singleton == null) {
                m_singleton = new ConfigurationTracker();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void shutdown() {
        m_singleton.dispose();
    }

    public static ConfigurationTracker get() {
        return m_singleton;
    }

    public synchronized void dispose() {
        if (this.m_registration != null) {
            this.m_registration.unregister();
        }
        this.m_factories.clear();
    }

    public synchronized void registerFactory(IPojoFactory factory) {
        this.m_factories.put(factory.getFactoryName(), factory);
        ServiceLocator<ConfigurationAdmin> locator = new ServiceLocator<ConfigurationAdmin>(ConfigurationAdmin.class, this.m_context);
        ConfigurationAdmin admin = locator.get();
        if (admin == null) {
            return;
        }
        List<Configuration> configurations = this.findFactoryConfiguration(admin, factory);
        for (Configuration configuration : configurations) {
            try {
                factory.updated(configuration.getPid(), configuration.getProperties());
            }
            catch (ConfigurationException e) {
                this.m_logger.log(1, "Cannot reconfigure instance " + configuration.getPid() + " from " + configuration.getFactoryPid() + " with the configuration : " + configuration.getProperties(), e);
            }
        }
    }

    public synchronized void instanceCreated(ComponentInstance instance) {
        ServiceLocator<ConfigurationAdmin> locator = new ServiceLocator<ConfigurationAdmin>(ConfigurationAdmin.class, this.m_context);
        ConfigurationAdmin admin = locator.get();
        if (admin == null) {
            return;
        }
        Configuration configuration = this.findSingletonConfiguration(admin, instance.getInstanceName());
        if (configuration != null) {
            Hashtable<String, Object> conf = this.copyConfiguration(configuration);
            if (!conf.containsKey("instance.name")) {
                conf.put("instance.name", configuration.getPid());
            }
            try {
                instance.getFactory().reconfigure(conf);
            }
            catch (UnacceptableConfiguration unacceptableConfiguration) {
                this.m_logger.log(1, "Cannot reconfigure the instance " + configuration.getPid() + " - the " + "configuration is unacceptable", unacceptableConfiguration);
            }
            catch (MissingHandlerException e) {
                this.m_logger.log(1, "Cannot reconfigure the instance " + configuration.getPid() + " - factory is " + "invalid", e);
            }
        }
    }

    public synchronized void unregisterFactory(IPojoFactory factory) {
        this.m_factories.remove(factory.getFactoryName());
    }

    @Override
    public void configurationEvent(ConfigurationEvent event) {
        String pid = event.getPid();
        String factoryPid = event.getFactoryPid();
        if (factoryPid == null) {
            ComponentInstance instance = this.retrieveInstance(pid);
            if (instance != null) {
                this.manageConfigurationEventForSingleton(instance, event);
            }
        } else {
            IPojoFactory factory = this.retrieveFactory(factoryPid);
            if (factory != null) {
                this.manageConfigurationEventForFactory(factory, event);
            }
        }
    }

    private void manageConfigurationEventForFactory(IPojoFactory factory, ConfigurationEvent event) {
        ServiceLocator<ConfigurationAdmin> locator = new ServiceLocator<ConfigurationAdmin>(ConfigurationAdmin.class, this.m_context);
        switch (event.getType()) {
            case 2: {
                factory.deleted(event.getPid());
                break;
            }
            case 1: {
                Configuration config;
                ConfigurationAdmin admin = locator.get();
                if (admin == null || (config = this.getConfiguration(admin, event.getPid(), factory.getBundleContext().getBundle())) == null) break;
                try {
                    factory.updated(event.getPid(), config.getProperties());
                    break;
                }
                catch (ConfigurationException e) {
                    this.m_logger.log(1, "Cannot reconfigure instance " + event.getPid() + " with the new " + "configuration " + config.getProperties(), e);
                }
            }
        }
        locator.unget();
    }

    private void manageConfigurationEventForSingleton(ComponentInstance instance, ConfigurationEvent event) {
        ServiceLocator<ConfigurationAdmin> locator = new ServiceLocator<ConfigurationAdmin>(ConfigurationAdmin.class, this.m_context);
        switch (event.getType()) {
            case 2: {
                instance.dispose();
                break;
            }
            case 1: {
                Configuration config;
                ConfigurationAdmin admin = locator.get();
                if (admin == null || (config = this.getConfiguration(admin, event.getPid(), instance.getFactory().getBundleContext().getBundle())) == null) break;
                Hashtable<String, Object> conf = this.copyConfiguration(config);
                if (!conf.containsKey("instance.name")) {
                    conf.put("instance.name", event.getPid());
                }
                try {
                    instance.getFactory().reconfigure(conf);
                    break;
                }
                catch (UnacceptableConfiguration unacceptableConfiguration) {
                    this.m_logger.log(1, "Cannot reconfigure the instance " + event.getPid() + " - the " + "configuration is unacceptable", unacceptableConfiguration);
                    break;
                }
                catch (MissingHandlerException e) {
                    this.m_logger.log(1, "Cannot reconfigure the instance " + event.getPid() + " - factory is " + "invalid", e);
                }
            }
        }
        locator.unget();
    }

    private Hashtable<String, Object> copyConfiguration(Configuration config) {
        Hashtable<String, Object> conf = new Hashtable<String, Object>();
        Enumeration keys = config.getProperties().keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            conf.put(key, config.getProperties().get(key));
        }
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPojoFactory retrieveFactory(String factoryPid) {
        ConfigurationTracker configurationTracker = this;
        synchronized (configurationTracker) {
            return this.m_factories.get(factoryPid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComponentInstance retrieveInstance(String instanceName) {
        Collection<IPojoFactory> factories;
        ConfigurationTracker configurationTracker = this;
        synchronized (configurationTracker) {
            factories = this.m_factories.values();
        }
        for (IPojoFactory factory : factories) {
            ComponentInstance instance = factory.getInstanceByName(instanceName);
            if (instance == null) continue;
            return instance;
        }
        return null;
    }

    private Configuration getConfiguration(ConfigurationAdmin admin, String pid, Bundle bundle) {
        if (admin == null) {
            return null;
        }
        try {
            Configuration cfg = admin.getConfiguration(pid);
            String bundleLocation = bundle.getLocation();
            if (cfg.getBundleLocation() == null || bundleLocation.equals(cfg.getBundleLocation())) {
                return cfg;
            }
            if (cfg.getBundleLocation().startsWith("?") && bundle.hasPermission((Object)new ConfigurationPermission(cfg.getBundleLocation(), "target"))) {
                return cfg;
            }
            this.m_logger.log(1, "Cannot use configuration pid=" + pid + " for bundle " + bundleLocation + " because it belongs to bundle " + cfg.getBundleLocation());
        }
        catch (IOException ioe) {
            this.m_logger.log(2, "Failed reading configuration for pid=" + pid, ioe);
        }
        return null;
    }

    public List<Configuration> findFactoryConfiguration(ConfigurationAdmin admin, IPojoFactory factory) {
        String filter = "(service.factoryPid=" + factory.getFactoryName() + ")";
        return this.findConfigurations(admin, filter);
    }

    public Configuration findSingletonConfiguration(ConfigurationAdmin admin, String pid) {
        String filter = "(service.pid=" + pid + ")";
        List<Configuration> list = this.findConfigurations(admin, filter);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    private List<Configuration> findConfigurations(ConfigurationAdmin admin, String filter) {
        List<Configuration> configurations = Collections.emptyList();
        if (admin == null) {
            return configurations;
        }
        try {
            Configuration[] list = admin.listConfigurations(filter);
            if (list == null) {
                return configurations;
            }
            return Arrays.asList(list);
        }
        catch (InvalidSyntaxException e) {
            this.m_logger.log(1, "Invalid Configuration selection filter " + filter, e);
        }
        catch (IOException e) {
            this.m_logger.log(1, "Error when retrieving configurations for filter=" + filter, e);
        }
        return configurations;
    }
}

